/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.objecteditors.utils.BaumChildrenLoader;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumOrtsterminPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumParentPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.ComboBoxFilterDialog;
import de.cismet.cids.custom.wunda_blau.search.server.AbstractMonToLwmoSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BaumMeldungLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class BaumOrtsterminEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
BaumParentPanel {
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    };
    public static final String GEOMTYPE = "Point";
    public static final int FOTO_WIDTH = 150;
    private static final Logger LOG = Logger.getLogger(BaumOrtsterminEditor.class);
    private static final String[] MELDUNG_COL_NAMES = new String[]{"Gebiet-Aktenzeichen", "Gebiet-Bemerkung", "Meldungsdatum", "Meldung-Bemerkung"};
    private static final String[] MELDUNG_PROP_NAMES = new String[]{"fk_gebiet.aktenzeichen", "fk_gebiet.bemerkung", "datum", "bemerkung"};
    private static final Class[] MELDUNG_PROP_TYPES = new Class[]{CidsBean.class, CidsBean.class, Date.class, String.class};
    private static final String[] LOADING_COL_NAMES = new String[]{"Die Daten werden geladen......"};
    private static final String[] MUSTSET_COL_NAMES = new String[]{"Die Daten bitte zuweisen......"};
    private static final String TITLE_NEW_ORTSTERMIN = "einen neuen Ortstermin anlegen ....";
    public static final String FIELD__TEILNEHMER = "n_teilnehmer";
    public static final String FIELD__ZEIT = "zeit";
    public static final String FIELD__ID = "id";
    public static final String FIELD__MELDUNG = "fk_meldung";
    public static final String FIELD__MELDUNG_ID = "fk_meldung.id";
    public static final String FIELD__MELDUNG_DATUM = "fk_meldung.datum";
    public static final String FIELD__GEBIET_AZ = "fk_meldung.fk_gebiet.aktenzeichen";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__MELDUNGEN = "n_ortstermine";
    public static final String FIELD__TEILNEHMER_OTSTERMIN = "fk_ortstermin";
    public static final String FIELD__TEILNEHMER_NAME = "name";
    public static final String FIELD__TEILNEHMER_TELEFON = "telefon";
    public static final String FIELD__TEILNEHMER_BEMERKUNG = "bemerkung";
    public static final String TABLE_NAME__MELDUNG = "baum_meldung";
    public static final String TABLE_NAME__TEILNEHMER = "baum_teilnehmer";
    public static final String BUNDLE_PANE_PREFIX = "BaumOrtsterminEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BaumOrtsterminEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BaumOrtsterminEditor.isOkForSaving().JOptionPane.title";
    public static final String BUNDLE_TEIL_QUESTION = "BaumOrtsterminEditor.btnRemoveTeilActionPerformed().question";
    public static final String BUNDLE_TEIL_TITLE = "BaumOrtsterminEditor.btnRemoveTeilActionPerformed().title";
    public static final String BUNDLE_TEIL_ERRORTITLE = "BaumOrtsterminEditor.btnRemoveTeilrActionPerformed().errortitle";
    public static final String BUNDLE_TEIL_ERRORTEXT = "BaumOrtsterminEditor.btnRemoveTeilActionPerformed().errortext";
    public static final String BUNDLE_NOMELDUNG = "BaumOrtsterminEditor.isOkForSaving().noMeldung";
    public static final String BUNDLE_NOSAVE_MESSAGE = "BaumOrtsterminEditor.noSave().message";
    public static final String BUNDLE_NOSAVE_TITLE = "BaumOrtsterminEditor.noSave().title";
    private static Exception errorNoSave = null;
    private final BaumChildrenLoader baumChildrenLoader = new BaumChildrenLoader(this);
    private List<CidsBean> teilBeans;
    private final boolean editor;
    private BaumOrtsterminPanel baumOrtsterminPanel;
    private JButton btnChangeGebiet;
    private ComboBoxFilterDialog comboBoxFilterDialogGebiet;
    private JScrollPane jScrollPaneMeldung;
    private JLabel lblGebiet_Meldung;
    private JPanel panContent;
    JPanel panOrtstermin;
    JPanel panOrtstermineMain;
    private JXTable xtMeldung;
    private BindingGroup bindingGroup;

    public BaumOrtsterminEditor() {
        this(true);
    }

    public BaumOrtsterminEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    @Override
    public boolean isEditor() {
        return this.editor;
    }

    public boolean isOkForSaving() {
        if (BaumOrtsterminEditor.getErrorNoSave() != null) {
            this.noSave();
            return false;
        }
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        boolean noErrorOccured = this.baumOrtsterminPanel.isOkayForSaving(this.getCidsBean());
        try {
            if (this.getCidsBean().getProperty(FIELD__MELDUNG_ID) == null) {
                LOG.warn((Object)"No meldung specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_NOMELDUNG));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Meldung not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save && noErrorOccured;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.xtMeldung.getColumn(2).setWidth(100);
        this.xtMeldung.setSortable(false);
        this.xtMeldung.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.xtMeldung.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = BaumOrtsterminEditor.this.xtMeldung.rowAtPoint(e.getPoint());
                int col = BaumOrtsterminEditor.this.xtMeldung.columnAtPoint(e.getPoint());
                if (row > -1 && col > -1) {
                    Object value = BaumOrtsterminEditor.this.xtMeldung.getValueAt(row, col);
                    if (null != value && !"".equals(value)) {
                        BaumOrtsterminEditor.this.xtMeldung.setToolTipText(value.toString());
                    } else {
                        BaumOrtsterminEditor.this.xtMeldung.setToolTipText(null);
                    }
                }
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.comboBoxFilterDialogGebiet = new ComboBoxFilterDialog(null, (AbstractMonToLwmoSearch)new BaumMeldungLightweightSearch(), "Gebiet-Meldung ausw\u00e4hlen", this.getConnectionContext());
        this.panContent = new RoundedPanel();
        this.panOrtstermin = new JPanel();
        this.lblGebiet_Meldung = new JLabel();
        this.btnChangeGebiet = new JButton();
        this.jScrollPaneMeldung = new JScrollPane();
        this.xtMeldung = new JXTable();
        this.panOrtstermineMain = new JPanel();
        this.baumOrtsterminPanel = this.baumOrtsterminPanel = new BaumOrtsterminPanel(this.getBaumChildrenLoader());
        this.setLayout(new GridBagLayout());
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panOrtstermin.setOpaque(false);
        this.panOrtstermin.setLayout(new GridBagLayout());
        this.lblGebiet_Meldung.setFont(new Font("Tahoma", 1, 11));
        this.lblGebiet_Meldung.setText("Gebiet-Meldung:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panOrtstermin.add((Component)this.lblGebiet_Meldung, gridBagConstraints);
        this.btnChangeGebiet.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32.png")));
        this.btnChangeGebiet.setToolTipText("Gebiet - Meldung zuweisen");
        this.btnChangeGebiet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumOrtsterminEditor.this.btnChangeGebietActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        this.panOrtstermin.add((Component)this.btnChangeGebiet, gridBagConstraints);
        this.btnChangeGebiet.setVisible(this.isEditor());
        this.xtMeldung.setModel((TableModel)new OrtsterminMeldungTableModel());
        this.xtMeldung.setVisibleRowCount(1);
        this.jScrollPaneMeldung.setViewportView((Component)this.xtMeldung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panOrtstermin.add((Component)this.jScrollPaneMeldung, gridBagConstraints);
        this.panOrtstermineMain.setOpaque(false);
        this.panOrtstermineMain.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean}"), (Object)this.baumOrtsterminPanel, (Property)BeanProperty.create((String)"cidsBean"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panOrtstermineMain.add((Component)this.baumOrtsterminPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panOrtstermin.add((Component)this.panOrtstermineMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.panOrtstermin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnChangeGebietActionPerformed(ActionEvent evt) {
        Object selectedItem = this.comboBoxFilterDialogGebiet.showAndGetSelected();
        if (selectedItem instanceof CidsBean) {
            CidsBean meldungBean = (CidsBean)selectedItem;
            this.setMeldungTable(meldungBean);
            this.xtMeldung.getTableHeader().setForeground(Color.BLACK);
            try {
                this.getCidsBean().setProperty(FIELD__MELDUNG, (Object)meldungBean);
            }
            catch (Exception ex) {
                LOG.warn((Object)"problem in setbeanproperty: fk_meldung.", (Throwable)ex);
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        block5: {
            try {
                this.bindingGroup.unbind();
                this.cidsBean = cb;
                if (this.teilBeans != null) {
                    Collections.sort(this.teilBeans, COMPARATOR);
                }
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
                this.bindingGroup.bind();
                if (this.getCidsBean().getProperty(FIELD__MELDUNG) == null) {
                    this.xtMeldung.getTableHeader().setForeground(Color.red);
                } else {
                    this.xtMeldung.getTableHeader().setForeground(Color.BLACK);
                    this.setMeldungTable((CidsBean)this.getCidsBean().getProperty(FIELD__MELDUNG));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Bean not set.", (Throwable)ex);
                if (!this.isEditor()) break block5;
                BaumOrtsterminEditor.setErrorNoSave(ex);
                this.noSave();
            }
        }
    }

    public void noSave() {
        ErrorInfo info = new ErrorInfo(NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_NOSAVE_TITLE), NbBundle.getMessage(BaumOrtsterminEditor.class, (String)BUNDLE_NOSAVE_MESSAGE), null, null, (Throwable)BaumOrtsterminEditor.getErrorNoSave(), Level.SEVERE, null);
        JXErrorPane.showDialog((Component)((Object)this), (ErrorInfo)info);
    }

    private void setMeldungTable(CidsBean meldungBean) {
        ArrayList<CidsBean> meldungBeans = new ArrayList<CidsBean>();
        meldungBeans.add(meldungBean);
        ((OrtsterminMeldungTableModel)this.xtMeldung.getModel()).setCidsBeans(meldungBeans);
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly((JComponent)this.xtMeldung);
            this.btnChangeGebiet.setVisible(this.isEditor());
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)"baum_ortstermin", (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_ORTSTERMIN;
        }
        Calendar calDatumZeit = Calendar.getInstance();
        calDatumZeit.setTime((Date)this.getCidsBean().getProperty(FIELD__ZEIT));
        Date datum = calDatumZeit.getTime();
        SimpleDateFormat formatTag = new SimpleDateFormat("dd.MM.yy");
        return String.format("G: %s - M: %s - Ortstermin: %s", this.getCidsBean().getProperty(FIELD__GEBIET_AZ), formatTag.format(this.getCidsBean().getProperty(FIELD__MELDUNG_DATUM)), formatTag.format(datum));
    }

    private void clearBaumChildrenLoader() {
        this.getBaumChildrenLoader().clearAllMaps();
        this.getBaumChildrenLoader().setLoadingCompletedWithoutError(false);
    }

    public void dispose() {
        super.dispose();
        this.baumOrtsterminPanel.dispose();
        this.xtMeldung.removeAll();
        ((OrtsterminMeldungTableModel)this.xtMeldung.getModel()).clear();
        this.clearBaumChildrenLoader();
        this.comboBoxFilterDialogGebiet.dispose();
    }

    public void setTitle(String string) {
    }

    public static Exception getErrorNoSave() {
        return errorNoSave;
    }

    public static void setErrorNoSave(Exception errorNoSave) {
        BaumOrtsterminEditor.errorNoSave = errorNoSave;
    }

    public BaumChildrenLoader getBaumChildrenLoader() {
        return this.baumChildrenLoader;
    }

    class MustSetTableModel
    extends CidsBeansTableModel {
        public MustSetTableModel() {
            super(MELDUNG_PROP_NAMES, MUSTSET_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }

    class LoadingTableModel
    extends CidsBeansTableModel {
        public LoadingTableModel() {
            super(MELDUNG_PROP_NAMES, LOADING_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }

    class OrtsterminMeldungTableModel
    extends CidsBeansTableModel {
        public OrtsterminMeldungTableModel() {
            super(MELDUNG_PROP_NAMES, MELDUNG_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }

    private static enum OtherTableCases {
        SET_VALUE,
        REDUNDANT_ATT_NAME;

    }
}

