/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.objecteditors.utils.BaumChildrenLoader;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumParentPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumSchadenPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.ComboBoxFilterDialog;
import de.cismet.cids.custom.wunda_blau.search.server.AbstractMonToLwmoSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BaumMeldungLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.AfterClosingHook;
import de.cismet.cids.editors.hooks.AfterSavingHook;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class BaumSchadenEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
AfterClosingHook,
AfterSavingHook,
BaumParentPanel {
    private static final Logger LOG = Logger.getLogger(BaumSchadenEditor.class);
    private static final String[] MELDUNG_COL_NAMES = new String[]{"Gebiet-Aktenzeichen", "Gebiet-Bemerkung", "Meldungsdatum", "Meldung-Bemerkung"};
    private static final String[] MELDUNG_PROP_NAMES = new String[]{"fk_gebiet.aktenzeichen", "fk_gebiet.bemerkung", "datum", "bemerkung"};
    private static final Class[] MELDUNG_PROP_TYPES = new Class[]{CidsBean.class, CidsBean.class, Date.class, String.class};
    private static final String[] LOADING_COL_NAMES = new String[]{"Die Daten werden geladen......"};
    private static final String[] MUSTSET_COL_NAMES = new String[]{"Die Daten bitte zuweisen......"};
    private static final String TITLE_NEW_SCHADEN = "einen neuen Schaden anlegen ....";
    public static final String FIELD__ID = "id";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    public static final String FIELD__SCHADEN_OHNE = "ohne_schaden";
    public static final String FIELD__SCHADEN_EFEU = "efeu";
    public static final String FIELD__SCHADEN_KRONE = "kronenschaden";
    public static final String FIELD__SCHADEN_STAMM = "stammschaden";
    public static final String FIELD__SCHADEN_WURZEL = "wurzelschaden";
    public static final String FIELD__SCHADEN_STURM = "sturmschaden";
    public static final String FIELD__SCHADEN_ABGESTORBEN = "abgestorben";
    public static final String FIELD__SCHADEN_GUTACHTEN = "gutachten";
    public static final String FIELD__SCHADEN_BERATUNG = "baumberatung";
    public static final String FIELD__SCHADEN_EINGANG = "eingegangen";
    public static final String FIELD__SCHADEN_FAELLUNG = "faellung";
    public static final String FIELD__SCHADEN_ABGELEHNT = "abgelehnt";
    public static final String FIELD__SCHADEN_GEFAHR = "gefahrensbaum";
    public static final String FIELD__SCHADEN_KLEISTUNG = "keine_leistung";
    public static final String FIELD__MELDUNG = "fk_meldung";
    public static final String FIELD__SCHADEN = "fk_schaden";
    public static final String FIELD__MELDUNG_ID = "fk_meldung.id";
    public static final String FIELD__MELDUNG_DATUM = "fk_meldung.datum";
    public static final String FIELD__GEBIET_AZ = "fk_meldung.fk_gebiet.aktenzeichen";
    public static final String TABLE__ERSATZ = "baum_ersatz";
    public static final String TABLE__FEST = "baum_festsetzung";
    public static final String TABLE__MELDUNG = "baum_meldung";
    public static final String TABLE_NAME = "baum_schaden";
    public static final String BUNDLE_PANE_PREFIX = "BaumSchadenEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BaumSchadenEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BaumSchadenEditor.isOkForSaving().JOptionPane.title";
    public static final String BUNDLE_PANE_TITLE_PERSIST = "BaumSchadenEditor.editorClose().JOptionPane.title";
    public static final String BUNDLE_PANE_PREFIX_ERSATZ = "BaumSchadenEditor.editorClose().JOptionPane.errorErsatz";
    public static final String BUNDLE_PANE_PREFIX_FEST = "BaumSchadenEditor.editorClose().JOptionPane.errorFest";
    public static final String BUNDLE_PANE_KONTROLLE = "BaumSchadenEditor.editorClose().JOptionPane.kontrolle";
    public static final String BUNDLE_PANE_ADMIN = "BaumSchadenEditor.editorClose().JOptionPane.admin";
    public static final String BUNDLE_LOAD_ERROR = "BaumSchadenEditor.loadChildren().error";
    public static final String BUNDLE_NOMELDUNG = "BaumSchadenEditor.isOkForSaving().noMeldung";
    public static final String BUNDLE_NOSAVE_MESSAGE = "BaumSchadenEditor.noSave().message";
    public static final String BUNDLE_NOSAVE_TITLE = "BaumSchadenEditor.noSave().title";
    private static Exception errorNoSave = null;
    private final boolean editor;
    private final BaumChildrenLoader baumChildrenLoader = new BaumChildrenLoader(this);
    private boolean areChildrenLoad = false;
    private BaumSchadenPanel baumSchadenPanel;
    private JButton btnChangeGebiet;
    private ComboBoxFilterDialog comboBoxFilterDialogGebiet;
    private Box.Filler filler1;
    private JScrollPane jScrollPaneMeldung;
    private JLabel lblGebiet_Meldung;
    private JPanel panAll;
    private JPanel panContent;
    private JPanel panFillerUnten;
    JPanel panSchaden;
    private JXTable xtMeldung;
    private BindingGroup bindingGroup;

    public BaumSchadenEditor() {
        this(true);
    }

    public BaumSchadenEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.xtMeldung.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.xtMeldung.setSortable(false);
        this.xtMeldung.getColumn(2).setMaxWidth(150);
        this.xtMeldung.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = BaumSchadenEditor.this.xtMeldung.rowAtPoint(e.getPoint());
                int col = BaumSchadenEditor.this.xtMeldung.columnAtPoint(e.getPoint());
                if (row > -1 && col > -1) {
                    Object value = BaumSchadenEditor.this.xtMeldung.getValueAt(row, col);
                    if (null != value && !"".equals(value)) {
                        BaumSchadenEditor.this.xtMeldung.setToolTipText(value.toString());
                    } else {
                        BaumSchadenEditor.this.xtMeldung.setToolTipText(null);
                    }
                }
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.comboBoxFilterDialogGebiet = new ComboBoxFilterDialog(null, (AbstractMonToLwmoSearch)new BaumMeldungLightweightSearch(), "Gebiet-Meldung ausw\u00e4hlen", this.getConnectionContext());
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panAll = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.panSchaden = new JPanel();
        this.baumSchadenPanel = this.baumSchadenPanel = new BaumSchadenPanel(this.getBaumChildrenLoader());
        this.btnChangeGebiet = new JButton();
        this.jScrollPaneMeldung = new JScrollPane();
        this.xtMeldung = new JXTable();
        this.lblGebiet_Meldung = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panAll.setOpaque(false);
        this.panAll.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panAll.add((Component)this.filler1, gridBagConstraints);
        this.panSchaden.setOpaque(false);
        this.panSchaden.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean}"), (Object)this.baumSchadenPanel, (Property)BeanProperty.create((String)"cidsBean"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panSchaden.add((Component)this.baumSchadenPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panAll.add((Component)this.panSchaden, gridBagConstraints);
        this.btnChangeGebiet.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32.png")));
        this.btnChangeGebiet.setToolTipText("Gebiet - Meldung zuweisen");
        this.btnChangeGebiet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumSchadenEditor.this.btnChangeGebietActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(2, 5, 5, 0);
        this.panAll.add((Component)this.btnChangeGebiet, gridBagConstraints);
        this.btnChangeGebiet.setVisible(this.isEditor());
        this.xtMeldung.setModel((TableModel)new SchadenMeldungTableModel());
        this.xtMeldung.setVisibleRowCount(1);
        this.jScrollPaneMeldung.setViewportView((Component)this.xtMeldung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panAll.add((Component)this.jScrollPaneMeldung, gridBagConstraints);
        this.lblGebiet_Meldung.setFont(new Font("Tahoma", 1, 11));
        this.lblGebiet_Meldung.setText("Gebiet-Meldung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panAll.add((Component)this.lblGebiet_Meldung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.panAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnChangeGebietActionPerformed(ActionEvent evt) {
        Object selectedItem = this.comboBoxFilterDialogGebiet.showAndGetSelected();
        if (selectedItem instanceof CidsBean) {
            CidsBean meldungBean = (CidsBean)selectedItem;
            this.setMeldungTable(meldungBean);
            this.xtMeldung.getTableHeader().setForeground(Color.BLACK);
            try {
                this.getCidsBean().setProperty(FIELD__MELDUNG, (Object)meldungBean);
            }
            catch (Exception ex) {
                LOG.warn((Object)"problem in setbeanproperty: fk_meldung.", (Throwable)ex);
            }
        }
    }

    public boolean isOkForSaving() {
        if (BaumSchadenEditor.getErrorNoSave() != null) {
            this.noSave();
            return false;
        }
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        boolean noErrorOccured = this.baumSchadenPanel.isOkForSaving(this.getCidsBean());
        try {
            if (this.getCidsBean().getProperty(FIELD__MELDUNG_ID) == null) {
                LOG.warn((Object)"No meldung specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_NOMELDUNG));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Meldung not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save && noErrorOccured;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    @Override
    public boolean isEditor() {
        return this.editor;
    }

    public void setCidsBean(CidsBean cb) {
        block7: {
            try {
                this.bindingGroup.unbind();
                this.cidsBean = cb;
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.getCidsBean(), (ConnectionContext)this.getConnectionContext());
                this.bindingGroup.bind();
                if (this.getCidsBean().getMetaObject().getStatus() == 1) {
                    this.setDefaultValues();
                }
                if (this.getCidsBean() != null && this.getCidsBean().getMetaObject().getStatus() != 1) {
                    this.loadChildren(this.getCidsBean().getPrimaryKeyValue());
                }
                if (this.getCidsBean() != null) {
                    if (this.getCidsBean().getProperty(FIELD__MELDUNG) == null) {
                        this.xtMeldung.getTableHeader().setForeground(Color.red);
                    } else {
                        this.xtMeldung.getTableHeader().setForeground(Color.BLACK);
                        this.setMeldungTable((CidsBean)this.getCidsBean().getProperty(FIELD__MELDUNG));
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Bean not set.", (Throwable)ex);
                if (!this.isEditor()) break block7;
                BaumSchadenEditor.setErrorNoSave(ex);
                this.noSave();
            }
        }
    }

    public void noSave() {
        ErrorInfo info = new ErrorInfo(NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_NOSAVE_TITLE), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_NOSAVE_MESSAGE), null, null, (Throwable)BaumSchadenEditor.getErrorNoSave(), Level.SEVERE, null);
        JXErrorPane.showDialog((Component)((Object)this), (ErrorInfo)info);
    }

    private void setMeldungTable(CidsBean meldungBean) {
        ArrayList<CidsBean> meldungBeans = new ArrayList<CidsBean>();
        meldungBeans.add(meldungBean);
        ((SchadenMeldungTableModel)this.xtMeldung.getModel()).setCidsBeans(meldungBeans);
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            this.btnChangeGebiet.setVisible(this.editor);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE__MELDUNG, (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_SCHADEN;
        }
        SimpleDateFormat formatTag = new SimpleDateFormat("dd.MM.yy");
        return String.format("G: %s - M: %s - Schaden: %s", this.getCidsBean().getProperty(FIELD__GEBIET_AZ), formatTag.format(this.getCidsBean().getProperty(FIELD__MELDUNG_DATUM)), this.getCidsBean().getProperty(FIELD__ID));
    }

    public void dispose() {
        this.baumSchadenPanel.dispose();
        this.xtMeldung.removeAll();
        ((SchadenMeldungTableModel)this.xtMeldung.getModel()).clear();
        this.baumChildrenLoader.clearAllMaps();
        this.comboBoxFilterDialogGebiet.dispose();
    }

    public void setDefaultValues() {
        try {
            this.getCidsBean().setProperty(FIELD__SCHADEN_ABGESTORBEN, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_BERATUNG, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_EINGANG, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_FAELLUNG, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_ABGELEHNT, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_GUTACHTEN, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_KRONE, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_OHNE, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_EFEU, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_STAMM, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_STURM, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_WURZEL, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_GEFAHR, (Object)false);
            this.getCidsBean().setProperty(FIELD__SCHADEN_KLEISTUNG, (Object)false);
        }
        catch (Exception ex) {
            LOG.warn((Object)"problem in set default values.", (Throwable)ex);
        }
    }

    private void clearBaumChildrenLoader() {
        this.getBaumChildrenLoader().clearAllMaps();
        this.getBaumChildrenLoader().setLoadingCompletedWithoutError(false);
    }

    public void setTitle(String string) {
    }

    private void loadChildren(final Integer id) {
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return BaumSchadenEditor.this.getBaumChildrenLoader().loadChildrenForSchaden(id, BaumSchadenEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    BaumSchadenEditor.this.areChildrenLoad = (Boolean)this.get();
                    BaumSchadenEditor.this.getBaumChildrenLoader().setLoadingCompletedWithoutError(BaumSchadenEditor.this.areChildrenLoad);
                    if (!BaumSchadenEditor.this.areChildrenLoad) {
                        BaumSchadenEditor.this.setTitle(NbBundle.getMessage(BaumSchadenEditor.class, (String)BaumSchadenEditor.BUNDLE_LOAD_ERROR));
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.error((Object)"Fehler beim Laden der Unterobjekte.", (Throwable)ex);
                }
            }
        }.execute();
    }

    public void afterSaving(AfterSavingHook.Event event) {
        try {
            if (AfterSavingHook.Status.SAVE_SUCCESS == event.getStatus()) {
                List<Object> listErsatz = new ArrayList();
                Map<Integer, List<CidsBean>> mapErsatz = this.getBaumChildrenLoader().getMapErsatz();
                for (Integer key : mapErsatz.keySet()) {
                    listErsatz = mapErsatz.get(key);
                }
                List<Object> listFest = new ArrayList();
                Map<Integer, List<CidsBean>> mapFest = this.getBaumChildrenLoader().getMapFest();
                for (Integer n : mapFest.keySet()) {
                    listFest = mapFest.get(n);
                }
                if (listErsatz != null && !listErsatz.isEmpty()) {
                    for (CidsBean cidsBean : listErsatz) {
                        try {
                            cidsBean.setProperty(FIELD__SCHADEN, (Object)event.getPersistedBean());
                            cidsBean.persist(this.getConnectionContext());
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Fehler beim Speichern der Ersatzpflanzungen.", (Throwable)ex);
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_PREFIX_ERSATZ) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_KONTROLLE) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_ADMIN) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_TITLE_PERSIST), 0);
                        }
                    }
                }
                if (listFest != null && !listFest.isEmpty()) {
                    for (CidsBean cidsBean : listFest) {
                        try {
                            cidsBean.setProperty(FIELD__SCHADEN, (Object)event.getPersistedBean());
                            cidsBean.persist(this.getConnectionContext());
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Fehler beim Speichern der Festsetzungen.", (Throwable)ex);
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_PREFIX_FEST) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_KONTROLLE) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_ADMIN) + NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumSchadenEditor.class, (String)BUNDLE_PANE_TITLE_PERSIST), 0);
                        }
                    }
                }
            }
        }
        catch (HeadlessException | MissingResourceException ex) {
            LOG.error((Object)"Fehler bei der Speichernachbereitung.", (Throwable)ex);
        }
    }

    public void afterClosing(AfterClosingHook.Event event) {
        this.clearBaumChildrenLoader();
    }

    public static Exception getErrorNoSave() {
        return errorNoSave;
    }

    public static void setErrorNoSave(Exception errorNoSave) {
        BaumSchadenEditor.errorNoSave = errorNoSave;
    }

    public BaumChildrenLoader getBaumChildrenLoader() {
        return this.baumChildrenLoader;
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        RegexPatternFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }
    }

    class MustSetTableModel
    extends CidsBeansTableModel {
        public MustSetTableModel() {
            super(MELDUNG_PROP_NAMES, MUSTSET_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }

    class LoadingTableModel
    extends CidsBeansTableModel {
        public LoadingTableModel() {
            super(MELDUNG_PROP_NAMES, LOADING_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }

    class SchadenMeldungTableModel
    extends CidsBeansTableModel {
        public SchadenMeldungTableModel() {
            super(MELDUNG_PROP_NAMES, MELDUNG_COL_NAMES, MELDUNG_PROP_TYPES);
        }
    }
}

