/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.custom.objecteditors.wunda_blau.EmobradLadestationEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EmobradSteckerEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(EmobradSteckerEditor.class);
    public static final String FIELD__SCHLUESSEL = "schluessel";
    public static final String FIELD__KWATT = "kilowatt";
    public static final String FIELD__AMPERE = "ampere";
    public static final String FIELD__VOLT = "volt";
    public static final String FIELD__TYP = "typ";
    public static final String FIELD__ID = "id";
    public static final String TABLE_NAME = "emobrad_stecker";
    public static final String BUNDLE_NONAME = "EmobradSteckerEditor.prepareForSave().noName";
    public static final String BUNDLE_DUPLICATENAME = "EmobradSteckerEditor.prepareForSave().duplicateName";
    public static final String BUNDLE_DUPLICATEKEY = "EmobradSteckerEditor.prepareForSave().duplicateSchluessel";
    public static final String BUNDLE_NOKWATT = "EmobradSteckerEditor.prepareForSave().noKiloWatt";
    public static final String BUNDLE_WRONGKWATT = "EmobradSteckerEditor.prepareForSave().wrongKiloWatt";
    public static final String BUNDLE_NOAMPERE = "EmobradSteckerEditor.prepareForSave().noAmpere";
    public static final String BUNDLE_WRONGAMPERE = "EmobradSteckerEditor.prepareForSave().wrongAmpere";
    public static final String BUNDLE_NOVOLT = "EmobradSteckerEditor.prepareForSave().noVolt";
    public static final String BUNDLE_WRONGVOLT = "EmobradSteckerEditor.prepareForSave().wrongVolt";
    public static final String BUNDLE_PANE_PREFIX = "EmobradSteckerEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "EmobradSteckerEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "EmobradSteckerEditor.prepareForSave().JOptionPane.title";
    private SwingWorker worker_key;
    private SwingWorker worker_name;
    private Boolean redundantName = false;
    private Boolean redundantKey = false;
    private boolean isEditor = true;
    private JFormattedTextField ftxtAmpere;
    private JFormattedTextField ftxtVolt;
    private JLabel lblAmpere;
    private JLabel lblKWatt;
    private JLabel lblTyp;
    private JLabel lblVolt;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panName;
    JSpinner spKWatt;
    private JTextField txtTyp;
    private BindingGroup bindingGroup;

    public EmobradSteckerEditor() {
    }

    public EmobradSteckerEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        DocumentListener keyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmobradSteckerEditor.this.checkAttributes();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmobradSteckerEditor.this.checkAttributes();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmobradSteckerEditor.this.checkAttributes();
            }
        };
        this.txtTyp.getDocument().addDocumentListener(keyListener);
        ((JSpinner.DefaultEditor)this.spKWatt.getEditor()).getTextField().getDocument().addDocumentListener(keyListener);
        this.ftxtAmpere.getDocument().addDocumentListener(keyListener);
        this.ftxtVolt.getDocument().addDocumentListener(keyListener);
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panFillerUnten1 = new JPanel();
        this.panName = new JPanel();
        this.lblTyp = new JLabel();
        this.txtTyp = new JTextField();
        this.lblKWatt = new JLabel();
        this.spKWatt = new JSpinner();
        this.lblAmpere = new JLabel();
        this.ftxtAmpere = new JFormattedTextField();
        this.lblVolt = new JLabel();
        this.ftxtVolt = new JFormattedTextField();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblTyp.setFont(new Font("Tahoma", 1, 11));
        this.lblTyp.setText("Typ:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panName.add((Component)this.lblTyp, gridBagConstraints);
        this.txtTyp.setHorizontalAlignment(4);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.typ}"), (Object)this.txtTyp, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtTyp, gridBagConstraints);
        this.lblKWatt.setFont(new Font("Tahoma", 1, 11));
        this.lblKWatt.setText("Kilowatt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panName.add((Component)this.lblKWatt, gridBagConstraints);
        this.spKWatt.setFont(new Font("Dialog", 0, 12));
        this.spKWatt.setModel(new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1));
        this.spKWatt.setName("spKWatt");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.kilowatt}"), (Object)this.spKWatt, (Property)BeanProperty.create((String)"value"));
        binding.setSourceNullValue((Object)0.0);
        binding.setSourceUnreadableValue((Object)0.0);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.spKWatt, gridBagConstraints);
        this.lblAmpere.setFont(new Font("Tahoma", 1, 11));
        this.lblAmpere.setText("Ampere:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panName.add((Component)this.lblAmpere, gridBagConstraints);
        this.ftxtAmpere.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#####"))));
        this.ftxtAmpere.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.ampere}"), (Object)this.ftxtAmpere, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.ftxtAmpere, gridBagConstraints);
        this.lblVolt.setFont(new Font("Tahoma", 1, 11));
        this.lblVolt.setText("Volt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panName.add((Component)this.lblVolt, gridBagConstraints);
        this.ftxtVolt.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#####"))));
        this.ftxtVolt.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.volt}"), (Object)this.ftxtVolt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.ftxtVolt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public boolean prepareForSave() {
        StringBuilder errorMessage;
        boolean save;
        block25: {
            block24: {
                save = true;
                errorMessage = new StringBuilder();
                try {
                    if (this.txtTyp.getText().trim().isEmpty()) {
                        LOG.warn((Object)"No name specified. Skip persisting.");
                        errorMessage.append(NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_NONAME));
                    } else {
                        if (this.cidsBean.getMetaObject().getStatus() == 1) {
                            this.cidsBean.setProperty(FIELD__SCHLUESSEL, (Object)this.createKey());
                        }
                        if (this.redundantName.booleanValue()) {
                            LOG.warn((Object)"Duplicate attributes specified. Skip persisting.");
                            errorMessage.append(NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_DUPLICATENAME));
                        } else if (this.redundantKey.booleanValue()) {
                            LOG.warn((Object)"Duplicate key specified. Skip persisting.");
                            errorMessage.append(NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_DUPLICATEKEY));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Name not given.", (Throwable)ex);
                    save = false;
                }
                try {
                    if (this.spKWatt.getValue().equals(0.0)) {
                        LOG.warn((Object)"No kilowatt specified. Skip persisting.");
                        errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_NOKWATT));
                    }
                }
                catch (MissingResourceException ex) {
                    LOG.warn((Object)"KiloWatt not given.", (Throwable)ex);
                    save = false;
                }
                try {
                    if (this.ftxtAmpere.getText().trim().isEmpty()) {
                        LOG.warn((Object)"No ampere specified. Skip persisting.");
                        errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_NOAMPERE));
                        break block24;
                    }
                    try {
                        if (Integer.parseInt(this.ftxtAmpere.getText()) <= 0) {
                            errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_WRONGAMPERE));
                        }
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)"Wrong ampere specified. Skip persisting.", (Throwable)e);
                        errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_WRONGAMPERE));
                    }
                }
                catch (MissingResourceException ex) {
                    LOG.warn((Object)"Ampere not given.", (Throwable)ex);
                    save = false;
                }
            }
            try {
                if (this.ftxtVolt.getText().trim().isEmpty()) {
                    LOG.warn((Object)"No volt specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_NOVOLT));
                    break block25;
                }
                try {
                    if (Integer.parseInt(this.ftxtVolt.getText()) <= 0) {
                        errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_WRONGVOLT));
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)"Wrong volt specified. Skip persisting.", (Throwable)e);
                    errorMessage.append(NbBundle.getMessage(EmobradLadestationEditor.class, (String)BUNDLE_WRONGVOLT));
                }
            }
            catch (MissingResourceException ex) {
                LOG.warn((Object)"Volt not given.", (Throwable)ex);
                save = false;
            }
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(EmobradSteckerEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.txtTyp);
            RendererTools.makeDoubleSpinnerWithoutButtons(this.spKWatt, 1);
            RendererTools.makeReadOnly(this.spKWatt);
            RendererTools.makeReadOnly(this.ftxtAmpere);
            RendererTools.makeReadOnly(this.ftxtVolt);
        }
    }

    public String createKey() {
        return this.txtTyp.getText().trim() + " (" + String.format(Locale.ROOT, "%.1f", this.spKWatt.getValue()) + "kW, " + this.ftxtAmpere.getText().trim() + "A, " + this.ftxtVolt.getText().trim() + "V)";
    }

    private void checkKey(String field, String insertValues, OtherTableCases fall) {
        this.valueFromOtherTable(TABLE_NAME, " where " + field + " ilike '" + insertValues + "' and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID), fall);
    }

    private void checkName(String where, OtherTableCases fall) {
        this.valueFromOtherTable(TABLE_NAME, where + " and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID), fall);
    }

    private void checkAttributes() {
        this.checkName(" where typ ilike '" + this.cidsBean.getProperty(FIELD__TYP) + "' and " + FIELD__AMPERE + " = " + this.cidsBean.getProperty(FIELD__AMPERE) + " and " + FIELD__VOLT + " = " + this.cidsBean.getProperty(FIELD__VOLT) + " and " + FIELD__KWATT + " = " + this.cidsBean.getProperty(FIELD__KWATT), OtherTableCases.REDUNDANT_NAME);
        this.checkKey(FIELD__SCHLUESSEL, this.createKey(), OtherTableCases.REDUNDANT_ATT_KEY);
    }

    public void dispose() {
        super.dispose();
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    private void valueFromOtherTable(final String tableName, final String whereClause, final OtherTableCases fall) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, EmobradSteckerEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        CidsBean check = (CidsBean)this.get();
                        if (check != null) {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradSteckerEditor.this.redundantKey = true;
                                    break;
                                }
                                case REDUNDANT_NAME: {
                                    EmobradSteckerEditor.this.redundantName = true;
                                }
                            }
                        } else {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradSteckerEditor.this.redundantKey = false;
                                    break;
                                }
                                case REDUNDANT_NAME: {
                                    EmobradSteckerEditor.this.redundantName = false;
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)"problem in Worker: load values.", (Throwable)e);
                }
            }
        };
        if (fall.equals((Object)OtherTableCases.REDUNDANT_NAME)) {
            if (this.worker_name != null) {
                this.worker_name.cancel(true);
            }
            this.worker_name = worker;
            this.worker_name.execute();
        } else {
            if (this.worker_key != null) {
                this.worker_key.cancel(true);
            }
            this.worker_key = worker;
            this.worker_key.execute();
        }
    }

    private static enum OtherTableCases {
        REDUNDANT_ATT_KEY,
        REDUNDANT_NAME;

    }
}

