/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.custom.objecteditors.wunda_blau.GrundwassermessstelleMesswerteDiagrammPanel;
import de.cismet.cids.dynamics.CidsBean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXList;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GrundwassermessstelleDiagrammAxisPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(GrundwassermessstelleDiagrammAxisPanel.class);
    private final GrundwassermessstelleMesswerteDiagrammPanel diagrammPanel;
    private final List<CidsBean> disabledStoffBeans = new ArrayList<CidsBean>();
    private JLabel jLabel1;
    private JList<CidsBean> jList1;
    private JScrollPane jScrollPane3;

    public GrundwassermessstelleDiagrammAxisPanel() {
        this.initComponents();
        this.diagrammPanel = null;
    }

    public GrundwassermessstelleDiagrammAxisPanel(GrundwassermessstelleMesswerteDiagrammPanel diagrammPanel) {
        this.diagrammPanel = diagrammPanel;
        this.initComponents();
    }

    public void setStoffBeans(Collection<CidsBean> stoffBeans) {
        this.disabledStoffBeans.clear();
        ((DefaultListModel)this.jList1.getModel()).clear();
        if (stoffBeans != null) {
            for (CidsBean stoffBean : stoffBeans) {
                ((DefaultListModel)this.jList1.getModel()).addElement(stoffBean);
            }
        }
    }

    public void setAxisName(String name) {
        this.jLabel1.setText(name);
        this.jLabel1.setVisible(name != null);
    }

    public String getAxisName() {
        return this.jLabel1.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jList1 = new MesswerteList();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GrundwassermessstelleDiagrammAxisPanel.class, (String)"GrundwassermessstelleDiagrammAxisPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setViewportBorder(null);
        this.jList1.setBorder(null);
        this.jList1.setCellRenderer(new MesswerteListCellRenderer());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GrundwassermessstelleDiagrammAxisPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane3, gridBagConstraints);
    }

    private void jList1MouseClicked(MouseEvent evt) {
        JList list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            int index = list.locationToIndex(evt.getPoint());
            CidsBean stoffBean = (CidsBean)((DefaultListModel)list.getModel()).get(index);
            if (stoffBean != null) {
                if (this.disabledStoffBeans.contains(stoffBean)) {
                    this.disabledStoffBeans.remove(stoffBean);
                } else {
                    this.disabledStoffBeans.add(stoffBean);
                }
                this.diagrammPanel.refreshChart();
                list.repaint();
            }
        }
    }

    public List<CidsBean> getStoffBeans() {
        ArrayList<CidsBean> stoffBeans = new ArrayList<CidsBean>();
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        for (int index = 0; index < model.getSize(); ++index) {
            CidsBean stoffBean = (CidsBean)model.getElementAt(index);
            stoffBeans.add(stoffBean);
        }
        return stoffBeans;
    }

    public List<CidsBean> getEnabledStoffBeans() {
        List<CidsBean> stoffBeans = this.getStoffBeans();
        stoffBeans.removeAll(this.disabledStoffBeans);
        return stoffBeans;
    }

    class StoffBeanTransferable
    implements Transferable {
        private final MesswerteListDnDObject stoffBean;

        public StoffBeanTransferable(MesswerteListDnDObject stoffBean) {
            this.stoffBean = stoffBean;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.match(GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return flavor.match(GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR) ? this.stoffBean : null;
        }
    }

    class MesswerteList
    extends JXList
    implements DropTargetListener,
    DragGestureListener,
    DragSourceListener {
        private final transient DragSource dragSource;

        public MesswerteList() {
            super(new DefaultListModel());
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this);
            new DropTarget((Component)((Object)this), 3, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            int index = this.locationToIndex(dge.getDragOrigin());
            CidsBean stoffBean = (CidsBean)((DefaultListModel)this.getModel()).getElementAt(this.convertIndexToModel(index));
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, new StoffBeanTransferable(new MesswerteListDnDObject(stoffBean, this)), this);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                MesswerteListDnDObject mldo;
                Object o = dtde.getTransferable().getTransferData(GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR);
                if (o instanceof MesswerteListDnDObject && !this.equals((mldo = (MesswerteListDnDObject)o).getSource())) {
                    CidsBean stoffBean = mldo.getStoffBean();
                    ListModel model = ((MesswerteList)((Object)dtde.getDropTargetContext().getComponent())).getModel();
                    if (!((DefaultListModel)model).contains(stoffBean)) {
                        ((DefaultListModel)model).addElement(stoffBean);
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"could not drop", (Throwable)e);
                dtde.dropComplete(false);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                try {
                    Object o = dsde.getDragSourceContext().getTransferable().getTransferData(GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR);
                    if (o instanceof MesswerteListDnDObject) {
                        MesswerteListDnDObject mldo = (MesswerteListDnDObject)o;
                        CidsBean stoffBean = mldo.getStoffBean();
                        ListModel model = ((MesswerteList)((Object)dsde.getDragSourceContext().getComponent())).getModel();
                        if (((DefaultListModel)model).contains(stoffBean)) {
                            ((DefaultListModel)model).removeElement(stoffBean);
                            GrundwassermessstelleDiagrammAxisPanel.this.disabledStoffBeans.remove(stoffBean);
                        }
                    }
                    GrundwassermessstelleDiagrammAxisPanel.this.diagrammPanel.refreshChart();
                    GrundwassermessstelleDiagrammAxisPanel.this.jList1.revalidate();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not obtain transferable data", (Throwable)ex);
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        public DefaultListModel<CidsBean> getModel() {
            return (DefaultListModel)super.getModel();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }
    }

    class MesswerteListDnDObject {
        private final CidsBean stoffBean;
        private final MesswerteList source;

        MesswerteListDnDObject(CidsBean stoffBean, MesswerteList source) {
            this.stoffBean = stoffBean;
            this.source = source;
        }

        public CidsBean getStoffBean() {
            return this.stoffBean;
        }

        public MesswerteList getSource() {
            return this.source;
        }
    }

    class MesswerteListCellRenderer
    extends DefaultListCellRenderer {
        MesswerteListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
            CidsBean stoffBean = (CidsBean)value;
            String schluessel = (String)stoffBean.getProperty("schluessel");
            boolean enabled = !GrundwassermessstelleDiagrammAxisPanel.this.disabledStoffBeans.contains(stoffBean);
            label.setEnabled(enabled);
            if (enabled) {
                label.setIcon(GrundwassermessstelleDiagrammAxisPanel.this.diagrammPanel.createIcon(schluessel));
            } else {
                label.setDisabledIcon(GrundwassermessstelleDiagrammAxisPanel.this.diagrammPanel.createIcon(null));
            }
            String name = (String)stoffBean.getProperty("name");
            String einheit = (String)stoffBean.getProperty("einheit");
            label.setText(name + (einheit != null ? " (" + einheit + ")" : ""));
            return label;
        }
    }
}

