/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.objecteditors.wunda_blau.GrundwassermessstelleMesswerteDiagrammPanel;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.server.GrundwassermessstelleMessungenSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.layout.WrapLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jfree.chart.JFreeChart;

public class GrundwassermessstelleMessungenTablePanel
extends JPanel
implements ConnectionContextStore,
CidsBeanStore {
    private static final Logger LOG = Logger.getLogger(GrundwassermessstelleMessungenTablePanel.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private CidsBean cidsBean;
    private final Map<String, CidsBean> kategorieMap = new HashMap<String, CidsBean>();
    private final Map<String, CidsBean> stoffMap = new HashMap<String, CidsBean>();
    private final boolean editable;
    private boolean loading = true;
    private boolean messungenEnabled = false;
    private final ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            GrundwassermessstelleMessungenTablePanel.this.jXTable1.requestFocusInWindow();
        }
    };
    private JButton btnAdd;
    private JButton btnRemove;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private GrundwassermessstelleMesswerteDiagrammPanel grundwassermessstelleMesswerteDiagrammPanel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JXTable jXTable1;
    private JXBusyLabel jxLBusyMeasure;

    public GrundwassermessstelleMessungenTablePanel() {
        this(false);
    }

    public GrundwassermessstelleMessungenTablePanel(boolean editable) {
        this.editable = editable;
    }

    public boolean isMessungenEnabled() {
        return this.messungenEnabled;
    }

    public void setLoading(final boolean loading) {
        this.loading = loading;
        this.refreshTabPane();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!loading) {
                    GrundwassermessstelleMessungenTablePanel.this.getDiagrammPanel().refreshChart();
                }
            }
        });
    }

    private CidsBean getStoffBean(String schluessel) {
        return this.stoffMap.get(schluessel);
    }

    private CidsBean getKategorieBean(String schluessel) {
        return this.kategorieMap.get(schluessel);
    }

    private void initComponents() {
        this.grundwassermessstelleMesswerteDiagrammPanel1 = new GrundwassermessstelleMesswerteDiagrammPanel(this.getConnectionContext());
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jXTable1 = new JXTable();
        this.jPanel3 = new JPanel();
        this.btnRemove = new JButton();
        this.btnAdd = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel5 = new JPanel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jxLBusyMeasure = new JXBusyLabel(new Dimension(64, 64));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout((LayoutManager)new WrapLayout(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new CardLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jXTable1.setModel((TableModel)new MesswerteTableModel());
        this.jXTable1.setOpaque(false);
        this.jXTable1.setRowFilter((RowFilter)new MesswertRowFilter());
        this.jXTable1.setTerminateEditOnFocusLost(false);
        this.jXTable1.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GrundwassermessstelleMessungenTablePanel.this.jXTable1FocusGained(evt);
            }
        });
        this.jXTable1.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                GrundwassermessstelleMessungenTablePanel.this.jXTable1KeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.jXTable1);
        this.jXTable1.setDefaultRenderer(Double.class, (TableCellRenderer)new MesswertTableCellRenderer());
        this.jXTable1.setDefaultEditor(Date.class, (TableCellEditor)new DatumTableCellEditor());
        this.jXTable1.setDefaultEditor(Double.class, (TableCellEditor)new MesswertTableCellEditor());
        this.jXTable1.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.jXTable1.getColumnModel().getSelectionModel().addListSelectionListener(this.listSelectionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrundwassermessstelleMessungenTablePanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.btnRemove, gridBagConstraints);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrundwassermessstelleMessungenTablePanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel3.add((Component)this.btnAdd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel3.setVisible(this.editable);
        this.jPanel4.add((Component)this.jPanel1, "table");
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.filler2, gridBagConstraints);
        this.jxLBusyMeasure.setHorizontalAlignment(0);
        this.jxLBusyMeasure.setBusy(true);
        this.jxLBusyMeasure.setPreferredSize(new Dimension(64, 64));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel5.add((Component)this.jxLBusyMeasure, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel5, "progress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        try {
            CidsBean messungBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"grundwassermessstelle_messung", (ConnectionContext)this.getConnectionContext());
            messungBean.setProperty("messstelle_id", this.cidsBean.getProperty("id"));
            if (this.getModel().getKategorieBean() != null) {
                messungBean.setProperty("kategorie_schluessel", this.getModel().getKategorieBean().getProperty("schluessel"));
            }
            this.getModel().addMessung(messungBean);
            int rowIndex = this.getModel().getRowIndex(messungBean);
            this.jXTable1.setRowSelectionInterval(rowIndex, rowIndex);
            this.jXTable1.scrollRowToVisible(rowIndex);
        }
        catch (Exception ex) {
            LOG.error((Object)"error while creating new messung", (Throwable)ex);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int rowIndex;
        int n = rowIndex = this.jXTable1.getSelectedRow() >= 0 ? this.jXTable1.convertRowIndexToModel(this.jXTable1.getSelectedRow()) : -1;
        if (rowIndex >= 0) {
            CidsBean messungBean = this.getModel().getMessungBean(rowIndex);
            this.getModel().removeMessung(messungBean);
        }
    }

    private void jXTable1FocusGained(FocusEvent evt) {
        int row = this.jXTable1.getSelectedRow();
        int col = this.jXTable1.getSelectedColumn();
        this.jXTable1.changeSelection(row, col, false, false);
        this.jXTable1.editCellAt(row, col);
        if (this.jXTable1.getCellEditor() instanceof MesswertTableCellEditor) {
            MesswertTableCellEditor editor = (MesswertTableCellEditor)this.jXTable1.getCellEditor();
            final JFormattedTextField textField = editor.getFormattedTextField();
            textField.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textField.selectAll();
                }
            });
        } else if (this.jXTable1.getCellEditor() instanceof DatumTableCellEditor) {
            DatumTableCellEditor editor = (DatumTableCellEditor)this.jXTable1.getCellEditor();
            final JFormattedTextField textField = editor.getDatePicker().getEditor();
            textField.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textField.selectAll();
                }
            });
        } else if (this.jXTable1.getCellEditor() instanceof DefaultCellEditor) {
            DefaultCellEditor editor = (DefaultCellEditor)this.jXTable1.getCellEditor();
            final JTextField textField = (JTextField)editor.getComponent();
            textField.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textField.selectAll();
                }
            });
        }
    }

    private void jXTable1KeyTyped(KeyEvent evt) {
    }

    private void refreshTabPane() {
        if (this.loading) {
            ((CardLayout)this.jPanel4.getLayout()).show(this.jPanel4, "progress");
        } else {
            ((CardLayout)this.jPanel4.getLayout()).show(this.jPanel4, "table");
        }
    }

    private void loadKategorien() throws Exception {
        this.setLoading(true);
        this.kategorieMap.clear();
        this.stoffMap.clear();
        this.jPanel2.removeAll();
        new SwingWorker<List<CidsBean>, Void>(){

            @Override
            protected List<CidsBean> doInBackground() throws Exception {
                MetaClass kategorieMc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"grundwassermessstelle_kategorie", (ConnectionContext)GrundwassermessstelleMessungenTablePanel.this.getConnectionContext());
                User user = SessionManager.getSession().getUser();
                MetaObject[] kategorieMos = SessionManager.getProxy().getAllLightweightMetaObjectsForClass(kategorieMc.getId(), user, new String[]{"id", "name"}, "%1$2s", GrundwassermessstelleMessungenTablePanel.this.getConnectionContext());
                ArrayList<CidsBean> kategorieBeans = new ArrayList<CidsBean>(kategorieMos.length);
                for (MetaObject kategorieMo : kategorieMos) {
                    if (kategorieMo == null) continue;
                    kategorieBeans.add(kategorieMo.getBean());
                }
                kategorieBeans.sort(new Comparator<CidsBean>(){

                    @Override
                    public int compare(CidsBean cidsBean1, CidsBean cidsBean2) {
                        Integer o2;
                        Integer o1 = cidsBean1 != null ? (Integer)cidsBean1.getProperty("reihenfolge") : null;
                        Integer n = o2 = cidsBean2 != null ? (Integer)cidsBean2.getProperty("reihenfolge") : null;
                        if (o2 == null) {
                            return 1;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        return Integer.compare(o1, o2);
                    }
                });
                return kategorieBeans;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    List kategorieBeans = (List)this.get();
                    for (CidsBean kategorieBean : kategorieBeans) {
                        GrundwassermessstelleMessungenTablePanel.this.kategorieMap.put((String)kategorieBean.getProperty("schluessel"), kategorieBean);
                        for (CidsBean stoffBean : kategorieBean.getBeanCollectionProperty("stoffe")) {
                            GrundwassermessstelleMessungenTablePanel.this.stoffMap.put((String)stoffBean.getProperty("schluessel"), stoffBean);
                        }
                    }
                    ButtonGroup bg = new ButtonGroup();
                    AbstractButton firstButton = null;
                    CidsBean firstKategorieBean = null;
                    ArrayList kategorieSchluessels = new ArrayList(GrundwassermessstelleMessungenTablePanel.this.kategorieMap.keySet());
                    kategorieSchluessels.sort(new Comparator<String>(){

                        @Override
                        public int compare(String schluessel1, String schluessel2) {
                            Integer reihenfolge2;
                            CidsBean kategorie1 = GrundwassermessstelleMessungenTablePanel.this.getKategorieBean(schluessel1);
                            CidsBean kategorie2 = GrundwassermessstelleMessungenTablePanel.this.getKategorieBean(schluessel2);
                            Integer reihenfolge1 = kategorie1 != null ? (Integer)kategorie1.getProperty("reihenfolge") : null;
                            Integer n = reihenfolge2 = kategorie2 != null ? (Integer)kategorie2.getProperty("reihenfolge") : null;
                            if (reihenfolge1 == null && reihenfolge2 == null) {
                                return 0;
                            }
                            if (reihenfolge1 == null) {
                                return -1;
                            }
                            if (reihenfolge2 == null) {
                                return 1;
                            }
                            return Integer.compare(reihenfolge1, reihenfolge2);
                        }
                    });
                    for (String kategorieSchluessel : kategorieSchluessels) {
                        CidsBean kategorieBean = GrundwassermessstelleMessungenTablePanel.this.getKategorieBean(kategorieSchluessel);
                        StoffgruppeButton button = new StoffgruppeButton(kategorieBean);
                        if (firstButton == null) {
                            firstButton = button;
                            firstKategorieBean = kategorieBean;
                        }
                        GrundwassermessstelleMessungenTablePanel.this.jPanel2.add(button);
                        bg.add(button);
                    }
                    GrundwassermessstelleMessungenTablePanel.this.jPanel1.repaint();
                    if (firstButton != null) {
                        firstButton.setSelected(true);
                    }
                    GrundwassermessstelleMessungenTablePanel.this.setKategorie(firstKategorieBean);
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while loading kategorie bean", (Throwable)ex);
                }
                finally {
                    GrundwassermessstelleMessungenTablePanel.this.setLoading(false);
                }
            }
        }.execute();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.messungenEnabled = ObjectRendererUtils.hasUserPermissionOnMetaClass(CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"GRUNDWASSERMESSSTELLE_MESSUNG", (ConnectionContext)this.getConnectionContext()), SessionManager.getSession().getUser(), ObjectRendererUtils.PermissionType.READ);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.initComponents();
        if (this.messungenEnabled) {
            try {
                this.loadKategorien();
            }
            catch (Exception ex) {
                LOG.error((Object)"error while initializing context", (Throwable)ex);
            }
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private MesswerteTableModel getModel() {
        return (MesswerteTableModel)this.jXTable1.getModel();
    }

    private void loadMessungen() {
        if (this.cidsBean != null) {
            this.setLoading(true);
            new SwingWorker<List, Void>(){

                @Override
                protected List doInBackground() throws Exception {
                    ArrayList<CidsBean> messungBeans = new ArrayList<CidsBean>();
                    Integer messstelleId = (Integer)GrundwassermessstelleMessungenTablePanel.this.cidsBean.getProperty("id");
                    if (messstelleId != null) {
                        GrundwassermessstelleMessungenSearch search = new GrundwassermessstelleMessungenSearch(messstelleId.intValue());
                        Collection messungMons = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, GrundwassermessstelleMessungenTablePanel.this.getConnectionContext());
                        for (MetaObjectNode messungMon : messungMons) {
                            MetaObject messungMo = SessionManager.getProxy().getMetaObject(messungMon.getObjectId(), messungMon.getClassId(), "WUNDA_BLAU", GrundwassermessstelleMessungenTablePanel.this.getConnectionContext());
                            CidsBean messungBean = messungMo.getBean();
                            messungBeans.add(messungBean);
                        }
                    }
                    return messungBeans;
                }

                @Override
                protected void done() {
                    try {
                        List messungBeans = (List)this.get();
                        GrundwassermessstelleMessungenTablePanel.this.setMessungBeans(messungBeans);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error while loading messung beans", (Throwable)ex);
                    }
                    finally {
                        GrundwassermessstelleMessungenTablePanel.this.setLoading(false);
                    }
                }
            }.execute();
        }
    }

    public GrundwassermessstelleMesswerteDiagrammPanel getDiagrammPanel() {
        return this.grundwassermessstelleMesswerteDiagrammPanel1;
    }

    public JFreeChart getChart() {
        return this.grundwassermessstelleMesswerteDiagrammPanel1.createChartPanel();
    }

    private void setMessungBeans(List<CidsBean> messungBeans) {
        this.getModel().setMessungBeans(messungBeans);
        this.grundwassermessstelleMesswerteDiagrammPanel1.refreshChart();
        if (this.jXTable1.getRowSorter().getSortKeys().isEmpty()) {
            this.jXTable1.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.loadMessungen();
    }

    private void setKategorie(CidsBean kategorieBean) {
        this.getModel().setKategorieBean(kategorieBean);
        this.grundwassermessstelleMesswerteDiagrammPanel1.setMessungBeans(this.getCurrentKategorieMessungBeans());
        this.grundwassermessstelleMesswerteDiagrammPanel1.setStoffBeans(this.getKategorieBean().getBeanCollectionProperty("stoffe"));
        this.grundwassermessstelleMesswerteDiagrammPanel1.refreshChart();
        if (this.jXTable1.getRowSorter().getSortKeys().isEmpty()) {
            this.jXTable1.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        }
    }

    public CidsBean getKategorieBean() {
        return this.getModel().getKategorieBean();
    }

    public List<CidsBean> getAllMessungBeans() {
        return new ArrayList<CidsBean>(((MesswerteTableModel)this.jXTable1.getModel()).getMessungBeans());
    }

    public List<CidsBean> getCurrentKategorieMessungBeans() {
        ArrayList<CidsBean> kategorieMessungBeans = new ArrayList<CidsBean>();
        for (int rowIndex = 0; rowIndex < this.jXTable1.getRowCount(); ++rowIndex) {
            CidsBean messungBean = this.getModel().getMessungBean(this.jXTable1.convertRowIndexToModel(rowIndex));
            kategorieMessungBeans.add(messungBean);
        }
        return kategorieMessungBeans;
    }

    public JPanel getButtonPanel() {
        return this.jPanel2;
    }

    class DatumTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JXDatePicker datePicker = new JXDatePicker();

        public DatumTableCellEditor() {
            this.datePicker.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatumTableCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Date date = (Date)value;
            this.datePicker.setDate(date);
            return this.datePicker;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                this.datePicker.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.datePicker.getDate();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        public JXDatePicker getDatePicker() {
            return this.datePicker;
        }
    }

    class MesswertTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JFormattedTextField formattedTextField;

        public MesswertTableCellEditor() {
            this.formattedTextField = new JFormattedTextField(new MesswertNumberFormatter());
            this.formattedTextField.setHorizontalAlignment(4);
            this.formattedTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MesswertTableCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
            this.formattedTextField.setValue(value != null ? Double.valueOf(((Number)value).doubleValue()) : null);
            return this.formattedTextField;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                this.formattedTextField.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.formattedTextField.getValue() != null ? Double.valueOf(((Number)this.formattedTextField.getValue()).doubleValue()) : null;
        }

        public JFormattedTextField getFormattedTextField() {
            return this.formattedTextField;
        }
    }

    class MesswertNumberFormatter
    extends NumberFormatter {
        public MesswertNumberFormatter() {
            super(new MesswertNumberFormat());
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            return super.stringToValue(string);
        }
    }

    class MesswertNumberFormat
    extends NumberFormat {
        final NumberFormat nf = NumberFormat.getNumberInstance(Locale.GERMAN);

        MesswertNumberFormat() {
            this(null);
        }

        MesswertNumberFormat(Integer nachkommastellen) {
            if (nachkommastellen != null) {
                this.nf.setMinimumFractionDigits(nachkommastellen);
                this.nf.setMaximumFractionDigits(nachkommastellen);
            }
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return new StringBuffer(NumberFormat.getNumberInstance(Locale.GERMAN).format(number, toAppendTo, pos).toString().replaceFirst("-", "< "));
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return new StringBuffer(NumberFormat.getNumberInstance(Locale.GERMAN).format(number, toAppendTo, pos).toString().replaceFirst("-", "< "));
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            String newSource;
            if (source == null) {
                newSource = null;
            } else if (source.trim().startsWith("< ")) {
                newSource = source.trim().replaceFirst("< ", "-");
            } else if (source.trim().startsWith("<")) {
                newSource = source.trim().replaceFirst("<", "-");
            } else {
                if (source.trim().isEmpty()) {
                    return null;
                }
                newSource = source.trim();
            }
            return NumberFormat.getNumberInstance(Locale.GERMAN).parse(newSource, parsePosition);
        }
    }

    class MesswertTableCellRenderer
    extends DefaultTableCellRenderer {
        MesswertTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            CidsBean messungBean = GrundwassermessstelleMessungenTablePanel.this.getModel().getMessungBeans().get(GrundwassermessstelleMessungenTablePanel.this.jXTable1.getRowSorter().convertRowIndexToModel(rowIndex));
            CidsBean stoffBean = GrundwassermessstelleMessungenTablePanel.this.getModel().getStoffBean(columnIndex);
            for (CidsBean messwertBean : messungBean.getBeanCollectionProperty("messwerte")) {
                if (!stoffBean.equals((Object)GrundwassermessstelleMessungenTablePanel.this.getStoffBean((String)messwertBean.getProperty("stoff_schluessel")))) continue;
                Double wert = (Double)messwertBean.getProperty("wert");
                MesswertNumberFormat format = new MesswertNumberFormat((Integer)stoffBean.getProperty("nachkommastellen"));
                label.setHorizontalAlignment(11);
                String einheit = (String)stoffBean.getProperty("einheit");
                label.setText(wert != null ? format.format(wert) + (einheit != null ? " " + einheit : "") : null);
                break;
            }
            return label;
        }
    }

    class MesswerteTableModel
    extends AbstractTableModel {
        private List<CidsBean> messungBeans;
        private CidsBean kategorieBean;

        public void setMessungBeans(List<CidsBean> messungBeans) {
            this.messungBeans = messungBeans;
            this.fireTableDataChanged();
        }

        public void setKategorieBean(CidsBean kategorieBean) {
            this.kategorieBean = kategorieBean;
            this.fireTableStructureChanged();
        }

        public int getRowIndex(CidsBean messungBean) {
            return this.messungBeans.indexOf(messungBean);
        }

        public void addMessung(CidsBean messungBean) {
            this.messungBeans.add(messungBean);
            this.fireTableDataChanged();
        }

        public void removeMessung(CidsBean messungBean) {
            this.messungBeans.remove(messungBean);
            this.fireTableDataChanged();
        }

        public CidsBean getKategorieBean() {
            return this.kategorieBean;
        }

        public List<CidsBean> getMessungBeans() {
            return this.messungBeans;
        }

        private boolean showBemerkung() {
            return Boolean.TRUE.equals(this.kategorieBean.getProperty("show_bemerkung_messung"));
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Datum";
            }
            if (this.showBemerkung() && columnIndex == this.getColumnCount() - 1) {
                return "Bemerkung";
            }
            CidsBean stoffBean = this.getStoffBean(columnIndex);
            return (String)stoffBean.getProperty("name");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return GrundwassermessstelleMessungenTablePanel.this.editable;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Date.class;
            }
            if (this.showBemerkung() && columnIndex == this.getColumnCount() - 1) {
                return String.class;
            }
            return Double.class;
        }

        @Override
        public int getRowCount() {
            return this.messungBeans != null ? this.messungBeans.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return this.kategorieBean != null ? this.kategorieBean.getBeanCollectionProperty("stoffe").size() + 1 + (this.showBemerkung() ? 1 : 0) : 0;
        }

        public CidsBean getStoffBean(int columnIndex) {
            int stoffIndex = columnIndex - 1;
            return (CidsBean)this.kategorieBean.getBeanCollectionProperty("stoffe").get(stoffIndex);
        }

        public CidsBean getMessungBean(int rowIndex) {
            return this.messungBeans.get(rowIndex);
        }

        public CidsBean getMesswertBean(int rowIndex, int columnIndex) {
            if (columnIndex > 0 && columnIndex < this.getColumnCount() - (this.showBemerkung() ? 1 : 0)) {
                CidsBean stoffBean = this.getStoffBean(columnIndex);
                CidsBean messungBean = this.getMessungBean(rowIndex);
                for (CidsBean messwertBean : messungBean.getBeanCollectionProperty("messwerte")) {
                    if (!stoffBean.equals((Object)GrundwassermessstelleMessungenTablePanel.this.getStoffBean((String)messwertBean.getProperty("stoff_schluessel")))) continue;
                    return messwertBean;
                }
                return null;
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CidsBean messungBean = this.getMessungBean(rowIndex);
            if (columnIndex == 0) {
                return messungBean.getProperty("datum");
            }
            if (this.showBemerkung() && columnIndex == this.getColumnCount() - 1) {
                return messungBean.getProperty("bemerkung");
            }
            CidsBean messwertBean = this.getMesswertBean(rowIndex, columnIndex);
            return messwertBean != null ? (Double)messwertBean.getProperty("wert") : null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
            try {
                CidsBean messungBean = this.getMessungBean(rowIndex);
                if (columnIndex == 0) {
                    messungBean.setProperty("datum", (Object)new java.sql.Date(((Date)value).getTime()));
                } else if (this.showBemerkung() && columnIndex == this.getColumnCount() - 1) {
                    messungBean.setProperty("bemerkung", (Object)((String)value));
                } else {
                    CidsBean foundMesswertBean = this.getMesswertBean(rowIndex, columnIndex);
                    if (foundMesswertBean != null) {
                        if (value != null) {
                            foundMesswertBean.setProperty("wert", (Object)((Double)value));
                        } else {
                            messungBean.getBeanCollectionProperty("messwerte").remove(foundMesswertBean);
                        }
                    } else {
                        try {
                            CidsBean stoffBean = this.getStoffBean(columnIndex);
                            if (value != null) {
                                CidsBean messwertBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"grundwassermessstelle_messwert", (ConnectionContext)GrundwassermessstelleMessungenTablePanel.this.getConnectionContext());
                                if (stoffBean != null) {
                                    messwertBean.setProperty("stoff_schluessel", stoffBean.getProperty("schluessel"));
                                }
                                messwertBean.setProperty("wert", (Object)((Double)value));
                                messungBean.getBeanCollectionProperty("messwerte").add(messwertBean);
                            }
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"error while creating messwertBean", (Throwable)ex);
                        }
                    }
                }
                GrundwassermessstelleMessungenTablePanel.this.getDiagrammPanel().refreshChart();
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not update value", (Throwable)ex);
            }
        }
    }

    class MesswertRowFilter
    extends RowFilter<TableModel, Integer> {
        MesswertRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            CidsBean messungBean = GrundwassermessstelleMessungenTablePanel.this.getModel().getMessungBeans().get(entry.getIdentifier());
            CidsBean kategorieBean = GrundwassermessstelleMessungenTablePanel.this.getModel().getKategorieBean();
            return kategorieBean != null && kategorieBean.equals((Object)GrundwassermessstelleMessungenTablePanel.this.getKategorieBean((String)messungBean.getProperty("kategorie_schluessel")));
        }
    }

    class StoffgruppeButton
    extends JToggleButton {
        StoffgruppeButton(final CidsBean kategorieBean) {
            super(kategorieBean.toString());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrundwassermessstelleMessungenTablePanel.this.setKategorie(kategorieBean);
                }
            });
        }
    }
}

