/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class KlimaortAussichtspunktEditor
extends JPanel
implements CidsBeanRenderer {
    private static final Logger LOG = Logger.getLogger(KlimaortAussichtspunktEditor.class);
    private final boolean editable;
    private CidsBean cidsBean;
    private ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"AussichtspunktEditor");
    private JButton btnRemStandort;
    private JComboBox cbGeom;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JList jlStandort;
    private JLabel lblBeschr;
    private JLabel lblGeom;
    private JLabel lblName;
    private JLabel lblStandort;
    private JPanel panIndikator;
    private JTextField txtBeschr;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public KlimaortAussichtspunktEditor() {
        this(true);
    }

    public KlimaortAussichtspunktEditor(boolean editable) {
        this.editable = editable;
        this.initComponents();
        this.jlStandort.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsBean) {
                    String name = (String)((CidsBean)value).getProperty("klima_standort.name");
                    ((JLabel)c).setText(name);
                    this.setText(name);
                }
                return c;
            }
        });
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblBeschr = new JLabel();
        this.txtBeschr = new JTextField();
        if (this.editable) {
            this.lblGeom = new JLabel();
        }
        if (this.editable) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
        }
        this.lblStandort = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jlStandort = new ImplementationList();
        this.panIndikator = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        if (this.editable) {
            this.btnRemStandort = new JButton();
        }
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblName.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.lblName.text", (Object[])new Object[0]));
        this.lblName.setName("lblName");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setName("txtName");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        this.jPanel1.add((Component)this.txtName, gridBagConstraints);
        this.lblBeschr.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.lblBeschr.text", (Object[])new Object[0]));
        this.lblBeschr.setName("lblBeschr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        this.jPanel1.add((Component)this.lblBeschr, gridBagConstraints);
        this.txtBeschr.setName("txtBeschr");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.description}"), (Object)this.txtBeschr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        this.jPanel1.add((Component)this.txtBeschr, gridBagConstraints);
        if (this.editable) {
            this.lblGeom.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.lblGeom.text", (Object[])new Object[0]));
            this.lblGeom.setName("lblGeom");
        }
        if (this.editable) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 10, 2, 2);
            this.jPanel1.add((Component)this.lblGeom, gridBagConstraints);
        }
        if (this.editable) {
            this.cbGeom.setFont(new Font("Dialog", 0, 12));
            this.cbGeom.setName("cbGeom");
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.editable) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 10);
            this.jPanel1.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblStandort.setHorizontalAlignment(0);
        this.lblStandort.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.lblStandort.text", (Object[])new Object[0]));
        this.lblStandort.setName("lblStandort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 10, 2, 10);
        this.jPanel1.add((Component)this.lblStandort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(290, 100));
        this.jScrollPane2.setName("jScrollPane2");
        this.jScrollPane2.setPreferredSize(new Dimension(490, 100));
        this.jlStandort.setSelectionMode(0);
        this.jlStandort.setName("jlStandort");
        this.jScrollPane2.setViewportView(this.jlStandort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 15, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.panIndikator.setMinimumSize(new Dimension(35, 100));
        this.panIndikator.setName("panIndikator");
        this.panIndikator.setOpaque(false);
        this.panIndikator.setPreferredSize(new Dimension(35, 100));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/clientutils/up.png")));
        this.jButton1.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.jButton1.text"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setMaximumSize(new Dimension(24, 24));
        this.jButton1.setMinimumSize(new Dimension(24, 24));
        this.jButton1.setName("jButton1");
        this.jButton1.setPreferredSize(new Dimension(24, 24));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KlimaortAussichtspunktEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.panIndikator.add(this.jButton1);
        this.jButton1.setVisible(this.isEditable());
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/clientutils/down.png")));
        this.jButton2.setText(NbBundle.getMessage(KlimaortAussichtspunktEditor.class, (String)"KlimaortAussichtspunktEditor.jButton2.text"));
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setMaximumSize(new Dimension(24, 24));
        this.jButton2.setMinimumSize(new Dimension(24, 24));
        this.jButton2.setName("jButton2");
        this.jButton2.setPreferredSize(new Dimension(24, 24));
        this.jButton2.setRequestFocusEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KlimaortAussichtspunktEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.panIndikator.add(this.jButton2);
        this.jButton2.setVisible(this.isEditable());
        if (this.editable) {
            this.btnRemStandort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
            this.btnRemStandort.setName("btnRemStandort");
            this.btnRemStandort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KlimaortAussichtspunktEditor.this.btnRemStandortActionPerformed(evt);
                }
            });
        }
        if (this.editable) {
            this.panIndikator.add(this.btnRemStandort);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        this.add((Component)this.panIndikator, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnRemStandortActionPerformed(ActionEvent evt) {
        int answer;
        Object selection = this.jlStandort.getSelectedValue();
        if (selection != null && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Soll der ausgew\u00e4hlte Standort wirklich gel\u00f6scht werden?", "Standort entfernen", 0)) == 0) {
            try {
                CidsBean beanToDelete = (CidsBean)selection;
                List<CidsBean> standortList = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "klima_standort");
                if (standortList != null) {
                    beanToDelete.delete();
                    standortList.remove(beanToDelete);
                    int pos = (Integer)beanToDelete.getProperty("reihenfolge");
                    for (CidsBean b : standortList) {
                        int reihenfolge = (Integer)b.getProperty("reihenfolge");
                        if (reihenfolge <= pos) continue;
                        b.setProperty("reihenfolge", (Object)(reihenfolge - 1));
                    }
                    ((CustomListModel)this.jlStandort.getModel()).init(this.cidsBean);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot remove klima_standort");
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Object selection = this.jlStandort.getSelectedValue();
        if (selection instanceof CidsBean) {
            Integer pos = (Integer)((CidsBean)selection).getProperty("reihenfolge");
            List<CidsBean> standortList = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "klima_standort");
            if (pos >= standortList.size() - 1) {
                return;
            }
            for (CidsBean bean : standortList) {
                int reihenfolge = (Integer)bean.getProperty("reihenfolge");
                if (reihenfolge == pos) {
                    try {
                        bean.setProperty("reihenfolge", (Object)(pos + 1));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while changing position", (Throwable)ex);
                    }
                    continue;
                }
                if (reihenfolge != pos + 1) continue;
                try {
                    bean.setProperty("reihenfolge", (Object)pos);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while changing position", (Throwable)ex);
                }
            }
            ((CustomListModel)this.jlStandort.getModel()).init(this.cidsBean);
            this.jlStandort.setSelectedValue(selection, true);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Object selection = this.jlStandort.getSelectedValue();
        if (selection instanceof CidsBean) {
            Integer pos = (Integer)((CidsBean)selection).getProperty("reihenfolge");
            if (pos == 0) {
                return;
            }
            List<CidsBean> standortList = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "klima_standort");
            for (CidsBean bean : standortList) {
                int reihenfolge = (Integer)bean.getProperty("reihenfolge");
                if (reihenfolge == pos) {
                    try {
                        bean.setProperty("reihenfolge", (Object)(pos - 1));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while changing position", (Throwable)ex);
                    }
                    continue;
                }
                if (reihenfolge != pos - 1) continue;
                try {
                    bean.setProperty("reihenfolge", (Object)pos);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while changing position", (Throwable)ex);
                }
            }
            ((CustomListModel)this.jlStandort.getModel()).init(this.cidsBean);
            this.jlStandort.setSelectedValue(selection, true);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (!this.editable) {
            RendererTools.makeReadOnly(this.bindingGroup, "cidsBean");
        }
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.connectionContext);
            this.bindingGroup.bind();
            this.jlStandort.setModel(new CustomListModel(cidsBean));
        }
    }

    public void dispose() {
    }

    public String getTitle() {
        String name;
        String string = name = this.cidsBean != null ? (String)this.cidsBean.getProperty("name") : null;
        if (name == null) {
            name = "unbenannt";
        }
        return "Aussichtspunkt: " + name;
    }

    public void setTitle(String string) {
    }

    public boolean isEditable() {
        return this.editable;
    }

    private static class CustomListModel
    implements ListModel<CidsBean> {
        private Map<Integer, CidsBean> positionMap = new HashMap<Integer, CidsBean>();
        private List<ListDataListener> listeners = new ArrayList<ListDataListener>();

        public CustomListModel(CidsBean aussichtspunktBean) {
            this.init(aussichtspunktBean);
        }

        public void init(CidsBean aussichtspunktBean) {
            this.positionMap = new HashMap<Integer, CidsBean>();
            List<CidsBean> standortList = CidsBeanSupport.getBeanCollectionFromProperty(aussichtspunktBean, "klima_standort");
            for (CidsBean bean : standortList) {
                this.positionMap.put((Integer)bean.getProperty("reihenfolge"), bean);
            }
            ListDataEvent event = new ListDataEvent(this, 0, 0, 0);
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(event);
            }
        }

        @Override
        public int getSize() {
            return this.positionMap.keySet().size();
        }

        @Override
        public CidsBean getElementAt(int index) {
            Integer[] keys = this.positionMap.keySet().toArray(new Integer[this.positionMap.keySet().size()]);
            return this.positionMap.get(keys[index]);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }

    private class ImplementationList
    extends JList
    implements CidsBeanDropListener {
        public ImplementationList() {
            block2: {
                try {
                    new CidsBeanDropTarget((Component)this);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug((Object)"error while creating CidsBeanDropTarget", (Throwable)ex);
                }
            }
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            if (KlimaortAussichtspunktEditor.this.cidsBean != null) {
                for (CidsBean bean : beans) {
                    if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Klima_standort")) continue;
                    List<CidsBean> standortList = CidsBeanSupport.getBeanCollectionFromProperty(KlimaortAussichtspunktEditor.this.cidsBean, "klima_standort");
                    try {
                        CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("KLIMAORT_AUSSICHTSPUNKT_KLIMA_STANDORT", KlimaortAussichtspunktEditor.this.connectionContext);
                        newBean.setProperty("klima_standort", (Object)bean);
                        newBean.setProperty("reihenfolge", (Object)standortList.size());
                        standortList.add(newBean);
                        ((CustomListModel)KlimaortAussichtspunktEditor.this.jlStandort.getModel()).init(KlimaortAussichtspunktEditor.this.cidsBean);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot create neu KLIMAORT_AUSSICHTSPUNKT_KLIMA_STANDORT", (Throwable)e);
                    }
                }
            }
        }
    }
}

