/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.clientutils.ServerResourcesLoaderClient;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.utils.MauernProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.BorderHighlighter;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class MauerDokumenteEditor
extends JPanel
implements RasterfariDocumentLoaderPanel.Listener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MauerDokumenteEditor.class);
    public static final String GEOFIELD_PROPERTY = "georeferenz.geo_field";
    public static final String DOCUMENTS_TABLE = "mauer_dokument";
    public static final String DOCUMENTS_PROPERTY = "n_dokumente";
    public static final String POSITION_PROPERTY = "position";
    public static final String NAME_PROPERTY = "name";
    public static final String FILENAME_PROPERTY = "filename";
    public static final String ART_PROPERTY = "fk_art";
    private static final Pattern IMAGE_FILE_PATTERN = Pattern.compile(".*\\.(bmp|png|jpg|jpeg|tif|tiff|wbmp)$", 2);
    private static final Pattern PDF_FILE_PATTERN = Pattern.compile(".*\\.pdf$", 2);
    private static final String[] COLUMN_PROPERTIES = new String[]{"position", "name", "fk_art"};
    private static final String[] FLAECHE_COLUMN_NAMES = new String[]{"#", "Dateiname", "Art"};
    private static final Class[] FLAECHE_COLUMN_CLASSES = new Class[]{Integer.class, String.class, String.class};
    private boolean editable;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final WebDavTunnelHelper webdavHelper;
    private final List<CidsBean> addedDocumentBeans = new ArrayList<CidsBean>();
    private final List<CidsBean> removedDocumentBeans = new ArrayList<CidsBean>();
    private CidsBean mauerBean;
    private final MauernProperties properties;
    private final FileFilter imageFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || IMAGE_FILE_PATTERN.matcher(f.getName()).matches();
        }

        @Override
        public String getDescription() {
            return "Bilddateien";
        }
    };
    private final FileFilter pdfFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || PDF_FILE_PATTERN.matcher(f.getName()).matches();
        }

        @Override
        public String getDescription() {
            return "Dokumente";
        }
    };
    JButton btnAddImg;
    JButton btnDown;
    private JButton btnOpen;
    JButton btnRemoveImg;
    JButton btnUp;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox<String> jComboBox1;
    private JDialog jDialog1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList<String> jList1;
    private JPanel jPanel1;
    private JPanel jPanel15;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JXTable jXTable2;
    private JXBusyLabel jxLBusy;
    private JLabel lblCurrentViewTitle;
    private JLabel lblHeaderDocuments;
    private JLabel lblHeaderDocuments1;
    private RoundedPanel panRasterfari;
    private JPanel pnlBild;
    private RoundedPanel pnlDocuments;
    private RoundedPanel pnlDocuments1;
    private SemiRoundedPanel pnlHeaderDocuments;
    private SemiRoundedPanel pnlHeaderDocuments1;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private SemiRoundedPanel semiRoundedPanel1;
    private BindingGroup bindingGroup;

    public MauerDokumenteEditor() {
        this(true);
    }

    public MauerDokumenteEditor(boolean editable) {
        this.editable = editable;
        WebDavTunnelHelper webdavHelper = null;
        MauernProperties properties = null;
        try {
            properties = (MauernProperties)ServerResourcesLoaderClient.getInstance().get((PropertiesServerResource)WundaBlauServerResources.MAUERN_PROPERTIES.getValue(), true);
            String pass = properties.getWebdavPassword();
            if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                pass = PasswordEncrypter.decryptString((String)pass);
            }
            String user = properties.getWebdavUser();
            webdavHelper = new WebDavTunnelHelper("WUNDA_BLAU", ProxyHandler.getInstance().getProxy(), user, pass, Boolean.valueOf(false));
        }
        catch (Exception ex) {
            String message = "Fehler beim Initialisieren der Bilderablage.";
            LOG.error((Object)"Fehler beim Initialisieren der Bilderablage.", (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Initialisieren der Bilderablage.", ex, null);
        }
        this.webdavHelper = webdavHelper;
        this.properties = properties;
    }

    public void deleteRemovedDocumentBeans() {
        this.deleteDocumentBeans(this.removedDocumentBeans);
    }

    public void deleteAddedDocumentBeans() {
        this.deleteDocumentBeans(this.addedDocumentBeans);
    }

    private void deleteDocumentBeans(Collection<CidsBean> documentBeans) {
        for (CidsBean deleteBean : documentBeans) {
            String fileName = (String)deleteBean.getProperty("url_object_name");
            String webdavUrl = this.properties.getWebdavUrl();
            try {
                this.webdavHelper.deleteFileFromWebDAV(fileName, webdavUrl, this.getConnectionContext());
                deleteBean.delete();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                MauerDokumenteEditor.showExceptionToUser(ex, this);
            }
        }
    }

    private void showDocumentCard(DocumentCard card) {
        ((CardLayout)this.pnlBild.getLayout()).show(this.pnlBild, card.toString());
    }

    public void showMeasureIsLoading() {
        this.showDocumentCard(DocumentCard.BUSY);
    }

    public void showMeasurePanel() {
        this.showDocumentCard(DocumentCard.DOCUMENT);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.jDialog1.pack();
        this.jXTable2.addHighlighter((Highlighter)new ColorHighlighter((component1, componentAdapter) -> {
            if (!this.isEditable() || componentAdapter.column != 1) {
                return false;
            }
            return this.removedDocumentBeans.contains(this.getTableModel().getCidsBean(this.jXTable2.convertRowIndexToModel(componentAdapter.row)));
        }, Color.WHITE, Color.RED));
        this.jXTable2.addHighlighter((Highlighter)new ColorHighlighter((component1, componentAdapter) -> {
            if (!this.isEditable() || componentAdapter.column != 1) {
                return false;
            }
            return this.addedDocumentBeans.contains(this.getTableModel().getCidsBean(this.jXTable2.convertRowIndexToModel(componentAdapter.row)));
        }, Color.WHITE, Color.GREEN.darker()));
        this.jXTable2.addHighlighter((Highlighter)new BorderHighlighter((component1, componentAdapter) -> {
            if (componentAdapter.column != 0) {
                return false;
            }
            CidsBean documentBean = this.getTableModel().getCidsBean(this.jXTable2.convertRowIndexToModel(componentAdapter.row));
            if (documentBean == null) {
                return false;
            }
            List sortedByPositionFotos = this.getDocumentBeans().stream().filter(b -> !this.removedDocumentBeans.contains(b)).filter(b -> "foto".equals(b.getProperty("fk_art.schluessel"))).sorted(Comparator.comparing(b -> (Integer)b.getProperty(POSITION_PROPERTY), Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
            CidsBean lowest1 = sortedByPositionFotos.size() > 0 ? (CidsBean)sortedByPositionFotos.get(0) : null;
            CidsBean lowest2 = sortedByPositionFotos.size() > 1 ? (CidsBean)sortedByPositionFotos.get(1) : null;
            return documentBean.equals((Object)lowest1) || documentBean.equals((Object)lowest2);
        }, (Border)new LineBorder(Color.GRAY)));
        this.jXTable2.getColumnModel().getColumn(0).setMinWidth(30);
        this.jXTable2.getColumnModel().getColumn(0).setMaxWidth(30);
        this.jXTable2.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.jXTable2.getSelectionModel().addListSelectionListener(e -> this.documentSelectionChanged());
        TableRowSorter<DokumenteTableModel> tableRowSorter = new TableRowSorter<DokumenteTableModel>(this.getTableModel());
        tableRowSorter.setComparator(2, Comparator.nullsLast(Comparator.comparing(CidsBean::toString)));
        tableRowSorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.jXTable2.setRowSorter(tableRowSorter);
        tableRowSorter.setRowFilter(new DocumentRowFilter());
        this.btnAddImg.setVisible(this.editable);
        this.btnRemoveImg.setVisible(this.editable);
        this.btnDown.setVisible(this.editable);
        this.btnUp.setVisible(this.editable);
        tableRowSorter.sort();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jFileChooser1 = new JFileChooser();
        this.jDialog1 = new JDialog();
        this.jPanel7 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new DefaultBindableReferenceCombo(new DefaultBindableReferenceCombo.Option[]{new DefaultBindableReferenceCombo.MetaClassOption(ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"mauer_dokument_art", (ConnectionContext)this.getConnectionContext()))});
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel8 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel15 = new JPanel();
        this.panRasterfari = new RoundedPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.lblCurrentViewTitle = new JLabel();
        this.btnOpen = new JButton();
        this.pnlBild = new JPanel();
        this.jPanel1 = new JPanel();
        this.rasterfariDocumentLoaderPanel1 = new RasterfariDocumentLoaderPanel(this.properties.getRasterfariUrl(), (RasterfariDocumentLoaderPanel.Listener)this, this.getConnectionContext());
        this.jPanel2 = new JPanel();
        this.jxLBusy = new JXBusyLabel(new Dimension(64, 64));
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel4 = new JLabel();
        this.pnlDocuments = new RoundedPanel();
        this.pnlHeaderDocuments = new SemiRoundedPanel();
        this.lblHeaderDocuments = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jPanel5 = new JPanel();
        this.btnAddImg = new JButton();
        this.btnRemoveImg = new JButton();
        this.jPanel6 = new JPanel();
        this.btnDown = new JButton();
        this.btnUp = new JButton();
        this.jPanel20 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jXTable2 = new JXTable();
        this.pnlDocuments1 = new RoundedPanel();
        this.pnlHeaderDocuments1 = new SemiRoundedPanel();
        this.lblHeaderDocuments1 = new JLabel();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jPanel21 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = this.rasterfariDocumentLoaderPanel1.getLstPages();
        this.jFileChooser1.setMultiSelectionEnabled(true);
        this.jDialog1.setTitle(NbBundle.getMessage(MauerDokumenteEditor.class, (String)"MauerDokumenteEditor.jDialog1.title"));
        this.jDialog1.setModal(true);
        this.jDialog1.setResizable(false);
        this.jDialog1.getContentPane().setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel3.setText(NbBundle.getMessage(MauerDokumenteEditor.class, (String)"MauerDokumenteEditor.jLabel3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel7.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel7.add(this.jComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jDialog1.getContentPane().add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new FlowLayout(2));
        this.jButton1.setText(NbBundle.getMessage(MauerDokumenteEditor.class, (String)"MauerDokumenteEditor.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jButton1);
        this.jButton2.setText(NbBundle.getMessage(MauerDokumenteEditor.class, (String)"MauerDokumenteEditor.jButton2.text"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.jComboBox1, (Property)ELProperty.create((String)"${selectedItem != null}"), (Object)this.jButton2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jDialog1.getContentPane().add((Component)this.jPanel8, gridBagConstraints);
        this.setMaximumSize(new Dimension(1190, 1625));
        this.setMinimumSize(new Dimension(807, 485));
        this.setOpaque(false);
        this.setVerifyInputWhenFocusTarget(false);
        this.setLayout(new CardLayout());
        this.jPanel15.setOpaque(false);
        this.jPanel15.setLayout(new GridBagLayout());
        this.panRasterfari.setMinimumSize(new Dimension(400, 200));
        this.panRasterfari.setPreferredSize(new Dimension(400, 200));
        this.panRasterfari.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel1.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel1.setPreferredSize(new Dimension(67, 32));
        this.semiRoundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.lblCurrentViewTitle.setForeground(new Color(255, 255, 255));
        this.lblCurrentViewTitle.setHorizontalAlignment(0);
        this.lblCurrentViewTitle.setText("Vorschau");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel1.add((Component)this.lblCurrentViewTitle, (Object)gridBagConstraints);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/inbox-download.png")));
        this.btnOpen.setText(NbBundle.getMessage(MauerDokumenteEditor.class, (String)"MauerDokumenteEditor.btnOpen.text"));
        this.btnOpen.setToolTipText("Download zum \u00d6ffnen in externer Anwendung");
        this.btnOpen.setBorderPainted(false);
        this.btnOpen.setContentAreaFilled(false);
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.btnOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.semiRoundedPanel1.add((Component)this.btnOpen, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panRasterfari.add((Component)this.semiRoundedPanel1, (Object)gridBagConstraints);
        this.pnlBild.setOpaque(false);
        this.pnlBild.setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.rasterfariDocumentLoaderPanel1, gridBagConstraints);
        this.pnlBild.add((Component)this.jPanel1, "DOCUMENT");
        this.jPanel2.setLayout(new BorderLayout());
        this.jxLBusy.setHorizontalAlignment(0);
        this.jxLBusy.setPreferredSize(new Dimension(64, 64));
        this.jPanel2.add((Component)this.jxLBusy, "Center");
        this.pnlBild.add((Component)this.jPanel2, "BUSY");
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Kein Dokument ausgew\u00e4hlt.");
        this.jPanel3.add((Component)this.jLabel1, "Center");
        this.pnlBild.add((Component)this.jPanel3, "NO_DOCUMENT");
        this.jPanel4.setLayout(new BorderLayout());
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Das Dokument konnte nicht geladen werden.");
        this.jPanel4.add((Component)this.jLabel2, "Center");
        this.pnlBild.add((Component)this.jPanel4, "ERROR");
        this.jPanel9.setLayout(new BorderLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Keine Vorschau verf\u00fcgbar.");
        this.jPanel9.add((Component)this.jLabel4, "Center");
        this.pnlBild.add((Component)this.jPanel9, "NO_PREVIEW");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panRasterfari.add((Component)this.pnlBild, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel15.add((Component)this.panRasterfari, gridBagConstraints);
        this.pnlDocuments.setMinimumSize(new Dimension(400, 200));
        this.pnlDocuments.setPreferredSize(new Dimension(400, 200));
        this.pnlDocuments.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderDocuments.setBackground(new Color(51, 51, 51));
        this.pnlHeaderDocuments.setForeground(new Color(51, 51, 51));
        this.pnlHeaderDocuments.setPreferredSize(new Dimension(74, 32));
        this.pnlHeaderDocuments.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderDocuments.setForeground(new Color(255, 255, 255));
        this.lblHeaderDocuments.setHorizontalAlignment(0);
        this.lblHeaderDocuments.setText("Dokumente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlHeaderDocuments.add((Component)this.lblHeaderDocuments, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.pnlHeaderDocuments.add((Component)this.filler1, (Object)gridBagConstraints);
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new FlowLayout(1, 0, 0));
        this.btnAddImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAddImg.setToolTipText("Dokument hinzuf\u00fcgen");
        this.btnAddImg.setBorderPainted(false);
        this.btnAddImg.setContentAreaFilled(false);
        this.btnAddImg.setFocusPainted(false);
        this.btnAddImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.btnAddImgActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.btnAddImg);
        this.btnRemoveImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        this.btnRemoveImg.setToolTipText("ausgew\u00e4hltes Dokument entfernen");
        this.btnRemoveImg.setBorderPainted(false);
        this.btnRemoveImg.setContentAreaFilled(false);
        this.btnRemoveImg.setEnabled(false);
        this.btnRemoveImg.setFocusPainted(false);
        this.btnRemoveImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.btnRemoveImgActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.btnRemoveImg);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.pnlHeaderDocuments.add((Component)this.jPanel5, (Object)gridBagConstraints);
        this.jPanel6.setOpaque(false);
        this.jPanel6.setLayout(new FlowLayout(1, 0, 0));
        this.btnDown.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/arrow-270.png")));
        this.btnDown.setToolTipText("laufende Nummer des ausgew\u00e4hlten Dokumentes inkrementieren");
        this.btnDown.setBorderPainted(false);
        this.btnDown.setContentAreaFilled(false);
        this.btnDown.setEnabled(false);
        this.btnDown.setFocusPainted(false);
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.btnDownActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnDown);
        this.btnUp.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/arrow-090.png")));
        this.btnUp.setToolTipText("laufende Nummer des ausgew\u00e4hlten Dokumentes dekrementieren");
        this.btnUp.setBorderPainted(false);
        this.btnUp.setContentAreaFilled(false);
        this.btnUp.setEnabled(false);
        this.btnUp.setFocusPainted(false);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MauerDokumenteEditor.this.btnUpActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnUp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.pnlHeaderDocuments.add((Component)this.jPanel6, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlDocuments.add((Component)this.pnlHeaderDocuments, (Object)gridBagConstraints);
        this.jPanel20.setOpaque(false);
        this.jPanel20.setLayout(new GridBagLayout());
        this.jXTable2.setModel((TableModel)new DokumenteTableModel());
        this.jXTable2.setMinimumSize(new Dimension(250, 130));
        this.jXTable2.setPreferredSize(new Dimension(250, 130));
        this.jScrollPane3.setViewportView((Component)this.jXTable2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel20.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlDocuments.add((Component)this.jPanel20, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel15.add((Component)this.pnlDocuments, gridBagConstraints);
        this.pnlDocuments1.setMinimumSize(new Dimension(400, 200));
        this.pnlDocuments1.setPreferredSize(new Dimension(400, 200));
        this.pnlDocuments1.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderDocuments1.setBackground(new Color(51, 51, 51));
        this.pnlHeaderDocuments1.setForeground(new Color(51, 51, 51));
        this.pnlHeaderDocuments1.setPreferredSize(new Dimension(74, 32));
        this.pnlHeaderDocuments1.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderDocuments1.setForeground(new Color(255, 255, 255));
        this.lblHeaderDocuments1.setHorizontalAlignment(0);
        this.lblHeaderDocuments1.setText("Seiten");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlHeaderDocuments1.add((Component)this.lblHeaderDocuments1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.pnlHeaderDocuments1.add((Component)this.filler4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlDocuments1.add((Component)this.pnlHeaderDocuments1, (Object)gridBagConstraints);
        this.jPanel21.setOpaque(false);
        this.jPanel21.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel21.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlDocuments1.add((Component)this.jPanel21, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel15.add((Component)this.pnlDocuments1, gridBagConstraints);
        this.add((Component)this.jPanel15, "card2");
        this.bindingGroup.bind();
    }

    private void btnAddImgActionPerformed(ActionEvent evt) {
        ((DefaultBindableReferenceCombo)this.jComboBox1).reload();
        if (((DefaultBindableReferenceCombo)this.jComboBox1).getItemCount() == 0) {
            this.addForArt(null);
        } else if (((DefaultBindableReferenceCombo)this.jComboBox1).getItemCount() == 1) {
            this.addForArt((CidsBean)((DefaultBindableReferenceCombo)this.jComboBox1).getModel().getElementAt(0));
        } else {
            StaticSwingTools.showDialog((Component)this, (JDialog)this.jDialog1, (boolean)true);
        }
    }

    public void dispose() {
        this.addedDocumentBeans.clear();
        this.removedDocumentBeans.clear();
    }

    private DokumenteTableModel getTableModel() {
        return (DokumenteTableModel)this.jXTable2.getModel();
    }

    private CidsBean getSelectedDocumentBean() {
        return this.jXTable2.getSelectedRows().length == 1 && this.jXTable2.getSelectedRow() >= 0 ? this.getTableModel().getCidsBean(this.jXTable2.convertRowIndexToModel(this.jXTable2.getSelectedRow())) : null;
    }

    private List<CidsBean> getSelectedDocumentBeans() {
        ArrayList<CidsBean> selectedDocumentBeans = new ArrayList<CidsBean>();
        int[] selectionIndices = this.jXTable2.getSelectedRows();
        if (selectionIndices != null && selectionIndices.length > 0) {
            for (int selectionIndex : selectionIndices) {
                CidsBean selectedDocumentBean = this.getTableModel().getCidsBean(this.jXTable2.convertRowIndexToModel(selectionIndex));
                selectedDocumentBeans.add(selectedDocumentBean);
            }
        }
        return selectedDocumentBeans;
    }

    private void documentSelectionChanged() {
        CidsBean selectedDocumnentBean = this.getSelectedDocumentBean();
        if (selectedDocumnentBean != null) {
            Integer position = (Integer)selectedDocumnentBean.getProperty(POSITION_PROPERTY);
            try {
                this.rasterfariDocumentLoaderPanel1.setDocument(String.format("%s/%s", this.properties.getRasterfariPath(), URLEncoder.encode((String)selectedDocumnentBean.getProperty(FILENAME_PROPERTY), "UTF-8")));
                this.showDocumentCard(DocumentCard.DOCUMENT);
                this.btnOpen.setEnabled(true);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.showDocumentCard(DocumentCard.ERROR);
                this.btnOpen.setEnabled(false);
            }
            ArrayList<CidsBean> unremovedDocumentBeans = new ArrayList<CidsBean>(this.getDocumentBeans());
            unremovedDocumentBeans.removeAll(this.removedDocumentBeans);
            this.btnUp.setEnabled(position != null && position > 1);
            this.btnDown.setEnabled(position != null && position < unremovedDocumentBeans.size());
        } else {
            this.rasterfariDocumentLoaderPanel1.setDocument(null);
            this.showDocumentCard(DocumentCard.NO_DOCUMENT);
            this.btnDown.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnOpen.setEnabled(false);
        }
        this.btnRemoveImg.setEnabled(!this.getSelectedDocumentBeans().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveImgActionPerformed(ActionEvent evt) {
        int answer;
        List<CidsBean> selectedDocumentBeans = this.getSelectedDocumentBeans();
        if (selectedDocumentBeans != null && !selectedDocumentBeans.isEmpty() && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sollen die Dokumente wirklich gel\u00f6scht werden?", "Dokumente entfernen", 0)) == 0) {
            try {
                ArrayList<CidsBean> removeList = new ArrayList<CidsBean>(selectedDocumentBeans);
                this.reenumerate();
                for (Object e : removeList) {
                    if (!(e instanceof CidsBean)) continue;
                    CidsBean documentToDelete = (CidsBean)e;
                    documentToDelete.setProperty(POSITION_PROPERTY, null);
                    this.removedDocumentBeans.add(documentToDelete);
                }
                this.reenumerate();
                this.getTableModel().fireTableDataChanged();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                MauerDokumenteEditor.showExceptionToUser(ex, this);
            }
            finally {
                if (this.getTableModel().getRowCount() > 0) {
                    ((TableRowSorter)this.jXTable2.getRowSorter()).sort();
                    this.jXTable2.getSelectionModel().setSelectionInterval(0, 0);
                } else {
                    this.showDocumentCard(DocumentCard.NO_DOCUMENT);
                }
            }
        }
    }

    public List<CidsBean> getRemovedDocumentBeans() {
        return this.removedDocumentBeans;
    }

    public List<CidsBean> getAddedDocumentBeans() {
        return this.addedDocumentBeans;
    }

    public void reenumerate() throws Exception {
        ArrayList<CidsBean> sortedDocumentBeans = new ArrayList<CidsBean>(this.getDocumentBeans());
        sortedDocumentBeans.removeAll(this.getRemovedDocumentBeans());
        Collections.sort(sortedDocumentBeans, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                Integer lfd2;
                Integer lfd1 = o1 != null ? (Integer)o1.getProperty(MauerDokumenteEditor.POSITION_PROPERTY) : null;
                Integer n = lfd2 = o2 != null ? (Integer)o2.getProperty(MauerDokumenteEditor.POSITION_PROPERTY) : null;
                if (lfd1 == null || lfd2 == null) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return 0;
                }
                return lfd1.compareTo(lfd2);
            }
        });
        int lfd = 1;
        for (CidsBean sortedDocumentBean : sortedDocumentBeans) {
            sortedDocumentBean.setProperty(POSITION_PROPERTY, (Object)lfd++);
        }
    }

    private static void showExceptionToUser(Exception ex, JComponent parent) {
        ErrorInfo ei = new ErrorInfo("Fehler", "Beim Vorgang ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)ei);
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        final String document = this.rasterfariDocumentLoaderPanel1.getCurrentDocument();
        if (document == null) {
            return;
        }
        final URL documentUrl = this.rasterfariDocumentLoaderPanel1.getDocumentUrl();
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String filename = document.substring(document.lastIndexOf("/") + 1);
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)MauerDokumenteEditor.this)) {
                    String downloadExtension = filename.substring(filename.lastIndexOf("."));
                    String downloadName = filename.substring(0, filename.lastIndexOf("."));
                    HttpDownload download = new HttpDownload(documentUrl, "", DownloadManagerDialog.getInstance().getJobName(), String.format("St\u00fctzmauer - Dokument #%d", MauerDokumenteEditor.this.getSelectedDocumentBean().getProperty(MauerDokumenteEditor.POSITION_PROPERTY)), downloadName, downloadExtension);
                    DownloadManager.instance().add((Download)download);
                }
            }
        });
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> unremovedDocumentBeans = new ArrayList<CidsBean>(this.getDocumentBeans());
        unremovedDocumentBeans.removeAll(this.removedDocumentBeans);
        CidsBean selectedDocumentBean = this.getSelectedDocumentBean();
        if (selectedDocumentBean != null) {
            Integer lfd = (Integer)selectedDocumentBean.getProperty(POSITION_PROPERTY);
            if (lfd < unremovedDocumentBeans.size()) {
                try {
                    for (CidsBean otherDocumentBean : unremovedDocumentBeans) {
                        Integer otherLfd = (Integer)otherDocumentBean.getProperty(POSITION_PROPERTY);
                        if (otherLfd != lfd + 1) continue;
                        otherDocumentBean.setProperty(POSITION_PROPERTY, (Object)lfd);
                        break;
                    }
                    selectedDocumentBean.setProperty(POSITION_PROPERTY, (Object)(lfd + 1));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            this.getTableModel().fireTableDataChanged();
            int index = unremovedDocumentBeans.indexOf(selectedDocumentBean);
            if (index >= 0) {
                int viewIndex = this.jXTable2.convertRowIndexToView(index);
                this.jXTable2.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
            }
            ((TableRowSorter)this.jXTable2.getRowSorter()).sort();
        }
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        List<CidsBean> otherDocumentBeans = this.getDocumentBeans();
        CidsBean selectedDocumentBean = this.getSelectedDocumentBean();
        if (selectedDocumentBean != null) {
            Integer lfd = (Integer)selectedDocumentBean.getProperty(POSITION_PROPERTY);
            if (lfd > 1) {
                try {
                    for (CidsBean otherDocumentBean : otherDocumentBeans) {
                        Integer otherLfd = (Integer)otherDocumentBean.getProperty(POSITION_PROPERTY);
                        if (otherLfd != lfd - 1) continue;
                        otherDocumentBean.setProperty(POSITION_PROPERTY, (Object)lfd);
                        break;
                    }
                    selectedDocumentBean.setProperty(POSITION_PROPERTY, (Object)(lfd - 1));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            this.getTableModel().fireTableDataChanged();
            int index = otherDocumentBeans.indexOf(selectedDocumentBean);
            if (index >= 0) {
                int viewIndex = this.jXTable2.convertRowIndexToView(index);
                this.jXTable2.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
            }
            ((TableRowSorter)this.jXTable2.getRowSorter()).sort();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jDialog1.setVisible(false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jDialog1.setVisible(false);
        this.addForArt((CidsBean)((DefaultBindableReferenceCombo)this.jComboBox1).getSelectedItem());
    }

    private void addForArt(CidsBean artBean) {
        File[] selFiles;
        String artSchluessel = (String)artBean.getProperty("schluessel");
        this.jFileChooser1.setFileFilter("foto".equals(artSchluessel) ? this.imageFileFilter : ("plan".equals(artSchluessel) ? this.pdfFileFilter : null));
        if (0 == this.jFileChooser1.showOpenDialog(this) && (selFiles = this.jFileChooser1.getSelectedFiles()) != null && selFiles.length > 0) {
            CismetThreadPool.execute((Runnable)new ImageUploadWorker(Arrays.asList(selFiles), artBean));
        }
    }

    public CidsBean getMauerBean() {
        return this.mauerBean;
    }

    public void setMauerBean(CidsBean mauerBean) {
        this.mauerBean = mauerBean;
        this.getTableModel().setCidsBeans(mauerBean != null ? this.getDocumentBeans() : null);
        this.showDocumentCard(DocumentCard.NO_DOCUMENT);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public List<CidsBean> getDocumentBeans() {
        return this.getMauerBean().getBeanCollectionProperty(DOCUMENTS_PROPERTY);
    }

    public static final class DocumentSizeFilter
    extends DocumentFilter {
        int maxCharacters;
        boolean DEBUG = false;

        public DocumentSizeFilter(int maxChars) {
            this.maxCharacters = maxChars;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() <= this.maxCharacters) {
                super.insertString(fb, offs, str, a);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            if (fb.getDocument().getLength() + str.length() - length <= this.maxCharacters) {
                super.replace(fb, offs, length, str, a);
            }
        }
    }

    final class ImageUploadWorker
    extends SwingWorker<Collection<CidsBean>, Void> {
        private final Collection<File> documentFiles;
        private final CidsBean artBean;

        public ImageUploadWorker(Collection<File> documentFiles, CidsBean artBean) {
            this.documentFiles = documentFiles;
            this.artBean = artBean;
            MauerDokumenteEditor.this.showDocumentCard(DocumentCard.BUSY);
        }

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            ArrayList<CidsBean> newBeans = new ArrayList<CidsBean>();
            ArrayList<CidsBean> unremovedDocumentBeans = new ArrayList<CidsBean>(MauerDokumenteEditor.this.getDocumentBeans());
            unremovedDocumentBeans.removeAll(MauerDokumenteEditor.this.removedDocumentBeans);
            int laufendeNummer = unremovedDocumentBeans.size() + 1;
            for (File imageFile : this.documentFiles) {
                String mauerNummer = (String)MauerDokumenteEditor.this.mauerBean.getProperty("mauer_nummer");
                String filename = (mauerNummer == null ? "____" : new DecimalFormat("#0000").format(Integer.parseInt(mauerNummer))) + "-" + RandomStringUtils.randomAlphanumeric((int)8) + "_" + imageFile.getName();
                String webdavUrl = MauerDokumenteEditor.this.properties.getWebdavUrl();
                MauerDokumenteEditor.this.webdavHelper.uploadFileToWebDAV(filename, imageFile, webdavUrl, (Component)MauerDokumenteEditor.this, MauerDokumenteEditor.this.getConnectionContext());
                CidsBean newDocumentBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)MauerDokumenteEditor.DOCUMENTS_TABLE, (ConnectionContext)MauerDokumenteEditor.this.getConnectionContext());
                newDocumentBean.setProperty(MauerDokumenteEditor.POSITION_PROPERTY, (Object)laufendeNummer++);
                newDocumentBean.setProperty(MauerDokumenteEditor.NAME_PROPERTY, (Object)imageFile.getName());
                newDocumentBean.setProperty(MauerDokumenteEditor.FILENAME_PROPERTY, (Object)filename);
                newDocumentBean.setProperty(MauerDokumenteEditor.ART_PROPERTY, (Object)this.artBean);
                newBeans.add(newDocumentBean);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    List documentBeans = MauerDokumenteEditor.this.mauerBean.getBeanCollectionProperty(MauerDokumenteEditor.DOCUMENTS_PROPERTY);
                    documentBeans.addAll(newBeans);
                    MauerDokumenteEditor.this.addedDocumentBeans.addAll(newBeans);
                    MauerDokumenteEditor.this.getTableModel().fireTableDataChanged();
                    ((TableRowSorter)MauerDokumenteEditor.this.jXTable2.getRowSorter()).sort();
                    List dokumenteBeans = MauerDokumenteEditor.this.mauerBean.getBeanCollectionProperty(MauerDokumenteEditor.DOCUMENTS_PROPERTY);
                    int index = dokumenteBeans.indexOf(newBeans.iterator().next());
                    int viewIndex = MauerDokumenteEditor.this.jXTable2.convertRowIndexToView(index);
                    MauerDokumenteEditor.this.jXTable2.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
                } else {
                    MauerDokumenteEditor.this.showDocumentCard(DocumentCard.NO_DOCUMENT);
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
                MauerDokumenteEditor.this.showDocumentCard(DocumentCard.ERROR);
            }
        }
    }

    class DokumenteTableModel
    extends CidsBeansTableModel {
        public DokumenteTableModel() {
            super(COLUMN_PROPERTIES, FLAECHE_COLUMN_NAMES, FLAECHE_COLUMN_CLASSES);
        }
    }

    class DocumentRowFilter
    extends RowFilter<TableModel, Integer> {
        DocumentRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            CidsBean documentBean = MauerDokumenteEditor.this.getTableModel().getCidsBean(entry.getIdentifier());
            return !MauerDokumenteEditor.this.addedDocumentBeans.contains(documentBean) || !MauerDokumenteEditor.this.removedDocumentBeans.contains(documentBean);
        }
    }

    private static enum DocumentCard {
        BUSY,
        DOCUMENT,
        NO_DOCUMENT,
        ERROR,
        NO_PREVIEW;

    }
}

