/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.DivBeanTable;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultBindableComboboxCellEditor;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class No2MessungEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
PropertyChangeListener {
    private static DefaultBindableReferenceCombo.Option NULLABLE_OPTION = new DefaultBindableReferenceCombo.NullableOption(null, "-");
    private static DefaultBindableReferenceCombo.Option SORTING_OPTION = new DefaultBindableReferenceCombo.SortingColumnOption("schluessel");
    private static DefaultBindableReferenceCombo.Option MANAGEABLE_OPTION = null;
    private static final String TITLE_NEW_MESSUNG = "eine neue Messung anlegen...";
    private static final Logger LOG = Logger.getLogger(No2MessungEditor.class);
    public static final int COLUMN_WIDTH = 250;
    public static final int COLUMN_WIDTH_VALUE = 50;
    public static final String FIELD__ID = "id";
    public static final String FIELD__ZEIT = "fk_zeit";
    public static final String FIELD__VON = "von";
    public static final String FIELD__BIS = "bis";
    public static final String FIELD__MP = "mp";
    public static final String FIELD__ZEIT_NAME = "fk_zeit.name";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ZEIT_SCHLUESSEL = "fk_zeit.schluessel";
    public static final String FIELD__SCHLUESSEL = "schluessel";
    public static final String FIELD__JAHR = "jahr";
    public static final String FIELD__WERTE = "n_werte";
    public static final String FIELD__WERT = "wert";
    public static final String FIELD__STANDORT = "fk_standort";
    public static final String FIELD__MESSUNG = "fk_messung";
    public static final String TABLE_NAME = "no2_messung";
    public static final String TABLE_NAME_ZEIT = "no2_zeit";
    public static final String TABLE_NAME_WERT = "no2_wert";
    public static final String TABLE_NAME_STANDORT = "no2_standort";
    public static final String BUNDLE_NOYEAR = "No2MessungEditor.prepareForSave().noYear";
    public static final String BUNDLE_DUPLICATE = "No2MessungEditor.prepareForSave().duplicate";
    public static final String BUNDLE_WRONGYEAR = "No2MessungEditor.prepareForSave().wrongYear";
    public static final String BUNDLE_NOTIME = "No2MessungEditor.prepareForSave().noTime";
    public static final String BUNDLE_NOLOCATION = "No2MessungEditor.prepareForSave().noLocation";
    public static final String BUNDLE_TWICELOCATION = "No2MessungEditor.prepareForSave().twiceLocation";
    public static final String BUNDLE_NOVALUE = "No2MessungEditor.prepareForSave().noValue";
    public static final String BUNDLE_WRONGVALUE = "No2MessungEditor.prepareForSave().wrongValue";
    public static final String BUNDLE_VONBIS = "No2MessungEditor.prepareForSave().VonBis";
    public static final String BUNDLE_VONBISLOST = "No2MessungEditor.prepareForSave().VonBisLost";
    public static final String BUNDLE_PANE_PREFIX = "No2MessungEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "No2MessungEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "No2MessungEditor.prepareForSave().JOptionPane.title";
    public static final String BUNDLE_PANE_PREFIX_LOC = "No2MessungEditor.btnCreateMeasureLocationsActionPerformed().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_TITLE_LOC = "No2MessungEditor.btnCreateMeasureLocationsActionPerformed().JOptionPane.title.add";
    public static final String BUNDLE_PANE_LOCATION_MEASURE = "No2MessungEditor.btnCreateMeasureLocationsActionPerformed().JOptionPane.message.add";
    public static final String BUNDLE_PANE_MESSAGE_DEL = "No2MessungEditor.btnDeleteMeasureLocationsActionPerformed().JOptionPane.message";
    public static final String BUNDLE_PANE_TITLE_DEL = "No2MessungEditor.btnDeleteMeasureLocationsActionPerformed().JOptionPane.title";
    public static final String BUNDLE_PANE_MESSAGE_ADD = "No2MessungEditor.btnCreateMeasureLocationsActionPerformed().JOptionPane.message";
    public static final String BUNDLE_PANE_TITLE_ADD = "No2MessungEditor.btnCreateMeasureLocationsActionPerformed().JOptionPane.title";
    private static final String[] WERTE_COL_NAMES = new String[]{"Werte", "Standorte"};
    private static final String[] WERTE_PROP_NAMES = new String[]{"wert", "fk_standort"};
    private static final Class[] WERTE_PROP_TYPES = new Class[]{Integer.class, CidsBean.class};
    private SwingWorker worker_name;
    private SwingWorker worker_time;
    private Boolean redundantName = false;
    private boolean isEditor = true;
    private MetaClass standortMetaClass;
    private JButton btnAddMesswert;
    private JButton btnCreateMeasureLocations;
    private JButton btnDeleteMeasureLocations;
    private JButton btnRemMesswert;
    private DefaultBindableReferenceCombo cbZeit;
    private DefaultBindableDateChooser dcBis;
    private DefaultBindableDateChooser dcVon;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JScrollPane jScrollPaneMesswerte;
    private JLabel lblBis;
    private JLabel lblJahr;
    private JLabel lblVon;
    private JLabel lblWerte;
    private JLabel lblZeit;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFiller;
    private JPanel panFillerUnten;
    private JPanel panMesswerte;
    private JPanel panMesswerteAdd;
    private JPanel panWerte;
    private JTextField txtJahr;
    private JXTable xtMesswerte;
    private BindingGroup bindingGroup;

    public No2MessungEditor() {
    }

    public No2MessungEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.standortMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_NAME_STANDORT, (ConnectionContext)connectionContext);
        this.cbZeit.setNullable(false);
        this.txtJahr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                No2MessungEditor.this.checkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                No2MessungEditor.this.checkName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                No2MessungEditor.this.checkName();
            }
        });
        this.cbZeit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                No2MessungEditor.this.checkName();
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panDaten = new JPanel();
        this.lblZeit = new JLabel();
        this.cbZeit = new DefaultBindableReferenceCombo(new DefaultBindableReferenceCombo.Option[]{NULLABLE_OPTION, MANAGEABLE_OPTION, SORTING_OPTION});
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblJahr = new JLabel();
        this.txtJahr = new JTextField();
        this.panFiller = new JPanel();
        this.lblVon = new JLabel();
        this.dcVon = new DefaultBindableDateChooser();
        this.lblBis = new JLabel();
        this.dcBis = new DefaultBindableDateChooser();
        this.lblWerte = new JLabel();
        this.panWerte = new JPanel();
        this.panMesswerte = new JPanel();
        this.jScrollPaneMesswerte = new JScrollPane();
        this.xtMesswerte = new JXTable();
        this.panMesswerteAdd = new JPanel();
        this.btnAddMesswert = new JButton();
        this.btnRemMesswert = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.btnCreateMeasureLocations = new JButton();
        this.btnDeleteMeasureLocations = new JButton();
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setMinimumSize(new Dimension(716, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(569, 488));
        this.panContent.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblZeit.setFont(new Font("Tahoma", 1, 11));
        this.lblZeit.setText("Zeitpunkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblZeit, gridBagConstraints);
        this.cbZeit.setFont(new Font("Dialog", 0, 12));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_zeit}"), (Object)this.cbZeit, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.cbZeit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblJahr.setFont(new Font("Tahoma", 1, 11));
        this.lblJahr.setText("Jahr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblJahr, gridBagConstraints);
        this.txtJahr.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.jahr}"), (Object)this.txtJahr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtJahr, gridBagConstraints);
        this.panFiller.setMinimumSize(new Dimension(20, 0));
        this.panFiller.setOpaque(false);
        GroupLayout panFillerLayout = new GroupLayout(this.panFiller);
        this.panFiller.setLayout(panFillerLayout);
        panFillerLayout.setHorizontalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        panFillerLayout.setVerticalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panDaten.add((Component)this.panFiller, gridBagConstraints);
        this.lblVon.setFont(new Font("Tahoma", 1, 11));
        this.lblVon.setText("Von:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblVon, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.von}"), (Object)this.dcVon, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcVon.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.dcVon, gridBagConstraints);
        this.lblBis.setFont(new Font("Tahoma", 1, 11));
        this.lblBis.setText("Bis:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBis, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bis}"), (Object)this.dcBis, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcBis.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.dcBis, gridBagConstraints);
        this.lblWerte.setFont(new Font("Tahoma", 1, 11));
        this.lblWerte.setText("Messwerte:");
        this.lblWerte.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 2, 5);
        this.panDaten.add((Component)this.lblWerte, gridBagConstraints);
        this.panWerte.setOpaque(false);
        this.panWerte.setLayout(new GridBagLayout());
        this.panMesswerte.setMinimumSize(new Dimension(26, 80));
        this.panMesswerte.setOpaque(false);
        this.panMesswerte.setLayout(new GridBagLayout());
        this.jScrollPaneMesswerte.setOpaque(false);
        this.xtMesswerte.setOpaque(false);
        this.jScrollPaneMesswerte.setViewportView((Component)this.xtMesswerte);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panMesswerte.add((Component)this.jScrollPaneMesswerte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panWerte.add((Component)this.panMesswerte, gridBagConstraints);
        this.panMesswerteAdd.setAlignmentX(0.0f);
        this.panMesswerteAdd.setAlignmentY(1.0f);
        this.panMesswerteAdd.setFocusable(false);
        this.panMesswerteAdd.setOpaque(false);
        this.panMesswerteAdd.setLayout(new GridBagLayout());
        this.btnAddMesswert.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAddMesswert.setBorderPainted(false);
        this.btnAddMesswert.setContentAreaFilled(false);
        this.btnAddMesswert.setFocusPainted(false);
        this.btnAddMesswert.setMaximumSize(new Dimension(45, 22));
        this.btnAddMesswert.setMinimumSize(new Dimension(45, 22));
        this.btnAddMesswert.setPreferredSize(new Dimension(45, 22));
        this.btnAddMesswert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                No2MessungEditor.this.btnAddMesswertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panMesswerteAdd.add((Component)this.btnAddMesswert, gridBagConstraints);
        this.btnRemMesswert.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        this.btnRemMesswert.setBorderPainted(false);
        this.btnRemMesswert.setContentAreaFilled(false);
        this.btnRemMesswert.setFocusPainted(false);
        this.btnRemMesswert.setMaximumSize(new Dimension(45, 22));
        this.btnRemMesswert.setMinimumSize(new Dimension(45, 22));
        this.btnRemMesswert.setPreferredSize(new Dimension(45, 22));
        this.btnRemMesswert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                No2MessungEditor.this.btnRemMesswertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panMesswerteAdd.add((Component)this.btnRemMesswert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panMesswerteAdd.add((Component)this.filler2, gridBagConstraints);
        this.btnCreateMeasureLocations.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/wizard.png")));
        this.btnCreateMeasureLocations.setToolTipText("Standorte anlegen");
        this.btnCreateMeasureLocations.setMaximumSize(new Dimension(45, 28));
        this.btnCreateMeasureLocations.setMinimumSize(new Dimension(45, 28));
        this.btnCreateMeasureLocations.setPreferredSize(new Dimension(45, 28));
        this.btnCreateMeasureLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                No2MessungEditor.this.btnCreateMeasureLocationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(15, 2, 2, 2);
        this.panMesswerteAdd.add((Component)this.btnCreateMeasureLocations, gridBagConstraints);
        this.btnDeleteMeasureLocations.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-delete.png")));
        this.btnDeleteMeasureLocations.setToolTipText("Standorte entfernen");
        this.btnDeleteMeasureLocations.setMaximumSize(new Dimension(45, 21));
        this.btnDeleteMeasureLocations.setMinimumSize(new Dimension(45, 21));
        this.btnDeleteMeasureLocations.setPreferredSize(new Dimension(45, 28));
        this.btnDeleteMeasureLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                No2MessungEditor.this.btnDeleteMeasureLocationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.panMesswerteAdd.add((Component)this.btnDeleteMeasureLocations, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.panWerte.add((Component)this.panMesswerteAdd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panDaten.add((Component)this.panWerte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 15, 15);
        this.panContent.add((Component)this.panDaten, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnAddMesswertActionPerformed(ActionEvent evt) {
        TableUtils.addObjectToTable(this.xtMesswerte, TABLE_NAME_WERT, this.getConnectionContext());
    }

    private void btnRemMesswertActionPerformed(ActionEvent evt) {
        TableUtils.removeObjectsFromTable(this.xtMesswerte);
    }

    private void btnCreateMeasureLocationsActionPerformed(ActionEvent evt) {
        try {
            if (this.txtJahr.getText().trim().isEmpty() || this.cbZeit.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_PREFIX_LOC) + NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_LOCATION_MEASURE) + NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_TITLE_LOC), 2);
            } else {
                int answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_MESSAGE_ADD), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_TITLE_ADD), 0, 2);
                if (answer == 0) {
                    this.deleteMeasure();
                    this.createMeasure();
                }
            }
        }
        catch (HeadlessException | MissingResourceException e) {
            LOG.error((Object)"Cannot add new no2_wert objects", (Throwable)e);
        }
    }

    private void btnDeleteMeasureLocationsActionPerformed(ActionEvent evt) {
        int answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_MESSAGE_DEL), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_TITLE_DEL), 0, 2);
        if (answer == 0) {
            this.deleteMeasure();
        }
    }

    public static void addLocationsToTable(JXTable table, MetaObject standortMo, ConnectionContext connectionContext) {
        try {
            CidsBean bean = CidsBeanSupport.createNewCidsBeanFromTableName(TABLE_NAME_WERT, connectionContext);
            bean.setProperty(FIELD__STANDORT, (Object)standortMo.getBean());
            ((DivBeanTable)table.getModel()).addBean(bean);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void deleteMeasure() {
        this.xtMesswerte.selectAll();
        TableUtils.removeObjectsFromTable(this.xtMesswerte);
    }

    public void createMeasure() {
        MetaClass myClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_NAME_STANDORT, (ConnectionContext)this.getConnectionContext());
        StringBuffer myQuery = new StringBuffer("");
        if ((Integer)this.cidsBean.getProperty(FIELD__ZEIT_SCHLUESSEL) == 13) {
            myQuery = new StringBuffer("select ").append(myClass.getId()).append(", ").append(myClass.getName()).append(".").append(myClass.getPrimaryKey()).append(" from ").append(myClass.getTableName()).append(" where ").append(FIELD__ID).append(" in ( select ").append(TABLE_NAME_WERT).append(".").append(FIELD__STANDORT).append(" from ").append(TABLE_NAME_WERT).append(" left join ").append(TABLE_NAME).append(" on ").append(TABLE_NAME).append(".").append(FIELD__ID).append(" = ").append(TABLE_NAME_WERT).append(".").append(FIELD__MESSUNG).append(" where ").append(TABLE_NAME).append(".").append(FIELD__JAHR).append(" = ").append((Integer)this.cidsBean.getProperty(FIELD__JAHR)).append(") order by ").append(FIELD__MP);
        } else {
            String datum = (Integer)this.cidsBean.getProperty(FIELD__ZEIT_SCHLUESSEL) > 9 ? "15." + this.cidsBean.getProperty(FIELD__ZEIT_SCHLUESSEL).toString() + "." + this.cidsBean.getProperty(FIELD__JAHR).toString() : "15.0" + this.cidsBean.getProperty(FIELD__ZEIT_SCHLUESSEL).toString() + "." + this.cidsBean.getProperty(FIELD__JAHR).toString();
            if (myClass != null) {
                myQuery = new StringBuffer("select ").append(myClass.getId()).append(", ").append(myClass.getName()).append(".").append(myClass.getPrimaryKey()).append(" from ").append(myClass.getTableName()).append(" where ").append(FIELD__VON).append(" < '").append(datum).append("' and ( ").append(FIELD__BIS).append(" is null or ").append(FIELD__BIS).append(" > '").append(datum).append("') order by ").append(FIELD__MP);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SQL: myQuery:" + myQuery.toString()));
        }
        try {
            MetaObject[] myMetaObjects = SessionManager.getProxy().getMetaObjectByQuery(myQuery.toString(), 0, this.getConnectionContext());
            if (myMetaObjects != null && myMetaObjects.length > 0) {
                for (MetaObject mo : myMetaObjects) {
                    No2MessungEditor.addLocationsToTable(this.xtMesswerte, mo, this.getConnectionContext());
                }
            } else {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_PREFIX_LOC) + NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_LOCATION_MEASURE) + NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_TITLE_LOC), 2);
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private void checkName() {
        this.valueFromOtherTable(TABLE_NAME, " left join no2_zeit on no2_zeit.id = no2_messung.fk_zeit where no2_zeit.name = '" + this.cbZeit.getSelectedItem() + "' and " + TABLE_NAME + "." + FIELD__JAHR + " = " + this.txtJahr.getText().trim() + " and " + TABLE_NAME + "." + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID), otherTableCases.redundantAttName);
    }

    private void setMeasureValues() {
        block8: {
            try {
                MetaClass myClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_NAME, (ConnectionContext)this.getConnectionContext());
                if (myClass == null) break block8;
                StringBuffer myQuery = new StringBuffer("select ").append(myClass.getId()).append(", ").append(myClass.getName()).append(".").append(myClass.getPrimaryKey()).append(" from ").append(myClass.getTableName()).append(" where ").append(FIELD__JAHR).append(" in (select max(").append(FIELD__JAHR).append(") from ").append(myClass.getTableName()).append(")");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: myQuery:" + myQuery.toString()));
                }
                try {
                    MetaObject[] myMetaObject = SessionManager.getProxy().getMetaObjectByQuery(myQuery.toString(), 0, this.getConnectionContext());
                    if (myMetaObject != null) {
                        int month = 0;
                        MetaObject moLast = null;
                        for (MetaObject mo : myMetaObject) {
                            if ((Integer)mo.getBean().getProperty(FIELD__ZEIT_SCHLUESSEL) <= month) continue;
                            month = (Integer)mo.getBean().getProperty(FIELD__ZEIT_SCHLUESSEL);
                            moLast = mo;
                        }
                        if (moLast != null) {
                            this.setNewMeasure(moLast.getBean());
                        }
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)" kann nicht geladen werden ", (Throwable)ex);
            }
        }
    }

    public boolean prepareForSave() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtJahr.getText().trim().isEmpty()) {
                LOG.warn((Object)"No year specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_NOYEAR));
            } else if (this.cbZeit.getSelectedItem() == null) {
                LOG.warn((Object)"No time specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_NOTIME));
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_DUPLICATE));
            } else if (this.txtJahr.getText().trim().length() == 4) {
                try {
                    Integer.parseInt(this.txtJahr.getText());
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)"Wrong Mp specified. Skip persisting.", (Throwable)e);
                    errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_WRONGYEAR));
                }
            } else {
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_WRONGYEAR));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            LocalDate ldVon;
            LocalDate ldBis;
            if (this.dcVon.getDate() == null && this.dcBis.getDate() != null || this.dcBis.getDate() == null && this.dcVon.getDate() != null) {
                LOG.warn((Object)"No von specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_VONBISLOST));
            } else if (this.dcVon.getDate() != null && this.dcBis.getDate() != null && (ldBis = this.dcBis.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).isBefore(ldVon = this.dcVon.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
                errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_VONBIS));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"VonBis not given.", (Throwable)ex);
            save = false;
        }
        try {
            switch (this.checkValuesForMeasure()) {
                case 1: {
                    LOG.warn((Object)"Twice measure specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_TWICELOCATION));
                    break;
                }
                case 2: {
                    LOG.warn((Object)"No value specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_NOVALUE));
                    break;
                }
                case 3: {
                    LOG.warn((Object)"No location specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_NOLOCATION));
                    break;
                }
                case 4: {
                    LOG.warn((Object)"Wrong value specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_WRONGVALUE));
                }
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Error in Tabele.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(No2MessungEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("remove propchange no2_Messung: " + this.cidsBean));
                this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("add propchange no2_Messung: " + this.cidsBean));
                this.cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.bindingGroup.bind();
            if (this.cidsBean.getMetaObject().getStatus() == 1) {
                this.setMeasureValues();
            } else {
                RendererTools.makeReadOnly(this.txtJahr);
                RendererTools.makeReadOnly((JComponent)this.cbZeit);
            }
            DivBeanTable wertModel = new DivBeanTable(this.isEditor, this.cidsBean, FIELD__WERTE, WERTE_COL_NAMES, WERTE_PROP_NAMES, WERTE_PROP_TYPES);
            this.xtMesswerte.setModel((TableModel)wertModel);
            this.xtMesswerte.getColumn(1).setCellEditor((TableCellEditor)new DefaultBindableComboboxCellEditor(this.standortMetaClass));
            this.xtMesswerte.getColumn(1).setPreferredWidth(250);
            this.xtMesswerte.getColumn(0).setMaxWidth(50);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.error((Object)"Bean not set.", (Throwable)ex);
        }
    }

    private int checkValuesForMeasure() {
        try {
            List<CidsBean> listMeasureBeans = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, FIELD__WERTE);
            if (listMeasureBeans != null && listMeasureBeans.size() > 0) {
                for (int i = 0; i < listMeasureBeans.size(); ++i) {
                    CidsBean measureBean = listMeasureBeans.get(i);
                    if (null == measureBean.getProperty(FIELD__WERT) || "".equals(measureBean.getProperty(FIELD__WERT).toString())) {
                        return 2;
                    }
                    if ((Integer)measureBean.getProperty(FIELD__WERT) < 0 && (Integer)measureBean.getProperty(FIELD__WERT) != -9999) {
                        return 4;
                    }
                    if (null == measureBean.getProperty(FIELD__STANDORT) || "".equals(measureBean.getProperty(FIELD__STANDORT).toString())) {
                        return 3;
                    }
                    if (listMeasureBeans.size() <= i + 1) continue;
                    for (int j = i + 1; j < listMeasureBeans.size(); ++j) {
                        if (!measureBean.getProperty(FIELD__STANDORT).equals(listMeasureBeans.get(j).getProperty(FIELD__STANDORT))) continue;
                        return 1;
                    }
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return 0;
    }

    public void setNewMeasure(CidsBean latestBean) {
        int nextTime;
        int nextYear;
        int latestYear = Integer.parseInt(latestBean.getProperty(FIELD__JAHR).toString());
        int latestTime = Integer.parseInt(latestBean.getProperty(FIELD__ZEIT_SCHLUESSEL).toString());
        if (latestTime == 13) {
            nextYear = latestYear + 1;
            nextTime = 1;
        } else {
            nextYear = latestYear;
            nextTime = latestTime + 1;
        }
        try {
            this.cidsBean.setProperty(FIELD__JAHR, (Object)nextYear);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.valueFromOtherTable(TABLE_NAME_ZEIT, " where schluessel = " + nextTime, otherTableCases.setTime);
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.txtJahr);
            RendererTools.makeReadOnly((JComponent)this.cbZeit);
            RendererTools.makeReadOnly((JComponent)this.dcVon);
            RendererTools.makeReadOnly((JComponent)this.dcBis);
            RendererTools.makeReadOnly((JComponent)this.xtMesswerte);
            this.panMesswerteAdd.setVisible(this.isEditor);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE_NAME, (int)92, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.cidsBean.getMetaObject().getStatus() == 1) {
            return TITLE_NEW_MESSUNG;
        }
        return this.cidsBean.getProperty(FIELD__ZEIT_NAME).toString() + "- " + this.cidsBean.getProperty(FIELD__JAHR).toString();
    }

    public void dispose() {
        super.dispose();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void valueFromOtherTable(final String tableName, final String whereClause, final otherTableCases fall) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, No2MessungEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                block8: {
                    try {
                        if (this.isCancelled()) break block8;
                        CidsBean check = (CidsBean)this.get();
                        switch (fall) {
                            case setTime: {
                                try {
                                    No2MessungEditor.this.cidsBean.setProperty(No2MessungEditor.FIELD__ZEIT, (Object)check);
                                }
                                catch (Exception ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            case redundantAttName: {
                                No2MessungEditor.this.redundantName = check != null;
                            }
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOG.warn((Object)"problem in Worker: chech name.", (Throwable)e);
                    }
                }
            }
        };
        switch (fall) {
            case redundantAttName: {
                if (this.worker_name != null) {
                    this.worker_name.cancel(true);
                }
                this.worker_name = worker;
                this.worker_name.execute();
                break;
            }
            case setTime: {
                if (this.worker_time != null) {
                    this.worker_time.cancel(true);
                }
                this.worker_time = worker;
                this.worker_time.execute();
            }
        }
    }

    private static enum otherTableCases {
        redundantAttName,
        setTime;

    }
}

