/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.No2ConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class No2StandortEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
PropertyChangeListener {
    private static final String TITLE_NEW_STANDORT = "einen neuen Messpunkt anlegen...";
    public static final String GEOMTYPE = "Point";
    private static final Logger LOG = Logger.getLogger(No2StandortEditor.class);
    public static final int FOTO_WIDTH = 150;
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ID = "id";
    public static final String FIELD__MP = "mp";
    public static final String FIELD__STRASSE = "strasse";
    public static final String FIELD__HNR = "hnr";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_GEOM = "geom";
    public static final String TABLE_NAME = "no2_standort";
    public static final String BUNDLE_NONAME = "No2StandortEditor.prepareForSave().noName";
    public static final String BUNDLE_DUPLICATENAME = "No2StandortEditor.prepareForSave().duplicateName";
    public static final String BUNDLE_WRONGVALUEMP = "No2StandortEditor.prepareForSave().wrongValueMp";
    public static final String BUNDLE_NOSTREET = "No2StandortEditor.prepareForSave().noStrasse";
    public static final String BUNDLE_NOGEOM = "No2StandortEditor.prepareForSave().noGeom";
    public static final String BUNDLE_WRONGGEOM = "No2StandortEditor.prepareForSave().wrongGeom";
    public static final String BUNDLE_WRONGVALUE = "No2StandortEditor.prepareForSave().wrongValueH";
    public static final String BUNDLE_NOVON = "No2StandortEditor.prepareForSave().noVon";
    public static final String BUNDLE_VONBIS = "No2StandortEditor.prepareForSave().vonBis";
    public static final String BUNDLE_NOLOAD = "No2StandortEditor.loadPictureWithUrl().noLoad";
    public static final String BUNDLE_PANE_PREFIX = "No2StandortEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "No2StandortEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "No2StandortEditor.prepareForSave().JOptionPane.title";
    private SwingWorker worker_name;
    private Boolean redundantName = false;
    private boolean isEditor = true;
    private final ImageIcon statusFalsch = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"));
    private final ImageIcon statusOk = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status.png"));
    private JComboBox cbGeom;
    private DefaultBindableDateChooser dcBis;
    private DefaultBindableDateChooser dcVon;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JPanel jPanel1;
    private JLabel lblBis;
    private JLabel lblFoto;
    private JLabel lblFotoAnzeigen;
    private JLabel lblGeom;
    private JLabel lblHnr;
    private JLabel lblHoehe;
    private JLabel lblKarte;
    private JLabel lblMp;
    private JLabel lblStrasse;
    private JLabel lblUrlCheck;
    private JLabel lblVon;
    private JLabel lblZusatzinfo;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFiller;
    private JPanel panFillerUnten;
    private JPanel panGeometrie;
    private JPanel panLage;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panUrl;
    private JPanel panZusatzinfo;
    private RoundedPanel rpKarte;
    private JScrollPane scpZusatzinfo;
    private SemiRoundedPanel semiRoundedPanel7;
    private JTextArea taZusatzinfo;
    private JTextField txtFoto;
    private JTextField txtHnr;
    private JTextField txtHoehe;
    private JTextField txtMp;
    private JTextField txtStrasse;
    private BindingGroup bindingGroup;

    public No2StandortEditor() {
    }

    public No2StandortEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.txtMp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                No2StandortEditor.this.checkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                No2StandortEditor.this.checkName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                No2StandortEditor.this.checkName();
            }
        });
        this.txtFoto.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                No2StandortEditor.this.doWithFotoUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                No2StandortEditor.this.doWithFotoUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                No2StandortEditor.this.doWithFotoUrl();
            }
        });
        if (this.isEditor) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setLocalRenderFeatureString(FIELD__GEOREFERENZ);
        }
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.jPanel1 = new JPanel();
        this.panDaten = new JPanel();
        this.lblMp = new JLabel();
        this.txtMp = new JTextField();
        this.lblHoehe = new JLabel();
        this.txtHoehe = new JTextField();
        this.lblStrasse = new JLabel();
        this.txtStrasse = new JTextField();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblHnr = new JLabel();
        this.txtHnr = new JTextField();
        this.lblZusatzinfo = new JLabel();
        this.panZusatzinfo = new JPanel();
        this.scpZusatzinfo = new JScrollPane();
        this.taZusatzinfo = new JTextArea();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panFiller = new JPanel();
        this.lblFotoAnzeigen = new JLabel();
        this.lblVon = new JLabel();
        this.dcVon = new DefaultBindableDateChooser();
        this.lblBis = new JLabel();
        this.dcBis = new DefaultBindableDateChooser();
        this.lblGeom = new JLabel();
        if (this.isEditor) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
        }
        this.lblFoto = new JLabel();
        this.txtFoto = new JTextField();
        this.panUrl = new JPanel();
        this.lblUrlCheck = new JLabel();
        this.panGeometrie = new JPanel();
        this.panLage = new JPanel();
        this.rpKarte = new RoundedPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setMinimumSize(new Dimension(716, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(569, 488));
        this.panContent.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblMp.setFont(new Font("Tahoma", 1, 11));
        this.lblMp.setText("Messpunkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblMp, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.mp}"), (Object)this.txtMp, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtMp, gridBagConstraints);
        this.lblHoehe.setFont(new Font("Tahoma", 1, 11));
        this.lblHoehe.setText("H\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHoehe, gridBagConstraints);
        this.txtHoehe.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hoehe}"), (Object)this.txtHoehe, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtHoehe, gridBagConstraints);
        this.lblStrasse.setFont(new Font("Tahoma", 1, 11));
        this.lblStrasse.setText("Stra\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblStrasse, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.strasse}"), (Object)this.txtStrasse, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtStrasse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblHnr.setFont(new Font("Tahoma", 1, 11));
        this.lblHnr.setText("HNr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHnr, gridBagConstraints);
        this.txtHnr.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hnr}"), (Object)this.txtHnr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtHnr, gridBagConstraints);
        this.lblZusatzinfo.setFont(new Font("Tahoma", 1, 11));
        this.lblZusatzinfo.setText("Zusatzinfo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblZusatzinfo, gridBagConstraints);
        this.panZusatzinfo.setOpaque(false);
        this.panZusatzinfo.setLayout(new GridBagLayout());
        this.taZusatzinfo.setColumns(20);
        this.taZusatzinfo.setLineWrap(true);
        this.taZusatzinfo.setRows(2);
        this.taZusatzinfo.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.zusatzinfo}"), (Object)this.taZusatzinfo, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpZusatzinfo.setViewportView(this.taZusatzinfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panZusatzinfo.add((Component)this.scpZusatzinfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panZusatzinfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler4, gridBagConstraints);
        this.panFiller.setMinimumSize(new Dimension(20, 0));
        this.panFiller.setOpaque(false);
        GroupLayout panFillerLayout = new GroupLayout(this.panFiller);
        this.panFiller.setLayout(panFillerLayout);
        panFillerLayout.setHorizontalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        panFillerLayout.setVerticalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panDaten.add((Component)this.panFiller, gridBagConstraints);
        this.lblFotoAnzeigen.setFont(new Font("Tahoma", 1, 11));
        this.lblFotoAnzeigen.setText("Kein Foto vorhanden");
        this.lblFotoAnzeigen.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.panDaten.add((Component)this.lblFotoAnzeigen, gridBagConstraints);
        this.lblVon.setFont(new Font("Tahoma", 1, 11));
        this.lblVon.setText("Von:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblVon, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.von}"), (Object)this.dcVon, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcVon.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.dcVon, gridBagConstraints);
        this.lblBis.setFont(new Font("Tahoma", 1, 11));
        this.lblBis.setText("Bis:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBis, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bis}"), (Object)this.dcBis, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcBis.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.dcBis, gridBagConstraints);
        this.lblGeom.setFont(new Font("Tahoma", 1, 11));
        this.lblGeom.setText("Geometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblGeom, gridBagConstraints);
        if (this.isEditor) {
            if (this.isEditor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panDaten.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblFoto.setFont(new Font("Tahoma", 1, 11));
        this.lblFoto.setText("Bild:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblFoto, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bild}"), (Object)this.txtFoto, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtFoto, gridBagConstraints);
        this.panUrl.setOpaque(false);
        this.panUrl.setLayout(new GridBagLayout());
        this.lblUrlCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panUrl.add((Component)this.lblUrlCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.jPanel1.add((Component)this.panDaten, gridBagConstraints);
        this.panGeometrie.setOpaque(false);
        this.panGeometrie.setLayout(new GridBagLayout());
        this.panLage.setOpaque(false);
        this.panLage.setLayout(new GridBagLayout());
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLage.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panGeometrie.add((Component)this.panLage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.jPanel1.add((Component)this.panGeometrie, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void checkName() {
        this.valueFromOtherTable(TABLE_NAME, " where mp = " + this.txtMp.getText().trim() + " and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID));
    }

    private void doWithFotoUrl() {
        String foto = No2ConfProperties.getInstance().getFotoUrl().concat(this.txtFoto.getText());
        this.checkUrl(foto, this.lblUrlCheck);
        this.loadPictureWithUrl(foto, this.lblFotoAnzeigen);
    }

    public boolean prepareForSave() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtMp.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_NONAME));
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_DUPLICATENAME));
            } else {
                try {
                    Integer.parseInt(this.txtMp.getText());
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)"Wrong Mp specified. Skip persisting.", (Throwable)e);
                    errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_WRONGVALUEMP));
                }
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtStrasse.getText().trim().isEmpty()) {
                LOG.warn((Object)"No street specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_NOSTREET));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Street not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.cidsBean.getProperty(FIELD__GEOREFERENZ) == null) {
                LOG.warn((Object)"No geom specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_NOGEOM));
            } else {
                CidsBean geom_pos = (CidsBean)this.cidsBean.getProperty(FIELD__GEOREFERENZ);
                if (!((Geometry)geom_pos.getProperty(FIELD__GEO_FIELD)).getGeometryType().equals(GEOMTYPE)) {
                    LOG.warn((Object)"Wrong geom specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_WRONGGEOM));
                }
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom not given.", (Throwable)ex);
            save = false;
        }
        if (!this.txtHoehe.getText().isEmpty()) {
            try {
                Integer.parseInt(this.txtHoehe.getText());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Wrong Heigth specified. Skip persisting.", (Throwable)e);
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_WRONGVALUE));
            }
        }
        try {
            LocalDate ldVon;
            LocalDate ldBis;
            if (this.dcVon.getDate() == null) {
                LOG.warn((Object)"No von specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_NOVON));
            } else if (this.dcBis.getDate() != null && (ldBis = this.dcBis.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).isBefore(ldVon = this.dcVon.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
                errorMessage.append(NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_VONBIS));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Von not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(No2StandortEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("remove propchange no2_standort: " + this.cidsBean));
                this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("add propchange no2_standort: " + this.cidsBean));
                this.cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.setMapWindow();
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.error((Object)"Bean not set.", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.txtStrasse);
            RendererTools.makeReadOnly(this.txtHnr);
            RendererTools.makeReadOnly(this.txtMp);
            RendererTools.makeReadOnly(this.txtHoehe);
            RendererTools.makeReadOnly(this.taZusatzinfo);
            RendererTools.makeReadOnly(this.txtFoto);
            RendererTools.makeReadOnly((JComponent)this.dcVon);
            RendererTools.makeReadOnly((JComponent)this.dcBis);
            this.lblGeom.setVisible(this.isEditor);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE_NAME, (int)92, (int)800, (int)600);
    }

    public ImageIcon loadPicture(URL url) {
        try {
            int bildZielBreite = 150;
            BufferedImage originalBild = ImageIO.read(WebAccessManager.getInstance().doRequest(url));
            Image skaliertesBild = originalBild.getScaledInstance(150, -1, 4);
            return new ImageIcon(skaliertesBild);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not load picture.", (Throwable)ex);
            return null;
        }
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            Double bufferMeter = No2ConfProperties.getInstance().getBufferMeter();
            if (cb.getProperty(FIELD__GEOREFERENZ) != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, bufferMeter);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_GEOM, (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, bufferMeter);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"Map window not set.", (Throwable)ex);
        }
    }

    public String getTitle() {
        if (this.cidsBean.getMetaObject().getStatus() == 1) {
            return TITLE_NEW_STANDORT;
        }
        return this.cidsBean.toString();
    }

    public void dispose() {
        super.dispose();
        if (this.isEditor) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
        }
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(FIELD__GEOREFERENZ)) {
            this.setMapWindow();
        }
    }

    private void valueFromOtherTable(final String tableName, final String whereClause) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, No2StandortEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        CidsBean check = (CidsBean)this.get();
                        No2StandortEditor.this.redundantName = check != null;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)"problem in Worker: chech name.", (Throwable)e);
                }
            }
        };
        if (this.worker_name != null) {
            this.worker_name.cancel(true);
        }
        this.worker_name = worker;
        this.worker_name.execute();
    }

    private void checkUrl(final String url, final JLabel showLabel) {
        showLabel.setIcon(this.statusFalsch);
        showLabel.setCursor(new Cursor(0));
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return WebAccessManager.getInstance().checkIfURLaccessible(new URL(url));
            }

            @Override
            protected void done() {
                try {
                    Boolean check = (Boolean)this.get();
                    if (check.booleanValue()) {
                        showLabel.setIcon(No2StandortEditor.this.statusOk);
                        showLabel.setCursor(new Cursor(12));
                    } else {
                        showLabel.setIcon(No2StandortEditor.this.statusFalsch);
                        showLabel.setCursor(new Cursor(0));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    showLabel.setIcon(No2StandortEditor.this.statusFalsch);
                    showLabel.setCursor(new Cursor(0));
                    LOG.warn((Object)"URL Check Problem in Worker.", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    private void loadPictureWithUrl(final String url, final JLabel showLabel) {
        showLabel.setCursor(new Cursor(0));
        SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>(){

            @Override
            protected ImageIcon doInBackground() throws Exception {
                return No2StandortEditor.this.loadPicture(new URL(url));
            }

            @Override
            protected void done() {
                try {
                    ImageIcon check = (ImageIcon)this.get();
                    if (check != null) {
                        showLabel.setIcon(check);
                        showLabel.setText("");
                        showLabel.setCursor(new Cursor(12));
                    } else {
                        showLabel.setIcon(null);
                        showLabel.setText(NbBundle.getMessage(No2StandortEditor.class, (String)No2StandortEditor.BUNDLE_NOLOAD));
                        showLabel.setCursor(new Cursor(0));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    showLabel.setText(NbBundle.getMessage(No2StandortEditor.class, (String)No2StandortEditor.BUNDLE_NOLOAD));
                    showLabel.setCursor(new Cursor(0));
                    LOG.warn((Object)"load picture Problem in Worker.", (Throwable)e);
                }
            }
        };
        worker.execute();
    }
}

