/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.custom.wunda_blau.search.server.StrAdrGeplanteAdresseStrasseSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.editors.FastBindableReferenceCombo;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class StrAdrGeplanteAdresseEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore {
    private static final Logger LOG = Logger.getLogger(StrAdrGeplanteAdresseEditor.class);
    public static final String STRASSENNAME_TOSTRING_TEMPLATE = "%1$2s";
    public static final String[] STRASSENNAME_TOSTRING_FIELDS = new String[]{"anzeige"};
    protected Object hausnr;
    private CidsBean cidsBean = null;
    private boolean isEditor = true;
    private final StrAdrGeplanteAdresseStrasseSearch strasseSearch = new StrAdrGeplanteAdresseStrasseSearch("%1$2s", STRASSENNAME_TOSTRING_FIELDS);
    private DefaultBindableReferenceCombo cbAntragsteller;
    private JComboBox cbGeom;
    private DefaultBindableReferenceCombo cbGrund;
    private JComboBox cbStrassenname;
    private DefaultBindableReferenceCombo cbVorhaben;
    private DefaultBindableDateChooser dcAlkis;
    private DefaultBindableDateChooser dcBauantrag;
    private DefaultBindableDateChooser dcGeplant;
    private DefaultBindableDateChooser dcHistorisch;
    private DefaultBindableDateChooser dcVorhanden;
    private JFormattedTextField ftxHausnr;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JLabel lblSchluessel;
    private JPanel panAdresse;
    private JPanel panFillerMitteWasDatum;
    private JPanel panFillerRechts;
    private JPanel panFillerRechtsAdresse;
    private JPanel panFillerRechtsHaupt;
    private JPanel panFillerUnten;
    private JPanel panFillerUntenHaupt;
    private JPanel panHaupt;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panWasDatum;
    private RoundedPanel rpKarte;
    private SemiRoundedPanel semiRoundedPanel7;
    private JTextField txtAdr_zusatz;
    private JTextField txtBemerkung;
    private BindingGroup bindingGroup;

    public StrAdrGeplanteAdresseEditor() {
        this(true);
    }

    public StrAdrGeplanteAdresseEditor(boolean isEditor) {
        this.isEditor = isEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        if (!this.isEditor) {
            this.noEdit();
        } else {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setLocalRenderFeatureString("georeferenz");
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerRechts = new JPanel();
        this.panFillerUnten = new JPanel();
        this.panHaupt = new JPanel();
        this.panAdresse = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel1 = new JLabel();
        this.txtAdr_zusatz = new JTextField();
        this.cbStrassenname = new FastBindableReferenceCombo((LightweightMetaObjectsSearch)this.strasseSearch, this.strasseSearch.getRepresentationPattern(), this.strasseSearch.getRepresentationFields());
        this.ftxHausnr = new JFormattedTextField();
        this.lblSchluessel = new JLabel();
        if (this.isEditor) {
            this.jLabel3 = new JLabel();
        }
        if (this.isEditor) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
        }
        this.rpKarte = new RoundedPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.jLabel17 = new JLabel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.panFillerRechtsAdresse = new JPanel();
        this.jLabel11 = new JLabel();
        this.txtBemerkung = new JTextField();
        this.panFillerRechtsHaupt = new JPanel();
        this.panFillerUntenHaupt = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.panWasDatum = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.dcGeplant = new DefaultBindableDateChooser();
        this.dcBauantrag = new DefaultBindableDateChooser();
        this.dcVorhanden = new DefaultBindableDateChooser();
        this.dcHistorisch = new DefaultBindableDateChooser();
        this.cbGrund = new DefaultBindableReferenceCombo(true);
        this.jLabel14 = new JLabel();
        this.jLabel2 = new JLabel();
        this.dcAlkis = new DefaultBindableDateChooser();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.cbVorhaben = new DefaultBindableReferenceCombo(false);
        this.cbAntragsteller = new DefaultBindableReferenceCombo(false);
        this.panFillerMitteWasDatum = new JPanel();
        this.setLayout(new GridBagLayout());
        this.panFillerRechts.setName("");
        this.panFillerRechts.setOpaque(false);
        GroupLayout panFillerRechtsLayout = new GroupLayout(this.panFillerRechts);
        this.panFillerRechts.setLayout(panFillerRechtsLayout);
        panFillerRechtsLayout.setHorizontalGroup(panFillerRechtsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerRechtsLayout.setVerticalGroup(panFillerRechtsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 5.0E-4;
        this.add(this.panFillerRechts, gridBagConstraints);
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 5.0E-4;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panHaupt.setOpaque(false);
        this.panHaupt.setLayout(new GridBagLayout());
        this.panAdresse.setOpaque(false);
        this.panAdresse.setLayout(new GridBagLayout());
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 15, 2, 2);
        this.panAdresse.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setFont(new Font("Tahoma", 1, 11));
        this.jLabel13.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        this.panAdresse.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panAdresse.add((Component)this.jLabel1, gridBagConstraints);
        this.txtAdr_zusatz.setHorizontalAlignment(4);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.adr_zusatz}"), (Object)this.txtAdr_zusatz, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtAdr_zusatz.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StrAdrGeplanteAdresseEditor.this.txtAdr_zusatzFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        this.panAdresse.add((Component)this.txtAdr_zusatz, gridBagConstraints);
        ((FastBindableReferenceCombo)this.cbStrassenname).setSorted(false);
        this.cbStrassenname.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.fk_strasse_id}"), (Object)this.cbStrassenname, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbStrassenname.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StrAdrGeplanteAdresseEditor.this.cbStrassennameMouseClicked(evt);
            }
        });
        this.cbStrassenname.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StrAdrGeplanteAdresseEditor.this.cbStrassennameActionPerformed(evt);
            }
        });
        this.cbStrassenname.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StrAdrGeplanteAdresseEditor.this.cbStrassennamePropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.panAdresse.add((Component)this.cbStrassenname, gridBagConstraints);
        this.ftxHausnr.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("###"))));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.hausnr}"), (Object)this.ftxHausnr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panAdresse.add((Component)this.ftxHausnr, gridBagConstraints);
        this.lblSchluessel.setHorizontalAlignment(4);
        this.lblSchluessel.setText("     ");
        this.lblSchluessel.setToolTipText("");
        this.lblSchluessel.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(7, 4, 6, 5);
        this.panAdresse.add((Component)this.lblSchluessel, gridBagConstraints);
        if (this.isEditor) {
            this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        }
        if (this.isEditor) {
            this.jLabel3.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel3.text"));
        }
        if (this.isEditor) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.panAdresse.add((Component)this.jLabel3, gridBagConstraints);
        }
        if (this.isEditor) {
            if (this.isEditor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.georeferenz}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 2, 2);
            this.panAdresse.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel17.setForeground(new Color(255, 255, 255));
        this.jLabel17.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.jLabel17, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        this.panPreviewMap.setMinimumSize(new Dimension(600, 600));
        this.panPreviewMap.setName("");
        this.panPreviewMap.setPreferredSize(new Dimension(500, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 5, 0);
        this.panAdresse.add((Component)this.rpKarte, gridBagConstraints);
        this.panFillerRechtsAdresse.setName("");
        this.panFillerRechtsAdresse.setOpaque(false);
        GroupLayout panFillerRechtsAdresseLayout = new GroupLayout(this.panFillerRechtsAdresse);
        this.panFillerRechtsAdresse.setLayout(panFillerRechtsAdresseLayout);
        panFillerRechtsAdresseLayout.setHorizontalGroup(panFillerRechtsAdresseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerRechtsAdresseLayout.setVerticalGroup(panFillerRechtsAdresseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.panAdresse.add((Component)this.panFillerRechtsAdresse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.9;
        this.panHaupt.add((Component)this.panAdresse, gridBagConstraints);
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panHaupt.add((Component)this.jLabel11, gridBagConstraints);
        this.txtBemerkung.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.txtBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtBemerkung.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StrAdrGeplanteAdresseEditor.this.txtBemerkungPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        this.panHaupt.add((Component)this.txtBemerkung, gridBagConstraints);
        this.panFillerRechtsHaupt.setName("");
        this.panFillerRechtsHaupt.setOpaque(false);
        GroupLayout panFillerRechtsHauptLayout = new GroupLayout(this.panFillerRechtsHaupt);
        this.panFillerRechtsHaupt.setLayout(panFillerRechtsHauptLayout);
        panFillerRechtsHauptLayout.setHorizontalGroup(panFillerRechtsHauptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerRechtsHauptLayout.setVerticalGroup(panFillerRechtsHauptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        this.panHaupt.add((Component)this.panFillerRechtsHaupt, gridBagConstraints);
        this.panFillerUntenHaupt.setName("");
        this.panFillerUntenHaupt.setOpaque(false);
        GroupLayout panFillerUntenHauptLayout = new GroupLayout(this.panFillerUntenHaupt);
        this.panFillerUntenHaupt.setLayout(panFillerUntenHauptLayout);
        panFillerUntenHauptLayout.setHorizontalGroup(panFillerUntenHauptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenHauptLayout.setVerticalGroup(panFillerUntenHauptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.panHaupt.add((Component)this.panFillerUntenHaupt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        this.panHaupt.add((Component)this.jSeparator1, gridBagConstraints);
        this.panWasDatum.setOpaque(false);
        this.panWasDatum.setLayout(new GridBagLayout());
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel4.text"));
        this.jLabel4.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel8, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dat_geplant}"), (Object)this.dcGeplant, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcGeplant.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.dcGeplant, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dat_bauantrag}"), (Object)this.dcBauantrag, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcBauantrag.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.dcBauantrag, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dat_vorhanden}"), (Object)this.dcVorhanden, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcVorhanden.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.dcVorhanden, gridBagConstraints);
        this.dcHistorisch.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dat_historisch}"), (Object)this.dcHistorisch, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcHistorisch.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        this.dcHistorisch.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StrAdrGeplanteAdresseEditor.this.dcHistorischPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.dcHistorisch, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.grund}"), (Object)this.cbGrund, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbGrund.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StrAdrGeplanteAdresseEditor.this.cbGrundItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.cbGrund, gridBagConstraints);
        this.cbGrund.getAccessibleContext().setAccessibleName("");
        this.jLabel14.setFont(new Font("Tahoma", 1, 11));
        this.jLabel14.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/dialog-warning.png")));
        this.jLabel2.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel2.text"));
        this.jLabel2.setToolTipText("Geb\u00e4ude noch nicht eingemessen.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panWasDatum.add((Component)this.jLabel2, gridBagConstraints);
        this.dcAlkis.setEnabled(false);
        this.dcAlkis.setName("");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dat_alkis}"), (Object)this.dcAlkis, (Property)BeanProperty.create((String)"date"));
        this.bindingGroup.addBinding((Binding)binding);
        this.dcAlkis.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StrAdrGeplanteAdresseEditor.this.dcAlkisPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.dcAlkis, gridBagConstraints);
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panWasDatum.add((Component)this.jLabel10, gridBagConstraints);
        this.cbVorhaben.setSelectedIndex(0);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.vorhaben}"), (Object)this.cbVorhaben, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.cbVorhaben, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.antrag}"), (Object)this.cbAntragsteller, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panWasDatum.add((Component)this.cbAntragsteller, gridBagConstraints);
        this.panFillerMitteWasDatum.setName("");
        this.panFillerMitteWasDatum.setOpaque(false);
        GroupLayout panFillerMitteWasDatumLayout = new GroupLayout(this.panFillerMitteWasDatum);
        this.panFillerMitteWasDatum.setLayout(panFillerMitteWasDatumLayout);
        panFillerMitteWasDatumLayout.setHorizontalGroup(panFillerMitteWasDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerMitteWasDatumLayout.setVerticalGroup(panFillerMitteWasDatumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.panWasDatum.add((Component)this.panFillerMitteWasDatum, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panHaupt.add((Component)this.panWasDatum, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.panHaupt, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void dcAlkisPropertyChange(PropertyChangeEvent evt) {
        this.alkisDatumIsSet();
    }

    private void txtAdr_zusatzFocusLost(FocusEvent evt) {
        String zusatz = this.txtAdr_zusatz.getText().trim();
        zusatz = "   " + zusatz;
        this.txtAdr_zusatz.setText(zusatz);
    }

    private void cbStrassennameActionPerformed(ActionEvent evt) {
        this.setAddressNoEdit();
        if (this.cbStrassenname.getSelectedItem() != null) {
            this.lblSchluessel.setText(String.valueOf(this.getOtherTableValue("str_adr_strasse", this.getMyWhere(this.cbStrassenname.getSelectedItem().toString())).getProperty("schluessel.name")));
        }
    }

    private void dcHistorischPropertyChange(PropertyChangeEvent evt) {
        this.histDatumIsSet();
    }

    private void cbStrassennamePropertyChange(PropertyChangeEvent evt) {
        if (this.cbStrassenname.getSelectedItem() != null) {
            this.lblSchluessel.setText(String.valueOf(this.getOtherTableValue("str_adr_strasse", this.getMyWhere(this.cbStrassenname.getSelectedItem().toString())).getProperty("schluessel.name")));
        }
    }

    private void txtBemerkungPropertyChange(PropertyChangeEvent evt) {
        this.checkEdit();
    }

    private void cbStrassennameMouseClicked(MouseEvent evt) {
        List cblStrassen = this.getCidsBean().getBeanCollectionProperty("fk_strasse_id");
        Collator umlautCollator = Collator.getInstance(Locale.GERMAN);
        umlautCollator.setStrength(1);
        Collections.sort(cblStrassen, umlautCollator);
        this.cbStrassenname.setModel(new DefaultComboBoxModel<Object>(cblStrassen.toArray()));
    }

    private void cbGrundItemStateChanged(ItemEvent evt) {
        this.grundIsSet();
    }

    private void checkEdit() {
        try {
            String sEdit;
            CidsBean myCB = this.getCidsBean();
            if (myCB.getProperty("kein_edit") != null && "true".equalsIgnoreCase(sEdit = myCB.getProperty("kein_edit").toString())) {
                this.noEdit();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not determine cidsBeans id. ", (Throwable)e);
        }
    }

    private void alkisDatumIsSet() {
        Date myDate = this.dcAlkis.getDate();
        if (myDate != null) {
            this.noEdit();
        }
    }

    private void noEdit() {
        this.cbStrassenname.setEnabled(false);
        this.ftxHausnr.setEnabled(false);
        this.txtAdr_zusatz.setEnabled(false);
        this.dcGeplant.setEnabled(false);
        this.dcBauantrag.setEnabled(false);
        this.dcVorhanden.setEnabled(false);
        this.dcHistorisch.setEnabled(false);
        this.cbGrund.setEnabled(false);
        this.cbVorhaben.setEnabled(false);
        this.cbAntragsteller.setEnabled(false);
        if (this.isEditor) {
            this.cbGeom.setEnabled(false);
        } else {
            this.txtBemerkung.setEnabled(false);
        }
    }

    private void grundIsSet() {
        Date myDate = this.dcHistorisch.getDate();
        Integer iGrund = this.cbGrund.getSelectedIndex();
        if (myDate != null && iGrund != -1) {
            this.noEdit();
        }
    }

    private void histDatumIsSet() {
        Date myDate = this.dcHistorisch.getDate();
        if (myDate != null) {
            Integer iGrund = this.cbGrund.getSelectedIndex();
            if (iGrund != -1) {
                this.noEdit();
            } else {
                this.dcGeplant.setEnabled(false);
                this.dcBauantrag.setEnabled(false);
                this.dcVorhanden.setEnabled(false);
                if (this.isEditor) {
                    this.cbGeom.setEnabled(false);
                }
            }
        } else {
            Date alkisDate = this.dcAlkis.getDate();
            try {
                String sEdit;
                boolean booledit = true;
                CidsBean myCB = this.getCidsBean();
                if (myCB.getProperty("kein_edit") != null && "true".equalsIgnoreCase(sEdit = myCB.getProperty("kein_edit").toString())) {
                    booledit = false;
                }
                if (booledit && this.isEditor && alkisDate == null) {
                    this.dcGeplant.setEnabled(true);
                    this.dcBauantrag.setEnabled(true);
                    this.dcVorhanden.setEnabled(true);
                    this.cbGeom.setEnabled(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setAddressNoEdit() {
        CidsBean myCidsBean = this.getCidsBean();
        try {
            if (myCidsBean != null && myCidsBean.getMetaObject().getStatus() != 1) {
                this.cbStrassenname.setEnabled(false);
                this.ftxHausnr.setEnabled(false);
                this.txtAdr_zusatz.setEnabled(false);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not determine cidsBeans in setAddressNoEdit. ", (Throwable)e);
        }
    }

    private CidsBean getOtherTableValue(String myTable, String myWhere) {
        block6: {
            try {
                MetaClass myClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)myTable, (ConnectionContext)this.getConnectionContext());
                if (myClass == null) break block6;
                StringBuffer myQuery = new StringBuffer("select ").append(myClass.getId()).append(", ").append(myClass.getPrimaryKey()).append(" from ").append(myClass.getTableName()).append(myWhere);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: myQuery:" + myQuery.toString()));
                }
                try {
                    MetaObject[] myMetaObject = SessionManager.getProxy().getMetaObjectByQuery(myQuery.toString(), 0);
                    if (myMetaObject.length > 0) {
                        return myMetaObject[0].getBean();
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)(myWhere + " kann nicht geladen werden in getOtherTableValue."), (Throwable)ex);
            }
        }
        return null;
    }

    private String getMyWhere(String myWhere) {
        return " where name ilike '" + myWhere + "'";
    }

    private StringBuilder checkDateRange(Date checkDate, String welchesDatum, String fehlerFrueh, String fehlerSpaet) {
        StringBuilder errorMessage = new StringBuilder();
        LocalDate fruehDatum = LocalDate.of(1999, 1, 1);
        LocalDate jetztDatum = LocalDate.now();
        LocalDate spaetDatum = jetztDatum.plusDays(100L);
        if (checkDate != null) {
            LocalDate ld = checkDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            if (ld.isBefore(fruehDatum)) {
                LOG.warn((Object)("Wrong '" + welchesDatum + "' specified. Skip persisting."));
                errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)("StrAdrGeplanteAdresseEditor.prepareForSave()." + fehlerFrueh)));
            }
            if (ld.isAfter(spaetDatum)) {
                LOG.warn((Object)("Wrong '" + welchesDatum + "' specified. Skip persisting."));
                errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)("StrAdrGeplanteAdresseEditor.prepareForSave()." + fehlerSpaet)));
            }
        }
        return errorMessage;
    }

    private StringBuilder noSelectedItem(Object controlValue, String welchesObject, String fehler) {
        StringBuilder errorMessage = new StringBuilder();
        if (controlValue == null) {
            LOG.warn((Object)("No '" + welchesObject + "' specified. Skip persisting."));
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)("StrAdrGeplanteAdresseEditor.prepareForSave()." + fehler)));
        }
        return errorMessage;
    }

    private StringBuilder getDateBefore(Date dateBefore, Date dateAfter, String welcheDati, String fehler) {
        StringBuilder errorMessage = new StringBuilder();
        if (dateBefore.before(dateAfter)) {
            LOG.warn((Object)("Wrong '" + welcheDati + "' specified. Skip persisting."));
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)("StrAdrGeplanteAdresseEditor.prepareForSave()." + fehler)));
        }
        return errorMessage;
    }

    public boolean prepareForSave() {
        StringBuilder errorMessage = new StringBuilder();
        if (this.ftxHausnr.getText() == null || this.ftxHausnr.getText().trim().isEmpty()) {
            LOG.warn((Object)"No 'hausnr' specified. Skip persisting.");
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().noHausnr"));
        } else if (this.ftxHausnr.getText().length() > 3) {
            LOG.warn((Object)"Property 'hausnr' is too long. Skip persisting.");
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().tooLongHausnr"));
        }
        if (this.txtAdr_zusatz.getText() == null || this.txtAdr_zusatz.getText().trim().isEmpty()) {
            this.txtAdr_zusatz.setText("    ");
        } else if (this.txtAdr_zusatz.getText().trim().matches("[a-z]") && this.txtAdr_zusatz.getText().trim().length() == 1) {
            String zusatz = this.txtAdr_zusatz.getText().trim();
            zusatz = "   " + zusatz;
            this.txtAdr_zusatz.setText(zusatz);
        } else {
            LOG.warn((Object)"No 'zusatz' specified. Skip persisting.");
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().wrongZusatz"));
        }
        errorMessage.append((CharSequence)this.noSelectedItem(this.cbVorhaben.getSelectedItem(), "vorhaben", "noVorhaben"));
        errorMessage.append((CharSequence)this.noSelectedItem(this.cbAntragsteller.getSelectedItem(), "antrag", "noAntrag"));
        errorMessage.append((CharSequence)this.noSelectedItem(this.cbStrassenname.getSelectedItem(), "schluessel", "noStrasse"));
        if (this.cbGeom.getSelectedItem() == null || this.cbGeom.getSelectedItem().toString().trim().isEmpty()) {
            LOG.warn((Object)"No 'geom' specified. Skip persisting.");
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().noGeom"));
        }
        errorMessage.append((CharSequence)this.checkDateRange(this.dcGeplant.getDate(), "geplant date", "datFalschGeplantFrueh", "datFalschGeplantSpaet"));
        errorMessage.append((CharSequence)this.checkDateRange(this.dcBauantrag.getDate(), "bauantrag date", "datFalschBauantragFrueh", "datFalschBauantragSpaet"));
        errorMessage.append((CharSequence)this.checkDateRange(this.dcVorhanden.getDate(), "vorhanden date", "datFalschVorhandenFrueh", "datFalschVorhandenSpaet"));
        errorMessage.append((CharSequence)this.checkDateRange(this.dcHistorisch.getDate(), "historisch date", "datFalschHistorischFrueh", "datFalschHistorischSpaet"));
        if (this.dcGeplant.getDate() == null && this.dcBauantrag.getDate() == null && this.dcVorhanden.getDate() == null) {
            LOG.warn((Object)"No 'date' specified. Skip persisting.");
            errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().noDate"));
        } else {
            if (this.dcGeplant.getDate() != null && this.dcBauantrag.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcBauantrag.getDate(), this.dcGeplant.getDate(), "date (geplant-bauantrag)", "datFalschGeplantBauantrag"));
            }
            if (this.dcGeplant.getDate() != null && this.dcVorhanden.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcVorhanden.getDate(), this.dcGeplant.getDate(), "date (geplant-vorhanden)", "datFalschGeplantVorhanden"));
            }
            if (this.dcBauantrag.getDate() != null && this.dcVorhanden.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcVorhanden.getDate(), this.dcBauantrag.getDate(), "date (bauantrag-vorhanden)", "datFalschBauantragVorhanden"));
            }
        }
        if (this.dcHistorisch.getDate() != null) {
            if (this.dcGeplant.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcHistorisch.getDate(), this.dcGeplant.getDate(), "date (geplant-historisch)", "datFalschGeplantHistorisch"));
            }
            if (this.dcVorhanden.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcHistorisch.getDate(), this.dcVorhanden.getDate(), "date (vorhanden-historisch)", "datFalschVorhandenHistorisch"));
            }
            if (this.dcBauantrag.getDate() != null) {
                errorMessage.append((CharSequence)this.getDateBefore(this.dcHistorisch.getDate(), this.dcBauantrag.getDate(), "date (bauantrag-historisch)", "datFalschBauantragHistorisch"));
            }
            errorMessage.append((CharSequence)this.noSelectedItem(this.cbGrund.getSelectedItem(), "grund", "datHistorischGrund"));
        }
        if (this.cbGrund.getSelectedItem() != null) {
            errorMessage.append((CharSequence)this.noSelectedItem(this.dcHistorisch.getDate(), "historisch", "datGrundHistorisch"));
        }
        try {
            CidsBean myCB = this.getCidsBean();
            if (myCB.getMetaObject().getStatus() == 1) {
                if (this.dcHistorisch.getDate() == null && this.cbStrassenname.getSelectedItem() != null) {
                    String myStrasse = this.getOtherTableValue("str_adr_strasse", this.getMyWhere(this.cbStrassenname.getSelectedItem().toString())).getProperty("id").toString();
                    String myHausnummer = this.ftxHausnr.getText();
                    String myZusatz = this.txtAdr_zusatz.getText().trim();
                    String myQuery = " where fk_strasse_id = " + myStrasse + " and hausnr = " + myHausnummer + " and trim(adr_zusatz) ilike '" + myZusatz + "' and dat_historisch is null";
                    if (this.getOtherTableValue("str_adr_geplante_adresse", myQuery) != null) {
                        LOG.warn((Object)"Not unique 'adress' specified. Skip persisting.");
                        errorMessage.append(NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().adresseVorhanden"));
                    }
                }
            } else {
                String myId = String.valueOf(myCB.getProperty("id"));
                String myQuery = " where id = " + myId + " and dat_historisch is not null";
                CidsBean dbBean = this.getOtherTableValue("str_adr_geplante_adresse", myQuery);
                if (dbBean != null) {
                    errorMessage.append((CharSequence)this.noSelectedItem(this.dcHistorisch.getDate(), "freies historisch", "historischVorhanden"));
                }
            }
        }
        catch (MissingResourceException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().JOptionPane.message.prefix") + errorMessage.toString() + NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().JOptionPane.message.suffix"), NbBundle.getMessage(StrAdrGeplanteAdresseEditor.class, (String)"StrAdrGeplanteAdresseEditor.prepareForSave().JOptionPane.title"), 2);
            return false;
        }
        return true;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.panPreviewMap.initMap(cb, "georeferenz.geo_field");
            this.bindingGroup.bind();
            this.loadStreets();
            if (cb.getMetaObject().getStatus() == 1) {
                this.cidsBean.setProperty("antrag", (Object)this.getOtherTableValue("str_adr_geplante_adresse_antrag", this.getMyWhere("Beh\u00f6rde")));
                this.cidsBean.setProperty("vorhaben", (Object)this.getOtherTableValue("str_adr_geplante_adresse_vorhaben", this.getMyWhere("Neubau")));
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadStreets() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                ((FastBindableReferenceCombo)StrAdrGeplanteAdresseEditor.this.cbStrassenname).refreshModel();
                return null;
            }
        }.execute();
    }

    public void dispose() {
        super.dispose();
        if (this.isEditor) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
        }
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }
}

