/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class VkThemaEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
RequestsFullSizeComponent {
    private static final String TITLE_NEW_THEMA = "eine neues Thema anlegen...";
    private static final Logger LOG = Logger.getLogger(VkThemaEditor.class);
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ID = "id";
    public static final String FIELD__FARBE = "farbe";
    public static final String TABLE_NAME = "vk_thema";
    public static final String BUNDLE_NONAME = "VkThemaEditor.prepareForSave().noName";
    public static final String BUNDLE_NOICON = "VkThemaEditor.prepareForSave().noIcon";
    public static final String BUNDLE_NOCOLOR = "VkThemaEditor.prepareForSave().noFarbe";
    public static final String BUNDLE_WRONGCOLOR = "VkThemaEditor.prepareForSave().wrongFarbe";
    public static final String BUNDLE_DUPLICATENAME = "VkThemaEditor.prepareForSave().duplicateName";
    public static final String BUNDLE_PANE_PREFIX = "VkThemaEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "VkThemaEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "VkThemaEditor.prepareForSave().JOptionPane.title";
    private SwingWorker worker_name;
    private Boolean redundantName = false;
    private boolean isEditor = true;
    private JButton btnChooseColor;
    private JButton btnMenAbortColor;
    private JButton btnMenOkColor;
    private JDialog dlgColor;
    private JColorChooser jColorChooser;
    private JLabel lblBeschreibung;
    private JLabel lblFarbe;
    private JLabel lblFuellung;
    private JLabel lblIcon;
    private JLabel lblName;
    private JLabel lblProzent;
    private JPanel panBeschreibung;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panMenButtonsColor;
    private JPanel panName;
    private JScrollPane scpBeschreibung;
    JSpinner spFuellung;
    private JTextArea taBeschreibung;
    private JTextField txtFarbe;
    private JTextField txtFarbeZeigen;
    private JTextField txtIcon;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public VkThemaEditor() {
    }

    public VkThemaEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VkThemaEditor.this.checkName(VkThemaEditor.FIELD__NAME);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VkThemaEditor.this.checkName(VkThemaEditor.FIELD__NAME);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VkThemaEditor.this.checkName(VkThemaEditor.FIELD__NAME);
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.dlgColor = new JDialog(StaticSwingTools.getParentFrame((Component)((Object)this)));
        this.jColorChooser = new JColorChooser();
        this.panMenButtonsColor = new JPanel();
        this.btnMenAbortColor = new JButton();
        this.btnMenOkColor = new JButton();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panFillerUnten1 = new JPanel();
        this.panName = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblIcon = new JLabel();
        this.txtIcon = new JTextField();
        this.lblFarbe = new JLabel();
        this.txtFarbe = new JTextField();
        this.btnChooseColor = new JButton();
        this.txtFarbeZeigen = new JTextField();
        this.lblFuellung = new JLabel();
        this.spFuellung = new JSpinner();
        this.lblProzent = new JLabel();
        this.lblBeschreibung = new JLabel();
        this.panBeschreibung = new JPanel();
        this.scpBeschreibung = new JScrollPane();
        this.taBeschreibung = new JTextArea();
        this.dlgColor.setTitle("Farbe ausw\u00e4hlen");
        this.dlgColor.setModal(true);
        this.dlgColor.setSize(new Dimension(700, 500));
        this.dlgColor.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.dlgColor.getContentPane().add((Component)this.jColorChooser, gridBagConstraints);
        this.panMenButtonsColor.setLayout(new GridBagLayout());
        this.btnMenAbortColor.setText("Abbrechen");
        this.btnMenAbortColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VkThemaEditor.this.btnMenAbortColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsColor.add((Component)this.btnMenAbortColor, gridBagConstraints);
        this.btnMenOkColor.setText("Ok");
        this.btnMenOkColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VkThemaEditor.this.btnMenOkColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMenButtonsColor.add((Component)this.btnMenOkColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgColor.getContentPane().add((Component)this.panMenButtonsColor, gridBagConstraints);
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtName, gridBagConstraints);
        this.lblIcon.setFont(new Font("Tahoma", 1, 11));
        this.lblIcon.setText("Icon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblIcon, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.signatur}"), (Object)this.txtIcon, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtIcon, gridBagConstraints);
        this.lblFarbe.setFont(new Font("Tahoma", 1, 11));
        this.lblFarbe.setText("Farbe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblFarbe, gridBagConstraints);
        this.txtFarbe.setEnabled(false);
        this.txtFarbe.setMaximumSize(new Dimension(75, Integer.MAX_VALUE));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.farbe}"), (Object)this.txtFarbe, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtFarbe, gridBagConstraints);
        this.btnChooseColor.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnChooseColor.setToolTipText(NbBundle.getMessage(VkThemaEditor.class, (String)"TOOL_FARBE"));
        this.btnChooseColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VkThemaEditor.this.btnChooseColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.btnChooseColor, gridBagConstraints);
        this.txtFarbeZeigen.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtFarbeZeigen, gridBagConstraints);
        this.lblFuellung.setFont(new Font("Tahoma", 1, 11));
        this.lblFuellung.setText("Fl\u00e4chenf\u00fcllung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblFuellung, gridBagConstraints);
        this.spFuellung.setFont(new Font("Dialog", 0, 12));
        this.spFuellung.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.spFuellung.setPreferredSize(new Dimension(75, 25));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.fuellung}"), (Object)this.spFuellung, (Property)BeanProperty.create((String)"value"));
        binding.setSourceNullValue((Object)0);
        binding.setSourceUnreadableValue((Object)0);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.spFuellung, gridBagConstraints);
        this.lblProzent.setFont(new Font("Tahoma", 1, 11));
        this.lblProzent.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 2, 5);
        this.panName.add((Component)this.lblProzent, gridBagConstraints);
        this.lblBeschreibung.setFont(new Font("Tahoma", 1, 11));
        this.lblBeschreibung.setText("Beschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblBeschreibung, gridBagConstraints);
        this.panBeschreibung.setOpaque(false);
        this.panBeschreibung.setLayout(new GridBagLayout());
        this.taBeschreibung.setColumns(20);
        this.taBeschreibung.setLineWrap(true);
        this.taBeschreibung.setRows(8);
        this.taBeschreibung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.beschreibung}"), (Object)this.taBeschreibung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBeschreibung.setViewportView(this.taBeschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBeschreibung.add((Component)this.scpBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.panBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(25, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void btnChooseColorActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)((Object)this)), (JDialog)this.dlgColor, (boolean)true);
    }

    private void btnMenAbortColorActionPerformed(ActionEvent evt) {
        this.dlgColor.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnMenOkColorActionPerformed(ActionEvent evt) {
        try {
            Color selColor = this.jColorChooser.getColor();
            String hex_red = this.twoHexString(Integer.toHexString(selColor.getRed()));
            String hex_green = this.twoHexString(Integer.toHexString(selColor.getGreen()));
            String hex_blue = this.twoHexString(Integer.toHexString(selColor.getBlue()));
            this.getCidsBean().setProperty(FIELD__FARBE, (Object)('#' + hex_red + hex_green + hex_blue));
            this.txtFarbeZeigen.setBackground(selColor);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            this.dlgColor.setVisible(false);
        }
    }

    private String twoHexString(String hex) {
        if (hex.length() == 1) {
            return '0' + hex;
        }
        return hex;
    }

    public boolean prepareForSave() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_NONAME));
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_DUPLICATENAME));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtIcon.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_NOICON));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtFarbe.getText().trim().isEmpty()) {
                LOG.warn((Object)"No color specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_NOCOLOR));
            } else if (this.txtFarbe.getText().trim().length() != 7 || !this.txtFarbe.getText().trim().matches("#[a-fA-F0-9]{0,6}$")) {
                LOG.warn((Object)"Wrong color specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_WRONGCOLOR));
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(VkThemaEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            this.bindingGroup.bind();
            this.setFarbe();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtIcon);
            RendererTools.makeReadOnly(this.txtFarbe);
            RendererTools.makeReadOnly(this.taBeschreibung);
            RendererTools.jSpinnerShouldLookLikeLabel(this.spFuellung);
            RendererTools.makeDoubleSpinnerWithoutButtons(this.spFuellung, 0);
            RendererTools.makeReadOnly(this.spFuellung);
            this.btnChooseColor.setVisible(false);
        }
    }

    private void setFarbe() {
        if (this.getCidsBean() != null && this.getCidsBean().getProperty(FIELD__FARBE) != null) {
            String hexColor = this.getCidsBean().getProperty(FIELD__FARBE).toString();
            int rot = Integer.valueOf(hexColor.substring(1, 3), 16);
            int gruen = Integer.valueOf(hexColor.substring(3, 5), 16);
            int blau = Integer.valueOf(hexColor.substring(5, 7), 16);
            Color showColor = new Color(rot, gruen, blau);
            this.txtFarbeZeigen.setBackground(showColor);
        } else {
            this.txtFarbeZeigen.setBackground(new Color(214, 217, 223));
        }
    }

    private void checkName(String field) {
        this.valueFromOtherTable(TABLE_NAME, " where " + field + " ilike '" + this.txtName.getText().trim() + "' and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID));
    }

    public void dispose() {
        super.dispose();
    }

    public String getTitle() {
        if (this.cidsBean.getMetaObject().getStatus() == 1) {
            return TITLE_NEW_THEMA;
        }
        return this.cidsBean.toString();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    private void valueFromOtherTable(final String tableName, final String whereClause) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, VkThemaEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        CidsBean check = (CidsBean)this.get();
                        VkThemaEditor.this.redundantName = check != null;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)"problem in Worker: load values.", (Throwable)e);
                }
            }
        };
        if (this.worker_name != null) {
            this.worker_name.cancel(true);
        }
        this.worker_name = worker;
        this.worker_name.execute();
    }
}

