/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WebDavPicturePanel
extends JPanel
implements CidsBeanStore,
EditorSaveListener,
Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(WebDavPicturePanel.class);
    private static final ImageIcon ERROR_ICON = new ImageIcon(WebDavPicturePanel.class.getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/file-broken.png"));
    private static final ImageIcon FOLDER_ICON = new ImageIcon(WebDavPicturePanel.class.getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/inode-directory.png"));
    private static final Pattern IMAGE_FILE_PATTERN = Pattern.compile(".*\\.(bmp|png|jpg|jpeg|tif|tiff|wbmp)$", 2);
    private static final int CACHE_SIZE = 20;
    private static final Map<String, SoftReference<BufferedImage>> IMAGE_CACHE = new LinkedHashMap<String, SoftReference<BufferedImage>>(20){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SoftReference<BufferedImage>> eldest) {
            return this.size() >= 20;
        }
    };
    private final WebDavTunnelHelper webdavHelper;
    private final String webdavDirectory;
    private final String beanCollProp;
    private final String geoFieldProp;
    private final String numberProp;
    private final String bildClassName;
    private final JFileChooser fileChooser = new JFileChooser();
    private final List<CidsBean> removeNewAddedFotoBean = new ArrayList<CidsBean>();
    private final List<CidsBean> removedFotoBeans = new ArrayList<CidsBean>();
    private final MappingComponent map = new MappingComponent();
    private final PropertyChangeListener listRepaintListener;
    private final Timer timer;
    private boolean listListenerEnabled = true;
    private boolean resizeListenerEnabled;
    private CidsBean cidsBean;
    private ImageResizeWorker currentResizeWorker;
    private CidsBean fotoCidsBean;
    private BufferedImage image;
    private final ConnectionContext connectionContext;
    JButton btnAddImg;
    JButton btnNextImg;
    JButton btnPrevImg;
    JButton btnRemoveImg;
    JXBusyLabel lblBusy;
    JLabel lblPicture;
    JList lstFotos;
    JPanel pnlFoto;
    private BindingGroup bindingGroup;

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        RoundedPanel pnlFotos = new RoundedPanel();
        SemiRoundedPanel pnlHeaderFotos = new SemiRoundedPanel();
        JLabel lblHeaderFotos = new JLabel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JScrollPane jspFotoList = new JScrollPane();
        this.lstFotos = new JList();
        JPanel pnlCtrlButtons = new JPanel();
        this.btnAddImg = new JButton();
        this.btnRemoveImg = new JButton();
        JPanel pnlMap = new JPanel();
        RoundedPanel pnlVorschau = new RoundedPanel();
        SemiRoundedPanel semiRoundedPanel2 = new SemiRoundedPanel();
        JLabel lblVorschau = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.pnlFoto = new JPanel();
        this.lblPicture = new JLabel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        JPanel pnlCtrlBtn = new JPanel();
        this.btnPrevImg = new JButton();
        this.btnNextImg = new JButton();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        pnlFotos.setMinimumSize(new Dimension(400, 200));
        pnlFotos.setName("pnlFotos");
        pnlFotos.setPreferredSize(new Dimension(400, 200));
        pnlFotos.setLayout((LayoutManager)new GridBagLayout());
        pnlHeaderFotos.setBackground(new Color(51, 51, 51));
        pnlHeaderFotos.setForeground(new Color(51, 51, 51));
        pnlHeaderFotos.setName("pnlHeaderFotos");
        pnlHeaderFotos.setLayout((LayoutManager)new FlowLayout());
        lblHeaderFotos.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)lblHeaderFotos, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.lblHeaderFotos.text"));
        lblHeaderFotos.setName("lblHeaderFotos");
        pnlHeaderFotos.add((Component)lblHeaderFotos);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        pnlFotos.add((Component)pnlHeaderFotos, (Object)gridBagConstraints);
        jPanel2.setName("jPanel2");
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());
        jPanel1.setName("jPanel1");
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());
        jspFotoList.setMinimumSize(new Dimension(250, 130));
        jspFotoList.setName("jspFotoList");
        this.lstFotos.setMinimumSize(new Dimension(250, 130));
        this.lstFotos.setName("lstFotos");
        this.lstFotos.setPreferredSize(new Dimension(250, 130));
        ELProperty eLProperty = ELProperty.create((String)("${cidsBean." + this.beanCollProp + "}"));
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstFotos);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstFotos.addListSelectionListener(formListener);
        jspFotoList.setViewportView(this.lstFotos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add((Component)jspFotoList, gridBagConstraints);
        pnlCtrlButtons.setName("pnlCtrlButtons");
        pnlCtrlButtons.setOpaque(false);
        pnlCtrlButtons.setLayout(new GridBagLayout());
        this.btnAddImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddImg, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.btnAddImg.text"));
        this.btnAddImg.setBorderPainted(false);
        this.btnAddImg.setContentAreaFilled(false);
        this.btnAddImg.setName("btnAddImg");
        this.btnAddImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        pnlCtrlButtons.add((Component)this.btnAddImg, gridBagConstraints);
        this.btnRemoveImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveImg, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.btnRemoveImg.text"));
        this.btnRemoveImg.setBorderPainted(false);
        this.btnRemoveImg.setContentAreaFilled(false);
        this.btnRemoveImg.setName("btnRemoveImg");
        this.btnRemoveImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pnlCtrlButtons.add((Component)this.btnRemoveImg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel1.add((Component)pnlCtrlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        jPanel2.add((Component)jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        pnlFotos.add((Component)jPanel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)pnlFotos, gridBagConstraints);
        pnlMap.setBorder(BorderFactory.createEtchedBorder());
        pnlMap.setMinimumSize(new Dimension(400, 200));
        pnlMap.setName("pnlMap");
        pnlMap.setPreferredSize(new Dimension(400, 200));
        pnlMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)pnlMap, gridBagConstraints);
        pnlMap.add((Component)this.map, "Center");
        pnlVorschau.setName("pnlVorschau");
        pnlVorschau.setLayout((LayoutManager)new GridBagLayout());
        semiRoundedPanel2.setBackground(new Color(51, 51, 51));
        semiRoundedPanel2.setName("semiRoundedPanel2");
        semiRoundedPanel2.setLayout((LayoutManager)new FlowLayout());
        lblVorschau.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)lblVorschau, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.lblVorschau.text"));
        lblVorschau.setName("lblVorschau");
        semiRoundedPanel2.add((Component)lblVorschau);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        pnlVorschau.add((Component)semiRoundedPanel2, (Object)gridBagConstraints);
        jPanel3.setName("jPanel3");
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());
        this.pnlFoto.setName("pnlFoto");
        this.pnlFoto.setOpaque(false);
        this.pnlFoto.setLayout(new GridBagLayout());
        this.lblPicture.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblPicture, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.lblPicture.text"));
        this.lblPicture.setName("lblPicture");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlFoto.add((Component)this.lblPicture, gridBagConstraints);
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 60));
        this.lblBusy.setName("lblBusy");
        this.lblBusy.setPreferredSize(new Dimension(140, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlFoto.add((Component)this.lblBusy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel3.add((Component)this.pnlFoto, gridBagConstraints);
        pnlCtrlBtn.setName("pnlCtrlBtn");
        pnlCtrlBtn.setOpaque(false);
        pnlCtrlBtn.setPreferredSize(new Dimension(100, 50));
        pnlCtrlBtn.setLayout(new GridBagLayout());
        this.btnPrevImg.setIcon(new ImageIcon(this.getClass().getResource("/res/arrow-left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrevImg, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.btnPrevImg.text"));
        this.btnPrevImg.setBorderPainted(false);
        this.btnPrevImg.setFocusPainted(false);
        this.btnPrevImg.setName("btnPrevImg");
        this.btnPrevImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlCtrlBtn.add((Component)this.btnPrevImg, gridBagConstraints);
        this.btnNextImg.setIcon(new ImageIcon(this.getClass().getResource("/res/arrow-right.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNextImg, (String)NbBundle.getMessage(WebDavPicturePanel.class, (String)"WebDavPicturePanel.btnNextImg.text"));
        this.btnNextImg.setBorderPainted(false);
        this.btnNextImg.setFocusPainted(false);
        this.btnNextImg.setName("btnNextImg");
        this.btnNextImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlCtrlBtn.add((Component)this.btnNextImg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel3.add((Component)pnlCtrlBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlVorschau.add((Component)jPanel3, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)pnlVorschau, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public WebDavPicturePanel() {
        this(true, "url", "bilder", "", "", "", null);
    }

    public WebDavPicturePanel(boolean editable, String urlProp, String beanCollProp, String bildClassName, String numberProp, String geoFieldProp, ConnectionContext connectionContext) {
        this.beanCollProp = beanCollProp;
        this.bildClassName = bildClassName;
        this.numberProp = numberProp;
        this.geoFieldProp = geoFieldProp;
        this.connectionContext = connectionContext;
        String webdavDirectory = null;
        WebDavTunnelHelper webdavHelper = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
            String pass = bundle.getString("password");
            if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                pass = PasswordEncrypter.decryptString((String)pass);
            }
            String user = bundle.getString("user");
            webdavDirectory = bundle.getString(urlProp);
            webdavHelper = new WebDavTunnelHelper("WUNDA_BLAU", ProxyHandler.getInstance().getProxy(), user, pass, Boolean.valueOf(false));
        }
        catch (Exception ex) {
            String message = "Fehler beim Initialisieren der Bilderablage.";
            LOG.error((Object)"Fehler beim Initialisieren der Bilderablage.", (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Initialisieren der Bilderablage.", ex, null);
        }
        this.webdavDirectory = webdavDirectory;
        this.webdavHelper = webdavHelper;
        this.initComponents();
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || IMAGE_FILE_PATTERN.matcher(f.getName()).matches();
            }

            @Override
            public String getDescription() {
                return "Bilddateien";
            }
        });
        this.fileChooser.setMultiSelectionEnabled(true);
        this.listRepaintListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebDavPicturePanel.this.lstFotos.repaint();
            }
        };
        this.lstFotos.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                WebDavPicturePanel.this.defineButtonStatus();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                WebDavPicturePanel.this.defineButtonStatus();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                WebDavPicturePanel.this.defineButtonStatus();
            }
        });
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDavPicturePanel.this.resizeListenerEnabled) {
                    if (WebDavPicturePanel.this.currentResizeWorker != null) {
                        WebDavPicturePanel.this.currentResizeWorker.cancel(true);
                    }
                    WebDavPicturePanel.this.currentResizeWorker = new ImageResizeWorker();
                    CismetThreadPool.execute((Runnable)WebDavPicturePanel.this.currentResizeWorker);
                }
            }
        });
        this.timer.setRepeats(false);
        this.btnAddImg.setVisible(editable);
        this.btnRemoveImg.setVisible(editable);
    }

    private void lstFotosValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && this.listListenerEnabled) {
            this.loadFoto();
        }
    }

    private void btnAddImgActionPerformed(ActionEvent evt) {
        File[] selFiles;
        if (0 == this.fileChooser.showOpenDialog(this) && (selFiles = this.fileChooser.getSelectedFiles()) != null && selFiles.length > 0) {
            CismetThreadPool.execute((Runnable)new ImageUploadWorker(Arrays.asList(selFiles)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveImgActionPerformed(ActionEvent evt) {
        int answer;
        Object[] selection = this.lstFotos.getSelectedValues();
        if (selection != null && selection.length > 0 && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sollen die Fotos wirklich gel\u00f6scht werden?", "Fotos entfernen", 0)) == 0) {
            try {
                this.listListenerEnabled = false;
                List<Object> removeList = Arrays.asList(selection);
                List fotos = this.cidsBean.getBeanCollectionProperty(this.beanCollProp);
                if (fotos != null) {
                    fotos.removeAll(removeList);
                }
                for (int i = 0; i < this.lstFotos.getModel().getSize(); ++i) {
                    CidsBean foto = (CidsBean)this.lstFotos.getModel().getElementAt(i);
                    foto.setProperty("laufende_nummer", (Object)(i + 1));
                }
                for (Object toDeleteObj : removeList) {
                    if (!(toDeleteObj instanceof CidsBean)) continue;
                    CidsBean fotoToDelete = (CidsBean)toDeleteObj;
                    String file = String.valueOf(fotoToDelete.getProperty("url.object_name"));
                    IMAGE_CACHE.remove(file);
                    this.removedFotoBeans.add(fotoToDelete);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                WebDavPicturePanel.showExceptionToUser(ex, this);
            }
            finally {
                this.listListenerEnabled = true;
                int modelSize = this.lstFotos.getModel().getSize();
                if (modelSize > 0) {
                    this.lstFotos.setSelectedIndex(0);
                } else {
                    this.image = null;
                    this.lblPicture.setIcon(FOLDER_ICON);
                }
            }
        }
    }

    private void btnPrevImgActionPerformed(ActionEvent evt) {
        this.lstFotos.setSelectedIndex(this.lstFotos.getSelectedIndex() - 1);
    }

    private void btnNextImgActionPerformed(ActionEvent evt) {
        this.lstFotos.setSelectedIndex(this.lstFotos.getSelectedIndex() + 1);
    }

    private void loadFoto() {
        Object fotoObj = this.lstFotos.getSelectedValue();
        if (this.fotoCidsBean != null) {
            this.fotoCidsBean.removePropertyChangeListener(this.listRepaintListener);
        }
        if (fotoObj instanceof CidsBean) {
            this.fotoCidsBean = (CidsBean)fotoObj;
            this.fotoCidsBean.addPropertyChangeListener(this.listRepaintListener);
            String fileObj = (String)this.fotoCidsBean.getProperty("url.object_name");
            boolean cacheHit = false;
            if (fileObj != null) {
                BufferedImage cachedImage;
                SoftReference<BufferedImage> cachedImageRef = IMAGE_CACHE.get(fileObj);
                if (cachedImageRef != null && (cachedImage = cachedImageRef.get()) != null) {
                    cacheHit = true;
                    this.image = cachedImage;
                    this.showWait(true);
                    this.resizeListenerEnabled = true;
                    this.timer.restart();
                }
                if (!cacheHit) {
                    CismetThreadPool.execute((Runnable)new LoadSelectedImageWorker(fileObj));
                }
            }
        } else {
            this.image = null;
            this.lblPicture.setIcon(FOLDER_ICON);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        this.bindingGroup.bind();
        if (cidsBean != null) {
            if (this.lstFotos.getModel().getSize() > 0) {
                this.lstFotos.setSelectedIndex(0);
            }
            this.initMap();
        }
    }

    public void defineButtonStatus() {
        int selectedIdx = this.lstFotos.getSelectedIndex();
        this.btnPrevImg.setEnabled(selectedIdx > 0);
        this.btnNextImg.setEnabled(selectedIdx < this.lstFotos.getModel().getSize() - 1 && selectedIdx > -1);
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                this.lblPicture.setIcon(null);
                this.lblBusy.setBusy(true);
                this.btnAddImg.setEnabled(false);
                this.btnRemoveImg.setEnabled(false);
                this.lstFotos.setEnabled(false);
                this.btnPrevImg.setEnabled(false);
                this.btnNextImg.setEnabled(false);
            }
        } else {
            this.lblBusy.setBusy(false);
            this.lblBusy.setVisible(false);
            this.btnAddImg.setEnabled(true);
            this.btnRemoveImg.setEnabled(true);
            this.lstFotos.setEnabled(true);
            this.defineButtonStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage downloadImageFromWebDAV(String fileName) throws Exception {
        InputStream iStream = this.webdavHelper.getFileFromWebDAV(fileName, this.webdavDirectory, this.getConnectionContext());
        try {
            final ImageInputStream iiStream = ImageIO.createImageInputStream(iStream);
            Iterator<ImageReader> itReader = ImageIO.getImageReaders(iiStream);
            if (itReader.hasNext()) {
                BufferedImage result;
                ImageReader reader = itReader.next();
                final ProgressMonitor monitor = new ProgressMonitor(this, "Bild wird \u00fcbertragen...", "", 0, 100);
                reader.addIIOReadProgressListener(new IIOReadProgressListener(){

                    @Override
                    public void sequenceStarted(ImageReader source, int minIndex) {
                    }

                    @Override
                    public void sequenceComplete(ImageReader source) {
                    }

                    @Override
                    public void imageStarted(ImageReader source, int imageIndex) {
                        monitor.setProgress(monitor.getMinimum());
                    }

                    @Override
                    public void imageProgress(ImageReader source, float percentageDone) {
                        if (monitor.isCanceled()) {
                            try {
                                iiStream.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            monitor.setProgress(Math.round(percentageDone));
                        }
                    }

                    @Override
                    public void imageComplete(ImageReader source) {
                        monitor.setProgress(monitor.getMaximum());
                    }

                    @Override
                    public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
                    }

                    @Override
                    public void thumbnailProgress(ImageReader source, float percentageDone) {
                    }

                    @Override
                    public void thumbnailComplete(ImageReader source) {
                    }

                    @Override
                    public void readAborted(ImageReader source) {
                        monitor.close();
                    }
                });
                ImageReadParam param = reader.getDefaultReadParam();
                reader.setInput(iiStream, true, true);
                try {
                    result = reader.read(0, param);
                }
                finally {
                    reader.dispose();
                    iiStream.close();
                }
                BufferedImage bufferedImage = result;
                return bufferedImage;
            }
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)iStream);
        }
    }

    public static Image adjustScale(BufferedImage bi, JComponent component, int insetX, int insetY) {
        double scaley;
        double scalex = (double)component.getWidth() / (double)bi.getWidth();
        double scale = Math.min(scalex, scaley = (double)component.getHeight() / (double)bi.getHeight());
        if (scale <= 1.0) {
            return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
        }
        return bi;
    }

    private void indicateError(String tooltip) {
        this.lblPicture.setIcon(ERROR_ICON);
        this.lblPicture.setText("Fehler beim \u00dcbertragen des Bildes!");
        this.lblPicture.setToolTipText(tooltip);
    }

    private static void showExceptionToUser(Exception ex, JComponent parent) {
        ErrorInfo ei = new ErrorInfo("Fehler", "Beim Vorgang ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)ei);
    }

    public void editorClosed(EditorClosedEvent event) {
        if (EditorSaveListener.EditorSaveStatus.SAVE_SUCCESS == event.getStatus()) {
            for (CidsBean deleteBean : this.removedFotoBeans) {
                String fileName = (String)deleteBean.getProperty("url_object_name");
                StringBuilder fileDir = new StringBuilder();
                fileDir.append(deleteBean.getProperty("url.url_base_id.prot_prefix").toString());
                fileDir.append(deleteBean.getProperty("url.url_base_id.server").toString());
                fileDir.append(deleteBean.getProperty("url.url_base_id.path").toString());
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, fileDir.toString(), this.getConnectionContext());
                    deleteBean.delete();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    WebDavPicturePanel.showExceptionToUser(ex, this);
                }
            }
        } else {
            for (CidsBean deleteBean : this.removeNewAddedFotoBean) {
                String fileName = (String)deleteBean.getProperty("url.object_name");
                StringBuilder fileDir = new StringBuilder();
                fileDir.append(deleteBean.getProperty("url.url_base_id.prot_prefix").toString());
                fileDir.append(deleteBean.getProperty("url.url_base_id.server").toString());
                fileDir.append(deleteBean.getProperty("url.url_base_id.path").toString());
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, fileDir.toString(), this.getConnectionContext());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    WebDavPicturePanel.showExceptionToUser(ex, this);
                }
            }
        }
    }

    public boolean prepareForSave() {
        return true;
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.map.getFeatureCollection().removeAllFeatures();
        this.map.dispose();
        this.cidsBean = null;
    }

    private void initMap() {
        Object geoObj;
        if (this.cidsBean != null && (geoObj = this.cidsBean.getProperty(this.geoFieldProp)) instanceof Geometry) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        Geometry pureGeom = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)geoObj), (String)ClientAlkisConf.getInstance().getSrsService());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("ALKISConstatns.Commons.GeoBUffer: " + ClientAlkisConf.getInstance().getGeoBuffer()));
                        }
                        XBoundingBox box = new XBoundingBox(pureGeom.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                        double diagonalLength = Math.sqrt(box.getWidth() * box.getWidth() + box.getHeight() * box.getHeight());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Buffer for map: " + diagonalLength));
                        }
                        XBoundingBox bufferedBox = new XBoundingBox(box.getGeometry().buffer(diagonalLength));
                        ActiveLayerModel mappingModel = new ActiveLayerModel();
                        mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                        mappingModel.addHome(new XBoundingBox(bufferedBox.getX1(), bufferedBox.getY1(), bufferedBox.getX2(), bufferedBox.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
                        SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                        swms.setName("Treppe");
                        DefaultStyledFeature dsf = new DefaultStyledFeature();
                        dsf.setGeometry(pureGeom);
                        dsf.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.5f));
                        dsf.setLineWidth(3);
                        dsf.setLinePaint((Paint)new Color(1.0f, 0.0f, 0.0f, 1.0f));
                        mappingModel.addLayer((RetrievalServiceLayer)swms);
                        WebDavPicturePanel.this.map.setMappingModel((MappingModel)mappingModel);
                        int duration = WebDavPicturePanel.this.map.getAnimationDuration();
                        WebDavPicturePanel.this.map.setAnimationDuration(0);
                        WebDavPicturePanel.this.map.gotoInitialBoundingBox();
                        WebDavPicturePanel.this.map.setInteractionMode("ZOOM");
                        WebDavPicturePanel.this.map.unlock();
                        WebDavPicturePanel.this.map.addCustomInputListener("MUTE", new PBasicInputEventHandler(){

                            public void mouseClicked(PInputEvent evt) {
                                if (evt.getClickCount() > 1) {
                                    CidsBean bean = WebDavPicturePanel.this.cidsBean;
                                    ObjectRendererUtils.switchToCismapMap();
                                    ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(bean, false);
                                }
                            }
                        });
                        WebDavPicturePanel.this.map.setInteractionMode("MUTE");
                        WebDavPicturePanel.this.map.getFeatureCollection().addFeature((Feature)dsf);
                        WebDavPicturePanel.this.map.setAnimationDuration(duration);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error while init map", (Throwable)ex);
                    }
                    return null;
                }
            }.execute();
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    final class ImageResizeWorker
    extends SwingWorker<ImageIcon, Void> {
        public ImageResizeWorker() {
            if (WebDavPicturePanel.this.image != null) {
                WebDavPicturePanel.this.lblPicture.setText("Wird neu skaliert...");
                WebDavPicturePanel.this.lstFotos.setEnabled(false);
            }
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            if (WebDavPicturePanel.this.image != null) {
                ImageIcon result = new ImageIcon(WebDavPicturePanel.adjustScale(WebDavPicturePanel.this.image, WebDavPicturePanel.this.pnlFoto, 20, 20));
                return result;
            }
            return null;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                try {
                    WebDavPicturePanel.this.resizeListenerEnabled = false;
                    ImageIcon result = (ImageIcon)this.get();
                    WebDavPicturePanel.this.lblPicture.setIcon(result);
                    WebDavPicturePanel.this.lblPicture.setText("");
                    WebDavPicturePanel.this.lblPicture.setToolTipText(null);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    WebDavPicturePanel.this.lblPicture.setText("Fehler beim Skalieren!");
                }
                finally {
                    WebDavPicturePanel.this.showWait(false);
                    if (WebDavPicturePanel.this.currentResizeWorker == this) {
                        WebDavPicturePanel.this.currentResizeWorker = null;
                    }
                    WebDavPicturePanel.this.resizeListenerEnabled = true;
                }
            }
        }
    }

    final class LoadSelectedImageWorker
    extends SwingWorker<BufferedImage, Void> {
        private final String file;

        public LoadSelectedImageWorker(String toLoad) {
            this.file = toLoad;
            WebDavPicturePanel.this.lblPicture.setText("");
            WebDavPicturePanel.this.lblPicture.setToolTipText(null);
            WebDavPicturePanel.this.showWait(true);
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            if (this.file != null && this.file.length() > 0) {
                return WebDavPicturePanel.this.downloadImageFromWebDAV(this.file);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                WebDavPicturePanel.this.image = (BufferedImage)this.get();
                if (WebDavPicturePanel.this.image != null) {
                    IMAGE_CACHE.put(this.file, new SoftReference<BufferedImage>(WebDavPicturePanel.this.image));
                    WebDavPicturePanel.this.resizeListenerEnabled = true;
                    WebDavPicturePanel.this.timer.restart();
                } else {
                    WebDavPicturePanel.this.indicateError("Bild konnte nicht geladen werden: Unbekanntes Bildformat");
                }
            }
            catch (InterruptedException ex) {
                WebDavPicturePanel.this.image = null;
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                WebDavPicturePanel.this.image = null;
                LOG.error((Object)ex, (Throwable)ex);
                String causeMessage = "";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                }
                WebDavPicturePanel.this.indicateError(causeMessage);
            }
            finally {
                if (WebDavPicturePanel.this.image == null) {
                    WebDavPicturePanel.this.showWait(false);
                }
            }
        }
    }

    final class ImageUploadWorker
    extends SwingWorker<Collection<CidsBean>, Void> {
        private final Collection<File> fotos;

        public ImageUploadWorker(Collection<File> fotos) {
            this.fotos = fotos;
            WebDavPicturePanel.this.lblPicture.setText("");
            WebDavPicturePanel.this.lblPicture.setToolTipText(null);
            WebDavPicturePanel.this.showWait(true);
        }

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            ArrayList<CidsBean> newBeans = new ArrayList<CidsBean>();
            int laufendeNummer = WebDavPicturePanel.this.lstFotos.getModel().getSize() + 1;
            for (File imageFile : this.fotos) {
                CidsBean urlBase;
                Object number = WebDavPicturePanel.this.cidsBean.getProperty(WebDavPicturePanel.this.numberProp);
                String fileName = (number == null ? "____" : new DecimalFormat("#0000").format(Integer.parseInt(number.toString()))) + "-" + laufendeNummer + "_" + imageFile.getName();
                WebDavPicturePanel.this.webdavHelper.uploadFileToWebDAV(fileName, imageFile, WebDavPicturePanel.this.webdavDirectory, (Component)WebDavPicturePanel.this, WebDavPicturePanel.this.getConnectionContext());
                MetaClass MB_MC = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"url_base", (ConnectionContext)WebDavPicturePanel.this.getConnectionContext());
                String protPrefix = WebDavPicturePanel.this.webdavDirectory.substring(0, WebDavPicturePanel.this.webdavDirectory.indexOf("://")) + "://";
                String server = WebDavPicturePanel.this.webdavDirectory.substring(protPrefix.length(), WebDavPicturePanel.this.webdavDirectory.indexOf("/", protPrefix.length()));
                String path = WebDavPicturePanel.this.webdavDirectory.substring(protPrefix.length() + server.length());
                String query = String.format("SELECT %s, %s FROM %s WHERE prot_prefix ILIKE '%s' AND server ILIKE '%s' AND path ILIKE '%s';", MB_MC.getID(), MB_MC.getPrimaryKey(), MB_MC.getTableName(), protPrefix, server, path);
                MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
                if (metaObjects.length <= 0) {
                    CidsBean urlBaseTmp = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"url_base", (ConnectionContext)WebDavPicturePanel.this.getConnectionContext());
                    urlBaseTmp.setProperty("prot_prefix", (Object)protPrefix);
                    urlBaseTmp.setProperty("server", (Object)server);
                    urlBaseTmp.setProperty("path", (Object)path);
                    urlBase = urlBaseTmp.persist(WebDavPicturePanel.this.getConnectionContext());
                } else {
                    urlBase = metaObjects[0].getBean();
                }
                CidsBean url = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"url", (ConnectionContext)WebDavPicturePanel.this.getConnectionContext());
                url.setProperty("url_base_id", (Object)urlBase);
                url.setProperty("object_name", (Object)fileName);
                CidsBean newFotoBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)WebDavPicturePanel.this.bildClassName, (ConnectionContext)WebDavPicturePanel.this.getConnectionContext());
                newFotoBean.setProperty("laufende_nummer", (Object)laufendeNummer);
                newFotoBean.setProperty("name", (Object)imageFile.getName());
                newFotoBean.setProperty("url", (Object)url);
                newBeans.add(newFotoBean);
                ++laufendeNummer;
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    List oldBeans = WebDavPicturePanel.this.cidsBean.getBeanCollectionProperty(WebDavPicturePanel.this.beanCollProp);
                    oldBeans.addAll(newBeans);
                    WebDavPicturePanel.this.removeNewAddedFotoBean.addAll(newBeans);
                    WebDavPicturePanel.this.lstFotos.setSelectedValue(newBeans.iterator().next(), true);
                } else {
                    WebDavPicturePanel.this.lblPicture.setIcon(FOLDER_ICON);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            finally {
                WebDavPicturePanel.this.showWait(false);
            }
        }
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == WebDavPicturePanel.this.btnAddImg) {
                WebDavPicturePanel.this.btnAddImgActionPerformed(evt);
            } else if (evt.getSource() == WebDavPicturePanel.this.btnRemoveImg) {
                WebDavPicturePanel.this.btnRemoveImgActionPerformed(evt);
            } else if (evt.getSource() == WebDavPicturePanel.this.btnPrevImg) {
                WebDavPicturePanel.this.btnPrevImgActionPerformed(evt);
            } else if (evt.getSource() == WebDavPicturePanel.this.btnNextImg) {
                WebDavPicturePanel.this.btnNextImgActionPerformed(evt);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == WebDavPicturePanel.this.lstFotos) {
                WebDavPicturePanel.this.lstFotosValueChanged(evt);
            }
        }
    }
}

