/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdesktop.beansbinding.Converter;

public class SQLDateToStringConverter
extends Converter<java.sql.Date, String> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private final DateFormat dateFormat;

    public SQLDateToStringConverter() {
        this(DATE_FORMAT);
    }

    public SQLDateToStringConverter(String simpleDateFormatString) {
        this(new SimpleDateFormat(simpleDateFormatString));
    }

    public SQLDateToStringConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String convertForward(java.sql.Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMAT.format(date);
    }

    public java.sql.Date convertReverse(String dateString) {
        Date uDate;
        try {
            uDate = DATE_FORMAT.parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
        java.sql.Date sDate = new java.sql.Date(uDate.getTime());
        return sDate;
    }
}

