/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CidsBeanSupport {
    private static final Logger LOG = Logger.getLogger(CidsBeanSupport.class);
    public static final String DOMAIN_NAME = "WUNDA_BLAU";
    public static final String TABLE__GEOM = "Geom";

    private CidsBeanSupport() {
        throw new AssertionError();
    }

    public static CidsBean createNewCidsBeanFromTableName(String tableName, Map<String, Object> initialProperties, ConnectionContext connectionContext) throws Exception {
        CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName(tableName, connectionContext);
        for (Map.Entry<String, Object> property : initialProperties.entrySet()) {
            newBean.setProperty(property.getKey(), property.getValue());
        }
        return newBean;
    }

    public static CidsBean createNewCidsBeanFromTableName(String tableName, ConnectionContext connectionContext) throws Exception {
        MetaClass metaClass;
        if (tableName != null && (metaClass = ClassCacheMultiple.getMetaClass((String)DOMAIN_NAME, (String)tableName, (ConnectionContext)connectionContext)) != null) {
            return metaClass.getEmptyInstance(connectionContext).getBean();
        }
        throw new Exception("Could not find MetaClass for table " + tableName);
    }

    public static CidsBean cloneBean(CidsBean bean, ConnectionContext conCon) {
        if (bean == null) {
            return null;
        }
        return CidsBeanSupport.cloneBean(bean, conCon, bean.getMetaObject().getMetaClass().getTableName());
    }

    public static CidsBean cloneBean(CidsBean bean, ConnectionContext conCon, String table) {
        try {
            CidsBean beanClone = CidsBean.createNewCidsBeanFromTableName((String)DOMAIN_NAME, (String)table, (ConnectionContext)conCon);
            for (String propertyName : beanClone.getPropertyNames()) {
                Object obj;
                if (propertyName.toLowerCase().equals("id") || (obj = bean.getProperty(propertyName)) == null || beanClone.getMetaObject().getAttributeByFieldName(propertyName).getMai().getForeignKeyClassId() < 0) continue;
                if (obj instanceof CidsBean) {
                    if (obj.getClass().getSimpleName().equals(TABLE__GEOM)) {
                        CidsBean beanGeom = CidsBeanSupport.cloneBean((CidsBean)obj, conCon, TABLE__GEOM);
                        beanClone.setProperty(propertyName, (Object)beanGeom);
                        continue;
                    }
                    beanClone.setProperty(propertyName, (Object)((CidsBean)obj));
                    continue;
                }
                if (obj instanceof Geometry) {
                    beanClone.setProperty(propertyName, ((Geometry)obj).clone());
                    continue;
                }
                if (obj instanceof Integer) {
                    beanClone.setProperty(propertyName, (Object)new Integer(obj.toString()));
                    continue;
                }
                if (obj instanceof Long) {
                    beanClone.setProperty(propertyName, (Object)new Long(obj.toString()));
                    continue;
                }
                if (obj instanceof Double) {
                    beanClone.setProperty(propertyName, (Object)new Double(obj.toString()));
                    continue;
                }
                if (obj instanceof Boolean) {
                    beanClone.setProperty(propertyName, (Object)Boolean.valueOf(obj.toString()));
                    continue;
                }
                if (obj instanceof String) {
                    beanClone.setProperty(propertyName, (Object)obj.toString());
                    continue;
                }
                if (obj instanceof Collection) {
                    List listArray = (List)obj;
                    List listArrayClone = (List)beanClone.getProperty(propertyName);
                    for (CidsBean beanListClone : listArray) {
                        listArrayClone.add(beanListClone);
                    }
                    continue;
                }
                LOG.error((Object)("unknown property type: " + obj.getClass().getName()));
            }
            return beanClone;
        }
        catch (Exception ex) {
            LOG.error((Object)"Cannot clone object", (Throwable)ex);
            return null;
        }
    }

    public static List<CidsBean> getBeanCollectionFromProperty(CidsBean bean, String collectionProperty) {
        Object colObj;
        if (bean != null && collectionProperty != null && (colObj = bean.getProperty(collectionProperty)) instanceof Collection) {
            return (List)colObj;
        }
        return null;
    }

    public static boolean checkWritePermission(CidsBean bean) {
        User user = SessionManager.getSession().getUser();
        return bean.getHasWritePermission(user) && bean.hasObjectWritePermission(user);
    }
}

