/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.cids.dynamics.CidsBean;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class KompensationskatasterBeanTable
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(KompensationskatasterBeanTable.class);
    private final CidsBean bean;
    private final String collectionPropertyName;
    private final String[] names;
    private final String[] attributes;
    private final Class[] types;
    private final boolean editable;

    public KompensationskatasterBeanTable(boolean editable, CidsBean bean, String collectionPropertyName, String[] names, String[] attributes, Class[] types) {
        this.bean = bean;
        this.collectionPropertyName = collectionPropertyName;
        this.names = names;
        this.attributes = attributes;
        this.types = types;
        this.editable = editable;
    }

    private List<CidsBean> getBeanList() {
        Object colObj;
        if (this.bean != null && this.collectionPropertyName != null && (colObj = this.bean.getProperty(this.collectionPropertyName)) instanceof Collection) {
            return (List)colObj;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        List<CidsBean> beanList = this.getBeanList();
        return beanList == null ? 0 : beanList.size();
    }

    public void addBean(CidsBean bean) {
        List<CidsBean> beanList = this.getBeanList();
        if (beanList != null && bean != null) {
            beanList.add(bean);
            this.fireTableDataChanged();
        }
    }

    public void removeRow(int rowToRemove) {
        List<CidsBean> beanList = this.getBeanList();
        if (beanList != null) {
            beanList.remove(rowToRemove);
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.attributes.length == 0) {
            return this.getBeanList().get(rowIndex);
        }
        return this.getBeanList().get(rowIndex).getProperty(this.attributes[columnIndex]);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            if (this.attributes.length == 0 && aValue instanceof CidsBean) {
                this.getBeanList().remove(rowIndex);
                this.getBeanList().add(rowIndex, (CidsBean)aValue);
            } else {
                this.getBeanList().get(rowIndex).setProperty(this.attributes[columnIndex], aValue);
            }
            this.bean.setProperty(this.collectionPropertyName, this.getBeanList());
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot set property " + this.attributes[columnIndex] + " new value: " + String.valueOf(aValue)), (Throwable)ex);
        }
    }
}

