/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.aedsicad.aaaweb.rest.model.Buchungsblatt;
import de.cismet.cids.custom.wunda_blau.search.server.AdresseGebaeudeLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXBusyLabel;

public class AlkisAdresseRenderer
extends JPanel
implements CidsBeanRenderer,
BorderProvider,
TitleComponentProvider,
FooterComponentProvider,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisAdresseRenderer.class);
    private Buchungsblatt buchungsblatt;
    private CidsBean cidsBean;
    private String title;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JXBusyLabel blWait;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel9;
    private JLabel lblBauweise;
    private JLabel lblDescBauweise;
    private JLabel lblDescFlurstuecke;
    private JLabel lblDescFunktion;
    private JLabel lblDescHausnummer;
    private JLabel lblDescLage;
    private JLabel lblDescStockwerkeOber;
    private JLabel lblDescStockwerkeUnter;
    private JLabel lblDescStrasse;
    private JLabel lblFunktion;
    private JLabel lblHausnummer;
    private JLabel lblLage;
    private JLabel lblStockwerkeOber;
    private JLabel lblStockwerkeUnter;
    private JLabel lblStrasse;
    private JLabel lblTitle;
    private JList lstLandparcels;
    private JPanel panAdresse;
    private JPanel panAdresseContent;
    private JPanel panFooter;
    private JPanel panGebaeude;
    private JPanel panGebaeudeContent;
    private JPanel panTitle;
    private JScrollPane scpLandparcels;
    private SemiRoundedPanel srpHeadAdresse;
    private SemiRoundedPanel srpHeadGebaeude;
    private BindingGroup bindingGroup;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.blWait.setVisible(false);
    }

    private MetaObject[] getAllAdressesForSameBuilding(CidsBean gebaeudeBean) {
        Object idObj;
        if (gebaeudeBean != null && (idObj = gebaeudeBean.getProperty("id")) instanceof Integer) {
            Integer gebaeudeId = (Integer)idObj;
            try {
                AdresseGebaeudeLightweightSearch search = new AdresseGebaeudeLightweightSearch();
                search.setRepresentationFields(new String[]{"id", "strasse", "nummer"});
                search.setGebaudeId(gebaeudeId);
                Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, this.getConnectionContext());
                for (LightweightMetaObject lwmo : lwmos) {
                    lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                        public String getRepresentation() {
                            StringBuilder result = new StringBuilder();
                            result.append(this.getAttribute("strasse")).append(" ").append(this.getAttribute("nummer"));
                            return result.toString();
                        }
                    });
                }
                return lwmos.toArray(new MetaObject[0]);
            }
            catch (ConnectionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return null;
            }
        }
        return new MetaObject[0];
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.blWait = new JXBusyLabel();
        this.panFooter = new JPanel();
        this.jPanel9 = new JPanel();
        this.panAdresse = new RoundedPanel();
        this.srpHeadAdresse = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.panAdresseContent = new RoundedPanel();
        this.lblDescStrasse = new JLabel();
        this.lblDescHausnummer = new JLabel();
        this.lblStrasse = new JLabel();
        this.lblHausnummer = new JLabel();
        this.panGebaeude = new RoundedPanel();
        this.srpHeadGebaeude = new SemiRoundedPanel();
        this.jLabel2 = new JLabel();
        this.panGebaeudeContent = new JPanel();
        this.lblDescFunktion = new JLabel();
        this.lblDescStockwerkeOber = new JLabel();
        this.lblFunktion = new JLabel();
        this.lblStockwerkeOber = new JLabel();
        this.lblDescBauweise = new JLabel();
        this.lblBauweise = new JLabel();
        this.lblDescStockwerkeUnter = new JLabel();
        this.lblStockwerkeUnter = new JLabel();
        this.scpLandparcels = new JScrollPane();
        this.lstLandparcels = new JList();
        this.lblDescFlurstuecke = new JLabel();
        this.lblDescLage = new JLabel();
        this.lblLage = new JLabel();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText("TITLE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.panTitle.add((Component)this.blWait, gridBagConstraints);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.jPanel9.setMaximumSize(new Dimension(40, 40));
        this.jPanel9.setMinimumSize(new Dimension(40, 40));
        this.jPanel9.setOpaque(false);
        this.jPanel9.setPreferredSize(new Dimension(40, 40));
        this.panFooter.add((Component)this.jPanel9, new GridBagConstraints());
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panAdresse.setOpaque(false);
        this.panAdresse.setLayout(new BorderLayout());
        this.srpHeadAdresse.setBackground(Color.darkGray);
        this.srpHeadAdresse.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Adresse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeadAdresse.add((Component)this.jLabel1, (Object)gridBagConstraints);
        this.panAdresse.add((Component)this.srpHeadAdresse, "North");
        this.panAdresseContent.setOpaque(false);
        this.panAdresseContent.setLayout(new GridBagLayout());
        this.lblDescStrasse.setFont(new Font("Tahoma", 1, 11));
        this.lblDescStrasse.setText("Stra\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panAdresseContent.add((Component)this.lblDescStrasse, gridBagConstraints);
        this.lblDescHausnummer.setFont(new Font("Tahoma", 1, 11));
        this.lblDescHausnummer.setText("Hausnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panAdresseContent.add((Component)this.lblDescHausnummer, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.strasse}"), (Object)this.lblStrasse, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAdresseContent.add((Component)this.lblStrasse, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.nummer}"), (Object)this.lblHausnummer, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panAdresseContent.add((Component)this.lblHausnummer, gridBagConstraints);
        this.panAdresse.add((Component)this.panAdresseContent, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panAdresse, gridBagConstraints);
        this.panGebaeude.setOpaque(false);
        this.panGebaeude.setLayout(new BorderLayout());
        this.srpHeadGebaeude.setBackground(Color.darkGray);
        this.srpHeadGebaeude.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("Geb\u00e4ude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeadGebaeude.add((Component)this.jLabel2, (Object)gridBagConstraints);
        this.panGebaeude.add((Component)this.srpHeadGebaeude, "North");
        this.panGebaeudeContent.setOpaque(false);
        this.panGebaeudeContent.setLayout(new GridBagLayout());
        this.lblDescFunktion.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFunktion.setText("Funktion:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescFunktion, gridBagConstraints);
        this.lblDescStockwerkeOber.setFont(new Font("Tahoma", 1, 11));
        this.lblDescStockwerkeOber.setText("Oberirdische Geschosse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescStockwerkeOber, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gebaeude.funktion}"), (Object)this.lblFunktion, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblFunktion, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gebaeude.geschosse_oberirdisch}"), (Object)this.lblStockwerkeOber, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblStockwerkeOber, gridBagConstraints);
        this.lblDescBauweise.setFont(new Font("Tahoma", 1, 11));
        this.lblDescBauweise.setText("Bauweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescBauweise, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gebaeude.bauweise}"), (Object)this.lblBauweise, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblBauweise, gridBagConstraints);
        this.lblDescStockwerkeUnter.setFont(new Font("Tahoma", 1, 11));
        this.lblDescStockwerkeUnter.setText("Unterirdische Geschosse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescStockwerkeUnter, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gebaeude.geschosse_unterirdisch}"), (Object)this.lblStockwerkeUnter, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblStockwerkeUnter, gridBagConstraints);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.gebaeude.landparcels}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JList)this.lstLandparcels);
        jListBinding.setSourceNullValue(null);
        jListBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstLandparcels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisAdresseRenderer.this.lstLandparcelsMouseClicked(evt);
            }
        });
        this.scpLandparcels.setViewportView(this.lstLandparcels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.scpLandparcels, gridBagConstraints);
        this.lblDescFlurstuecke.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFlurstuecke.setText("Das Geb\u00e4ude ist auf folgendem Flurst\u00fcck errichtet:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescFlurstuecke, gridBagConstraints);
        this.lblDescLage.setFont(new Font("Tahoma", 1, 11));
        this.lblDescLage.setText("Lage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescLage, gridBagConstraints);
        this.lblLage.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblLage, gridBagConstraints);
        this.panGebaeude.add((Component)this.panGebaeudeContent, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panGebaeude, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void lstLandparcelsMouseClicked(MouseEvent evt) {
        CidsBean selBean;
        Object jumpID;
        Object selection;
        if (evt.getClickCount() > 1 && (selection = this.lstLandparcels.getSelectedValue()) instanceof CidsBean && (jumpID = (selBean = (CidsBean)selection).getProperty("fullobjectid")) instanceof Integer) {
            String tabname = "alkis_landparcel";
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"alkis_landparcel", (ConnectionContext)this.getConnectionContext());
            if (mc != null) {
                ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(mc, ((Integer)jumpID).intValue(), "");
            } else {
                LOG.error((Object)"Could not find MetaClass for alkis_landparcel");
            }
        }
    }

    public void setCidsBean(CidsBean cb) {
        this.bindingGroup.unbind();
        if (cb != null) {
            this.cidsBean = cb;
            Object gebaeudeObj = this.cidsBean.getProperty("gebaeude");
            if (gebaeudeObj instanceof CidsBean) {
                this.panGebaeude.setVisible(true);
                this.initLageLabel(this.getAllAdressesForSameBuilding((CidsBean)gebaeudeObj));
            } else {
                this.panGebaeude.setVisible(false);
            }
            this.bindingGroup.bind();
        }
    }

    private void initLageLabel(MetaObject[] sameBuildingAdresses) {
        LinkedHashMap multiMap = TypeSafeCollections.newLinkedHashMap();
        for (MetaObject adressMO : sameBuildingAdresses) {
            if (!(adressMO instanceof LightweightMetaObject)) continue;
            LightweightMetaObject lwmo = (LightweightMetaObject)adressMO;
            Object strasse = lwmo.getLWAttribute("strasse");
            Object nummer = lwmo.getLWAttribute("nummer");
            if (strasse == null) continue;
            List bucket = (List)multiMap.get(strasse.toString());
            if (bucket == null) {
                bucket = TypeSafeCollections.newArrayList();
                multiMap.put(strasse.toString(), bucket);
            }
            if (nummer == null) continue;
            bucket.add(nummer.toString());
        }
        StringBuilder lageTxt = new StringBuilder("<html>");
        int size = multiMap.size();
        for (Map.Entry entry : multiMap.entrySet()) {
            String strasse = (String)entry.getKey();
            List nummern = (List)entry.getValue();
            lageTxt.append(strasse);
            if (nummern.size() > 0) {
                lageTxt.append(" ");
                for (int i = 0; i < nummern.size(); ++i) {
                    lageTxt.append((String)nummern.get(i));
                    if (i >= nummern.size() - 1) continue;
                    lageTxt.append(", ");
                }
            }
            if (--size <= 0) continue;
            lageTxt.append("<br>");
        }
        lageTxt.append("</html>");
        this.lblLage.setText(lageTxt.toString());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        title = title == null ? "<Error>" : "Adresse " + title;
        this.title = title;
        this.lblTitle.setText(this.title);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Object getBuchungsblatt() {
        return this.buchungsblatt;
    }

    public void setBuchungsblatt(Buchungsblatt buchungsblatt) {
        this.buchungsblatt = buchungsblatt;
    }

    private void setWaiting(boolean waiting) {
        this.blWait.setVisible(waiting);
        this.blWait.setBusy(waiting);
    }

    private boolean isWaiting() {
        return this.blWait.isBusy();
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

