/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wunda_blau.search.server.AdresseGebaeudeLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.collections.TypeSafeCollections;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class AlkisGebaeudeRendererPanel
extends JPanel
implements DisposableCidsBeanStore,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(AlkisGebaeudeRendererPanel.class);
    private CidsBean cidsBean;
    private final ConnectionContext connectionContext;
    private JLabel lblBauweise;
    private JLabel lblDescBauweise;
    private JLabel lblDescFlurstuecke;
    private JLabel lblDescFunktion;
    private JLabel lblDescLage;
    private JLabel lblDescStockwerkeOber;
    private JLabel lblDescStockwerkeUnter;
    private JLabel lblFunktion;
    private JLabel lblLage;
    private JLabel lblStockwerkeOber;
    private JLabel lblStockwerkeUnter;
    private JList lstLandparcels;
    private JPanel panGebaeudeContent;
    private JScrollPane scpLandparcels;
    private BindingGroup bindingGroup;

    public AlkisGebaeudeRendererPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panGebaeudeContent = new JPanel();
        this.lblDescFunktion = new JLabel();
        this.lblDescStockwerkeOber = new JLabel();
        this.lblFunktion = new JLabel();
        this.lblStockwerkeOber = new JLabel();
        this.lblDescBauweise = new JLabel();
        this.lblBauweise = new JLabel();
        this.lblDescStockwerkeUnter = new JLabel();
        this.lblStockwerkeUnter = new JLabel();
        this.scpLandparcels = new JScrollPane();
        this.lstLandparcels = new JList();
        this.lblDescFlurstuecke = new JLabel();
        this.lblDescLage = new JLabel();
        this.lblLage = new JLabel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panGebaeudeContent.setOpaque(false);
        this.panGebaeudeContent.setLayout(new GridBagLayout());
        this.lblDescFunktion.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFunktion.setText("Funktion:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescFunktion, gridBagConstraints);
        this.lblDescStockwerkeOber.setFont(new Font("Tahoma", 1, 11));
        this.lblDescStockwerkeOber.setText("Oberirdische Geschosse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescStockwerkeOber, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.funktion}"), (Object)this.lblFunktion, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblFunktion, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geschosse_oberirdisch}"), (Object)this.lblStockwerkeOber, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblStockwerkeOber, gridBagConstraints);
        this.lblDescBauweise.setFont(new Font("Tahoma", 1, 11));
        this.lblDescBauweise.setText("Bauweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescBauweise, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bauweise}"), (Object)this.lblBauweise, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblBauweise, gridBagConstraints);
        this.lblDescStockwerkeUnter.setFont(new Font("Tahoma", 1, 11));
        this.lblDescStockwerkeUnter.setText("Unterirdische Geschosse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescStockwerkeUnter, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geschosse_unterirdisch}"), (Object)this.lblStockwerkeUnter, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblStockwerkeUnter, gridBagConstraints);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.landparcels}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JList)this.lstLandparcels);
        jListBinding.setSourceNullValue(null);
        jListBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstLandparcels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisGebaeudeRendererPanel.this.lstLandparcelsMouseClicked(evt);
            }
        });
        this.scpLandparcels.setViewportView(this.lstLandparcels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.scpLandparcels, gridBagConstraints);
        this.lblDescFlurstuecke.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFlurstuecke.setText("Das Geb\u00e4ude ist auf folgendem Flurst\u00fcck errichtet:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescFlurstuecke, gridBagConstraints);
        this.lblDescLage.setFont(new Font("Tahoma", 1, 11));
        this.lblDescLage.setText("Lage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblDescLage, gridBagConstraints);
        this.lblLage.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panGebaeudeContent.add((Component)this.lblLage, gridBagConstraints);
        this.add((Component)this.panGebaeudeContent, "Center");
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        this.bindingGroup.unbind();
        if (cb != null) {
            this.cidsBean = cb;
            this.initLageLabel(this.getAllAdressesForSameBuilding());
            this.bindingGroup.bind();
        }
    }

    private void initLageLabel(MetaObject[] sameBuildingAdresses) {
        LinkedHashMap multiMap = TypeSafeCollections.newLinkedHashMap();
        for (MetaObject adressMO : sameBuildingAdresses) {
            if (!(adressMO instanceof LightweightMetaObject)) continue;
            LightweightMetaObject lwmo = (LightweightMetaObject)adressMO;
            Object strasse = lwmo.getLWAttribute("strasse");
            Object nummer = lwmo.getLWAttribute("nummer");
            if (strasse == null) continue;
            List bucket = (List)multiMap.get(strasse.toString());
            if (bucket == null) {
                bucket = TypeSafeCollections.newArrayList();
                multiMap.put(strasse.toString(), bucket);
            }
            if (nummer == null) continue;
            bucket.add(nummer.toString());
        }
        StringBuilder lageTxt = new StringBuilder("<html>");
        int size = multiMap.size();
        for (Map.Entry entry : multiMap.entrySet()) {
            String strasse = (String)entry.getKey();
            List nummern = (List)entry.getValue();
            lageTxt.append(strasse);
            if (nummern.size() > 0) {
                lageTxt.append(" ");
                for (int i = 0; i < nummern.size(); ++i) {
                    lageTxt.append((String)nummern.get(i));
                    if (i >= nummern.size() - 1) continue;
                    lageTxt.append(", ");
                }
            }
            if (--size <= 0) continue;
            lageTxt.append("<br>");
        }
        lageTxt.append("</html>");
        this.lblLage.setText(lageTxt.toString());
    }

    private MetaObject[] getAllAdressesForSameBuilding() {
        Object idObj;
        if (this.cidsBean != null && (idObj = this.cidsBean.getProperty("id")) instanceof Integer) {
            Integer gebaeudeId = (Integer)idObj;
            try {
                AdresseGebaeudeLightweightSearch search = new AdresseGebaeudeLightweightSearch();
                search.setRepresentationFields(new String[]{"id", "strasse", "nummer"});
                search.setGebaudeId(gebaeudeId);
                Collection lwmos = SessionManager.getProxy().customServerSearch((CidsServerSearch)search, this.getConnectionContext());
                for (LightweightMetaObject lwmo : lwmos) {
                    lwmo.setFormater(new AbstractAttributeRepresentationFormater(){

                        public String getRepresentation() {
                            StringBuilder result = new StringBuilder();
                            result.append(this.getAttribute("strasse")).append(" ").append(this.getAttribute("nummer"));
                            return result.toString();
                        }
                    });
                }
                return lwmos.toArray(new MetaObject[0]);
            }
            catch (ConnectionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return null;
            }
        }
        return new MetaObject[0];
    }

    private void lstLandparcelsMouseClicked(MouseEvent evt) {
        CidsBean selBean;
        Object jumpID;
        Object selection;
        if (evt.getClickCount() > 1 && (selection = this.lstLandparcels.getSelectedValue()) instanceof CidsBean && (jumpID = (selBean = (CidsBean)selection).getProperty("fullobjectid")) instanceof Integer) {
            String tabname = "alkis_landparcel";
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"alkis_landparcel", (ConnectionContext)this.getConnectionContext());
            if (mc != null) {
                ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(mc, ((Integer)jumpID).intValue(), "");
            } else {
                LOG.error((Object)"Could not find MetaClass for alkis_landparcel");
            }
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

