/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import com.vividsolutions.jts.geom.Geometry;
import de.aedsicad.aaaweb.rest.model.LandParcel;
import de.cismet.cids.custom.clientutils.BaulastBescheinigungDialog;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.AlkisEigentuemerPanel;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.DownloadInfoFactory;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisKarteDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.graphics.ReflectionRenderer;
import org.openide.util.NbBundle;

public class AlkisLandparcelRenderer
extends JPanel
implements BorderProvider,
CidsBeanRenderer,
TitleComponentProvider,
FooterComponentProvider,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final String ICON_RES_PACKAGE = "/de/cismet/cids/custom/wunda_blau/res/";
    private static final String ALKIS_RES_PACKAGE = "/de/cismet/cids/custom/wunda_blau/res/alkis/";
    private static final Logger LOG = Logger.getLogger(AlkisLandparcelRenderer.class);
    private static final String CARD_1 = "CARD_1";
    private static final String CARD_2 = "CARD_2";
    private static final String PRODUCT_ACTION_TAG_KARTE = "custom.alkis.product.karte@WUNDA_BLAU";
    private static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_ENABLED = "baulast.report.bescheinigung_enabled@WUNDA_BLAU";
    private static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_DISABLED = "baulast.report.bescheinigung_disabled@WUNDA_BLAU";
    private boolean eigentuemerPermission;
    private final boolean demoMode = StaticDebuggingTools.checkHomeForFile((String)"demoMode");
    private ImageIcon BUCH_PDF;
    private ImageIcon BUCH_HTML;
    private ImageIcon BUCH_EIG_NRW_PDF;
    private ImageIcon BUCH_EIG_NRW_HTML;
    private ImageIcon BUCH_EIG_KOM_PDF;
    private ImageIcon BLA_BESCH_PDF;
    private ImageIcon BUCH_EIG_KOM_HTML;
    private ImageIcon KARTE_PDF;
    private final Map<Object, ImageIcon> productPreviewImages;
    private CardLayout cardLayout;
    private MappingComponent map;
    private LandParcel landparcel;
    private CidsBean cidsBean;
    private String title;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JXBusyLabel blWait;
    private JButton btnBack;
    private JButton btnForward;
    private AlkisEigentuemerPanel eigentuemerPanel;
    private JEditorPane epLage;
    private JXHyperlink hlBaulastbescheinigung;
    private JXHyperlink hlFlurstuecksEigentumsnachweisKomHtml;
    private JXHyperlink hlFlurstuecksEigentumsnachweisKomInternHtml;
    private JXHyperlink hlFlurstuecksEigentumsnachweisKomInternPdf;
    private JXHyperlink hlFlurstuecksEigentumsnachweisKomPdf;
    private JXHyperlink hlFlurstuecksEigentumsnachweisNrwHtml;
    private JXHyperlink hlFlurstuecksEigentumsnachweisNrwPdf;
    private JXHyperlink hlFlurstuecksnachweisHtml;
    private JXHyperlink hlFlurstuecksnachweisPdf;
    private JXHyperlink hlKarte;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblBack;
    private JLabel lblDescGemarkung;
    private JLabel lblDescGemeinde;
    private JLabel lblDescGroesse;
    private JLabel lblDescLage;
    private JLabel lblDescLandparcelCode;
    private JLabel lblForw;
    private JLabel lblGemarkung;
    private JLabel lblGemeinde;
    private JLabel lblGroesse;
    private JLabel lblLandparcelCode;
    private JLabel lblPreviewHead;
    private JLabel lblProductPreview;
    private JLabel lblTitle;
    private JPanel panBuchungEigentum;
    private JPanel panButtons;
    private JPanel panDescription;
    private JPanel panFlurstueckMap;
    private JPanel panFooter;
    private JPanel panFooterLeft;
    private JPanel panFooterRight;
    private JPanel panHtmlProducts;
    private JPanel panMainInfo;
    private JPanel panPdfProducts;
    private JPanel panProductPreview;
    private JPanel panProducts;
    private JPanel panSpacing;
    private JPanel panTitle;
    private JScrollPane scpLage;
    private SemiRoundedPanel semiRoundedPanel1;
    private SemiRoundedPanel semiRoundedPanel2;
    private SemiRoundedPanel semiRoundedPanel3;
    private SemiRoundedPanel semiRoundedPanel4;
    private SemiRoundedPanel semiRoundedPanel5;
    private BindingGroup bindingGroup;

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Object getLandparcel() {
        return this.landparcel;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public void dispose() {
        this.bindingGroup.unbind();
        if (!this.eigentuemerPanel.isContinueInBackground()) {
            this.eigentuemerPanel.cancelWorker();
            this.setWaiting(false);
        }
        this.map.dispose();
    }

    public AlkisLandparcelRenderer() {
        this.productPreviewImages = TypeSafeCollections.newHashMap();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.eigentuemerPermission = AlkisProductDownloadHelper.validateUserHasEigentuemerAccess(this.getConnectionContext());
        this.initIcons();
        this.initComponents();
        this.eigentuemerPanel.initWithConnectionContext(connectionContext);
        this.initFooterElements();
        this.initProductPreview();
        this.scpLage.getViewport().setOpaque(false);
        this.blWait.setVisible(false);
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof CardLayout) {
            this.cardLayout = (CardLayout)layoutManager;
            this.cardLayout.show(this, CARD_1);
        } else {
            this.cardLayout = new CardLayout();
            LOG.error((Object)("Alkis_landparcelRenderer exspects CardLayout as major layout manager, but has " + this.getLayout() + "!"));
        }
        this.epLage.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    Object adresse = null;
                    if (adresse != null) {
                        AlkisLandparcelRenderer.this.eigentuemerPanel.setContinueInBackground(true);
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObject(adresse.getMetaObject(), "");
                    } else {
                        LOG.warn((Object)"Could not find adress bean in gotoMap");
                    }
                }
            }
        });
        this.map = new MappingComponent();
        this.panFlurstueckMap.add((Component)this.map, "Center");
        this.initEditorPanes();
        if (!AlkisProductDownloadHelper.validateUserHasAlkisProductAccess(this.getConnectionContext())) {
            this.btnForward.setEnabled(false);
            this.lblForw.setEnabled(false);
        }
        if (!this.eigentuemerPermission) {
            this.panBuchungEigentum.setVisible(false);
        }
        this.panHtmlProducts.setVisible(AlkisProductDownloadHelper.validateUserHasAlkisHTMLProductAccess(this.getConnectionContext()));
        boolean billingAllowedFsueKom = BillingPopup.isBillingAllowed("fsuekom", this.getConnectionContext());
        boolean billingAllowedFsueNw = BillingPopup.isBillingAllowed("fsuenw", this.getConnectionContext());
        boolean billingAllowedFsNw = BillingPopup.isBillingAllowed("fsnw", this.getConnectionContext());
        boolean billingAllowedBlabBe = BillingPopup.isBillingAllowed("blab_be", this.getConnectionContext());
        this.hlKarte.setEnabled(ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_KARTE, this.getConnectionContext()));
        this.hlFlurstuecksnachweisPdf.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_PDF)), this.getConnectionContext()) && billingAllowedFsNw);
        this.hlFlurstuecksnachweisHtml.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_HTML)), this.getConnectionContext()));
        this.hlFlurstuecksEigentumsnachweisKomPdf.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF)), this.getConnectionContext()) && billingAllowedFsueKom);
        this.hlFlurstuecksEigentumsnachweisKomHtml.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML)), this.getConnectionContext()));
        this.hlFlurstuecksEigentumsnachweisKomInternPdf.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF)), this.getConnectionContext()));
        this.hlFlurstuecksEigentumsnachweisKomInternHtml.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML)), this.getConnectionContext()));
        this.hlFlurstuecksEigentumsnachweisNrwPdf.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF)), this.getConnectionContext()) && billingAllowedFsueNw);
        this.hlFlurstuecksEigentumsnachweisNrwHtml.setEnabled(ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML)), this.getConnectionContext()));
        this.hlBaulastbescheinigung.setEnabled(ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_ENABLED, this.getConnectionContext()) && !ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_DISABLED, this.getConnectionContext()) && billingAllowedBlabBe);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initIcons() {
        ReflectionRenderer reflectionRenderer = new ReflectionRenderer(0.5f, 0.15f, false);
        BufferedImage i1 = null;
        BufferedImage i2 = null;
        BufferedImage i3 = null;
        BufferedImage i4 = null;
        BufferedImage i5 = null;
        BufferedImage i6 = null;
        BufferedImage i7 = null;
        BufferedImage i8 = null;
        try {
            i1 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/buchnachweispdf.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i2 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/buchnachweishtml.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i3 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/bucheignachweispdf.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i4 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/bucheignachweishtml.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i5 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/karte.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i6 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/buchnachweispdf.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i7 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/buchnachweishtml.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            i8 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/baulastbescheinigungpdf.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.BUCH_PDF = new ImageIcon(i1);
        this.BUCH_HTML = new ImageIcon(i2);
        this.BUCH_EIG_NRW_PDF = new ImageIcon(i3);
        this.BUCH_EIG_NRW_HTML = new ImageIcon(i4);
        this.KARTE_PDF = new ImageIcon(i5);
        this.BUCH_EIG_KOM_PDF = new ImageIcon(i6);
        this.BUCH_EIG_KOM_HTML = new ImageIcon(i7);
        this.BLA_BESCH_PDF = new ImageIcon(i8);
    }

    private void initProductPreview() {
        this.initProductPreviewImages();
        int maxX = 0;
        int maxY = 0;
        for (ImageIcon ii : this.productPreviewImages.values()) {
            if (ii.getIconWidth() > maxX) {
                maxX = ii.getIconWidth();
            }
            if (ii.getIconHeight() <= maxY) continue;
            maxY = ii.getIconHeight();
        }
        Dimension previewDim = new Dimension(maxX + 20, maxY + 40);
        ObjectRendererUtils.setAllDimensions(this.panProductPreview, previewDim);
    }

    private void initEditorPanes() {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        StyleSheet css2 = ((HTMLEditorKit)this.epLage.getEditorKit()).getStyleSheet();
        css2.addRule(bodyRule);
    }

    private void initProductPreviewImages() {
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisNrwPdf, this.BUCH_EIG_NRW_PDF);
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisKomPdf, this.BUCH_EIG_KOM_PDF);
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisKomInternPdf, this.BUCH_EIG_KOM_PDF);
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisNrwHtml, this.BUCH_EIG_NRW_HTML);
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisKomHtml, this.BUCH_EIG_KOM_HTML);
        this.productPreviewImages.put(this.hlFlurstuecksEigentumsnachweisKomInternHtml, this.BUCH_EIG_KOM_HTML);
        this.productPreviewImages.put(this.hlFlurstuecksnachweisHtml, this.BUCH_HTML);
        this.productPreviewImages.put(this.hlFlurstuecksnachweisPdf, this.BUCH_PDF);
        this.productPreviewImages.put(this.hlKarte, this.KARTE_PDF);
        this.productPreviewImages.put(this.hlBaulastbescheinigung, this.BLA_BESCH_PDF);
        ProductLabelMouseAdaper productListener = new ProductLabelMouseAdaper();
        this.hlFlurstuecksEigentumsnachweisNrwPdf.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksEigentumsnachweisKomPdf.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksEigentumsnachweisNrwHtml.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksEigentumsnachweisKomHtml.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksEigentumsnachweisKomInternPdf.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksEigentumsnachweisKomInternHtml.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksnachweisHtml.addMouseListener((MouseListener)productListener);
        this.hlFlurstuecksnachweisPdf.addMouseListener((MouseListener)productListener);
        this.hlKarte.addMouseListener((MouseListener)productListener);
        this.hlBaulastbescheinigung.addMouseListener((MouseListener)productListener);
    }

    private void setWaiting(boolean waiting) {
        this.blWait.setVisible(waiting);
        this.blWait.setBusy(waiting);
    }

    private void initFooterElements() {
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblForw, this.btnForward, ObjectRendererUtils.FORWARD_SELECTED, ObjectRendererUtils.FORWARD_PRESSED);
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblBack, this.btnBack, ObjectRendererUtils.BACKWARD_SELECTED, ObjectRendererUtils.BACKWARD_PRESSED);
    }

    private void downloadEinzelnachweisProduct(String product, boolean berechtigungspruefung) {
        if (!ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(product), this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        try {
            List<String> parcelCodes = Arrays.asList(AlkisProducts.getLandparcelCodeFromParcelBeanObject((Object)this.cidsBean));
            BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo = DownloadInfoFactory.createBerechtigungspruefungAlkisEinzelnachweisDownloadInfo((String)product, parcelCodes);
            String billingKey = ClientAlkisProducts.getInstance().getBillingKey(product);
            if (billingKey == null || BillingPopup.doBilling(billingKey, "no.yet", (Geometry)null, (BerechtigungspruefungBillingDownloadInfo)(berechtigungspruefung && AlkisProductDownloadHelper.checkBerechtigungspruefung(downloadInfo.getProduktTyp(), this.getConnectionContext()) ? downloadInfo : null), this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                AlkisProductDownloadHelper.downloadEinzelnachweisProduct(downloadInfo, this.getConnectionContext());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void downloadKarteProduct() {
        if (!ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_KARTE, this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        List<String> parcelCodes = Arrays.asList(AlkisProducts.getLandparcelCodeFromParcelBeanObject((Object)this.cidsBean));
        BerechtigungspruefungAlkisKarteDownloadInfo downloadInfo = DownloadInfoFactory.createBerechtigungspruefungAlkisKarteDownloadInfo(parcelCodes);
        AlkisProductDownloadHelper.downloadKarteProduct(downloadInfo, this.getConnectionContext());
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.blWait = new JXBusyLabel();
        this.panFooter = new JPanel();
        this.panButtons = new JPanel();
        this.panFooterLeft = new JPanel();
        this.lblBack = new JLabel();
        this.btnBack = new JButton();
        this.panFooterRight = new JPanel();
        this.btnForward = new JButton();
        this.lblForw = new JLabel();
        this.panDescription = new JPanel();
        this.panBuchungEigentum = new RoundedPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.eigentuemerPanel = new AlkisEigentuemerPanel();
        this.panMainInfo = new RoundedPanel();
        this.lblLandparcelCode = new JLabel();
        this.lblDescLandparcelCode = new JLabel();
        this.lblDescGemeinde = new JLabel();
        this.lblGemeinde = new JLabel();
        this.lblDescGemarkung = new JLabel();
        this.lblGemarkung = new JLabel();
        this.lblDescLage = new JLabel();
        this.lblGroesse = new JLabel();
        this.lblDescGroesse = new JLabel();
        this.scpLage = new JScrollPane();
        this.epLage = new JEditorPane();
        this.semiRoundedPanel2 = new SemiRoundedPanel();
        this.jLabel6 = new JLabel();
        this.panFlurstueckMap = new JPanel();
        this.panProducts = new JPanel();
        this.panPdfProducts = new RoundedPanel();
        this.hlKarte = new JXHyperlink();
        this.hlFlurstuecksEigentumsnachweisNrwPdf = new JXHyperlink();
        this.hlFlurstuecksnachweisPdf = new JXHyperlink();
        this.jPanel1 = new JPanel();
        this.semiRoundedPanel4 = new SemiRoundedPanel();
        this.jLabel4 = new JLabel();
        this.hlFlurstuecksEigentumsnachweisKomPdf = new JXHyperlink();
        this.hlFlurstuecksEigentumsnachweisKomInternPdf = new JXHyperlink();
        this.hlBaulastbescheinigung = new JXHyperlink();
        this.panHtmlProducts = new RoundedPanel();
        this.hlFlurstuecksEigentumsnachweisKomHtml = new JXHyperlink();
        this.hlFlurstuecksnachweisHtml = new JXHyperlink();
        this.jPanel2 = new JPanel();
        this.semiRoundedPanel5 = new SemiRoundedPanel();
        this.jLabel5 = new JLabel();
        this.hlFlurstuecksEigentumsnachweisNrwHtml = new JXHyperlink();
        this.hlFlurstuecksEigentumsnachweisKomInternHtml = new JXHyperlink();
        this.panSpacing = new JPanel();
        this.panProductPreview = new RoundedPanel();
        this.lblProductPreview = new JLabel();
        this.semiRoundedPanel3 = new SemiRoundedPanel();
        this.lblPreviewHead = new JLabel();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText("TITLE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 5);
        this.panTitle.add((Component)this.blWait, gridBagConstraints);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new BorderLayout());
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridBagLayout());
        this.panFooterLeft.setMaximumSize(new Dimension(124, 40));
        this.panFooterLeft.setMinimumSize(new Dimension(124, 40));
        this.panFooterLeft.setOpaque(false);
        this.panFooterLeft.setPreferredSize(new Dimension(124, 40));
        this.panFooterLeft.setLayout(new FlowLayout(2, 10, 5));
        this.lblBack.setFont(new Font("Tahoma", 1, 14));
        this.lblBack.setForeground(new Color(255, 255, 255));
        this.lblBack.setText("Info");
        this.lblBack.setEnabled(false);
        this.lblBack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisLandparcelRenderer.this.lblBackMouseClicked(evt);
            }
        });
        this.panFooterLeft.add(this.lblBack);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        this.btnBack.setBorder(null);
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setFocusPainted(false);
        this.btnBack.setMaximumSize(new Dimension(30, 30));
        this.btnBack.setMinimumSize(new Dimension(30, 30));
        this.btnBack.setPreferredSize(new Dimension(30, 30));
        this.btnBack.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-pressed.png")));
        this.btnBack.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-sel.png")));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.btnBackActionPerformed(evt);
            }
        });
        this.panFooterLeft.add(this.btnBack);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panButtons.add((Component)this.panFooterLeft, gridBagConstraints);
        this.panFooterRight.setMaximumSize(new Dimension(124, 40));
        this.panFooterRight.setOpaque(false);
        this.panFooterRight.setLayout(new FlowLayout(0, 10, 5));
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.btnForwardActionPerformed(evt);
            }
        });
        this.panFooterRight.add(this.btnForward);
        this.lblForw.setFont(new Font("Tahoma", 1, 14));
        this.lblForw.setForeground(new Color(255, 255, 255));
        this.lblForw.setText("Produkte");
        this.lblForw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisLandparcelRenderer.this.lblForwMouseClicked(evt);
            }
        });
        this.panFooterRight.add(this.lblForw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panButtons.add((Component)this.panFooterRight, gridBagConstraints);
        this.panFooter.add((Component)this.panButtons, "Center");
        this.setLayout(new CardLayout());
        this.panDescription.setOpaque(false);
        this.panDescription.setLayout(new GridBagLayout());
        this.panBuchungEigentum.setLayout(new GridBagLayout());
        this.semiRoundedPanel1.setBackground(Color.darkGray);
        this.semiRoundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText(NbBundle.getMessage(AlkisLandparcelRenderer.class, (String)"AlkisEitentuemerPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel1.add((Component)this.jLabel1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panBuchungEigentum.add((Component)this.semiRoundedPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBuchungEigentum.add((Component)this.eigentuemerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panDescription.add((Component)this.panBuchungEigentum, gridBagConstraints);
        this.panMainInfo.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.alkis_id}"), (Object)this.lblLandparcelCode, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        this.panMainInfo.add((Component)this.lblLandparcelCode, gridBagConstraints);
        this.lblDescLandparcelCode.setFont(new Font("Tahoma", 1, 11));
        this.lblDescLandparcelCode.setText("Flurst\u00fcckskennzeichen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescLandparcelCode, gridBagConstraints);
        this.lblDescGemeinde.setFont(new Font("Tahoma", 1, 11));
        this.lblDescGemeinde.setText("Gemeinde:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescGemeinde, gridBagConstraints);
        this.lblGemeinde.setText("Wuppertal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panMainInfo.add((Component)this.lblGemeinde, gridBagConstraints);
        this.lblDescGemarkung.setFont(new Font("Tahoma", 1, 11));
        this.lblDescGemarkung.setText("Gemarkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescGemarkung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gemarkung}"), (Object)this.lblGemarkung, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panMainInfo.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblDescLage.setFont(new Font("Tahoma", 1, 11));
        this.lblDescLage.setText("Lage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescLage, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.groesse} m\u00b2"), (Object)this.lblGroesse, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panMainInfo.add((Component)this.lblGroesse, gridBagConstraints);
        this.lblDescGroesse.setFont(new Font("Tahoma", 1, 11));
        this.lblDescGroesse.setText("Gr\u00f6\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescGroesse, gridBagConstraints);
        this.scpLage.setBorder(null);
        this.scpLage.setMaximumSize(new Dimension(250, 20));
        this.scpLage.setMinimumSize(new Dimension(250, 20));
        this.scpLage.setOpaque(false);
        this.scpLage.setPreferredSize(new Dimension(250, 20));
        this.epLage.setEditable(false);
        this.epLage.setBorder(null);
        this.epLage.setContentType("text/html");
        this.epLage.setOpaque(false);
        this.scpLage.setViewportView(this.epLage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMainInfo.add((Component)this.scpLage, gridBagConstraints);
        this.semiRoundedPanel2.setBackground(Color.darkGray);
        this.semiRoundedPanel2.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel6.setText("Flurst\u00fccksinformation");
        this.jLabel6.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel2.add((Component)this.jLabel6, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.panMainInfo.add((Component)this.semiRoundedPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panDescription.add((Component)this.panMainInfo, gridBagConstraints);
        this.panFlurstueckMap.setBorder(BorderFactory.createEtchedBorder());
        this.panFlurstueckMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panDescription.add((Component)this.panFlurstueckMap, gridBagConstraints);
        this.add((Component)this.panDescription, CARD_1);
        this.panProducts.setOpaque(false);
        this.panProducts.setLayout(new GridBagLayout());
        this.panPdfProducts.setOpaque(false);
        this.panPdfProducts.setLayout(new GridBagLayout());
        this.hlKarte.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlKarte.setText("Karte");
        this.hlKarte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlKarteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 10, 7);
        this.panPdfProducts.add((Component)this.hlKarte, gridBagConstraints);
        this.hlFlurstuecksEigentumsnachweisNrwPdf.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlFlurstuecksEigentumsnachweisNrwPdf.setText("Flurst\u00fccks- und Eigentumsnachweis (NRW)");
        this.hlFlurstuecksEigentumsnachweisNrwPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisNrwPdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlFlurstuecksEigentumsnachweisNrwPdf, gridBagConstraints);
        this.hlFlurstuecksnachweisPdf.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlFlurstuecksnachweisPdf.setText("Flurst\u00fccksnachweis");
        this.hlFlurstuecksnachweisPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksnachweisPdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlFlurstuecksnachweisPdf, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPdfProducts.add((Component)this.jPanel1, gridBagConstraints);
        this.semiRoundedPanel4.setBackground(Color.darkGray);
        this.semiRoundedPanel4.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("PDF-Produkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel4.add((Component)this.jLabel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panPdfProducts.add((Component)this.semiRoundedPanel4, gridBagConstraints);
        this.hlFlurstuecksEigentumsnachweisKomPdf.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlFlurstuecksEigentumsnachweisKomPdf.setText("Flurst\u00fccks- und Eigentumsnachweis (kommunal)");
        this.hlFlurstuecksEigentumsnachweisKomPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisKomPdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlFlurstuecksEigentumsnachweisKomPdf, gridBagConstraints);
        this.hlFlurstuecksEigentumsnachweisKomInternPdf.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlFlurstuecksEigentumsnachweisKomInternPdf.setText("Flurst\u00fccks- und Eigentumsnachweis (NRW, intern)");
        this.hlFlurstuecksEigentumsnachweisKomInternPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisKomInternPdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlFlurstuecksEigentumsnachweisKomInternPdf, gridBagConstraints);
        this.hlBaulastbescheinigung.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlBaulastbescheinigung.setText("Baulastbescheinigung");
        this.hlBaulastbescheinigung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlBaulastbescheinigungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlBaulastbescheinigung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 9, 5);
        this.panProducts.add((Component)this.panPdfProducts, gridBagConstraints);
        this.panHtmlProducts.setOpaque(false);
        this.panHtmlProducts.setLayout(new GridBagLayout());
        this.hlFlurstuecksEigentumsnachweisKomHtml.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-html.png")));
        this.hlFlurstuecksEigentumsnachweisKomHtml.setText("Flurst\u00fccks- und Eigentumsnachweis (kommunal)");
        this.hlFlurstuecksEigentumsnachweisKomHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisKomHtmlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 10, 7);
        this.panHtmlProducts.add((Component)this.hlFlurstuecksEigentumsnachweisKomHtml, gridBagConstraints);
        this.hlFlurstuecksnachweisHtml.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-html.png")));
        this.hlFlurstuecksnachweisHtml.setText("Flurst\u00fccksnachweis");
        this.hlFlurstuecksnachweisHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksnachweisHtmlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 7, 7, 7);
        this.panHtmlProducts.add((Component)this.hlFlurstuecksnachweisHtml, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHtmlProducts.add((Component)this.jPanel2, gridBagConstraints);
        this.semiRoundedPanel5.setBackground(Color.darkGray);
        this.semiRoundedPanel5.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel5.setForeground(new Color(255, 255, 255));
        this.jLabel5.setText("HTML-Produkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel5.add((Component)this.jLabel5, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panHtmlProducts.add((Component)this.semiRoundedPanel5, gridBagConstraints);
        this.hlFlurstuecksEigentumsnachweisNrwHtml.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-html.png")));
        this.hlFlurstuecksEigentumsnachweisNrwHtml.setText("Flurst\u00fccks- und Eigentumsnachweis (NRW)");
        this.hlFlurstuecksEigentumsnachweisNrwHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisNrwHtmlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 10, 7);
        this.panHtmlProducts.add((Component)this.hlFlurstuecksEigentumsnachweisNrwHtml, gridBagConstraints);
        this.hlFlurstuecksEigentumsnachweisKomInternHtml.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-html.png")));
        this.hlFlurstuecksEigentumsnachweisKomInternHtml.setText("Flurst\u00fccks- und Eigentumsnachweis (NRW, intern)");
        this.hlFlurstuecksEigentumsnachweisKomInternHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelRenderer.this.hlFlurstuecksEigentumsnachweisKomInternHtmlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 10, 7);
        this.panHtmlProducts.add((Component)this.hlFlurstuecksEigentumsnachweisKomInternHtml, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 5, 5);
        this.panProducts.add((Component)this.panHtmlProducts, gridBagConstraints);
        this.panSpacing.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.panProducts.add((Component)this.panSpacing, gridBagConstraints);
        this.panProductPreview.setOpaque(false);
        this.panProductPreview.setLayout(new BorderLayout());
        this.lblProductPreview.setHorizontalAlignment(0);
        this.lblProductPreview.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.panProductPreview.add((Component)this.lblProductPreview, "Center");
        this.semiRoundedPanel3.setBackground(Color.darkGray);
        this.semiRoundedPanel3.setLayout((LayoutManager)new GridBagLayout());
        this.lblPreviewHead.setText("Vorschau");
        this.lblPreviewHead.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel3.add((Component)this.lblPreviewHead, (Object)gridBagConstraints);
        this.panProductPreview.add((Component)this.semiRoundedPanel3, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panProducts.add((Component)this.panProductPreview, gridBagConstraints);
        this.add((Component)this.panProducts, CARD_2);
        this.bindingGroup.bind();
    }

    private void hlKarteActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadKarteProduct();
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstueckskarte.pdf"));
        }
    }

    private void hlFlurstuecksnachweisPdfActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_PDF), true);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksnachweis.pdf"));
        }
    }

    private void hlFlurstuecksEigentumsnachweisKomHtmlActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML), false);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksnachweis.pdf"));
        }
    }

    private void hlFlurstuecksnachweisHtmlActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_HTML), false);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksnachweis.html"));
        }
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, CARD_1);
        this.btnBack.setEnabled(false);
        this.btnForward.setEnabled(true);
        this.lblBack.setEnabled(false);
        this.lblForw.setEnabled(true);
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, CARD_2);
        this.btnBack.setEnabled(true);
        this.btnForward.setEnabled(false);
        this.lblBack.setEnabled(true);
        this.lblForw.setEnabled(false);
    }

    private void lblBackMouseClicked(MouseEvent evt) {
        if (this.lblBack.isEnabled()) {
            this.btnBackActionPerformed(null);
        }
    }

    private void lblForwMouseClicked(MouseEvent evt) {
        if (this.lblForw.isEnabled()) {
            this.btnForwardActionPerformed(null);
        }
    }

    private void hlFlurstuecksEigentumsnachweisNrwPdfActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF), true);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksundeigentumsnachweis_nrw.pdf"));
        }
    }

    private void hlFlurstuecksEigentumsnachweisKomPdfActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF), true);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksundeigentumsnachweis_kommunal.pdf"));
        }
    }

    private void hlFlurstuecksEigentumsnachweisNrwHtmlActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML), false);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksundeigentumsnachweis_kommunal.pdf"));
        }
    }

    private void hlFlurstuecksEigentumsnachweisKomInternPdfActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF), true);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksundeigentumsnachweis_kommunal_intern.pdf"));
        }
    }

    private void hlFlurstuecksEigentumsnachweisKomInternHtmlActionPerformed(ActionEvent evt) {
        if (!this.demoMode) {
            this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML), false);
        } else {
            BrowserLauncher.openURLorFile((String)(ClientAlkisConf.getInstance().getDemoServiceUrl() + "flurstuecksundeigentumsnachweis_kommunal_intern.html"));
        }
    }

    private void hlBaulastbescheinigungActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> flurstuecke = new ArrayList<CidsBean>();
        flurstuecke.add(this.cidsBean);
        BaulastBescheinigungDialog.getInstance().show(flurstuecke, this, this.getConnectionContext());
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        this.bindingGroup.unbind();
        if (cb != null) {
            this.cidsBean = cb;
            this.initMap();
            this.initLage();
            this.bindingGroup.bind();
            if (this.eigentuemerPermission) {
                this.eigentuemerPanel.setFlurstuecke(Arrays.asList(this.cidsBean), new AlkisEigentuemerPanel.Listener(){

                    @Override
                    public void loadingStarted() {
                        AlkisLandparcelRenderer.this.blWait.setVisible(true);
                        AlkisLandparcelRenderer.this.setWaiting(true);
                    }

                    @Override
                    public void loadingDone() {
                        AlkisLandparcelRenderer.this.blWait.setVisible(false);
                    }
                });
            }
        }
    }

    private void initLage() {
        HashMap streetToBeans = TypeSafeCollections.newHashMap();
        Object adressenObj = this.cidsBean.getProperty("adressen");
        if (adressenObj instanceof List) {
            List adressenBeans = (List)adressenObj;
            for (CidsBean adresse : adressenBeans) {
                Iterator strasseObj = adresse.getProperty("strasse");
                if (strasseObj == null) continue;
                String strasse = strasseObj.toString();
                List beansWithThisStreet = (List)streetToBeans.get(strasse);
                if (beansWithThisStreet == null) {
                    beansWithThisStreet = TypeSafeCollections.newArrayList();
                    streetToBeans.put(strasse, beansWithThisStreet);
                }
                beansWithThisStreet.add(adresse);
            }
        }
        StringBuilder adressenContent = new StringBuilder("<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\" valign=\"top\">");
        ArrayList sortStrassen = TypeSafeCollections.newArrayList(streetToBeans.keySet());
        Collections.sort(sortStrassen);
        int entryCount = sortStrassen.size();
        for (String strasse : sortStrassen) {
            List beansWithThisStreet = (List)streetToBeans.get(strasse);
            Collections.sort(beansWithThisStreet, new Comparator<CidsBean>(){

                @Override
                public int compare(CidsBean o1, CidsBean o2) {
                    if (o1 != null && o2 != null) {
                        Object n1 = o1.getProperty("nummer");
                        Object n2 = o2.getProperty("nummer");
                        return AlphanumComparator.getInstance().compare(String.valueOf(n1), String.valueOf(n2));
                    }
                    return 0;
                }
            });
            LinkedHashMap hausnummernToBeans = TypeSafeCollections.newLinkedHashMap();
            for (CidsBean cidsBean : beansWithThisStreet) {
                Object hausnummerObj = cidsBean.getProperty("nummer");
                if (hausnummerObj == null) continue;
                hausnummernToBeans.put(hausnummerObj.toString(), cidsBean);
            }
            if (hausnummernToBeans.isEmpty()) {
                for (CidsBean cidsBean : beansWithThisStreet) {
                    adressenContent.append("<tr><td>");
                    if (strasse != null && !strasse.trim().matches(".*\\(\\d+\\)$") && !strasse.trim().matches("^\\(\\d+\\).*")) {
                        adressenContent.append(strasse);
                    } else {
                        adressenContent.append(AlkisProducts.generateLinkFromCidsBean((CidsBean)cidsBean, (String)strasse));
                    }
                    adressenContent.append("</td></tr>");
                }
                continue;
            }
            entryCount += hausnummernToBeans.size() / 7;
            adressenContent.append("<tr><td>");
            adressenContent.append(strasse).append("&nbsp;");
            adressenContent.append("</td>");
            adressenContent.append("<td>");
            for (Map.Entry entry : hausnummernToBeans.entrySet()) {
                String nummer = (String)entry.getKey();
                CidsBean numberBean = (CidsBean)entry.getValue();
                adressenContent.append(AlkisProducts.generateLinkFromCidsBean((CidsBean)numberBean, (String)nummer));
                adressenContent.append(", ");
            }
            adressenContent.delete(adressenContent.length() - 2, adressenContent.length());
            adressenContent.append("</td>");
            adressenContent.append("</tr>");
        }
        adressenContent.append("</table></html>");
        this.epLage.setText(adressenContent.toString());
        int linecount = entryCount;
        if (linecount > 1) {
            if (linecount < 5) {
                ObjectRendererUtils.setAllDimensions(this.scpLage, new Dimension(this.scpLage.getPreferredSize().width, 20 * linecount));
            } else {
                ObjectRendererUtils.setAllDimensions(this.scpLage, new Dimension(this.scpLage.getPreferredSize().width, 100));
            }
        }
    }

    private void initMap() {
        Object geoObj = this.cidsBean.getProperty("geometrie");
        if (geoObj instanceof Geometry) {
            final Geometry pureGeom = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)geoObj), (String)ClientAlkisConf.getInstance().getSrsService());
            final XBoundingBox box = new XBoundingBox(pureGeom.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
            Runnable mapRunnable = new Runnable(){

                @Override
                public void run() {
                    ActiveLayerModel mappingModel = new ActiveLayerModel();
                    mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    mappingModel.addHome(new XBoundingBox(box.getX1(), box.getY1(), box.getX2(), box.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
                    SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                    swms.setName("Flurstueck");
                    DefaultStyledFeature dsf = new DefaultStyledFeature();
                    dsf.setGeometry(pureGeom);
                    dsf.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.75f));
                    mappingModel.addLayer((RetrievalServiceLayer)swms);
                    AlkisLandparcelRenderer.this.map.setMappingModel((MappingModel)mappingModel);
                    int duration = AlkisLandparcelRenderer.this.map.getAnimationDuration();
                    AlkisLandparcelRenderer.this.map.setAnimationDuration(0);
                    AlkisLandparcelRenderer.this.map.gotoInitialBoundingBox();
                    AlkisLandparcelRenderer.this.map.setInteractionMode("ZOOM");
                    AlkisLandparcelRenderer.this.map.unlock();
                    AlkisLandparcelRenderer.this.map.addCustomInputListener("MUTE", new PBasicInputEventHandler(){

                        public void mouseClicked(PInputEvent evt) {
                            if (evt.getClickCount() > 1) {
                                CidsBean bean = AlkisLandparcelRenderer.this.cidsBean;
                                ObjectRendererUtils.switchToCismapMap();
                                ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(bean, false);
                            }
                        }
                    });
                    AlkisLandparcelRenderer.this.map.setInteractionMode("MUTE");
                    AlkisLandparcelRenderer.this.map.getFeatureCollection().addFeature((Feature)dsf);
                    AlkisLandparcelRenderer.this.map.setAnimationDuration(duration);
                }
            };
            if (EventQueue.isDispatchThread()) {
                mapRunnable.run();
            } else {
                EventQueue.invokeLater(mapRunnable);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        title = title == null ? "<Error>" : AlkisProducts.prettyPrintLandparcelCode((String)title);
        this.title = title;
        this.lblTitle.setText(this.title);
    }

    class ProductLabelMouseAdaper
    extends MouseAdapter {
        ProductLabelMouseAdaper() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Object srcObj = e.getSource();
            ImageIcon imageIcon = (ImageIcon)AlkisLandparcelRenderer.this.productPreviewImages.get(srcObj);
            if (imageIcon != null) {
                AlkisLandparcelRenderer.this.lblProductPreview.setIcon(imageIcon);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AlkisLandparcelRenderer.this.lblProductPreview.setIcon(null);
        }
    }
}

