/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class FsBestellungReportGenerator {
    private static final String PARAMETER_DATUM_HEUTE = "DATUM_HEUTE";
    private static final String PARAMETER_DATUM_EINGANG = "DATUM_EINGANG";
    private static final String PARAMETER_PRODUKTBEZEICHNUNG = "PRODUKTBEZEICHNUNG";
    private static final String PARAMETER_FLURSTUECKSKENNZEICHEN = "FLURSTUECKSKENNZEICHEN";
    private static final String PARAMETER_TRANSAKTIONSID = "TRANSAKTIONSID";
    private static final String PARAMETER_LIEFER_FIRMA = "LIEFER_FIRMA";
    private static final String PARAMETER_LIEFER_VORNAME = "LIEFER_VORNAME";
    private static final String PARAMETER_LIEFER_NAME = "LIEFER_NAME";
    private static final String PARAMETER_LIEFER_STRASSE = "LIEFER_STRASSE";
    private static final String PARAMETER_LIEFER_HAUSNUMMER = "LIEFER_HAUSNUMMER";
    private static final String PARAMETER_LIEFER_PLZ = "LIEFER_PLZ";
    private static final String PARAMETER_LIEFER_ORT = "LIEFER_ORT";
    private static final String PARAMETER_LIEFER_ALTERNATIV = "LIEFER_ALTERNATIV";
    private static final String PARAMETER_LIEFER_ADRESSE = "LIEFER_ADRESSE";
    private static final String PARAMETER_RECHNUNG_FIRMA = "RECHNUNG_FIRMA";
    private static final String PARAMETER_RECHNUNG_VORNAME = "RECHNUNG_VORNAME";
    private static final String PARAMETER_RECHNUNG_NAME = "RECHNUNG_NAME";
    private static final String PARAMETER_RECHNUNG_STRASSE = "RECHNUNG_STRASSE";
    private static final String PARAMETER_RECHNUNG_HAUSNUMMER = "RECHNUNG_HAUSNUMMER";
    private static final String PARAMETER_RECHNUNG_PLZ = "RECHNUNG_PLZ";
    private static final String PARAMETER_RECHNUNG_ORT = "RECHNUNG_ORT";
    private static final String PARAMETER_RECHNUNG_ALTERNATIV = "RECHNUNG_ALTERNATIV";
    private static final String PARAMETER_RECHNUNG_ADRESSE = "RECHNUNG_ADRESSE";
    private static final Logger LOG = Logger.getLogger(FsBestellungReportGenerator.class);

    private static String dashIfNull(String string) {
        return string != null ? string : "-";
    }

    private static String emptyIfNull(String string) {
        return string != null ? string : "";
    }

    public static Download createJasperDownload(final CidsBean bestellungbean, String jobname) {
        boolean isLiegenschaftsbuch;
        final SimpleDateFormat dateformat = new SimpleDateFormat("dd.MM.yyyy");
        final String vorgangsnummer = bestellungbean.getProperty("transid") != null ? ((String)bestellungbean.getProperty("transid")).substring("KFAS_KF600200-".length()) : null;
        final String landparcelcode = (String)bestellungbean.getProperty("landparcelcode");
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                try {
                    return new JRBeanCollectionDataSource(Arrays.asList(bestellungbean));
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                    return null;
                }
            }
        };
        JasperReportDownload.JasperReportParametersGenerator parametersGenerator = new JasperReportDownload.JasperReportParametersGenerator(){

            public Map generateParamters() {
                String datumHeute = FsBestellungReportGenerator.dashIfNull(dateformat.format(new Date()));
                String datumEingang = FsBestellungReportGenerator.dashIfNull(dateformat.format((Timestamp)bestellungbean.getProperty("eingang_ts")));
                String transaktionsid = FsBestellungReportGenerator.dashIfNull(vorgangsnummer);
                String flurstueckskennzeichen = FsBestellungReportGenerator.dashIfNull(landparcelcode).replace(",", ", ");
                String produktbezeichnung = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_produkt.fk_typ.name"));
                String lieferFirma = FsBestellungReportGenerator.emptyIfNull((String)bestellungbean.getProperty("fk_adresse_versand.firma"));
                String lieferVorname = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.vorname"));
                String lieferName = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.name"));
                String lieferStrasse = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.strasse"));
                String lieferHausnummer = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.hausnummer"));
                String lieferPlz = FsBestellungReportGenerator.dashIfNull(bestellungbean.getProperty("fk_adresse_versand.plz") != null ? Integer.toString((Integer)bestellungbean.getProperty("fk_adresse_versand.plz")) : null);
                String lieferOrt = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.ort"));
                String lieferStaat = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.staat"));
                String lieferAlternativ = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_versand.alternativ"));
                String lieferAdresse = lieferAlternativ.equals("-") ? lieferStrasse + " " + lieferHausnummer + "\n" + lieferPlz + " " + lieferOrt : lieferAlternativ + "\n" + lieferStaat;
                String rechnungFirma = FsBestellungReportGenerator.emptyIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.firma"));
                String rechnungVorname = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.vorname"));
                String rechnungName = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.name"));
                String rechnungStrasse = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.strasse"));
                String rechnungHausnummer = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.hausnummer"));
                String rechnungPlz = FsBestellungReportGenerator.dashIfNull(bestellungbean.getProperty("fk_adresse_rechnung.plz") != null ? Integer.toString((Integer)bestellungbean.getProperty("fk_adresse_rechnung.plz")) : null);
                String rechnungOrt = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.ort"));
                String rechnungStaat = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.staat"));
                String rechnungAlternativ = FsBestellungReportGenerator.dashIfNull((String)bestellungbean.getProperty("fk_adresse_rechnung.alternativ"));
                String rechnungAdresse = rechnungAlternativ.equals("-") ? rechnungStrasse + " " + rechnungHausnummer + "\n" + rechnungPlz + " " + rechnungOrt : rechnungAlternativ + "\n" + rechnungStaat;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put(FsBestellungReportGenerator.PARAMETER_DATUM_HEUTE, datumHeute);
                parameters.put(FsBestellungReportGenerator.PARAMETER_DATUM_EINGANG, datumEingang);
                parameters.put(FsBestellungReportGenerator.PARAMETER_TRANSAKTIONSID, transaktionsid);
                parameters.put(FsBestellungReportGenerator.PARAMETER_FLURSTUECKSKENNZEICHEN, flurstueckskennzeichen);
                parameters.put(FsBestellungReportGenerator.PARAMETER_PRODUKTBEZEICHNUNG, produktbezeichnung);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_FIRMA, lieferFirma);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_VORNAME, lieferVorname);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_NAME, lieferName);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_STRASSE, lieferStrasse);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_HAUSNUMMER, lieferHausnummer);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_PLZ, lieferPlz);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_ORT, lieferOrt);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_ALTERNATIV, lieferAlternativ);
                parameters.put(FsBestellungReportGenerator.PARAMETER_LIEFER_ADRESSE, lieferAdresse);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_FIRMA, rechnungFirma);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_VORNAME, rechnungVorname);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_NAME, rechnungName);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_STRASSE, rechnungStrasse);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_HAUSNUMMER, rechnungHausnummer);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_PLZ, rechnungPlz);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_ORT, rechnungOrt);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_ALTERNATIV, rechnungAlternativ);
                parameters.put(FsBestellungReportGenerator.PARAMETER_RECHNUNG_ADRESSE, rechnungAdresse);
                return parameters;
            }
        };
        boolean isBaulasten = ((String)bestellungbean.getProperty("transid")).startsWith("KFAS_KF600202-") || ((String)bestellungbean.getProperty("transid")).startsWith("KFAS_KF600203-");
        boolean bl = isLiegenschaftsbuch = ((String)bestellungbean.getProperty("transid")).startsWith("KFAS_KF600204-") || ((String)bestellungbean.getProperty("transid")).startsWith("KFAS_KF600205-");
        JasperReportDownload download = new JasperReportDownload(isBaulasten ? "/de/cismet/cids/custom/wunda_blau/res/bestellung_baulasten.jasper" : (isLiegenschaftsbuch ? "/de/cismet/cids/custom/wunda_blau/res/bestellung_liegenschaftsbuch.jasper" : "/de/cismet/cids/custom/wunda_blau/res/bestellung_produkt.jasper"), parametersGenerator, dataSourceGenerator, jobname, "Produkt-Bestellung", "Bestellung_" + vorgangsnummer);
        return download;
    }
}

