/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.tools.gui.RoundedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXDatePicker;

public class KaufvertragRenderer
extends JPanel
implements CidsBeanRenderer,
RequestsFullSizeComponent {
    private static final String VERTRAG = "Vertrag";
    private static final Logger LOG = Logger.getLogger(KaufvertragRenderer.class);
    private final Converter<Timestamp, Date> timeStampConverter = new Converter<Timestamp, Date>(){

        public Date convertForward(Timestamp value) {
            try {
                if (value != null) {
                    return new Date(value.getTime());
                }
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)"Problem during Timestamp vonversion. Will return now().", (Throwable)ex);
                return new Date(System.currentTimeMillis());
            }
        }

        public Timestamp convertReverse(Date value) {
            try {
                if (value != null) {
                    return new Timestamp(value.getTime());
                }
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)"Problem during Timestamp vonversion. Will return now().", (Throwable)ex);
                return new Timestamp(System.currentTimeMillis());
            }
        }
    };
    private CidsBean cidsBean;
    private DefaultBindableDateChooser dpVerkaufsdatum;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel lblAdresse;
    private JLabel lblAuswertung;
    private JLabel lblGesamtflaeche;
    private JLabel lblGesamtteilflaeche;
    private JLabel lblKaufpreisAbs;
    private JLabel lblKaufpreisQm;
    private JLabel lblObjektart;
    private JLabel lblRegBez;
    private JLabel lblRegJahr;
    private JLabel lblSachKaufpreis;
    private JLabel lblSachKaufpreisRoh;
    private JLabel lblSachMarktanp;
    private JLabel lblSachRohertrag;
    private JLabel lblSachZinssatz;
    private JLabel lblSachwerte;
    private JLabel lblTeilmarkt;
    private JPanel panFlurstuecke;
    private JPanel panGebaeude;
    private JPanel panMain;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panSachwerte;
    private JPanel panTeileigentum;
    private BindingGroup bindingGroup;

    public KaufvertragRenderer() {
        this.initComponents();
        RendererTools.jxDatePickerShouldLookLikeLabel((JXDatePicker)this.dpVerkaufsdatum);
    }

    public void createSuppanels() {
        List flurstuecke = this.cidsBean.getBeanCollectionProperty("flurstuecke");
        if (flurstuecke != null && !flurstuecke.isEmpty()) {
            int anzahl = flurstuecke.size();
            if (anzahl % 2 == 0) {
                this.panFlurstuecke.setLayout(new GridLayout(anzahl / 2, 2, 5, 5));
            } else {
                this.panFlurstuecke.setLayout(new GridLayout((anzahl + 1) / 2, 2, 5, 5));
            }
            for (Object flurstueck : flurstuecke) {
                this.panFlurstuecke.add((Component)this.createFlurstueckPanel((CidsBean)flurstueck));
            }
        } else {
            this.panFlurstuecke.setVisible(false);
            this.jLabel18.setVisible(false);
        }
        List gebaeudeList = this.cidsBean.getBeanCollectionProperty("gebauede");
        if (gebaeudeList != null && !gebaeudeList.isEmpty()) {
            int anzahl = gebaeudeList.size();
            if (anzahl % 2 == 0) {
                this.panGebaeude.setLayout(new GridLayout(anzahl / 2, 2, 5, 5));
            } else {
                this.panGebaeude.setLayout(new GridLayout((anzahl + 1) / 2, 2, 5, 5));
            }
            for (CidsBean gebaeude : gebaeudeList) {
                this.panGebaeude.add((Component)this.createGebaeudePanel(gebaeude));
            }
        } else {
            this.panGebaeude.setVisible(false);
            this.jLabel19.setVisible(false);
        }
        List teileigentume = this.cidsBean.getBeanCollectionProperty("teileigentum");
        if (teileigentume != null && !teileigentume.isEmpty()) {
            int anzahl = teileigentume.size();
            if (anzahl % 2 == 0) {
                this.panTeileigentum.setLayout(new GridLayout(anzahl / 2, 2, 5, 5));
            } else {
                this.panTeileigentum.setLayout(new GridLayout((anzahl + 1) / 2, 2, 5, 5));
            }
            for (CidsBean teileigentum : teileigentume) {
                this.panTeileigentum.add((Component)this.createTeileigentumPanel(teileigentum));
            }
        } else {
            this.panTeileigentum.setVisible(false);
            this.jLabel20.setVisible(false);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.panMain = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel10 = new JLabel();
        this.lblSachwerte = new JLabel();
        this.lblRegBez = new JLabel();
        this.lblRegJahr = new JLabel();
        this.lblAdresse = new JLabel();
        this.lblObjektart = new JLabel();
        this.lblTeilmarkt = new JLabel();
        this.lblGesamtflaeche = new JLabel();
        this.lblGesamtteilflaeche = new JLabel();
        this.lblKaufpreisQm = new JLabel();
        this.lblKaufpreisAbs = new JLabel();
        this.lblAuswertung = new JLabel();
        this.panSachwerte = new RoundedPanel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.lblSachKaufpreis = new JLabel();
        this.lblSachRohertrag = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.lblSachKaufpreisRoh = new JLabel();
        this.lblSachMarktanp = new JLabel();
        this.lblSachZinssatz = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.panFlurstuecke = new JPanel();
        this.panGebaeude = new JPanel();
        this.panTeileigentum = new JPanel();
        this.dpVerkaufsdatum = new DefaultBindableDateChooser();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel1.add((Component)this.panPreviewMap, gridBagConstraints);
        this.panMain.setOpaque(false);
        this.panMain.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Reg_Bez:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Reg_Jahr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Verkaufsdatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Adresse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Objektart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("Teilmarkt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Gesamtfl\u00e4che:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("Gesamtteilfl\u00e4che:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Kaufpreis pro m\u00b2:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setText("Zur Auswertung geeignet:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Kaufpreis absolut:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel10, gridBagConstraints);
        this.lblSachwerte.setFont(new Font("Tahoma", 1, 11));
        this.lblSachwerte.setText("Sachwerte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.lblSachwerte, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.reg_bez}"), (Object)this.lblRegBez, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblRegBez, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.reg_jahr}"), (Object)this.lblRegJahr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblRegJahr, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.adresse}"), (Object)this.lblAdresse, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblAdresse, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.objektart}"), (Object)this.lblObjektart, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblObjektart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.teilmarkt}"), (Object)this.lblTeilmarkt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblTeilmarkt, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gesamtflaeche}"), (Object)this.lblGesamtflaeche, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblGesamtflaeche, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gesamtteilflaeche}"), (Object)this.lblGesamtteilflaeche, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblGesamtteilflaeche, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.kaufpreis_pro_qm}"), (Object)this.lblKaufpreisQm, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblKaufpreisQm, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.kaufpreis_absolut}"), (Object)this.lblKaufpreisAbs, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblKaufpreisAbs, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.zur_auswertunng_geeignet}"), (Object)this.lblAuswertung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.lblAuswertung, gridBagConstraints);
        this.panSachwerte.setOpaque(false);
        this.jLabel13.setFont(new Font("Tahoma", 1, 11));
        this.jLabel13.setText("Rohertrag:");
        this.jLabel14.setFont(new Font("Tahoma", 1, 11));
        this.jLabel14.setText("Bereinigter Kaufpreis:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sachwerte.bereinigter_kaufpreis_wf_nf}"), (Object)this.lblSachKaufpreis, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sachwerte.rohertrag}"), (Object)this.lblSachRohertrag, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel15.setFont(new Font("Tahoma", 1, 11));
        this.jLabel15.setText("Bereinigter Kaufpreis Rohertrag:");
        this.jLabel16.setFont(new Font("Tahoma", 1, 11));
        this.jLabel16.setText("Marktanpassungsfaktor:");
        this.jLabel17.setFont(new Font("Tahoma", 1, 11));
        this.jLabel17.setText("Liegenschaftszinssatz:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sachwerte.bereinigter_kaufpreis_rohertrag}"), (Object)this.lblSachKaufpreisRoh, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sachwerte.marktanpassungsfaktor}"), (Object)this.lblSachMarktanp, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.sachwerte.liegenschaftszinssatz}"), (Object)this.lblSachZinssatz, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout panSachwerteLayout = new GroupLayout(this.panSachwerte);
        this.panSachwerte.setLayout(panSachwerteLayout);
        panSachwerteLayout.setHorizontalGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panSachwerteLayout.createSequentialGroup().addContainerGap().addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel16).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSachKaufpreis).addComponent(this.lblSachRohertrag).addComponent(this.lblSachKaufpreisRoh).addComponent(this.lblSachMarktanp).addComponent(this.lblSachZinssatz)).addContainerGap(105, Short.MAX_VALUE)));
        panSachwerteLayout.setVerticalGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panSachwerteLayout.createSequentialGroup().addContainerGap().addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.lblSachRohertrag)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.lblSachKaufpreis)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.lblSachKaufpreisRoh)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.lblSachMarktanp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panSachwerteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.lblSachZinssatz)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 31;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 32);
        this.panMain.add((Component)this.panSachwerte, gridBagConstraints);
        this.jLabel18.setFont(new Font("Tahoma", 1, 11));
        this.jLabel18.setText("Flurst\u00fccke:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel19.setFont(new Font("Tahoma", 1, 11));
        this.jLabel19.setText("Geb\u00e4ude:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel20.setFont(new Font("Tahoma", 1, 11));
        this.jLabel20.setText("Teileigentum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 20);
        this.panMain.add((Component)this.jLabel20, gridBagConstraints);
        this.panFlurstuecke.setOpaque(false);
        GroupLayout panFlurstueckeLayout = new GroupLayout(this.panFlurstuecke);
        this.panFlurstuecke.setLayout(panFlurstueckeLayout);
        panFlurstueckeLayout.setHorizontalGroup(panFlurstueckeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 234, Short.MAX_VALUE));
        panFlurstueckeLayout.setVerticalGroup(panFlurstueckeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 78;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panMain.add((Component)this.panFlurstuecke, gridBagConstraints);
        this.panGebaeude.setOpaque(false);
        GroupLayout panGebaeudeLayout = new GroupLayout(this.panGebaeude);
        this.panGebaeude.setLayout(panGebaeudeLayout);
        panGebaeudeLayout.setHorizontalGroup(panGebaeudeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 258, Short.MAX_VALUE));
        panGebaeudeLayout.setVerticalGroup(panGebaeudeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 86;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.panMain.add((Component)this.panGebaeude, gridBagConstraints);
        this.panTeileigentum.setOpaque(false);
        GroupLayout panTeileigentumLayout = new GroupLayout(this.panTeileigentum);
        this.panTeileigentum.setLayout(panTeileigentumLayout);
        panTeileigentumLayout.setHorizontalGroup(panTeileigentumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 291, Short.MAX_VALUE));
        panTeileigentumLayout.setVerticalGroup(panTeileigentumLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 97;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 17, 0);
        this.panMain.add((Component)this.panTeileigentum, gridBagConstraints);
        this.dpVerkaufsdatum.setBorder(null);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.verkaufsdatum.fromts}"), (Object)this.dpVerkaufsdatum, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.timeStampConverter);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.panMain.add((Component)this.dpVerkaufsdatum, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.jPanel1.add((Component)this.panMain, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            this.panPreviewMap.initMap(cidsBean, "umschreibendes_rechteck.geo_field");
            this.bindingGroup.bind();
            this.createSuppanels();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        String vertragstyp;
        String title = "";
        String name = (String)this.cidsBean.getProperty("reg_bez");
        title = StringUtils.isNotBlank((String)name) ? (!(vertragstyp = (String)this.cidsBean.getProperty("vertragstyp")).equals("") ? vertragstyp + " - " + name : "Vertrag - " + name) : VERTRAG;
        return title;
    }

    public void setTitle(String title) {
    }

    private RoundedPanel createFlurstueckPanel(CidsBean flurstueck) {
        int c = 6;
        RoundedPanel round = new RoundedPanel();
        round.setLayout((LayoutManager)new FlowLayout(3));
        round.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel pnlFlurstueck = new JPanel();
        pnlFlurstueck.setOpaque(false);
        pnlFlurstueck.setLayout(new GridLayout(6, 2, 20, 5));
        JLabel gemName = new JLabel();
        gemName.setFont(new Font("Tahoma", 1, 11));
        gemName.setText("Gemarkungsname:");
        JLabel gemNr = new JLabel();
        gemNr.setFont(new Font("Tahoma", 1, 11));
        gemNr.setText("Gemarkungsnr:");
        JLabel lblFlur = new JLabel();
        lblFlur.setFont(new Font("Tahoma", 1, 11));
        lblFlur.setText("Flur:");
        JLabel flurstZN = new JLabel();
        flurstZN.setFont(new Font("Tahoma", 1, 11));
        flurstZN.setText("Z\u00e4hler / Nenner:");
        JLabel flaeche = new JLabel();
        flaeche.setFont(new Font("Tahoma", 1, 11));
        flaeche.setText("Fl\u00e4che:");
        JLabel teilflaeche = new JLabel();
        teilflaeche.setFont(new Font("Tahoma", 1, 11));
        teilflaeche.setText("Teilfl\u00e4che:");
        String gemarkungsname = (String)flurstueck.getProperty("gemarkungsname");
        if (StringUtils.isNotBlank((String)gemarkungsname)) {
            pnlFlurstueck.add(gemName);
            pnlFlurstueck.add(new JLabel(gemarkungsname));
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        String gemarkungsNr = (String)flurstueck.getProperty("gemarkungs_nr");
        if (StringUtils.isNotBlank((String)gemarkungsNr) && !"null".equals(gemarkungsNr)) {
            pnlFlurstueck.add(gemNr);
            pnlFlurstueck.add(new JLabel(gemarkungsNr));
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        String flur = (String)flurstueck.getProperty("flur");
        if (StringUtils.isNotBlank((String)flur)) {
            pnlFlurstueck.add(lblFlur);
            pnlFlurstueck.add(new JLabel(flur));
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        String fstnr_z = (String)flurstueck.getProperty("fstnr_z");
        String fstnr_n = (String)flurstueck.getProperty("fstnr_n");
        if (StringUtils.isNotBlank((String)fstnr_z)) {
            if (StringUtils.isNotBlank((String)fstnr_n)) {
                pnlFlurstueck.add(flurstZN);
                pnlFlurstueck.add(new JLabel(fstnr_z + "/" + fstnr_n));
            } else {
                pnlFlurstueck.add(flurstZN);
                pnlFlurstueck.add(new JLabel(fstnr_z));
            }
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        Float flaecheFlurstueck = (Float)flurstueck.getProperty("flaeche_flurstueck");
        if (flaecheFlurstueck != null && flaecheFlurstueck.floatValue() > -1.0f) {
            pnlFlurstueck.add(flaeche);
            pnlFlurstueck.add(new JLabel(flaecheFlurstueck.toString()));
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        Float teilflaecheFlurstueck = (Float)flurstueck.getProperty("teilflaeche_flurstueck");
        if (teilflaecheFlurstueck != null && teilflaecheFlurstueck.floatValue() > -1.0f) {
            pnlFlurstueck.add(teilflaeche);
            pnlFlurstueck.add(new JLabel(teilflaecheFlurstueck.toString()));
        } else {
            ((GridLayout)pnlFlurstueck.getLayout()).setRows(--c);
        }
        round.add((Component)pnlFlurstueck, (Object)"Center");
        return round;
    }

    private RoundedPanel createGebaeudePanel(CidsBean gebaeude) {
        int c = 5;
        RoundedPanel round = new RoundedPanel();
        round.setLayout((LayoutManager)new FlowLayout(3));
        round.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel geb = new JPanel();
        geb.setOpaque(false);
        geb.setLayout(new GridLayout(c, 2, 20, 5));
        JLabel bez = new JLabel();
        bez.setFont(new Font("Tahoma", 1, 11));
        bez.setText("Bezeichnung:");
        JLabel lblBaujahr = new JLabel();
        lblBaujahr.setFont(new Font("Tahoma", 1, 11));
        lblBaujahr.setText("Baujahr:");
        JLabel wf = new JLabel();
        wf.setFont(new Font("Tahoma", 1, 11));
        wf.setText("Wohnfl\u00e4che:");
        JLabel nf = new JLabel();
        nf.setFont(new Font("Tahoma", 1, 11));
        nf.setText("Nutzfl\u00e4che:");
        JLabel wf_nf = new JLabel();
        wf_nf.setFont(new Font("Tahoma", 1, 11));
        wf_nf.setText("Wohnfl\u00e4che/Nutzfl\u00e4che:");
        String bezeichnung = (String)gebaeude.getProperty("bezeichnung");
        if (StringUtils.isNotBlank((String)bezeichnung)) {
            geb.add(bez);
            geb.add(new JLabel(bezeichnung));
        } else {
            ((GridLayout)geb.getLayout()).setRows(--c);
        }
        Integer baujahr = (Integer)gebaeude.getProperty("baujahr");
        if (baujahr != null && baujahr > -1) {
            geb.add(lblBaujahr);
            geb.add(new JLabel(baujahr.toString()));
        } else {
            ((GridLayout)geb.getLayout()).setRows(--c);
        }
        Float wfGebaeudeQm = (Float)gebaeude.getProperty("wf_gebaeude_qm");
        if (wfGebaeudeQm != null && wfGebaeudeQm.floatValue() > -1.0f) {
            geb.add(wf);
            geb.add(new JLabel(wfGebaeudeQm.toString()));
        } else {
            ((GridLayout)geb.getLayout()).setRows(--c);
        }
        Float nfGebaeudeQm = (Float)gebaeude.getProperty("nf_gebaeude_qm");
        if (nfGebaeudeQm != null && nfGebaeudeQm.floatValue() > -1.0f) {
            geb.add(nf);
            geb.add(new JLabel(nfGebaeudeQm.toString()));
        } else {
            ((GridLayout)geb.getLayout()).setRows(--c);
        }
        Float wfNf = (Float)gebaeude.getProperty("wf_nf");
        if (wfNf != null && wfNf.floatValue() > -1.0f) {
            geb.add(wf_nf);
            geb.add(new JLabel(wfNf.toString()));
        } else {
            ((GridLayout)geb.getLayout()).setRows(--c);
        }
        round.add((Component)geb, (Object)"Center");
        return round;
    }

    private RoundedPanel createTeileigentumPanel(CidsBean teileigentum) {
        int c = 8;
        RoundedPanel round = new RoundedPanel();
        round.setLayout((LayoutManager)new FlowLayout(3));
        round.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel teil = new JPanel();
        teil.setOpaque(false);
        teil.setLayout(new GridLayout(c, 2, 20, 5));
        JLabel geschosse = new JLabel();
        geschosse.setFont(new Font("Tahoma", 1, 11));
        geschosse.setText("Anzahl Geschosse:");
        JLabel kaufpreis = new JLabel();
        kaufpreis.setFont(new Font("Tahoma", 1, 11));
        kaufpreis.setText("Rel. Kaufpreis:");
        JLabel tmarkt = new JLabel();
        tmarkt.setFont(new Font("Tahoma", 1, 11));
        tmarkt.setText("Teilmarkt:");
        JLabel vermietung = new JLabel();
        vermietung.setFont(new Font("Tahoma", 1, 11));
        vermietung.setText("Vermietungssituation:");
        JLabel ausstattung = new JLabel();
        ausstattung.setFont(new Font("Tahoma", 1, 11));
        ausstattung.setText("Ausstattungsstandard:");
        JLabel modernisierung = new JLabel();
        modernisierung.setFont(new Font("Tahoma", 1, 11));
        modernisierung.setText("Modernisierungsjahr:");
        JLabel lblRaumzahl = new JLabel();
        lblRaumzahl.setFont(new Font("Tahoma", 1, 11));
        lblRaumzahl.setText("Raumanzahl:");
        JLabel lblWohnlage = new JLabel();
        lblWohnlage.setFont(new Font("Tahoma", 1, 11));
        lblWohnlage.setText("Wohnlage:");
        Integer anzahlGeschosse = (Integer)teileigentum.getProperty("anzahl_geschosse");
        if (anzahlGeschosse != null && anzahlGeschosse > -1) {
            teil.add(geschosse);
            teil.add(new JLabel(anzahlGeschosse.toString()));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        Float rel_kaufpreis = (Float)teileigentum.getProperty("rel_kaufpreis");
        if (rel_kaufpreis != null && rel_kaufpreis.floatValue() > -1.0f) {
            teil.add(kaufpreis);
            teil.add(new JLabel(rel_kaufpreis.toString()));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        String teilmarkt = (String)teileigentum.getProperty("teilmarkt");
        if (StringUtils.isNotBlank((String)teilmarkt)) {
            teil.add(tmarkt);
            teil.add(new JLabel(teilmarkt.trim()));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        String vermietungssituation = (String)teileigentum.getProperty("vermietungssituation");
        if (StringUtils.isNotBlank((String)vermietungssituation) && !"null".equals(vermietungssituation)) {
            teil.add(vermietung);
            teil.add(new JLabel(vermietungssituation));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        String ausstattungsstandard = (String)teileigentum.getProperty("ausstattungstsandard");
        if (StringUtils.isNotBlank((String)ausstattungsstandard) && !"null".equals(ausstattungsstandard)) {
            teil.add(ausstattung);
            teil.add(new JLabel(ausstattungsstandard));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        Integer modernisierungsjahr = (Integer)teileigentum.getProperty("modernisierungsjahr");
        if (modernisierungsjahr != null && modernisierungsjahr > -1) {
            teil.add(modernisierung);
            teil.add(new JLabel(modernisierungsjahr.toString()));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        Integer raumzahl = (Integer)teileigentum.getProperty("raumzahl");
        if (raumzahl != null && raumzahl > -1) {
            teil.add(lblRaumzahl);
            teil.add(new JLabel(raumzahl.toString()));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        String wohnlage = (String)teileigentum.getProperty("wohnlage");
        if (StringUtils.isNotBlank((String)wohnlage) && !"null".equals(wohnlage)) {
            teil.add(lblWohnlage);
            teil.add(new JLabel(wohnlage));
        } else {
            ((GridLayout)teil.getLayout()).setRows(--c);
        }
        round.add((Component)teil, (Object)"Center");
        return round;
    }
}

