/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import com.guigarage.jgrid.JGrid;
import com.guigarage.jgrid.renderer.GridCellRenderer;
import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObject;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXImagePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Sb_stadtbildserieGridRenderer
extends JPanel
implements GridCellRenderer {
    private static final Logger LOG = Logger.getLogger(Sb_stadtbildserieGridRenderer.class);
    private Image image;
    private boolean paintMarker = false;
    private float markerFraction;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLayeredPane jLayeredPane1;
    private JLabel lblAmount;
    private JXImagePanel pnlBullet;
    private JPanel pnlBulletPoint;
    private JXImagePanel pnlImage;
    private JPanel pnlMarker;

    public Sb_stadtbildserieGridRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.pnlBulletPoint = new JPanel();
        this.pnlBullet = new JXImagePanel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblAmount = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.pnlMarker = new MarkerPanel();
        this.pnlImage = new JXImagePanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(64, 64));
        this.setLayout(new GridBagLayout());
        this.jLayeredPane1.setLayout(new GridBagLayout());
        this.pnlBulletPoint.setMaximumSize(new Dimension(51, 16));
        this.pnlBulletPoint.setMinimumSize(new Dimension(51, 16));
        this.pnlBulletPoint.setOpaque(false);
        this.pnlBulletPoint.setPreferredSize(new Dimension(51, 16));
        this.pnlBulletPoint.setLayout(new GridBagLayout());
        this.pnlBullet.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieGridRenderer.class, (String)"Sb_stadtbildserieGridRenderer.pnlBullet.toolTipText"));
        this.pnlBullet.setMinimumSize(new Dimension(16, 16));
        this.pnlBullet.setName("");
        this.pnlBullet.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlBulletPoint.add((Component)this.pnlBullet, gridBagConstraints);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_red.png"));
            this.pnlBullet.setImage((Image)image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlBulletPoint.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 20;
        this.jLayeredPane1.add((Component)this.pnlBulletPoint, gridBagConstraints);
        this.jLayeredPane1.setLayer(this.pnlBulletPoint, 3);
        this.lblAmount.setBackground(new Color(190, 187, 182));
        this.lblAmount.setForeground(new Color(0, 0, 0));
        this.lblAmount.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblAmount, (String)NbBundle.getMessage(Sb_stadtbildserieGridRenderer.class, (String)"Sb_stadtbildserieGridRenderer.lblAmount.text"));
        this.lblAmount.setMaximumSize(new Dimension(51, 16));
        this.lblAmount.setMinimumSize(new Dimension(51, 16));
        this.lblAmount.setPreferredSize(new Dimension(51, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 20;
        this.jLayeredPane1.add((Component)this.lblAmount, gridBagConstraints);
        this.jLayeredPane1.setLayer(this.lblAmount, 2);
        this.pnlMarker.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jLayeredPane1.add((Component)this.pnlMarker, gridBagConstraints);
        this.jLayeredPane1.setLayer(this.pnlMarker, 1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jLayeredPane1.add((Component)this.pnlImage, gridBagConstraints);
        this.jLayeredPane1.setLayer((Component)this.pnlImage, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jLayeredPane1.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLayeredPane1, gridBagConstraints);
    }

    public Component getGridCellRendererComponent(JGrid grid, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.image = null;
        this.paintMarker = false;
        int fixedCellDimension = grid.getFixedCellDimension();
        this.pnlImage.setPreferredSize(new Dimension(fixedCellDimension, fixedCellDimension));
        if (value instanceof Sb_stadtbildserieGridObject) {
            Sb_stadtbildserieGridObject gridObject = (Sb_stadtbildserieGridObject)value;
            this.image = gridObject.getImage(fixedCellDimension, false);
            this.markerFraction = gridObject.getFraction();
            this.paintMarker = gridObject.isMarker();
            int amountImages = gridObject.getAmountImages();
            int amountSelectedImages = gridObject.getAmountSelectedImages();
            Sb_RestrictionLevelUtils.BulletPointSettings pointSettings = gridObject.determineBulletPointColor();
            this.setBulletPointColor(pointSettings);
            this.lblAmount.setText(amountSelectedImages + " von " + amountImages);
        }
        if (this.image != null) {
            this.pnlImage.setImage(this.image);
        } else {
            Image scaledErrorImage;
            this.image = scaledErrorImage = StadtbilderUtils.scaleImage(StadtbilderUtils.ERROR_IMAGE, grid.getFixedCellDimension(), false);
            this.pnlImage.setImage(scaledErrorImage);
        }
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point bulletPointCoordinates = SwingUtilities.convertPoint(this, event.getPoint(), this.pnlBulletPoint);
        if (this.pnlBullet.getBounds().contains(bulletPointCoordinates)) {
            return this.pnlBullet.getToolTipText(event);
        }
        return super.getToolTipText(event);
    }

    private void setBulletPointColor(Sb_RestrictionLevelUtils.BulletPointSettings pointSettings) {
        if (pointSettings == null) {
            this.pnlBullet.setToolTipText(null);
            this.pnlBullet.setImage(null);
        } else {
            this.pnlBullet.setToolTipText(pointSettings.getTooltipText());
            this.pnlBullet.setImage(pointSettings.getColorImage());
        }
    }

    class MarkerPanel
    extends JPanel {
        MarkerPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setComposite(AlphaComposite.getInstance(3));
            if (Sb_stadtbildserieGridRenderer.this.image != null) {
                if (Sb_stadtbildserieGridRenderer.this.paintMarker) {
                    int x = (int)((float)this.getWidth() * Sb_stadtbildserieGridRenderer.this.markerFraction);
                    g2.setStroke(new BasicStroke(3.5f));
                    g2.setColor(new Color(50, 50, 50));
                    g2.drawLine(x, 0, x, this.getHeight());
                    g2.setStroke(new BasicStroke(2.5f));
                    g2.setColor(new Color(248, 211, 80));
                    g2.drawLine(x, 0, x, this.getHeight());
                }
                g2.dispose();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setComposite(AlphaComposite.getInstance(3));
            if (Sb_stadtbildserieGridRenderer.this.image != null) {
                if (Sb_stadtbildserieGridRenderer.this.paintMarker) {
                    int x = (int)((float)this.getWidth() * Sb_stadtbildserieGridRenderer.this.markerFraction);
                    g2.setStroke(new BasicStroke(3.5f));
                    g2.setColor(new Color(50, 50, 50));
                    g2.drawLine(x, 0, x, this.getHeight());
                    g2.setStroke(new BasicStroke(2.5f));
                    g2.setColor(new Color(248, 211, 80));
                    g2.drawLine(x, 0, x, this.getHeight());
                }
                g2.dispose();
            }
        }
    }
}

