/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.TableModelIndexConvertingToViewIndexComparator;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.actions.VermessungsrissReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.BackgroundTaskMultipleDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VermessungRissAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(VermessungRissAggregationRenderer.class);
    private static final double BUFFER = 0.005;
    private static final ImageIcon ICON_LOADING = new ImageIcon(VermessungRissAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_yellow.png"));
    private static final ImageIcon ICON_FOUND = new ImageIcon(VermessungRissAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_green.png"));
    private static final ImageIcon ICON_NOTFOUND = new ImageIcon(VermessungRissAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_red.png"));
    private static final ImageIcon ICON_ERROR = new ImageIcon(VermessungRissAggregationRenderer.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_red.png"));
    private static final Class[] AGR_COMLUMN_CLASSES = new Class[]{Boolean.class, Integer.class, String.class, String.class, Integer.class, Integer.class, String.class, Boolean.class, Boolean.class};
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Auswahl", "Schl\u00fcssel", "Gemarkung", "Flur", "Blatt", "Jahr", "Format", "Riss", "Erg."};
    private static final String[] AGR_PROPERTY_NAMES = new String[]{null, "schluessel", "gemarkung.name", "flur", "blatt", "jahr", "format.name", null, null};
    private static final int[] AGR_COMLUMN_WIDTH = new int[]{40, 40, 100, 60, 40, 60, 80, 30, 30};
    private List<CidsBean> cidsBeans;
    private String title = "";
    private Map<CidsBean, CidsFeature> features;
    private Comparator<Integer> tableComparator;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private boolean allowErgaenzendeDokumenteReport = false;
    private boolean allowVermessungsrisseReport = false;
    private final Map<CidsBean, Boolean> rissCheckerMap = new HashMap<CidsBean, Boolean>();
    private final Map<CidsBean, Exception> rissCheckerExceptionMap = new HashMap<CidsBean, Exception>();
    private final Map<CidsBean, Boolean> ergCheckerMap = new HashMap<CidsBean, Boolean>();
    private final Map<CidsBean, Exception> ergCheckerExceptionMap = new HashMap<CidsBean, Exception>();
    private final Map<CidsBean, Boolean> risseSelectionMap = new HashMap<CidsBean, Boolean>();
    private JButton btnGenerateReport;
    private JComboBox cmbType;
    private Box.Filler flrGap;
    private JLabel lblJobnumber;
    private JLabel lblProjectname;
    private JLabel lblType;
    private MappingComponent mappingComponent;
    private JPanel panMap;
    private JPanel pnlReport;
    private JScrollPane scpRisse;
    private JTable tblRisse;
    private JTextField txtJobnumber;
    private JTextField txtProjectname;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.scpRisse.getViewport().setOpaque(false);
        this.tblRisse.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.tblRisse.getColumnModel().getColumn(7).setCellRenderer(new PictureStateCellRenderer(false));
        this.tblRisse.getColumnModel().getColumn(8).setCellRenderer(new PictureStateCellRenderer(true));
        this.tableComparator = new TableModelIndexConvertingToViewIndexComparator(this.tblRisse);
        TableColumnModel cModel = this.tblRisse.getColumnModel();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            cModel.getColumn(i).setPreferredWidth(AGR_COMLUMN_WIDTH[i]);
        }
        TableRowSorter<TableModel> tableSorter = ObjectRendererUtils.decorateTableWithSorter(this.tblRisse);
        LinkedList<RowSorter.SortKey> sortKeys = new LinkedList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(3, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(4, SortOrder.DESCENDING));
        tableSorter.setSortKeys(sortKeys);
    }

    public void animateToOverview() {
        this.mappingComponent.gotoInitialBoundingBox();
        Rectangle2D viewBounds = this.mappingComponent.getCamera().getViewBounds().getBounds2D();
        double scale = this.mappingComponent.getScaleDenominator();
        double newX = (viewBounds.getX() / scale - 0.005) * scale;
        double newY = (viewBounds.getY() / scale - 0.005) * scale;
        double newWidth = (viewBounds.getWidth() / scale + 0.01) * scale;
        double newHeight = (viewBounds.getHeight() / scale + 0.01) * scale;
        viewBounds.setRect(newX, newY, newWidth, newHeight);
        this.mappingComponent.getCamera().animateViewToCenterBounds(viewBounds, true, (long)this.mappingComponent.getAnimationDuration());
    }

    private void initComponents() {
        this.scpRisse = new JScrollPane();
        this.tblRisse = new JTable();
        this.panMap = new JPanel();
        this.mappingComponent = new MappingComponent();
        this.pnlReport = new JPanel();
        this.flrGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblProjectname = new JLabel();
        this.txtProjectname = new JTextField();
        this.lblJobnumber = new JLabel();
        this.txtJobnumber = new JTextField();
        this.btnGenerateReport = new JButton();
        this.cmbType = new JComboBox();
        this.lblType = new JLabel();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                VermessungRissAggregationRenderer.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setLayout(new GridBagLayout());
        this.tblRisse.setModel(new PointTableModel());
        this.tblRisse.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                VermessungRissAggregationRenderer.this.tblRisseFocusLost(evt);
            }
        });
        this.scpRisse.setViewportView(this.tblRisse);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.scpRisse, gridBagConstraints);
        this.panMap.setMaximumSize(new Dimension(300, 450));
        this.panMap.setMinimumSize(new Dimension(300, 450));
        this.panMap.setOpaque(false);
        this.panMap.setPreferredSize(new Dimension(300, 450));
        this.panMap.setLayout(new GridBagLayout());
        this.mappingComponent.setBorder(BorderFactory.createEtchedBorder());
        this.mappingComponent.setMaximumSize(new Dimension(100, 100));
        this.mappingComponent.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panMap.add((Component)this.mappingComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.panMap, gridBagConstraints);
        this.pnlReport.setOpaque(false);
        this.pnlReport.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.pnlReport.add((Component)this.flrGap, gridBagConstraints);
        this.lblProjectname.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.lblProjectname.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.lblProjectname, gridBagConstraints);
        this.txtProjectname.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.txtProjectname.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.txtProjectname, gridBagConstraints);
        this.lblJobnumber.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.lblJobnumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.lblJobnumber, gridBagConstraints);
        this.txtJobnumber.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.txtJobnumber.text"));
        this.txtJobnumber.setMaximumSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.txtJobnumber, gridBagConstraints);
        this.btnGenerateReport.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.btnGenerateReport.text"));
        this.btnGenerateReport.setToolTipText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.btnGenerateReport.toolTipText"));
        this.btnGenerateReport.setFocusPainted(false);
        this.btnGenerateReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungRissAggregationRenderer.this.btnGenerateReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlReport.add((Component)this.btnGenerateReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.pnlReport.add((Component)this.cmbType, gridBagConstraints);
        this.lblType.setText(NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.lblType.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.pnlReport.add((Component)this.lblType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.pnlReport, gridBagConstraints);
    }

    private void tblRisseFocusLost(FocusEvent evt) {
        this.tblRisse.clearSelection();
        this.animateToOverview();
    }

    private void btnGenerateReportActionPerformed(ActionEvent evt) {
        final Collection<CidsBean> selectedVermessungsrisse = this.getSelectedVermessungsrisse();
        if (selectedVermessungsrisse.isEmpty()) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.btnGenerateReportActionPerformed(ActionEvent).emptySelection.message"), NbBundle.getMessage(VermessungRissAggregationRenderer.class, (String)"VermessungRissAggregationRenderer.btnGenerateReportActionPerformed(ActionEvent).emptySelection.title"), 1);
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Object typeObj = VermessungRissAggregationRenderer.this.cmbType.getSelectedItem();
                if (typeObj instanceof String) {
                    String type = (String)typeObj;
                    HashMap<String, Map<String, Integer>> productGroupExts = new HashMap<String, Map<String, Integer>>();
                    try {
                        for (CidsBean selectedVermessungsriss : selectedVermessungsrisse) {
                            boolean isDocumentAvailable;
                            Map<String, Integer> priceGroups;
                            String productGroupExt = (String)selectedVermessungsriss.getProperty("format.productgroup_ext");
                            if (productGroupExts.containsKey(productGroupExt)) {
                                priceGroups = (Map)productGroupExts.get(productGroupExt);
                            } else {
                                priceGroups = new HashMap();
                                productGroupExts.put(productGroupExt, priceGroups);
                            }
                            if (!(isDocumentAvailable = type.equalsIgnoreCase("Vermessungsrisse") ? (Boolean)VermessungRissAggregationRenderer.this.rissCheckerMap.get(selectedVermessungsriss) : (type.equalsIgnoreCase("Erg\u00e4nzende Dokumente") ? (Boolean)VermessungRissAggregationRenderer.this.ergCheckerMap.get(selectedVermessungsriss) : false))) continue;
                            String pricegroup = (String)selectedVermessungsriss.getProperty("format.pricegroup");
                            Integer amount = (Integer)priceGroups.get(pricegroup);
                            if (amount == null) {
                                priceGroups.put(pricegroup, 1);
                                continue;
                            }
                            Integer newAmount = amount + 1;
                            priceGroups.put(pricegroup, newAmount);
                        }
                        if (productGroupExts.size() > 1 && SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "billing.mode@WUNDA_BLAU", VermessungRissAggregationRenderer.this.getConnectionContext())) {
                            JOptionPane.showMessageDialog(VermessungRissAggregationRenderer.this, "<html>Es wurden Produkte zum Download ausgew\u00e4hlt,<br>die auf unterschiedliche Weise abgerechnet werden.<br>Daher werden nun mehrere Download-Protokolle erzeugt.", "Mehrere Download-Protokolle", 1);
                        }
                        boolean downloadBilder = false;
                        boolean downloadGrenzniederschriften = false;
                        for (String productGroupExt : productGroupExts.keySet()) {
                            Map priceGroups = (Map)productGroupExts.get(productGroupExt);
                            Set keys = priceGroups.keySet();
                            BillingProductGroupAmount[] amounts = new BillingProductGroupAmount[keys.size()];
                            int i = 0;
                            for (String k : keys) {
                                amounts[i] = new BillingProductGroupAmount(k, ((Integer)priceGroups.get(k)).intValue());
                                ++i;
                            }
                            if (type.equalsIgnoreCase("Vermessungsrisse")) {
                                if (!BillingPopup.doBilling("vrpdf" + (productGroupExt != null ? productGroupExt : ""), "no.yet", (Geometry)null, VermessungRissAggregationRenderer.this.getConnectionContext(), amounts)) continue;
                                downloadBilder = true;
                                continue;
                            }
                            if (!type.equalsIgnoreCase("Erg\u00e4nzende Dokumente") || !BillingPopup.doBilling("doklapdf" + (productGroupExt != null ? productGroupExt : ""), "no.yet", (Geometry)null, VermessungRissAggregationRenderer.this.getConnectionContext(), amounts)) continue;
                            downloadGrenzniederschriften = true;
                        }
                        if (downloadBilder) {
                            VermessungRissAggregationRenderer.this.downloadProducts(selectedVermessungsrisse, type, ClientAlkisConf.getInstance().getVermessungHostBilder());
                        }
                        if (downloadGrenzniederschriften) {
                            VermessungRissAggregationRenderer.this.downloadProducts(selectedVermessungsrisse, type, ClientAlkisConf.getInstance().getVermessungHostGrenzniederschriften());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                    }
                } else {
                    LOG.info((Object)("Unknown type '" + typeObj + "' encountered. Skipping report generation."));
                }
                return null;
            }
        }.execute();
    }

    private Collection<URL> identifyAdditionalFiles(Collection<CidsBean> selectedVermessungsrisse, String host) {
        LinkedList<URL> additionalFilesToDownload = new LinkedList<URL>();
        for (CidsBean vermessungsriss : selectedVermessungsrisse) {
            String blatt;
            String flur;
            Integer gemarkung;
            String schluessel;
            try {
                schluessel = vermessungsriss.getProperty("schluessel").toString();
                gemarkung = (Integer)vermessungsriss.getProperty("gemarkung.id");
                flur = vermessungsriss.getProperty("flur").toString();
                blatt = vermessungsriss.getProperty("blatt").toString();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not include raster document for vermessungsriss '" + vermessungsriss.toJSONString(true) + "'."), (Throwable)ex);
                continue;
            }
            String document = host.equals(ClientAlkisConf.getInstance().getVermessungHostGrenzniederschriften()) ? VermessungPictureFinderClientUtils.findGrenzniederschriftPicture(schluessel, gemarkung, flur, blatt) : VermessungPictureFinderClientUtils.findVermessungsrissPicture(schluessel, gemarkung, flur, blatt);
            if (document == null) {
                LOG.info((Object)"No document URLS found for the Vermessungsriss report");
            }
            boolean isOfReducedSize = false;
            if (document == null) continue;
            try {
                URL url = ClientAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (url.toString().contains("_rs")) {
                    isOfReducedSize = true;
                }
                if (!isOfReducedSize) break;
                additionalFilesToDownload.add(new URL(url.toString().replaceAll("_rs", "")));
                break;
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not read document from URL '" + document + "'. Skipping this url."), (Throwable)ex);
            }
        }
        return additionalFilesToDownload;
    }

    private void downloadProducts(final Collection<CidsBean> selectedVermessungsrisse, final String type, final String host) {
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
            String projectname = this.txtProjectname.getText();
            if (projectname == null || projectname.trim().length() == 0) {
                projectname = type;
            }
            final String finalProjectname = projectname;
            BackgroundTaskMultipleDownload.FetchDownloadsTask fetchDownloadsTask = new BackgroundTaskMultipleDownload.FetchDownloadsTask(){

                public Collection<? extends Download> fetchDownloads() throws Exception {
                    ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>(selectedVermessungsrisse.size());
                    for (CidsBean selectedVermessungsriss : selectedVermessungsrisse) {
                        mons.add(new MetaObjectNode(selectedVermessungsriss));
                    }
                    ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(VermessungsrissReportServerAction.Parameter.RISSE_MONS.toString(), mons), new ServerActionParameter(VermessungsrissReportServerAction.Parameter.JOB_NUMBER.toString(), (Object)VermessungRissAggregationRenderer.this.txtJobnumber.getText()), new ServerActionParameter(VermessungsrissReportServerAction.Parameter.PROJECT_NAME.toString(), (Object)VermessungRissAggregationRenderer.this.txtProjectname.getText()), new ServerActionParameter(VermessungsrissReportServerAction.Parameter.HOST.toString(), (Object)host)};
                    String jobname = DownloadManagerDialog.getInstance().getJobName();
                    ByteArrayActionDownload serverActionDownload = new ByteArrayActionDownload("vermessungsrissReport", null, saps, finalProjectname, jobname, "Vermessungsrisse".equalsIgnoreCase(type) ? "vermriss" : "ergdok", ".pdf", VermessungRissAggregationRenderer.this.getConnectionContext());
                    ArrayList<ByteArrayActionDownload> downloads = new ArrayList<ByteArrayActionDownload>();
                    downloads.add(serverActionDownload);
                    Collection additionalFilesToDownload = VermessungRissAggregationRenderer.this.identifyAdditionalFiles(selectedVermessungsrisse, host);
                    if (!additionalFilesToDownload.isEmpty()) {
                        for (URL additionalFileToDownload : additionalFilesToDownload) {
                            String file = additionalFileToDownload.getFile().substring(additionalFileToDownload.getFile().lastIndexOf(47) + 1);
                            String filename = file.substring(0, file.lastIndexOf(46));
                            String extension = file.substring(file.lastIndexOf(46));
                            downloads.add((ByteArrayActionDownload)new HttpDownload(additionalFileToDownload, null, jobname, file, filename, extension));
                        }
                    }
                    return downloads;
                }
            };
            DownloadManager.instance().add((Download)new BackgroundTaskMultipleDownload(null, projectname, fetchDownloadsTask));
        }
    }

    private void formAncestorAdded(AncestorEvent evt) {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Sleeping to wait for zooming to added features was interrupted.", (Throwable)ex);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VermessungRissAggregationRenderer.this.animateToOverview();
                    }
                });
            }
        });
    }

    protected Collection<CidsBean> getSelectedVermessungsrisse() {
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        PointTableModel tableModel = this.getTableModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object includedObj = tableModel.getValueAt(i, 0);
            if (!(includedObj instanceof Boolean) || !((Boolean)includedObj).booleanValue()) continue;
            selectedIndexes.add(i);
        }
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        for (Integer selectedIndex : selectedIndexes) {
            result.add(this.cidsBeans.get(selectedIndex));
        }
        return result;
    }

    public List<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    private PointTableModel getTableModel() {
        return (PointTableModel)this.tblRisse.getModel();
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        if (beans instanceof List) {
            this.clearMaps();
            this.cidsBeans = (List)beans;
            this.features = new HashMap<CidsBean, CidsFeature>(beans.size());
            this.initMap();
            for (CidsBean cidsBean : beans) {
                this.risseSelectionMap.put(cidsBean, true);
            }
            this.getTableModel().refresh();
            for (CidsBean bean : beans) {
                new PictureWorker(bean, true).execute();
                new PictureWorker(bean, false).execute();
            }
            this.updateButtons();
        }
        this.setTitle(null);
    }

    private void updateButtons() {
        boolean enabled;
        boolean billingAllowed = BillingPopup.isBillingAllowed("doklapdf", this.getConnectionContext()) || BillingPopup.isBillingAllowed("vrpdf", this.getConnectionContext());
        boolean bl = enabled = billingAllowed && (this.allowErgaenzendeDokumenteReport && this.allowVermessungsrisseReport || this.allowErgaenzendeDokumenteReport || this.allowVermessungsrisseReport);
        if (this.allowErgaenzendeDokumenteReport && this.allowVermessungsrisseReport) {
            this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Vermessungsrisse", "Erg\u00e4nzende Dokumente"}));
        } else if (this.allowErgaenzendeDokumenteReport) {
            this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Erg\u00e4nzende Dokumente"}));
        } else if (this.allowVermessungsrisseReport) {
            this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Vermessungsrisse"}));
        }
        this.cmbType.setEnabled(enabled);
        this.btnGenerateReport.setEnabled(enabled);
        this.txtJobnumber.setEnabled(enabled);
        this.txtProjectname.setEnabled(enabled);
    }

    public void dispose() {
        this.mappingComponent.dispose();
        this.clearMaps();
    }

    public void clearMaps() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rissCheckerMap.clear();
            this.rissCheckerExceptionMap.clear();
            this.ergCheckerMap.clear();
            this.ergCheckerExceptionMap.clear();
            this.risseSelectionMap.clear();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VermessungRissAggregationRenderer.this.clearMaps();
                }
            });
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String desc = "Vermessungsrisse";
        List<CidsBean> beans = this.cidsBeans;
        if (beans != null && beans.size() > 0) {
            desc = desc + " - " + beans.size() + " Vermessungsrisse ausgew\u00e4hlt";
        }
        this.title = desc;
    }

    protected void initMap() {
        try {
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            XBoundingBox box = this.boundingBoxFromPointList(this.cidsBeans);
            mappingModel.addHome(new XBoundingBox(-0.5, -0.5, 0.5, 0.5, ClientAlkisConf.getInstance().getSrsService(), true));
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getRasterfariUrl()));
            swms.setName("Vermessung_Riss");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            this.mappingComponent.setMappingModel((MappingModel)mappingModel);
            this.mappingComponent.setAnimationDuration(0);
            this.mappingComponent.gotoInitialBoundingBox();
            this.mappingComponent.setInteractionMode("ZOOM");
            this.mappingComponent.unlock();
            for (CidsBean cidsBean : this.cidsBeans) {
                CidsFeature feature = new CidsFeature(cidsBean.getMetaObject());
                this.features.put(cidsBean, feature);
            }
            this.mappingComponent.getFeatureCollection().addFeatures(this.features.values());
            this.mappingComponent.setAnimationDuration(500);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    protected XBoundingBox boundingBoxFromPointList(Collection<CidsBean> vermessungsrisse) {
        LinkedList<Geometry> geometries = new LinkedList<Geometry>();
        for (CidsBean vermessungsriss : vermessungsrisse) {
            try {
                if (!(vermessungsriss.getProperty("geometrie.geo_field") instanceof Geometry)) continue;
                geometries.add((Geometry)vermessungsriss.getProperty("geometrie.geo_field"));
            }
            catch (Exception ex) {
                LOG.warn((Object)"Could not add geometry to create a bounding box.", (Throwable)ex);
            }
        }
        GeometryCollection geoCollection = new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]), new GeometryFactory());
        return new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
    }

    private static boolean hasVermessungsriss(CidsBean cidsBean) {
        try {
            return VermessungPictureFinderClientUtils.findVermessungsrissPicture((String)cidsBean.getProperty("schluessel"), (Integer)cidsBean.getProperty("gemarkung.id"), (String)cidsBean.getProperty("flur"), (String)cidsBean.getProperty("blatt")) != null;
        }
        catch (Exception ex) {
            LOG.info((Object)"Could not determine if CidsBean has measurement sketches.", (Throwable)ex);
            return false;
        }
    }

    private static boolean hasErgaenzendeDokumente(CidsBean cidsBean) {
        try {
            return VermessungPictureFinderClientUtils.findGrenzniederschriftPicture((String)cidsBean.getProperty("schluessel"), (Integer)cidsBean.getProperty("gemarkung.id"), (String)cidsBean.getProperty("flur"), (String)cidsBean.getProperty("blatt")) != null;
        }
        catch (Exception ex) {
            LOG.info((Object)"Could not determine if CidsBean has measurement sketches.", (Throwable)ex);
            return false;
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class PointTableModel
    extends DefaultTableModel {
        PointTableModel() {
        }

        public void refresh() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PointTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getRowCount() {
            return VermessungRissAggregationRenderer.this.cidsBeans != null ? VermessungRissAggregationRenderer.this.cidsBeans.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return AGR_COMLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return AGR_COMLUMN_NAMES[column];
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CidsBean cidsBean = (CidsBean)VermessungRissAggregationRenderer.this.cidsBeans.get(row);
            if (column == 0) {
                if (value instanceof Boolean) {
                    VermessungRissAggregationRenderer.this.risseSelectionMap.put(cidsBean, (Boolean)value);
                } else {
                    VermessungRissAggregationRenderer.this.risseSelectionMap.remove(cidsBean);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            CidsBean cidsBean = (CidsBean)VermessungRissAggregationRenderer.this.cidsBeans.get(row);
            switch (column) {
                case 0: {
                    return VermessungRissAggregationRenderer.this.risseSelectionMap.get(cidsBean);
                }
                case 7: {
                    return VermessungRissAggregationRenderer.this.rissCheckerMap.get(cidsBean);
                }
                case 8: {
                    return VermessungRissAggregationRenderer.this.ergCheckerMap.get(cidsBean);
                }
            }
            if (column >= 0 && column < AGR_PROPERTY_NAMES.length) {
                return cidsBean != null ? cidsBean.getProperty(AGR_PROPERTY_NAMES[column]) : null;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return AGR_COMLUMN_CLASSES[columnIndex];
        }
    }

    class PictureStateCellRenderer
    extends DefaultTableCellRenderer {
        private final boolean erg;

        public PictureStateCellRenderer(boolean erg) {
            this.erg = erg;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CidsBean cidsBean = (CidsBean)VermessungRissAggregationRenderer.this.cidsBeans.get(VermessungRissAggregationRenderer.this.tblRisse.getRowSorter().convertRowIndexToModel(row));
            Exception ex = (Exception)(this.erg ? VermessungRissAggregationRenderer.this.ergCheckerExceptionMap : VermessungRissAggregationRenderer.this.rissCheckerExceptionMap).get(cidsBean);
            Boolean status = (Boolean)(this.erg ? VermessungRissAggregationRenderer.this.ergCheckerMap : VermessungRissAggregationRenderer.this.rissCheckerMap).get(cidsBean);
            if (ex != null) {
                JLabel label = new JLabel(ICON_ERROR);
                label.setToolTipText(ex.getMessage());
                return label;
            }
            if (Boolean.TRUE.equals(status)) {
                return new JLabel(ICON_FOUND);
            }
            if (Boolean.FALSE.equals(status)) {
                return new JLabel(ICON_NOTFOUND);
            }
            return new JLabel(ICON_LOADING);
        }
    }

    class SelectionCellRenderer
    extends DefaultTableCellRenderer {
        SelectionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new SelectionCheckBox((CidsBean)VermessungRissAggregationRenderer.this.cidsBeans.get(VermessungRissAggregationRenderer.this.tblRisse.getRowSorter().convertRowIndexToModel(row)));
        }
    }

    class SelectionCheckBox
    extends JCheckBox {
        public SelectionCheckBox(final CidsBean cidsBean) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    VermessungRissAggregationRenderer.this.risseSelectionMap.put(cidsBean, SelectionCheckBox.this.isSelected());
                }
            });
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || VermessungRissAggregationRenderer.this.cidsBeans == null) {
                return;
            }
            CidsFeature featureToSelect = null;
            int[] indexes = VermessungRissAggregationRenderer.this.tblRisse.getSelectedRows();
            if (indexes != null && indexes.length > 0) {
                for (int viewIdx : indexes) {
                    int modelIdx = VermessungRissAggregationRenderer.this.tblRisse.getRowSorter().convertRowIndexToModel(viewIdx);
                    if (modelIdx <= -1 || modelIdx >= VermessungRissAggregationRenderer.this.cidsBeans.size()) continue;
                    CidsBean selectedBean = (CidsBean)VermessungRissAggregationRenderer.this.cidsBeans.get(modelIdx);
                    featureToSelect = (CidsFeature)VermessungRissAggregationRenderer.this.features.get(selectedBean);
                    break;
                }
            }
            if (featureToSelect != null && featureToSelect.getGeometry() != null) {
                XBoundingBox boxToGoto = new XBoundingBox(featureToSelect.getGeometry().getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                VermessungRissAggregationRenderer.this.mappingComponent.getFeatureCollection().unselectAll();
                VermessungRissAggregationRenderer.this.mappingComponent.getFeatureCollection().select((Feature)featureToSelect);
                VermessungRissAggregationRenderer.this.mappingComponent.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
            } else {
                VermessungRissAggregationRenderer.this.mappingComponent.getFeatureCollection().unselectAll();
                VermessungRissAggregationRenderer.this.mappingComponent.gotoInitialBoundingBox();
            }
        }
    }

    public class PictureWorker
    extends SwingWorker<Boolean, Void> {
        final boolean rissOrErg;
        private final CidsBean cidsBean;

        public PictureWorker(CidsBean cidsBean, boolean rissOrErg) {
            this.cidsBean = cidsBean;
            this.rissOrErg = rissOrErg;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return this.rissOrErg ? VermessungRissAggregationRenderer.hasVermessungsriss(this.cidsBean) : VermessungRissAggregationRenderer.hasErgaenzendeDokumente(this.cidsBean);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            Map checkerMap = this.rissOrErg ? VermessungRissAggregationRenderer.this.rissCheckerMap : VermessungRissAggregationRenderer.this.ergCheckerMap;
            Map exceptionMap = this.rissOrErg ? VermessungRissAggregationRenderer.this.rissCheckerExceptionMap : VermessungRissAggregationRenderer.this.ergCheckerExceptionMap;
            try {
                checkerMap.put(this.cidsBean, this.get());
                VermessungRissAggregationRenderer.this.getTableModel().refresh();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                checkerMap.put(this.cidsBean, null);
                exceptionMap.put(this.cidsBean, ex);
            }
            finally {
                if (checkerMap.size() == VermessungRissAggregationRenderer.this.cidsBeans.size()) {
                    boolean allowReport = false;
                    for (Boolean value : checkerMap.values()) {
                        if (!Boolean.TRUE.equals(value)) continue;
                        allowReport = true;
                        break;
                    }
                    if (this.rissOrErg) {
                        VermessungRissAggregationRenderer.this.allowVermessungsrisseReport = allowReport;
                    } else {
                        VermessungRissAggregationRenderer.this.allowErgaenzendeDokumenteReport = allowReport;
                    }
                    VermessungRissAggregationRenderer.this.updateButtons();
                }
            }
        }
    }
}

