/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.orbit;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.orbit.OrbitControlFeature;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class OrbitViewerToolbarComponentProvider
implements ToolbarComponentsProvider,
ConnectionContextStore,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(OrbitViewerToolbarComponentProvider.class);
    private static final String CONFIG_ATTR = "custom.orbit.toolbarButton@WUNDA_BLAU";
    private List<ToolbarComponentDescription> toolbarComponents;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        if (OrbitViewerToolbarComponentProvider.validateUserConfigAttr(connectionContext)) {
            try {
                ArrayList preparationList = TypeSafeCollections.newArrayList();
                ToolbarComponentDescription description = new ToolbarComponentDescription("tlbMain", (JComponent)new OrbitViewerControlJButton(connectionContext), ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdPan");
                preparationList.add(description);
                this.toolbarComponents = Collections.unmodifiableList(preparationList);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error during loading of the Orbit ServerRessources", (Throwable)ex);
                this.toolbarComponents = Collections.emptyList();
            }
        }
    }

    public static boolean validateUserConfigAttr(ConnectionContext connectionContext) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), CONFIG_ATTR, connectionContext);
        }
        catch (ConnectionException ex) {
            LOG.info((Object)"Could not validate action tag:custom.orbit.toolbarButton@WUNDA_BLAU", (Throwable)ex);
            return false;
        }
    }

    public List<ToolbarComponentDescription> getToolbarComponents() {
        return this.toolbarComponents;
    }

    public String getPluginName() {
        return "OrbitViewerControl";
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "OrbitViewerControlPlugin";
        }
        return null;
    }

    public Component getComponent() {
        return new OrbitViewerControlJButton(this.connectionContext);
    }

    final class OrbitViewerControlJButton
    extends JButton {
        public OrbitViewerControlJButton(ConnectionContext connectionContext) {
            this.setText(null);
            this.setToolTipText("OrbitViewer");
            this.setName("OrbitViewerControl");
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/orbitviewer/orbit22.png")));
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrbitControlFeature.controlOrAddOnMap(OrbitViewerToolbarComponentProvider.this.getConnectionContext());
                }
            });
        }
    }
}

