/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class BillingBuchungsbelegReport {
    private static final String REPORT_BUCHUNGSBELEG_URL = "/de/cismet/cids/custom/reports/wunda_blau/buchungsbeleg.jasper";
    private static final String REPORT_RECHNUNGSANLAGE_URL = "/de/cismet/cids/custom/reports/wunda_blau/rechnungsanlage.jasper";
    SwingWorker<JasperPrint, Void> downloadWorker;
    private CidsBean kundeBean;
    private Collection<CidsBean> billingBeansOhneMwst;
    private Collection<CidsBean> billingBeansBaulastenOhneMwst;
    private Collection<CidsBean> billingBeansKatasterOhneMwst;
    private BigDecimal nettoSummeOhneMwst;
    private BigDecimal bruttoSummeOhneMwst;
    private BigDecimal katasterNettoSummeOhneMwst;
    private BigDecimal katasterBruttoSummeOhneMwst;
    private BigDecimal baulastenNettoSummeOhneMwst;
    private BigDecimal baulastenBruttoSummeOhneMwst;
    private Collection<CidsBean> billingBeansMitMwst;
    private BigDecimal nettoSummeMitMwst;
    private BigDecimal bruttoSummeMitMwst;
    private BigDecimal nettoSummeGesamt;
    private BigDecimal bruttoSummeGesamt;
    private Date from;
    private Date till;
    private boolean isRechnungsanlage;
    private int amountTotalDownloads;
    private int amountWithCosts;
    private int amountWithoutCosts;
    private int amountVUamtlicherLageplan;
    private int amountVUhoheitlicheVermessung;
    private int amountVUsonstige;
    private int amountEigenerGebrauch = 0;
    private int amountWiederverkauf = 0;
    private int amountEigenerGebrauchGeb\u00fchrenbefreit = 0;
    private int amountVUamtlicherLageplanGB = 0;
    private int amountVUhoheitlicheVermessungGB = 0;
    private int amountVUsonstigeGB = 0;
    private int amountEigenerGebrauchGB = 0;
    private int amountWiederverkaufGB = 0;
    private int amountEigenerGebrauchGeb\u00fchrenbefreitGB = 0;
    private Observer downloadObserver;

    public BillingBuchungsbelegReport(CidsBean kundeBean, Collection<CidsBean> filteredBillingsOhneMwst, BigDecimal nettoOhneMwst, BigDecimal bruttoOhneMwst, Collection<CidsBean> katasterBillingsOhneMwst, BigDecimal katasterNettoOhneMwst, BigDecimal katasterBruttoOhneMwst, Collection<CidsBean> baulastenBillingsOhneMwst, BigDecimal baulastenNettoOhneMwst, BigDecimal baulastenBruttoOhneMwst, Collection<CidsBean> filteredBuchungenMitMwst, BigDecimal nettoMitMwst, BigDecimal bruttoMitMwst, BigDecimal nettoGesamt, BigDecimal bruttoGesamt, Date from, Date till) {
        this(kundeBean, filteredBillingsOhneMwst, nettoOhneMwst, bruttoOhneMwst, katasterBillingsOhneMwst, katasterNettoOhneMwst, katasterBruttoOhneMwst, baulastenBillingsOhneMwst, baulastenNettoOhneMwst, baulastenBruttoOhneMwst, filteredBuchungenMitMwst, nettoMitMwst, bruttoMitMwst, nettoGesamt, bruttoGesamt, from, till, false, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public BillingBuchungsbelegReport(CidsBean kundeBean, Collection<CidsBean> filteredBillingsOhneMwst, BigDecimal nettoOhneMwst, BigDecimal bruttoOhneMwst, Collection<CidsBean> katasterBillingsOhneMwst, BigDecimal katasterNettoOhneMwst, BigDecimal katasterBruttoOhneMwst, Collection<CidsBean> baulastenBillingsOhneMwst, BigDecimal baulastenNettoOhneMwst, BigDecimal baulastenBruttoOhneMwst, Collection<CidsBean> filteredBuchungenMitMwst, BigDecimal nettoMitMwst, BigDecimal bruttoMitMwst, BigDecimal nettoGesamt, BigDecimal bruttoGesamt, Date from, Date till, boolean isRechnungsanlage, int amountTotalDownloads, int amountWithCosts, int amountWithoutCosts, int amountVUamtlicherLageplan, int amountVUhoheitlicheVermessung, int amountVUsonstige, int amountEigenerGebrauch, int amountWiederverkauf, int amountEigenerGebrauchGeb\u00fchrenbefreit, int amountVUamtlicherLageplanGB, int amountVUhoheitlicheVermessungGB, int amountVUsonstigeGB, int amountEigenerGebrauchGB, int amountWiederverkaufGB, int amountEigenerGebrauchGeb\u00fchrenbefreitGB) {
        this.kundeBean = kundeBean;
        this.billingBeansOhneMwst = filteredBillingsOhneMwst;
        this.nettoSummeOhneMwst = nettoOhneMwst;
        this.bruttoSummeOhneMwst = bruttoOhneMwst;
        this.billingBeansKatasterOhneMwst = katasterBillingsOhneMwst;
        this.katasterNettoSummeOhneMwst = katasterNettoOhneMwst;
        this.katasterBruttoSummeOhneMwst = katasterBruttoOhneMwst;
        this.billingBeansBaulastenOhneMwst = baulastenBillingsOhneMwst;
        this.baulastenNettoSummeOhneMwst = baulastenNettoOhneMwst;
        this.baulastenBruttoSummeOhneMwst = baulastenBruttoOhneMwst;
        this.billingBeansMitMwst = filteredBuchungenMitMwst;
        this.nettoSummeMitMwst = nettoMitMwst;
        this.bruttoSummeMitMwst = bruttoMitMwst;
        this.nettoSummeGesamt = nettoGesamt;
        this.bruttoSummeGesamt = bruttoGesamt;
        this.from = from;
        this.till = till;
        this.isRechnungsanlage = isRechnungsanlage;
        this.amountTotalDownloads = amountTotalDownloads;
        this.amountWithCosts = amountWithCosts;
        this.amountWithoutCosts = amountWithoutCosts;
        this.amountVUamtlicherLageplan = amountVUamtlicherLageplan;
        this.amountVUhoheitlicheVermessung = amountVUhoheitlicheVermessung;
        this.amountVUsonstige = amountVUsonstige;
        this.amountEigenerGebrauch = amountEigenerGebrauch;
        this.amountWiederverkauf = amountWiederverkauf;
        this.amountEigenerGebrauchGeb\u00fchrenbefreit = amountEigenerGebrauchGeb\u00fchrenbefreit;
        this.amountVUamtlicherLageplanGB = amountVUamtlicherLageplanGB;
        this.amountVUhoheitlicheVermessungGB = amountVUhoheitlicheVermessungGB;
        this.amountVUsonstigeGB = amountVUsonstigeGB;
        this.amountEigenerGebrauchGB = amountEigenerGebrauchGB;
        this.amountWiederverkaufGB = amountWiederverkaufGB;
        this.amountEigenerGebrauchGeb\u00fchrenbefreitGB = amountEigenerGebrauchGeb\u00fchrenbefreitGB;
    }

    public Map generateReportParam(CidsBean current) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("kundeBean", this.kundeBean);
        params.put("billingBeansOhneMwst", this.billingBeansOhneMwst);
        params.put("billingBeansKatasterOhneMwst", this.billingBeansKatasterOhneMwst);
        params.put("billingBeansBaulastenOhneMwst", this.billingBeansBaulastenOhneMwst);
        params.put("nettoSummeOhneMwst", this.nettoSummeOhneMwst);
        params.put("bruttoSummeOhneMwst", this.bruttoSummeOhneMwst);
        params.put("katasterNettoSummeOhneMwst", this.katasterNettoSummeOhneMwst);
        params.put("katasterBruttoSummeOhneMwst", this.katasterBruttoSummeOhneMwst);
        params.put("baulastenNettoSummeOhneMwst", this.baulastenNettoSummeOhneMwst);
        params.put("baulastenBruttoSummeOhneMwst", this.baulastenBruttoSummeOhneMwst);
        params.put("billingBeansMitMwst", this.billingBeansMitMwst);
        params.put("nettoSummeMitMwst", this.nettoSummeMitMwst);
        params.put("bruttoSummeMitMwst", this.bruttoSummeMitMwst);
        params.put("nettoSummeGesamt", this.nettoSummeGesamt);
        params.put("bruttoSummeGesamt", this.bruttoSummeGesamt);
        params.put("from", this.from);
        if (this.till == null) {
            params.put("till", this.from);
        } else {
            params.put("till", this.till);
        }
        params.put("isRechnungsanlage", this.isRechnungsanlage);
        params.put("amountTotalDownloads", this.amountTotalDownloads);
        params.put("amountWithCosts", this.amountWithCosts);
        params.put("amountWithoutCosts", this.amountWithoutCosts);
        params.put("amountVUamtlicherLageplan", this.amountVUamtlicherLageplan);
        params.put("amountVUhoheitlicheVermessung", this.amountVUhoheitlicheVermessung);
        params.put("amountVUsonstige", this.amountVUsonstige);
        params.put("amountEigenerGebrauch", this.amountEigenerGebrauch);
        params.put("amountWiederverkauf", this.amountWiederverkauf);
        params.put("amountEigenerGebrauchGeb\u00fchrenbefreit", this.amountEigenerGebrauchGeb\u00fchrenbefreit);
        params.put("amountVUamtlicherLageplanGB", this.amountVUamtlicherLageplanGB);
        params.put("amountVUhoheitlicheVermessungGB", this.amountVUhoheitlicheVermessungGB);
        params.put("amountVUsonstigeGB", this.amountVUsonstigeGB);
        params.put("amountEigenerGebrauchGB", this.amountEigenerGebrauchGB);
        params.put("amountWiederverkaufGB", this.amountWiederverkaufGB);
        params.put("amountEigenerGebrauchGeb\u00fchrenbefreitGB", this.amountEigenerGebrauchGeb\u00fchrenbefreitGB);
        return params;
    }

    public void generateReport() {
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                beans.add(BillingBuchungsbelegReport.this.kundeBean);
                JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(beans);
                return beanArray;
            }
        };
        JasperReportDownload.JasperReportParametersGenerator parametersGenerator = new JasperReportDownload.JasperReportParametersGenerator(){

            public Map generateParamters() {
                return BillingBuchungsbelegReport.this.generateReportParam(BillingBuchungsbelegReport.this.kundeBean);
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            String resourceName;
            String title;
            String filename;
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            if (this.isRechnungsanlage) {
                filename = "buchungen_rechnungsanlage";
                title = "Buchungen: Rechnungsanlage";
                resourceName = REPORT_RECHNUNGSANLAGE_URL;
            } else {
                filename = "buchungen_buchungsbeleg";
                title = "Buchungen: Buchungsbeleg";
                resourceName = REPORT_BUCHUNGSBELEG_URL;
            }
            filename = filename + "_" + String.valueOf(this.kundeBean.getProperty("name_intern"));
            JasperReportDownload download = new JasperReportDownload(resourceName, parametersGenerator, dataSourceGenerator, jobname, title, filename);
            download.addObserver(this.downloadObserver);
            DownloadManager.instance().add((Download)download);
        }
    }

    public void setDownloadObserver(Observer downloadObserver) {
        this.downloadObserver = downloadObserver;
    }
}

