/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.custom.reports.wunda_blau.BillingStatisticsDataSourceAccumulation;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class BillingStatisticsReport
implements ConnectionContextProvider {
    private static final String REPORT_URL = "/de/cismet/cids/custom/reports/wunda_blau/geschaeftsstatisktik.jasper";
    private static final Logger LOG = Logger.getLogger(BillingStatisticsReport.class);
    protected Date from;
    protected Date till;
    protected int amountTotalDownloads;
    protected int amountWithCosts;
    protected int amountWithoutCosts;
    protected int amountVUamtlicherLageplan;
    protected int amountVUhoheitlicheVermessung;
    protected int amountVUsonstige;
    protected int amountVUamtlicherLageplanGB = 0;
    protected int amountVUhoheitlicheVermessungGB = 0;
    protected int amountVUsonstigeGB = 0;
    protected int amountWithCostsVU = 0;
    protected int amountWithCostsWiederver = 0;
    protected int amountWiederverkaeufe = 0;
    protected int amountWiederverkaeufeGB = 0;
    protected double earningsWithCostsVU = 0.0;
    protected double earningsWithCostsWiederver = 0.0;
    SwingWorker<JasperPrint, Void> downloadWorker;
    Collection<CidsBean> billingBeans;
    private final ConnectionContext connectionContext;

    public BillingStatisticsReport(Collection<CidsBean> billingBeans, Date from, Date till, int amountTotalDownloads, int amountWithCosts, int amountWithoutCosts, int amountVUamtlicherLageplan, int amountVUhoheitlicheVermessung, int amountVUsonstige, int amountVUamtlicherLageplanGB, int amountVUhoheitlicheVermessungGB, int amountVUsonstigeGB, int amountWithCostsVU, int amountWithCostsWiederver, int amountWiederverkaeufe, int amountWiederverkaeufeGB, double earningsWithCostsVU, double earningsWithCostsWiederver, ConnectionContext connectionContext) {
        this.billingBeans = billingBeans;
        this.from = from;
        this.till = till;
        this.amountTotalDownloads = amountTotalDownloads;
        this.amountWithCosts = amountWithCosts;
        this.amountWithoutCosts = amountWithoutCosts;
        this.amountVUamtlicherLageplan = amountVUamtlicherLageplan;
        this.amountVUhoheitlicheVermessung = amountVUhoheitlicheVermessung;
        this.amountVUsonstige = amountVUsonstige;
        this.amountVUamtlicherLageplanGB = amountVUamtlicherLageplanGB;
        this.amountVUhoheitlicheVermessungGB = amountVUhoheitlicheVermessungGB;
        this.amountVUsonstigeGB = amountVUsonstigeGB;
        this.amountWithCostsVU = amountWithCostsVU;
        this.amountWithCostsWiederver = amountWithCostsWiederver;
        this.amountWiederverkaeufe = amountWiederverkaeufe;
        this.amountWiederverkaeufeGB = amountWiederverkaeufeGB;
        this.earningsWithCostsVU = earningsWithCostsVU;
        this.earningsWithCostsWiederver = earningsWithCostsWiederver;
        this.connectionContext = connectionContext;
    }

    protected String getReportUrl() {
        return REPORT_URL;
    }

    protected String getFilename() {
        return "buchungen_geschaeftsstatistik";
    }

    protected String getTitle() {
        return "Buchungen: Gesch\u00e4ftsstatistik";
    }

    public void generateReport() {
        JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

            public JRDataSource generateDataSource() {
                JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(BillingStatisticsReport.this.billingBeans);
                return beanArray;
            }
        };
        JasperReportDownload.JasperReportParametersGenerator parametersGenerator = new JasperReportDownload.JasperReportParametersGenerator(){

            public Map generateParamters() {
                return BillingStatisticsReport.this.generateParamters();
            }
        };
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String filename = this.getFilename();
            String title = this.getTitle();
            DownloadManager.instance().add((Download)new JasperReportDownload(this.getReportUrl(), parametersGenerator, dataSourceGenerator, jobname, title, filename));
        }
    }

    protected BillingStatisticsDataSourceAccumulation createDataSourceAccumulation() {
        BillingStatisticsDataSourceAccumulation dataSourceAccumulation = new BillingStatisticsDataSourceAccumulation(this.billingBeans, this.getConnectionContext());
        dataSourceAccumulation.fetchSearchResults();
        return dataSourceAccumulation;
    }

    Map generateParamters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("from", this.from);
        if (this.till == null) {
            params.put("till", this.from);
        } else {
            params.put("till", this.till);
        }
        params.put("dataSourceCollection", this.createDataSourceAccumulation());
        params.put("amountTotalDownloads", this.amountTotalDownloads);
        params.put("amountWithCosts", this.amountWithCosts);
        params.put("amountWithoutCosts", this.amountWithoutCosts);
        params.put("amountWithCostsVU", this.amountWithCostsVU);
        params.put("amountWithCostsWiederver", this.amountWithCostsWiederver);
        params.put("amountVUamtlicherLageplan", this.amountVUamtlicherLageplan);
        params.put("amountVUamtlicherLageplanGB", this.amountVUamtlicherLageplanGB);
        params.put("amountVUhoheitlicheVermessung", this.amountVUhoheitlicheVermessung);
        params.put("amountVUhoheitlicheVermessungGB", this.amountVUhoheitlicheVermessungGB);
        params.put("amountVUsonstige", this.amountVUsonstige);
        params.put("amountVUsonstigeGB", this.amountVUsonstigeGB);
        params.put("amountWiederverkaeufe", this.amountWiederverkaeufe);
        params.put("amountWiederverkaeufeGB", this.amountWiederverkaeufeGB);
        params.put("earningsWithCostsVU", this.earningsWithCostsVU);
        params.put("earningsWithCostsWiederver", this.earningsWithCostsWiederver);
        return params;
    }

    public static String joinCidsBeanIds(Collection<CidsBean> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CidsBean item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item.getPrimaryKeyValue());
        }
        return sb.toString();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

