/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.tools.MapImageFactory;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.util.MapImageFactoryConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.utils.PotenzialflaecheReportCreator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class PfMapFactory
extends MapImageFactory {
    private static final transient Logger LOG = Logger.getLogger(PfMapFactory.class);
    private static final double PPI = 72.156;
    private static final double METERS_TO_INCH_FACTOR = 0.0254;

    protected PotenzialflaecheReportCreator.MapConfiguration extractConfiguration(String configuration) throws Exception {
        return (PotenzialflaecheReportCreator.MapConfiguration)new ObjectMapper().readValue(configuration, PotenzialflaecheReportCreator.MapConfiguration.class);
    }

    protected BufferedImage generateMap(MapImageFactoryConfiguration configuration) throws Exception {
        if (configuration instanceof PotenzialflaecheReportCreator.MapConfiguration) {
            return this.generateMap((PotenzialflaecheReportCreator.MapConfiguration)configuration);
        }
        throw new Exception("wrong configuration format");
    }

    protected BufferedImage generateMap(PotenzialflaecheReportCreator.MapConfiguration config) throws Exception {
        File file = config.getFileFromCache();
        if (Boolean.TRUE.equals(config.getUseCache()) && file != null && file.exists() && file.isFile()) {
            return ImageIO.read(file);
        }
        MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"PF_POTENZIALFLAECHE", (ConnectionContext)this.getConnectionContext());
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Integer id : config.getIds()) {
            MetaObject mo = SessionManager.getProxy().getMetaObject(SessionManager.getSession().getUser(), id.intValue(), mc.getId(), "WUNDA_BLAU", this.getConnectionContext());
            Feature feature = this.createPfFeature(mo != null ? mo.getBean() : null);
            if (feature == null) continue;
            features.add(feature);
        }
        int mapHeight = config.getHeight();
        int mapWidth = config.getWidth();
        XBoundingBox boundingBox = PfMapFactory.genBoundingBox(features, config.getBuffer(), config.getSrs());
        double scaleDenominator = PfMapFactory.getScaleDenom(mapWidth, mapHeight, boundingBox.getWidth(), boundingBox.getHeight());
        String mapUrl = config.getMapUrl();
        SimpleWMS simpleWms = new SimpleWMS(new SimpleWmsGetMapUrl(mapUrl));
        HeadlessMapProvider mapProvider = new HeadlessMapProvider();
        mapProvider.setCenterMapOnResize(true);
        mapProvider.setCrs(new Crs(config.getSrs(), "", "", true, true));
        mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
        if (Boolean.TRUE.equals(config.getShowGeom())) {
            for (Feature feature : features) {
                PNode annotationNode;
                mapProvider.addFeature(feature);
                if (mapProvider.getMappingComponent().getPFeatureHM().get(feature) == null || (annotationNode = ((PFeature)mapProvider.getMappingComponent().getPFeatureHM().get(feature)).getPrimaryAnnotationNode()) == null) continue;
                PBounds bounds = annotationNode.getBounds();
                bounds.x = -bounds.width / 2.0;
                bounds.y = -bounds.height / 2.0;
                annotationNode.setBounds((Rectangle2D)bounds);
            }
        }
        double bbWidth = boundingBox.getWidth();
        double bbHeight = boundingBox.getHeight();
        double bbCenterX = boundingBox.getX1() + bbWidth / 2.0;
        double bbCenterY = boundingBox.getY1() + bbHeight / 2.0;
        double mapWidthInMeter = (double)mapWidth / 72.156 * 0.0254;
        double mapHeightInMeter = (double)mapHeight / 72.156 * 0.0254;
        double worldWidthInPx = mapWidthInMeter * scaleDenominator;
        double worldHeightInPx = mapHeightInMeter * scaleDenominator;
        boundingBox.setX1(bbCenterX - worldWidthInPx / 2.0);
        boundingBox.setX2(bbCenterX + worldWidthInPx / 2.0);
        boundingBox.setY1(bbCenterY - worldHeightInPx / 2.0);
        boundingBox.setY2(bbCenterY + worldHeightInPx / 2.0);
        mapProvider.setBoundingBox(boundingBox);
        int mapDPI = config.getMapDpi();
        mapProvider.setFeatureResolutionFactor((double)mapDPI);
        BufferedImage image = (BufferedImage)mapProvider.getImageAndWait(72, mapDPI, (double)mapWidth, (double)mapHeight);
        try {
            if (file != null && file.getParentFile() != null) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdir();
                }
                ImageIO.write((RenderedImage)image, "png", file);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return image;
    }

    private Feature createPfFeature(CidsBean pfBean) {
        Geometry geom;
        Geometry geometry = geom = pfBean != null ? (Geometry)pfBean.getProperty("geometrie.geo_field") : null;
        if (geom != null) {
            Color color = Color.RED;
            String colorString = (String)pfBean.getProperty("kampagne.colorcode");
            if (colorString != null) {
                try {
                    color = Color.decode(colorString);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"color code couldn't be decoded, falling back to default color (red)", (Throwable)ex);
                }
            }
            DefaultStyledFeature feature = new DefaultStyledFeature();
            feature.setGeometry(geom);
            feature.setHighlightingEnabled(true);
            feature.setLinePaint((Paint)color);
            feature.setFillingPaint((Paint)new Color(color.getRed(), color.getGreen(), color.getBlue(), 127));
            feature.setLineWidth(3);
            return new CidsFeature(pfBean.getMetaObject());
        }
        return null;
    }

    private static double getScaleDenom(int mapWidthInPx, int mapHeightInPx, double bbWidthInMeter, double bbHeightInMeter) {
        double mapRatio = (double)mapWidthInPx / (double)mapHeightInPx;
        double bbRatio = bbWidthInMeter / bbHeightInMeter;
        double mapWidthInMeter = (double)mapWidthInPx / 72.156 * 0.0254;
        double mapHeightInMeter = (double)mapHeightInPx / 72.156 * 0.0254;
        return bbRatio > mapRatio ? bbWidthInMeter / mapWidthInMeter : bbHeightInMeter / mapHeightInMeter;
    }

    private static XBoundingBox genBoundingBox(Collection<Feature> features, Integer buffer, String srs) {
        int srid = CrsTransformer.extractSridFromCrs((String)srs);
        boolean first = true;
        ArrayList<Geometry> geoms = new ArrayList<Geometry>(features.size());
        for (Feature feature : features) {
            Geometry geometry = feature.getGeometry();
            if (geometry == null) continue;
            geometry = geometry.getEnvelope();
            if (first) {
                srid = geometry.getSRID();
                first = false;
            } else if (geometry.getSRID() != srid) {
                geometry = CrsTransformer.transformToGivenCrs((Geometry)geometry, (String)srs);
            }
            geoms.add(geometry);
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        Geometry union = factory.buildGeometry(geoms);
        if (union instanceof GeometryCollection) {
            union = ((GeometryCollection)union).union();
        }
        Geometry boxGeom = buffer != null ? union.buffer((double)buffer.intValue()) : union;
        boxGeom.setSRID(srid);
        return new XBoundingBox(boxGeom);
    }
}

