/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.treeicons.wunda_blau;

import Sirius.navigator.types.treenode.ClassTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.CidsTreeObjectIconFactory;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.Static2DTools;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class Fs_bestellungIconFactory
implements CidsTreeObjectIconFactory {
    private static final Logger LOG = Logger.getLogger(Fs_bestellungIconFactory.class);
    private static final ImageIcon FALLBACK = new ImageIcon(Fs_bestellungIconFactory.class.getResource("/res/16/FsBestellungGrau.png"));
    volatile SwingWorker<Void, Void> objectRetrievingWorker = null;
    final WeakHashMap<ObjectTreeNode, ExecutorService> listOfRetrievingObjectWorkers = new WeakHashMap();
    private final ExecutorService objectRetrievalExecutor = Executors.newFixedThreadPool(15);
    private final ImageIcon OPEN_ICON = new ImageIcon(this.getClass().getResource("/res/16/FsBestellung_overlay_error.png"));
    private final ImageIcon ERROR_ICON = new ImageIcon(this.getClass().getResource("/res/16/FsBestellung_overlay_open.png"));

    public Icon getClosedPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getLeafPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getClosedObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getLeafObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconFromState(otn);
    }

    public Icon getClassNodeIcon(ClassTreeNode dmtn) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon generateIconFromState(final ObjectTreeNode node) {
        if (node != null) {
            MetaObject mo = node.getMetaObject(false);
            if (mo != null) {
                CidsBean bestellungBean = mo.getBean();
                Icon result = node.getLeafIcon();
                Overlay ol = Fs_bestellungIconFactory.getOverlayForBestellung(bestellungBean);
                if (ol != null) {
                    switch (ol) {
                        case OPEN: {
                            ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.OPEN_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                            result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                            break;
                        }
                        case ERROR: {
                            ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.ERROR_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                            result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                        }
                    }
                }
                return result;
            }
            if (!this.listOfRetrievingObjectWorkers.containsKey(node) && !this.listOfRetrievingObjectWorkers.containsKey(node)) {
                this.listOfRetrievingObjectWorkers.put(node, this.objectRetrievalExecutor);
                WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = this.listOfRetrievingObjectWorkers;
                synchronized (weakHashMap) {
                    this.objectRetrievalExecutor.execute(new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            if (node != null) {
                                if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                                    if (ComponentRegistry.getRegistry().getSearchResultsTree().containsNode(node.getNode())) {
                                        node.getMetaObject(true);
                                    }
                                } else {
                                    node.getMetaObject(true);
                                }
                            }
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            try {
                                Void result = (Void)this.get();
                                if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                                    ((DefaultTreeModel)ComponentRegistry.getRegistry().getSearchResultsTree().getModel()).nodeChanged((TreeNode)node);
                                } else {
                                    ((DefaultTreeModel)ComponentRegistry.getRegistry().getCatalogueTree().getModel()).nodeChanged((TreeNode)node);
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Fehler beim Laden des MetaObjects", (Throwable)e);
                            }
                            finally {
                                WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = Fs_bestellungIconFactory.this.listOfRetrievingObjectWorkers;
                                synchronized (weakHashMap) {
                                    Fs_bestellungIconFactory.this.listOfRetrievingObjectWorkers.remove(node);
                                }
                            }
                        }
                    });
                }
            }
            return FALLBACK;
        }
        return null;
    }

    private static boolean isPostweg(CidsBean bestellung) {
        Boolean postweg = (Boolean)bestellung.getProperty("postweg");
        if (postweg == null) {
            return false;
        }
        return postweg;
    }

    private static boolean isErledigt(CidsBean bestellung) {
        Boolean erledigt = (Boolean)bestellung.getProperty("erledigt");
        if (erledigt == null) {
            return false;
        }
        return erledigt;
    }

    public static Overlay getOverlayForBestellung(CidsBean bestellungBean) {
        if (bestellungBean.getProperty("fehler") != null) {
            return Overlay.OPEN;
        }
        if (Fs_bestellungIconFactory.isPostweg(bestellungBean) && !Fs_bestellungIconFactory.isErledigt(bestellungBean)) {
            return Overlay.ERROR;
        }
        return null;
    }

    public static enum Overlay {
        OPEN,
        ERROR;

    }
}

