/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.treeicons.wunda_blau;

import Sirius.navigator.types.treenode.ClassTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.CidsTreeObjectIconFactory;
import Sirius.server.middleware.types.MetaNode;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.Static2DTools;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class Sb_stadtbildserieIconFactory
implements CidsTreeObjectIconFactory {
    private static final Logger LOG = Logger.getLogger(Sb_stadtbildserieIconFactory.class);
    final WeakHashMap<ObjectTreeNode, ExecutorService> listOfRetrievingObjectWorkers = new WeakHashMap();
    final WeakHashMap<ObjectTreeNode, Icon> iconMap = new WeakHashMap();
    private final ImageIcon WARNING_ICON;
    private final ImageIcon BODENNAH_ICON;
    private final ImageIcon PREVIEW_ICON;
    private final ImageIcon SCHRAEG_ICON;
    private final ImageIcon REIHENSCHRAEG_ICON;
    private final ImageIcon SENKRECHT_ICON;
    private final String PRUEFEN_SUBTREE_NODE_NAME = "Pr\u00fcfen";
    private final String OK_SUBTREE_NODE_NAME = "Ok";
    private final ExecutorService objectRetrievalExecutor = Executors.newFixedThreadPool(15);

    public Sb_stadtbildserieIconFactory() {
        this.WARNING_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/question.png"));
        this.BODENNAH_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/Stadtbildserie_Bodennah.png"));
        this.PREVIEW_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/Stadtbildserie_Preview.png"));
        this.SCHRAEG_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/Stadtbildserie_Schraeg.png"));
        this.REIHENSCHRAEG_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/Stadtbildserie_Schraeg.png"));
        this.SENKRECHT_ICON = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/Stadtbildserie_Senkrecht.png"));
    }

    public Icon getClosedPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getLeafPureNodeIcon(PureTreeNode ptn) {
        return null;
    }

    public Icon getOpenObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconAccordingToPosition(otn);
    }

    public Icon getClosedObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconAccordingToPosition(otn);
    }

    public Icon getLeafObjectNodeIcon(ObjectTreeNode otn) {
        return this.generateIconAccordingToPosition(otn);
    }

    public Icon getClassNodeIcon(ClassTreeNode dmtn) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon generateIconAccordingToPosition(final ObjectTreeNode node) {
        if (node != null) {
            if (this.iconMap.containsKey(node) && !node.isChanged()) {
                Icon icon = this.iconMap.get(node);
                if (icon != null) {
                    return icon;
                }
            } else {
                MetaObject mo = node.getMetaObject(false);
                if (mo != null) {
                    Icon icon = this.createIconForNode(node);
                    this.setIconToNode(node, icon);
                    return icon;
                }
                if (!this.listOfRetrievingObjectWorkers.containsKey(node) && !this.listOfRetrievingObjectWorkers.containsKey(node)) {
                    this.listOfRetrievingObjectWorkers.put(node, this.objectRetrievalExecutor);
                    WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = this.listOfRetrievingObjectWorkers;
                    synchronized (weakHashMap) {
                        this.objectRetrievalExecutor.execute(new SwingWorker<Icon, Void>(){

                            @Override
                            protected Icon doInBackground() throws Exception {
                                return Sb_stadtbildserieIconFactory.this.createIconForNode(node);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void done() {
                                try {
                                    Icon result = (Icon)this.get();
                                    Sb_stadtbildserieIconFactory.this.setIconToNode(node, result);
                                    boolean wasChangedBefore = node.isChanged();
                                    if (node.getMetaObject(false) != null) {
                                        node.setMetaObject(null);
                                        node.setChanged(wasChangedBefore);
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Fehler beim Laden des MetaObjects", (Throwable)e);
                                }
                                finally {
                                    WeakHashMap<ObjectTreeNode, ExecutorService> weakHashMap = Sb_stadtbildserieIconFactory.this.listOfRetrievingObjectWorkers;
                                    synchronized (weakHashMap) {
                                        Sb_stadtbildserieIconFactory.this.listOfRetrievingObjectWorkers.remove(node);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }
        return this.PREVIEW_ICON;
    }

    private Icon createIconForNode(ObjectTreeNode node) {
        Icon result = this.PREVIEW_ICON;
        if (this.listOfRetrievingObjectWorkers.containsKey(node)) {
            MetaObject stadtbildserieMO = null;
            if (node != null && node.getParent() != null) {
                if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                    if (ComponentRegistry.getRegistry().getSearchResultsTree().containsNode(node.getNode())) {
                        stadtbildserieMO = node.getMetaObject(true);
                    }
                } else {
                    stadtbildserieMO = node.getMetaObject(true);
                }
            }
            TreeNode[] nodePath = node.getPath();
            boolean inSubTreePruefen = false;
            for (int i = 1; i < nodePath.length; ++i) {
                Object userObject;
                if (!(nodePath[i] instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)nodePath[i]).getUserObject()) instanceof MetaNode)) continue;
                String name = ((MetaNode)userObject).getName();
                if (name.equals("Pr\u00fcfen")) {
                    inSubTreePruefen = true;
                    break;
                }
                if (name.equals("Ok")) break;
            }
            if (stadtbildserieMO != null) {
                Boolean pruefen;
                CidsBean stadtbildserieBean = stadtbildserieMO.getBean();
                CidsBean bildtypBean = (CidsBean)stadtbildserieBean.getProperty("bildtyp");
                if (bildtypBean != null && null != bildtypBean.getPrimaryKeyValue()) {
                    switch (bildtypBean.getPrimaryKeyValue()) {
                        case 0: {
                            result = this.REIHENSCHRAEG_ICON;
                            break;
                        }
                        case 3: {
                            result = this.SCHRAEG_ICON;
                            break;
                        }
                        case 1: {
                            result = this.SENKRECHT_ICON;
                            break;
                        }
                        case 2: {
                            result = this.BODENNAH_ICON;
                            break;
                        }
                    }
                }
                if (!(pruefen = Boolean.valueOf(Boolean.TRUE.equals(stadtbildserieBean.getProperty("pruefen")))).equals(inSubTreePruefen)) {
                    ImageIcon overlay = Static2DTools.createOverlayIcon((ImageIcon)this.WARNING_ICON, (int)result.getIconWidth(), (int)result.getIconHeight());
                    result = Static2DTools.mergeIcons((Icon)result, (Icon)overlay);
                }
            }
            return result;
        }
        return null;
    }

    private void setIconToNode(ObjectTreeNode node, Icon icon) {
        if (icon != null) {
            this.iconMap.put(node, icon);
            if (node.getPath()[0].equals(ComponentRegistry.getRegistry().getSearchResultsTree().getModel().getRoot())) {
                ((DefaultTreeModel)ComponentRegistry.getRegistry().getSearchResultsTree().getModel()).nodeChanged((TreeNode)node);
            } else {
                ((DefaultTreeModel)ComponentRegistry.getRegistry().getCatalogueTree().getModel()).nodeChanged((TreeNode)node);
            }
        }
    }
}

