/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.virtualcitymap;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.virtualcitymap.VCMControlFeature;
import de.cismet.cids.custom.virtualcitymap.VCMProperties;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VirtualCityMapToolbarComponentProvider
implements ToolbarComponentsProvider,
ConnectionContextStore,
CidsUiComponent {
    private static VCMControlFeature currentVCMControlFeature = null;
    private static final Logger LOG = Logger.getLogger(VirtualCityMapToolbarComponentProvider.class);
    private static final String HINTSEPARATOR_BEFORE = "<";
    private static final String HINTSEPARATOR_AFTER = ">";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public String getPluginName() {
        return "VirtualCityMapControl";
    }

    public Collection<ToolbarComponentDescription> getToolbarComponents() {
        Object[] toolbarConfig = this.getToolbarConfig();
        if (toolbarConfig != null) {
            String toolbarId = (String)toolbarConfig[0];
            ToolbarComponentsProvider.ToolbarPositionHint toolbarPositionHint = (ToolbarComponentsProvider.ToolbarPositionHint)toolbarConfig[1];
            String toolbarHintTarget = (String)toolbarConfig[2];
            LinkedList<ToolbarComponentDescription> preparationList = new LinkedList<ToolbarComponentDescription>();
            ToolbarComponentDescription description = new ToolbarComponentDescription(toolbarId, (JComponent)new VirtualCityMapButton(this.getConnectionContext()), toolbarPositionHint, toolbarHintTarget);
            preparationList.add(description);
            return Collections.unmodifiableList(preparationList);
        }
        return null;
    }

    public Object[] getToolbarConfig() {
        String configAttr;
        VCMProperties properties = VCMProperties.getInstance();
        if (properties.isEmpty()) {
            LOG.warn((Object)("openVCM openVCM(). properties are empty. you should check this server_resource: " + WundaBlauServerResources.VCM_PROPERTIES.getValue()));
            LOG.info((Object)"trying to load the properties from server_resource");
            properties.load(this.getConnectionContext());
        }
        if ((configAttr = properties.getToolbarConfAttr()) != null) {
            try {
                String result = SessionManager.getConnection().getConfigAttr(SessionManager.getSession().getUser(), configAttr, this.getConnectionContext());
                if (result != null) {
                    String[] split;
                    if (result.contains(HINTSEPARATOR_BEFORE)) {
                        String[] split2 = result.split(HINTSEPARATOR_BEFORE);
                        if (split2.length == 2) {
                            return new Object[]{split2[0], ToolbarComponentsProvider.ToolbarPositionHint.BEFORE, split2[1]};
                        }
                    } else if (result.contains(HINTSEPARATOR_AFTER) && (split = result.split(HINTSEPARATOR_AFTER)).length == 2) {
                        return new Object[]{split[0], ToolbarComponentsProvider.ToolbarPositionHint.AFTER, split[1]};
                    }
                }
            }
            catch (ConnectionException ex) {
                LOG.info((Object)("Can not check ConfigAttr: " + configAttr), (Throwable)ex);
            }
        }
        return null;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "VirtualCityMapToolbar";
        }
        return null;
    }

    public Component getComponent() {
        return new VirtualCityMapButton(this.connectionContext);
    }

    private final class VirtualCityMapButton
    extends JButton {
        Icon icon;

        public VirtualCityMapButton(final ConnectionContext connectionContext) {
            super(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            double w;
                            VCMControlFeature vcmf = new VCMControlFeature(connectionContext);
                            Geometry bb = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera().getGeometry(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                            double h = bb.getEnvelopeInternal().getHeight();
                            if (h > (w = bb.getEnvelopeInternal().getWidth())) {
                                vcmf.setGeometry(bb.getCentroid().buffer(w / 2.0 * 0.625).getEnvelope());
                            } else {
                                vcmf.setGeometry(bb.getCentroid().buffer(h / 2.0 * 0.625).getEnvelope());
                            }
                            if (currentVCMControlFeature != null) {
                                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)currentVCMControlFeature);
                                currentVCMControlFeature = null;
                            }
                            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)vcmf);
                            currentVCMControlFeature = vcmf;
                        }
                    });
                }
            });
            this.icon = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/virtualcitymap/vcm22.png"));
            super.setToolTipText(NbBundle.getMessage(VirtualCityMapToolbarComponentProvider.class, (String)"VirtualCityMapToolbarComponent.tooltip"));
            this.setIcon(this.icon);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }
    }
}

