/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.actiontag.ActionTagProtected;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.AlkisCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.AlkisSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputField;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputFieldConfig;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputWindow;
import de.cismet.cids.custom.wupp.client.alkis.ParcelInputField;
import de.cismet.cids.custom.wupp.client.alkis.ParcelInputFieldConfig;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AlkisWindowSearch
extends JPanel
implements CidsWindowSearch,
ActionTagProtected,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisWindowSearch.class);
    private static final String ACTION_TAG = "custom.alkis.windowsearch@WUNDA_BLAU";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private MetaClass mc = null;
    private ImageIcon icon = null;
    private SearchControlPanel pnlSearchCancel = null;
    private final ParcelInputFieldConfig parcelInputFieldConfig;
    private GrundbuchblattInputFieldConfig grundbuchblattInputFieldConfig;
    private boolean fallbackConfigParcel = false;
    private boolean fallbackConfigGrundbuchblatt = false;
    private GeoSearchButton btnGeoSearch;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup bgrNach;
    private ButtonGroup bgrOwner;
    private ButtonGroup bgrUeber;
    private JCheckBox chkGeomFilter;
    private GrundbuchblattInputField grundbuchblattInputField1;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JLabel lblFallbackGrundbuchblatt;
    private JRadioButton optEigIstFirma;
    private JRadioButton optEigIstMaennlich;
    private JRadioButton optEigIstUnbekannt;
    private JRadioButton optEigIstWeiblich;
    private JRadioButton optSucheNachFlurstuecke;
    private JRadioButton optSucheNachGrundbuchblaetter;
    private JRadioButton optSucheUeberEigentuemer;
    private JRadioButton optSucheUeberFlurstueck;
    private JRadioButton optSucheUeberGrundbuchblatt;
    private JPanel panCommand;
    private JPanel panEingabe;
    private JPanel panEingabeEigentuemer;
    private JPanel panEingabeFlurstueck;
    private JPanel panEingabeGrundbuchblatt;
    private ParcelInputField panParcelInputField;
    private JPanel panSearch;
    private JPanel panSucheNach;
    private JPanel panSucheUeber;
    private JTextField txtGeburtsdatum;
    private JTextField txtGeburtsname;
    private JTextField txtName;
    private JTextField txtVorname;

    public AlkisWindowSearch() {
        ParcelInputFieldConfig parcelInputFieldConfig = null;
        try {
            parcelInputFieldConfig = (ParcelInputFieldConfig)MAPPER.readValue(AlkisWindowSearch.class.getResourceAsStream("/de/cismet/cids/custom/wunda_blau/res/alkis/ParcelInputFieldConfig.json"), ParcelInputFieldConfig.class);
        }
        catch (IOException ex) {
            LOG.warn((Object)"ParcelInputFieldConfig could not be loaded, use fallback configuration.", (Throwable)ex);
            parcelInputFieldConfig = ParcelInputFieldConfig.FallbackConfig;
            this.fallbackConfigParcel = true;
        }
        this.parcelInputFieldConfig = parcelInputFieldConfig;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.grundbuchblattInputFieldConfig = (GrundbuchblattInputFieldConfig)new ObjectMapper().readValue(GrundbuchblattInputWindow.class.getResourceAsStream("/de/cismet/cids/custom/wunda_blau/res/alkis/GrundbuchblattInputFieldConfig.json"), GrundbuchblattInputFieldConfig.class);
            System.out.println(this.grundbuchblattInputFieldConfig.getDelimiter1AsString());
        }
        catch (IOException ex) {
            LOG.warn((Object)"GrundbuchblattInputFieldConfig could not be loaded, use fallback configuration.", (Throwable)ex);
            this.grundbuchblattInputFieldConfig = GrundbuchblattInputFieldConfig.FallbackConfig;
            this.fallbackConfigGrundbuchblatt = true;
        }
        try {
            this.mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"ALKIS_LANDPARCEL", (ConnectionContext)this.getConnectionContext());
            this.icon = new ImageIcon(this.mc.getIconData());
            this.initComponents();
            ((CardLayout)this.panEingabe.getLayout()).show(this.panEingabe, "eigentuemer");
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.panCommand.add((Component)this.pnlSearchCancel);
            this.panCommand.add(Box.createHorizontalStrut(5));
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
            if (this.geoSearchEnabled) {
                AlkisCreateSearchGeometryListener alkisSearchGeometryListener = new AlkisCreateSearchGeometryListener(this.mappingComponent, new AlkisSearchTooltip(this.icon));
                alkisSearchGeometryListener.addPropertyChangeListener(this);
                this.btnGeoSearch = new GeoSearchButton("ALKIS_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null, NbBundle.getMessage(AlkisWindowSearch.class, (String)"AlkisWindowSearch.btnGeoSearch.toolTipText"));
                this.panCommand.add((Component)this.btnGeoSearch);
            }
            if (this.fallbackConfigParcel) {
                this.jLabel1.setVisible(true);
            } else {
                this.jLabel1.setVisible(false);
            }
            if (this.fallbackConfigGrundbuchblatt) {
                this.lblFallbackGrundbuchblatt.setVisible(true);
            } else {
                this.lblFallbackGrundbuchblatt.setVisible(false);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in Constructor of AlkisWindowSearch", (Throwable)e);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.bgrUeber = new ButtonGroup();
        this.bgrNach = new ButtonGroup();
        this.bgrOwner = new ButtonGroup();
        this.panSearch = new JPanel();
        this.panSucheNach = new JPanel();
        this.optSucheNachFlurstuecke = new JRadioButton();
        this.optSucheNachGrundbuchblaetter = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.panSucheUeber = new JPanel();
        this.optSucheUeberEigentuemer = new JRadioButton();
        this.optSucheUeberFlurstueck = new JRadioButton();
        this.optSucheUeberGrundbuchblatt = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.panCommand = new JPanel();
        this.panEingabe = new JPanel();
        this.panEingabeGrundbuchblatt = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabel4 = new JLabel();
        this.grundbuchblattInputField1 = new GrundbuchblattInputField(this.grundbuchblattInputFieldConfig);
        this.lblFallbackGrundbuchblatt = new JLabel();
        this.panEingabeFlurstueck = new JPanel();
        this.panParcelInputField = new ParcelInputField(this.parcelInputFieldConfig);
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.panEingabeEigentuemer = new JPanel();
        this.txtVorname = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtName = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel4 = new JPanel();
        this.optEigIstWeiblich = new JRadioButton();
        this.optEigIstMaennlich = new JRadioButton();
        this.optEigIstFirma = new JRadioButton();
        this.optEigIstUnbekannt = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.txtGeburtsname = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.txtGeburtsdatum = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel6 = new JPanel();
        this.chkGeomFilter = new JCheckBox();
        this.setMaximumSize(new Dimension(325, 460));
        this.setMinimumSize(new Dimension(325, 460));
        this.setPreferredSize(new Dimension(325, 460));
        this.setLayout(new BorderLayout());
        this.panSearch.setMaximumSize(new Dimension(400, 150));
        this.panSearch.setMinimumSize(new Dimension(400, 150));
        this.panSearch.setPreferredSize(new Dimension(400, 150));
        this.panSearch.setLayout(new GridBagLayout());
        this.panSucheNach.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Suche nach"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.panSucheNach.setLayout(new GridBagLayout());
        this.bgrNach.add(this.optSucheNachFlurstuecke);
        this.optSucheNachFlurstuecke.setSelected(true);
        this.optSucheNachFlurstuecke.setText("Flurst\u00fccken");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panSucheNach.add((Component)this.optSucheNachFlurstuecke, gridBagConstraints);
        this.bgrNach.add(this.optSucheNachGrundbuchblaetter);
        this.optSucheNachGrundbuchblaetter.setText("Grundbuchbl\u00e4ttern");
        this.panSucheNach.add((Component)this.optSucheNachGrundbuchblaetter, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panSucheNach.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panSearch.add((Component)this.panSucheNach, gridBagConstraints);
        this.panSucheUeber.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Suche \u00fcber"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.panSucheUeber.setLayout(new GridBagLayout());
        this.bgrUeber.add(this.optSucheUeberEigentuemer);
        this.optSucheUeberEigentuemer.setSelected(true);
        this.optSucheUeberEigentuemer.setText("Eigent\u00fcmer");
        this.optSucheUeberEigentuemer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optSucheUeberEigentuemerActionPerformed(evt);
            }
        });
        this.panSucheUeber.add((Component)this.optSucheUeberEigentuemer, new GridBagConstraints());
        this.bgrUeber.add(this.optSucheUeberFlurstueck);
        this.optSucheUeberFlurstueck.setText("Flurst\u00fcck");
        this.optSucheUeberFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optSucheUeberFlurstueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panSucheUeber.add((Component)this.optSucheUeberFlurstueck, gridBagConstraints);
        this.bgrUeber.add(this.optSucheUeberGrundbuchblatt);
        this.optSucheUeberGrundbuchblatt.setText("Grundbuchblatt");
        this.optSucheUeberGrundbuchblatt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optSucheUeberGrundbuchblattActionPerformed(evt);
            }
        });
        this.panSucheUeber.add((Component)this.optSucheUeberGrundbuchblatt, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panSucheUeber.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.panSearch.add((Component)this.panSucheUeber, gridBagConstraints);
        this.panCommand.setLayout(new BoxLayout(this.panCommand, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panCommand, gridBagConstraints);
        this.panEingabe.setLayout(new CardLayout());
        this.panEingabeGrundbuchblatt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Grundbuchblatt Suchmaske"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.panEingabeGrundbuchblatt.setLayout(new GridBagLayout());
        this.jLabel12.setText("Grundbuchblattnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeGrundbuchblatt.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel4.setText("<html> <p>Beispiel: 053001-0003117</p><br><p>Platzhaltersymbole:</p><p>&nbsp;<b>%</b>&nbsp;&nbsp;&nbsp;&nbsp;eine beliebige Anzahl von Zeichen</p> <p>&nbsp;<b>_</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ein einzelnes Zeichen</p> </html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.panEingabeGrundbuchblatt.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeGrundbuchblatt.add((Component)this.grundbuchblattInputField1, gridBagConstraints);
        this.lblFallbackGrundbuchblatt.setText("<html><b><font color=\"#FF0000\">Es ist ein Fehler beim Laden der Konfiguration aufgetreten. <br />\nDie Funktionalit\u00e4t ist dadurch eingeschr\u00e4nkt.</font></b></html>");
        this.lblFallbackGrundbuchblatt.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.panEingabeGrundbuchblatt.add((Component)this.lblFallbackGrundbuchblatt, gridBagConstraints);
        this.panEingabe.add((Component)this.panEingabeGrundbuchblatt, "grundbuchblatt");
        this.panEingabeFlurstueck.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Flurst\u00fcck Suchmaske"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.panEingabeFlurstueck.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeFlurstueck.add((Component)this.panParcelInputField, gridBagConstraints);
        this.jLabel9.setText("Flurst\u00fccksnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeFlurstueck.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel3.setText("<html> <p>Beispiel: 053001-117-00058</p><br><p>Platzhaltersymbole:</p><p>&nbsp;<b>%</b>&nbsp;&nbsp;&nbsp;&nbsp;eine beliebige Anzahl von Zeichen</p> <p>&nbsp;<b>_</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ein einzelnes Zeichen</p> </html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.panEingabeFlurstueck.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel1.setText("<html><b><font color=\"#FF0000\">Es ist ein Fehler beim Laden der Konfiguration aufgetreten. <br />\nDie Funktionalit\u00e4t ist dadurch eingeschr\u00e4nkt.</font></b></html>");
        this.jLabel1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.panEingabeFlurstueck.add((Component)this.jLabel1, gridBagConstraints);
        this.panEingabe.add((Component)this.panEingabeFlurstueck, "flurstueck");
        this.panEingabeEigentuemer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Eigent\u00fcmer Suchmaske"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.panEingabeEigentuemer.setLayout(new GridBagLayout());
        this.txtVorname.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.txtVornameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.txtVorname, gridBagConstraints);
        this.jLabel7.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.txtName, gridBagConstraints);
        this.jLabel8.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.jLabel8, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Eigent\u00fcmer Anrede ist"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.jPanel4.setLayout(new GridBagLayout());
        this.bgrOwner.add(this.optEigIstWeiblich);
        this.optEigIstWeiblich.setText("Frau");
        this.optEigIstWeiblich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optEigIstWeiblichActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.optEigIstWeiblich, gridBagConstraints);
        this.bgrOwner.add(this.optEigIstMaennlich);
        this.optEigIstMaennlich.setText("Herr");
        this.optEigIstMaennlich.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optEigIstMaennlichActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.optEigIstMaennlich, gridBagConstraints);
        this.bgrOwner.add(this.optEigIstFirma);
        this.optEigIstFirma.setText("Firma");
        this.optEigIstFirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optEigIstFirmaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.optEigIstFirma, gridBagConstraints);
        this.bgrOwner.add(this.optEigIstUnbekannt);
        this.optEigIstUnbekannt.setSelected(true);
        this.optEigIstUnbekannt.setText("unbekannt");
        this.optEigIstUnbekannt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.optEigIstUnbekanntActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.optEigIstUnbekannt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panEingabeEigentuemer.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.txtGeburtsname, gridBagConstraints);
        this.jLabel13.setText("Geburtsname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setText("Geburtsdatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.jLabel14, gridBagConstraints);
        this.txtGeburtsdatum.setToolTipText("Bsp.: 18.01.1974");
        this.txtGeburtsdatum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisWindowSearch.this.txtGeburtsdatumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.txtGeburtsdatum, gridBagConstraints);
        this.jLabel2.setText("<html><br><p>Platzhaltersymbole:</p><p>&nbsp;<b>%</b>&nbsp;&nbsp;&nbsp;&nbsp;eine beliebige Anzahl von Zeichen</p> <p>&nbsp;<b>_</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ein einzelnes Zeichen</p> </html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.panEingabeEigentuemer.add((Component)this.jLabel2, gridBagConstraints);
        this.panEingabe.add((Component)this.panEingabeEigentuemer, "eigentuemer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panSearch.add((Component)this.panEingabe, gridBagConstraints);
        this.jPanel6.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.panSearch.add((Component)this.jPanel6, gridBagConstraints);
        this.chkGeomFilter.setText("nur im aktuellen Kartenausschnitt suchen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 17, 0, 0);
        this.panSearch.add((Component)this.chkGeomFilter, gridBagConstraints);
        this.add((Component)this.panSearch, "Center");
    }

    private void optSucheUeberEigentuemerActionPerformed(ActionEvent evt) {
        ((CardLayout)this.panEingabe.getLayout()).show(this.panEingabe, "eigentuemer");
    }

    private void txtVornameActionPerformed(ActionEvent evt) {
    }

    private void txtGeburtsdatumActionPerformed(ActionEvent evt) {
    }

    private void optEigIstMaennlichActionPerformed(ActionEvent evt) {
        this.txtVorname.setEnabled(true);
        this.txtGeburtsname.setEnabled(true);
        this.txtGeburtsdatum.setEnabled(true);
    }

    private void optEigIstUnbekanntActionPerformed(ActionEvent evt) {
        this.txtVorname.setEnabled(true);
        this.txtGeburtsname.setEnabled(true);
        this.txtGeburtsdatum.setEnabled(true);
    }

    private void optEigIstFirmaActionPerformed(ActionEvent evt) {
        this.txtVorname.setEnabled(false);
        this.txtGeburtsname.setEnabled(false);
        this.txtGeburtsdatum.setEnabled(false);
    }

    private void optEigIstWeiblichActionPerformed(ActionEvent evt) {
        this.txtVorname.setEnabled(true);
        this.txtGeburtsname.setEnabled(true);
        this.txtGeburtsdatum.setEnabled(true);
    }

    private void optSucheUeberFlurstueckActionPerformed(ActionEvent evt) {
        ((CardLayout)this.panEingabe.getLayout()).show(this.panEingabe, "flurstueck");
    }

    private void optSucheUeberGrundbuchblattActionPerformed(ActionEvent evt) {
        ((CardLayout)this.panEingabe.getLayout()).show(this.panEingabe, "grundbuchblatt");
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return "ALKIS-Suche";
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public boolean isFallbackConfig() {
        return this.fallbackConfigParcel;
    }

    public MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry searchgeom = null;
        if (geometry != null) {
            searchgeom = CrsTransformer.transformToDefaultCrs((Geometry)geometry);
        } else if (this.chkGeomFilter.isSelected()) {
            Geometry g = ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry();
            Geometry transformed = CrsTransformer.transformToDefaultCrs((Geometry)g);
            transformed.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            searchgeom = transformed;
        }
        CidsAlkisSearchStatement.Resulttyp resulttype = null;
        resulttype = this.optSucheNachFlurstuecke.isSelected() ? CidsAlkisSearchStatement.Resulttyp.FLURSTUECK : CidsAlkisSearchStatement.Resulttyp.BUCHUNGSBLATT;
        if (this.optSucheUeberEigentuemer.isSelected()) {
            CidsAlkisSearchStatement.Personentyp ptyp = null;
            if (this.optEigIstFirma.isSelected()) {
                ptyp = CidsAlkisSearchStatement.Personentyp.FIRMA;
            } else if (this.optEigIstMaennlich.isSelected()) {
                ptyp = CidsAlkisSearchStatement.Personentyp.MANN;
            } else if (this.optEigIstWeiblich.isSelected()) {
                ptyp = CidsAlkisSearchStatement.Personentyp.FRAU;
            }
            String name = this.txtName.getText().trim();
            String vorname = this.txtVorname.getText().trim();
            String geburtsname = this.txtGeburtsname.getText().trim();
            String geburtsdatum = this.txtGeburtsdatum.getText().trim();
            return new CidsAlkisSearchStatement(resulttype, name, vorname, geburtsname, geburtsdatum, ptyp, searchgeom);
        }
        if (this.optSucheUeberFlurstueck.isSelected()) {
            return new CidsAlkisSearchStatement(resulttype, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, this.panParcelInputField.getCurrentParcel(), searchgeom);
        }
        return new CidsAlkisSearchStatement(resulttype, CidsAlkisSearchStatement.SucheUeber.BUCHUNGSBLATTNUMMER, this.grundbuchblattInputField1.getGrundbuchblattnummer(), searchgeom);
    }

    public boolean checkActionTag() {
        return ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext());
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public void searchStarted() {
    }

    public void searchDone(int results) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }
}

