/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search;

import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.LandParcelSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.LandParcelSearchTooltip;
import de.cismet.cids.custom.wunda_blau.search.server.CidsLandParcelSearchStatement;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LandParcelWindowSearch
extends JPanel
implements CidsWindowSearch,
SearchControlListener,
PropertyChangeListener,
ConnectionContextStore {
    static final Logger log = Logger.getLogger(LandParcelWindowSearch.class);
    private MetaClass mc = null;
    private ImageIcon icon;
    private SearchControlPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnNewSearch;
    private JCheckBox chkActual;
    private JCheckBox chkHistorical;
    private JCheckBox chkMap;
    private DefaultBindableDateChooser dcFrom;
    private DefaultBindableDateChooser dcTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel panCommand;
    private JPanel panParcelType;
    private JPanel panSearch;
    private JPanel panTime;
    private BindingGroup bindingGroup;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"FLURSTUECK", (ConnectionContext)this.getConnectionContext());
            this.icon = new ImageIcon(this.mc.getIconData());
            this.initComponents();
            this.initDateChoosers();
            this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.getConnectionContext());
            Dimension max = this.pnlSearchCancel.getMaximumSize();
            Dimension min = this.pnlSearchCancel.getMinimumSize();
            Dimension pre = this.pnlSearchCancel.getPreferredSize();
            this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
            this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
            this.panCommand.add((Component)this.pnlSearchCancel);
            this.panCommand.add(Box.createHorizontalStrut(5));
            this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
            boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
            if (this.geoSearchEnabled) {
                LandParcelSearchGeometryListener landParcelSearchGeometryListener = new LandParcelSearchGeometryListener(this.mappingComponent, new LandParcelSearchTooltip(this.icon));
                landParcelSearchGeometryListener.addPropertyChangeListener(this);
                this.btnGeoSearch = new GeoSearchButton("LAND_PARCEL_CREATE_SEARCH_GEOMETRY", this.mappingComponent, null, NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.btnGeoSearch.toolTipText"));
                this.panCommand.add((Component)this.btnGeoSearch);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"Error in Constructor of LandParcelWindowSearch", (Throwable)exception);
        }
    }

    private void initDateChoosers() {
        java.util.Date date = new java.util.Date(System.currentTimeMillis());
        date.setMonth(0);
        date.setDate(1);
        this.dcFrom.setDate(date);
        this.dcTo.setDate(new java.util.Date(System.currentTimeMillis()));
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panSearch = new JPanel();
        this.panParcelType = new JPanel();
        this.chkActual = new JCheckBox();
        this.chkHistorical = new JCheckBox();
        this.panTime = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dcFrom = new DefaultBindableDateChooser();
        this.dcTo = new DefaultBindableDateChooser();
        this.panCommand = new JPanel();
        this.jPanel1 = new JPanel();
        this.chkMap = new JCheckBox();
        this.btnNewSearch = new JButton();
        this.setLayout(new BorderLayout());
        this.panSearch.setLayout(new GridBagLayout());
        this.panParcelType.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.panParcelType.border.title")));
        this.panParcelType.setLayout(new GridBagLayout());
        this.chkActual.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkActual, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.chkActual.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParcelType.add((Component)this.chkActual, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHistorical, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.chkHistorical.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParcelType.add((Component)this.chkHistorical, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panParcelType, gridBagConstraints);
        this.panTime.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.panTime.border.title")));
        this.panTime.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.jLabel1.text"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkHistorical, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTime.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.jLabel2.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkHistorical, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTime.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.jLabel3.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkHistorical, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel3, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTime.add((Component)this.jLabel3, gridBagConstraints);
        this.dcFrom.setPreferredSize(new Dimension(124, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkHistorical, (Property)ELProperty.create((String)"${selected}"), (Object)this.dcFrom, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTime.add((Component)this.dcFrom, gridBagConstraints);
        this.dcTo.setPreferredSize(new Dimension(124, 20));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkHistorical, (Property)ELProperty.create((String)"${selected}"), (Object)this.dcTo, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTime.add((Component)this.dcTo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panTime, gridBagConstraints);
        this.panCommand.setLayout(new BoxLayout(this.panCommand, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panCommand, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkMap, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.chkMap.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.chkMap, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewSearch, (String)NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.btnNewSearch.text"));
        this.btnNewSearch.setToolTipText(NbBundle.getMessage(LandParcelWindowSearch.class, (String)"LandParcelWindowSearch.btnNewSearch.toolTipText"));
        this.btnNewSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LandParcelWindowSearch.this.btnNewSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panSearch.add((Component)this.btnNewSearch, gridBagConstraints);
        this.add((Component)this.panSearch, "North");
        this.bindingGroup.bind();
    }

    private void btnNewSearchActionPerformed(ActionEvent evt) {
        this.chkActual.setSelected(true);
        this.chkHistorical.setSelected(false);
        this.initDateChoosers();
        this.chkMap.setSelected(false);
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public MetaObjectNodeServerSearch getServerSearch(Geometry geometry) {
        Geometry searchgeom = null;
        if (geometry != null) {
            searchgeom = CrsTransformer.transformToDefaultCrs((Geometry)geometry);
        } else if (this.chkMap.isSelected()) {
            Geometry g = ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry();
            Geometry transformed = CrsTransformer.transformToDefaultCrs((Geometry)g);
            transformed.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            searchgeom = transformed;
        }
        if (this.chkHistorical.isSelected()) {
            java.util.Date from = this.dcFrom.getDate();
            java.util.Date to = this.dcTo.getDate();
            return new CidsLandParcelSearchStatement(this.chkActual.isSelected(), true, new Date(from.getTime()), new Date(to.getTime()), searchgeom);
        }
        return new CidsLandParcelSearchStatement(this.chkActual.isSelected(), searchgeom);
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return this.getServerSearch(null);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int numberOfResults) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public String getName() {
        return "Flurst\u00fcck-Suche";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("ACTION_SEARCH_STARTED".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Geometry) {
            MetaObjectNodeServerSearch search = this.getServerSearch((Geometry)evt.getNewValue());
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)search, (ConnectionContext)this.getConnectionContext());
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

