/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wupp.client.alkis;

import de.cismet.cids.custom.wupp.client.alkis.AbstractInputField;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputFieldConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GrundbuchblattInputField
extends AbstractInputField {
    public static final String PROP_GRUNDBUCHBLATTNUMMER = "grundbuchblattnummer";
    public static final String PROP_BUCHUNGSBLATTNUMMER = "buchungsblattnummer";
    private final GrundbuchblattInputFieldConfig config;
    private String buchungsblattnummer;
    private String grundbuchblattnummer;
    private JLabel lblDelimitier1;
    private JTextField txtBuchungsblattnummer;
    private JTextField txtDistrict;

    public GrundbuchblattInputField() {
        this(GrundbuchblattInputFieldConfig.FallbackConfig);
    }

    public GrundbuchblattInputField(final GrundbuchblattInputFieldConfig config) {
        super(config);
        this.config = config;
        this.initComponents();
        this.setTxtDistrict(this.txtDistrict);
        this.txtDistrict.setDocument(new AbstractInputField.DistrictPlainDocument(this, this.txtDistrict, this.txtBuchungsblattnummer));
        this.txtBuchungsblattnummer.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null || str.isEmpty()) {
                    return;
                }
                GrundbuchblattInputField.this.txtBuchungsblattnummer.setForeground(Color.BLACK);
                str = str.replaceAll("[^-a-zA-Z0-9_%]", "");
                int posDel = str.indexOf(config.getDelimiter1());
                if (posDel >= 0) {
                    str = str.substring(posDel + 1);
                }
                StringBuilder futureStringBuilder = new StringBuilder(GrundbuchblattInputField.this.txtBuchungsblattnummer.getText());
                futureStringBuilder.insert(offs, str);
                String futureText = futureStringBuilder.toString();
                this.checkFutureString(futureText);
                super.insertString(offs, str, a);
                GrundbuchblattInputField.this.updateResult();
            }

            @Override
            public void remove(int offs, int len) throws BadLocationException {
                GrundbuchblattInputField.this.txtBuchungsblattnummer.setForeground(Color.BLACK);
                String futureText = GrundbuchblattInputField.this.txtBuchungsblattnummer.getText();
                futureText = futureText.substring(offs, offs + len);
                this.checkFutureString(futureText);
                super.remove(offs, len);
                GrundbuchblattInputField.this.updateResult();
            }

            private void checkFutureString(String futureString) {
                if (!futureString.matches("^[0-9_%]{0,7}[a-zA-Z_%]*")) {
                    GrundbuchblattInputField.this.txtBuchungsblattnummer.setForeground(Color.RED);
                }
            }
        });
    }

    private void initComponents() {
        this.txtDistrict = new JTextField();
        this.lblDelimitier1 = new JLabel(this.config.getDelimiter1AsString());
        this.txtBuchungsblattnummer = new JTextField();
        this.setLayout(new GridBagLayout());
        this.txtDistrict.setHorizontalAlignment(0);
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.txtDistrict.getFont());
        Dimension dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxLenDistrictNumberField() + 4), this.txtDistrict.getPreferredSize().height);
        this.txtDistrict.setMinimumSize(dim);
        this.txtDistrict.setPreferredSize(dim);
        this.txtDistrict.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GrundbuchblattInputField.this.txtDistrictFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GrundbuchblattInputField.this.txtDistrictFocusLost(evt);
            }
        });
        this.add((Component)this.txtDistrict, new GridBagConstraints());
        this.lblDelimitier1.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.lblDelimitier1, gridBagConstraints);
        this.txtBuchungsblattnummer.setHorizontalAlignment(0);
        dim = new Dimension(metrics.stringWidth("0") * (this.config.getMaxBuchungsblattnummerField() + 4), this.txtBuchungsblattnummer.getPreferredSize().height);
        this.txtBuchungsblattnummer.setMinimumSize(dim);
        this.txtBuchungsblattnummer.setPreferredSize(dim);
        this.txtBuchungsblattnummer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GrundbuchblattInputField.this.txtBuchungsblattnummerFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GrundbuchblattInputField.this.txtBuchungsblattnummerFocusLost(evt);
            }
        });
        this.add((Component)this.txtBuchungsblattnummer, new GridBagConstraints());
    }

    private void txtDistrictFocusGained(FocusEvent evt) {
        int textLength = this.txtDistrict.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtDistrict.getHighlighter().removeAllHighlights();
            this.txtDistrict.setCaretPosition(textLength);
        } else {
            this.txtDistrict.setCaretPosition(0);
            this.txtDistrict.moveCaretPosition(textLength);
        }
    }

    private void txtDistrictFocusLost(FocusEvent evt) {
        this.finishDistrict();
        this.txtDistrict.setCaretPosition(0);
    }

    private void txtBuchungsblattnummerFocusGained(FocusEvent evt) {
        int textLenght = this.txtBuchungsblattnummer.getText().length();
        if (this.isOverwritten()) {
            this.setOverwritten(false);
            this.txtBuchungsblattnummer.getHighlighter().removeAllHighlights();
            this.txtBuchungsblattnummer.setCaretPosition(textLenght);
        } else {
            this.txtBuchungsblattnummer.setCaretPosition(0);
            this.txtBuchungsblattnummer.moveCaretPosition(textLenght);
        }
    }

    private void txtBuchungsblattnummerFocusLost(FocusEvent evt) {
        this.finishBuchungsblattnummer();
        this.txtBuchungsblattnummer.setCaretPosition(0);
    }

    private void finishBuchungsblattnummer() {
        String text = this.txtBuchungsblattnummer.getText();
        if (text != null && !text.isEmpty() && !this.txtBuchungsblattnummer.getText().contains("%")) {
            int newMaxLength = this.config.getMaxBuchungsblattnummerField();
            this.addLeadingZeroes(this.txtBuchungsblattnummer.getDocument(), newMaxLength);
        }
        this.fireAreaBlockFinished(AbstractInputField.BlockType.BUCHUNGSBLATTNUMMER);
    }

    @Override
    void updateResult() {
        String oldGrundbuchblattnummer = this.grundbuchblattnummer;
        StringBuilder sb = new StringBuilder();
        if (this.txtDistrict.getText() != null && !this.txtDistrict.getText().isEmpty()) {
            sb.append(this.txtDistrict.getText());
        }
        if (this.txtBuchungsblattnummer.getText() != null && !this.txtBuchungsblattnummer.getText().isEmpty() && !this.txtBuchungsblattnummer.getText().matches("^0+$")) {
            sb.append(this.config.getDelimiter1AsString()).append(this.txtBuchungsblattnummer.getText());
        }
        this.grundbuchblattnummer = sb.toString();
        super.firePropertyChange(PROP_GRUNDBUCHBLATTNUMMER, oldGrundbuchblattnummer, this.grundbuchblattnummer);
    }

    public String getGrundbuchblattnummer() {
        return this.grundbuchblattnummer;
    }

    public void setGrundbuchblattNummerForTest(String grundbuchblattnummer) {
        this.changeFocus = false;
        this.txtDistrict.setText(grundbuchblattnummer);
        this.finishDistrict();
        this.finishBuchungsblattnummer();
        this.changeFocus = true;
    }

    public void finish() {
        this.changeFocus = false;
        this.finishDistrict();
        this.finishBuchungsblattnummer();
        this.changeFocus = true;
    }

    public String getBuchungsblattnummer() {
        return this.buchungsblattnummer;
    }

    public void setBuchungsblattnummerInTxtBuchungsblattnummer(String buchungsblattnummer) {
        this.changeFocus = false;
        this.writeOver = false;
        this.txtBuchungsblattnummer.setText(buchungsblattnummer);
        this.finishBuchungsblattnummer();
        this.changeFocus = true;
        this.writeOver = true;
    }

    @Override
    void fireAreaBlockFinished(AbstractInputField.BlockType blockNr) {
        switch (blockNr) {
            case DISTRICT: {
                String oldValue = this.getDistrictNumber();
                this.setDistrictNumber(this.txtDistrict.getText());
                super.firePropertyChange("districtNumber", oldValue, this.getDistrictNumber());
                break;
            }
            case BUCHUNGSBLATTNUMMER: {
                String oldValue = this.buchungsblattnummer;
                this.buchungsblattnummer = this.txtBuchungsblattnummer.getText();
                super.firePropertyChange(PROP_BUCHUNGSBLATTNUMMER, oldValue, this.buchungsblattnummer);
            }
        }
    }
}

