/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.butler;

import com.fasterxml.jackson.databind.ObjectMapper;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;

import org.apache.log4j.Logger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.IOException;

import java.util.ArrayList;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.cismet.cids.custom.nas.NasFeePreviewPanel;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerResolution;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @author   daniel
 * @version  $Revision$, $Date$
 */
public class Butler2ProductPanel extends javax.swing.JPanel implements ActionListener,
    ListSelectionListener,
    ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(Butler1ProductPanel.class);
    private static final double RASTER_DISCOUNT = 0.25d;

    //~ Instance fields --------------------------------------------------------

    ArrayList<ButlerProduct> products;
    ArrayList<ButlerResolution> resolutions;
    private Geometry geom;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup btGroupFormat;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel lblFiller;
    private javax.swing.JLabel lblFormat;
    private javax.swing.JLabel lblProdukt;
    private javax.swing.JList lstProdukt;
    private javax.swing.JPanel pnlFee;
    private de.cismet.cids.custom.nas.NasFeePreviewPanel pnlFeePreview;
    private javax.swing.JPanel pnlFormat;
    private javax.swing.JRadioButton rbShp;
    private javax.swing.JRadioButton rbTif;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new Butler2ProductPanel object.
     */
    public Butler2ProductPanel() {
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Creates new form Butler2ProductPanel.
     *
     * @param  connectionContext  DOCUMENT ME!
     */
    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        loadPrductDescriptions();
        initComponents();
        pnlFeePreview = new NasFeePreviewPanel(getConnectionContext());
        lstProdukt.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        rbShp.addActionListener(this);
        rbTif.addActionListener(this);
        // this fires the action event and starts the fee calculation
        rbShp.setSelected(true);
        // setting an empty geometry causes the fee preview panel to show a fee of 0.
        final GeometryFactory gf = new GeometryFactory();
        geom = gf.createMultiPolygon(null);
        calculateFee();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        btGroupFormat = new javax.swing.ButtonGroup();
        lblProdukt = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lstProdukt = new javax.swing.JList();
        lblFormat = new javax.swing.JLabel();
        pnlFormat = new javax.swing.JPanel();
        rbShp = new javax.swing.JRadioButton();
        rbTif = new javax.swing.JRadioButton();
        lblFiller = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        pnlFee = new javax.swing.JPanel();
        pnlFeePreview = new de.cismet.cids.custom.nas.NasFeePreviewPanel(getConnectionContext());

        setPreferredSize(new java.awt.Dimension(400, 425));
        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            lblProdukt,
            org.openide.util.NbBundle.getMessage(Butler2ProductPanel.class, "Butler2ProductPanel.lblProdukt.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 40);
        add(lblProdukt, gridBagConstraints);

        jScrollPane1.setMinimumSize(new java.awt.Dimension(250, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(258, 150));

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${products}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        lstProdukt,
                        "productBinding");
        bindingGroup.addBinding(jListBinding);

        jScrollPane1.setViewportView(lstProdukt);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 10);
        add(jScrollPane1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFormat,
            org.openide.util.NbBundle.getMessage(Butler2ProductPanel.class, "Butler2ProductPanel.lblFormat.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 40);
        add(lblFormat, gridBagConstraints);

        pnlFormat.setLayout(new java.awt.GridBagLayout());

        btGroupFormat.add(rbShp);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbShp,
            org.openide.util.NbBundle.getMessage(Butler2ProductPanel.class, "Butler2ProductPanel.rbShp.text")); // NOI18N
        rbShp.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    rbShpActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbShp, gridBagConstraints);

        btGroupFormat.add(rbTif);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbTif,
            org.openide.util.NbBundle.getMessage(Butler2ProductPanel.class, "Butler2ProductPanel.rbTif.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        pnlFormat.add(rbTif, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFiller,
            org.openide.util.NbBundle.getMessage(Butler2ProductPanel.class, "Butler2ProductPanel.lblFiller.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlFormat.add(lblFiller, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 10);
        add(pnlFormat, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(jSeparator1, gridBagConstraints);

        pnlFee.setBackground(new java.awt.Color(255, 255, 255));
        pnlFee.setLayout(new java.awt.BorderLayout());
        pnlFee.add(pnlFeePreview, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        add(pnlFee, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void rbShpActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rbShpActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_rbShpActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void loadPrductDescriptions() {
        try {
            final ObjectMapper mapper = new ObjectMapper();
            final ButlerProductInfo tester = mapper.readValue(ButlerProductInfo.class.getResourceAsStream(
                        "/de/cismet/cids/custom/butler/productDescription.json"),
                    ButlerProductInfo.class);
            final ArrayList<ButlerProductGroup> productGroups = tester.getButler2ProductGroups();
            products = productGroups.get(0).getButlerProducts();
            resolutions = productGroups.get(0).getButlerResolutions();
        } catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<ButlerResolution> getResolutions() {
        return resolutions;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  resolutions  DOCUMENT ME!
     */
    public void setResolutions(final ArrayList<ButlerResolution> resolutions) {
        this.resolutions = resolutions;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<ButlerProduct> getProducts() {
        return products;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  products  DOCUMENT ME!
     */
    public void setProducts(final ArrayList<ButlerProduct> products) {
        this.products = products;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Geometry getGeometry() {
        return geom;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  geom  DOCUMENT ME!
     */
    public void setGeometry(final Geometry geom) {
        this.geom = geom;
        calculateFee();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ButlerProduct getSelectedProduct() {
        final ButlerProduct bp = (ButlerProduct)lstProdukt.getSelectedValue();
        if (bp != null) {
            if (rbShp.isSelected()) {
                final ButlerResolution res = new ButlerResolution();
                res.setKey("600");
                bp.setResolution(res);
                bp.setFormat(new ButlerFormat("pdf"));
            } else if (rbTif.isSelected()) {
                final ButlerResolution res = new ButlerResolution();
                res.setKey("600");

                bp.setResolution(res);
                bp.setFormat(new ButlerFormat("tif"));
            }
        }
        return bp;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  listener  DOCUMENT ME!
     */
    public void addProductListSelectionListener(final ListSelectionListener listener) {
        lstProdukt.addListSelectionListener(listener);
    }

    /**
     * DOCUMENT ME!
     */
    private void calculateFee() {
        pnlFee.removeAll();
        pnlFeePreview = new NasFeePreviewPanel(getConnectionContext());
        pnlFeePreview.setDiscount(RASTER_DISCOUNT);
        pnlFeePreview.setGeom(geom);
        pnlFeePreview.refresh();
        pnlFee.add(pnlFeePreview);
        pnlFee.revalidate();
        pnlFee.repaint();
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        calculateFee();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public ArrayList<BillingProductGroupAmount> getProductGroupAmounts() {
        return pnlFeePreview.getProductGroupAmounts();
    }

    @Override
    public void valueChanged(final ListSelectionEvent e) {
        calculateFee();
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
