/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;

import com.fasterxml.jackson.databind.ObjectMapper;

import com.vividsolutions.jts.geom.Geometry;

import org.apache.log4j.Logger;

import java.awt.Component;

import java.text.SimpleDateFormat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;

import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.BaulastBescheinigungHelper;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.commons.gui.progress.BusyLoggingTextPane;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class BaulastBescheinigungDialog extends javax.swing.JDialog implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    public static final Logger LOG = Logger.getLogger(BaulastBescheinigungDialog.class);

    private static BaulastBescheinigungDialog INSTANCE;
    private static ObjectMapper MAPPER = new ObjectMapper();

    //~ Instance fields --------------------------------------------------------

    private BerechtigungspruefungBescheinigungDownloadInfo downloadInfo = null;

    private SwingWorker worker;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.commons.gui.progress.BusyStatusPanel busyStatusPanel1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private de.cismet.commons.gui.progress.BusyLoggingTextPane protokollPane;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form BaulastBescheinigungDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    private BaulastBescheinigungDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static BaulastBescheinigungDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BaulastBescheinigungDialog(null, true);
        }
        return INSTANCE;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  message  DOCUMENT ME!
     */
    public static void addMessage(final String message) {
        getInstance().protokollPane.addMessage(message, BusyLoggingTextPane.Styles.INFO);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  message  DOCUMENT ME!
     */
    public void addError(final String message) {
        protokollPane.addMessage(message, BusyLoggingTextPane.Styles.ERROR);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        protokollPane = new de.cismet.commons.gui.progress.BusyLoggingTextPane();
        jPanel9 = new javax.swing.JPanel();
        busyStatusPanel1 = new de.cismet.commons.gui.progress.BusyStatusPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel2,
            org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 4);
        jPanel1.add(jLabel2, gridBagConstraints);

        jTextField1.setText(org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jTextField1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jTextField1, gridBagConstraints);

        jTextField2.setText(org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jTextField2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel1.add(jTextField2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel3.add(jPanel1, gridBagConstraints);

        jPanel4.setMinimumSize(new java.awt.Dimension(500, 27));
        jPanel4.setPreferredSize(new java.awt.Dimension(500, 27));
        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridLayout(1, 0, 5, 0));

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton2,
            org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jButton2.text")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton2ActionPerformed(evt);
                }
            });
        jPanel2.add(jButton2);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton1,
            org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        jPanel2.add(jButton1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        jPanel4.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jPanel7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel3.add(jPanel4, gridBagConstraints);

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder(
                org.openide.util.NbBundle.getMessage(
                    BaulastBescheinigungDialog.class,
                    "BaulastBescheinigungDialog.jPanel8.border.title"))); // NOI18N
        jPanel8.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setMinimumSize(new java.awt.Dimension(500, 300));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(520, 250));

        protokollPane.setEditable(false);
        jScrollPane1.setViewportView(protokollPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel8.add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel3.add(jPanel8, gridBagConstraints);

        jPanel9.setMinimumSize(new java.awt.Dimension(400, 27));
        jPanel9.setOpaque(false);
        jPanel9.setPreferredSize(new java.awt.Dimension(400, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel9, gridBagConstraints);

        busyStatusPanel1.setStatusMessage(org.openide.util.NbBundle.getMessage(
                BaulastBescheinigungDialog.class,
                "BaulastBescheinigungDialog.busyStatusPanel1.statusMessage")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel3.add(busyStatusPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jPanel3, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  flurstuecke        DOCUMENT ME!
     * @param  parent             DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public void show(final Collection<CidsBean> flurstuecke,
            final Component parent,
            final ConnectionContext connectionContext) {
        try {
            this.connectionContext = connectionContext;
            final List<CidsBean> flurstueckeList = new ArrayList<>(new HashSet<>(flurstuecke));

            jTextField2.setText(new SimpleDateFormat("yy").format(new Date()) + "-");
            jPanel1.setVisible(!BillingPopup.hasUserBillingMode(getConnectionContext()));

            prepareDownload(flurstueckeList);

            StaticSwingTools.showDialog(this);
        } catch (final Exception ex) {
            LOG.error(ex, ex);
            // TODO SHOW ERROR
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        try {
            boolean berechtigungspruefung = false;
            try {
                berechtigungspruefung = SessionManager.getConnection()
                            .hasConfigAttr(
                                    SessionManager.getSession().getUser(),
                                    "berechtigungspruefung_baulastbescheinigung",
                                    getConnectionContext());
            } catch (final ConnectionException ex) {
                LOG.info("could not check config attr", ex);
            }

            final boolean hasBilling = BillingPopup.hasUserBillingMode(getConnectionContext());
            downloadInfo.setAuftragsnummer(hasBilling ? null : jTextField2.getText());
            downloadInfo.setProduktbezeichnung(hasBilling ? null : jTextField1.getText());

            final Collection<BillingProductGroupAmount> prodAmounts = new ArrayList<>();
            for (final HashMap.Entry<String, Integer> amount : downloadInfo.getAmounts().entrySet()) {
                prodAmounts.add(new BillingProductGroupAmount(amount.getKey(), amount.getValue()));
            }
            if (BillingPopup.doBilling(
                            "blab_be",
                            MAPPER.writeValueAsString(downloadInfo),
                            (Geometry)null,
                            (berechtigungspruefung
                                && AlkisProductDownloadHelper.checkBerechtigungspruefung(
                                    downloadInfo.getProduktTyp(),
                                    getConnectionContext())) ? downloadInfo : null,
                            getConnectionContext(),
                            prodAmounts.toArray(new BillingProductGroupAmount[0]))) {
                final String berechnung = BillingPopup.getInstance().getBerechnungsProtokoll();
                if ((berechnung != null) && !berechnung.trim().isEmpty()) {
                    addMessage("\n===\n\nGebührenberechnung:\n");
                    addMessage(berechnung);
                }

                AlkisProductDownloadHelper.downloadBaulastbescheinigung(downloadInfo, "", getConnectionContext());
            }
        } catch (final Exception ex) {
            LOG.error(ex, ex);
            // TODO SHOW ERROR
        }

        setVisible(false);
    } //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  flurstuecke  DOCUMENT ME!
     */
    public void prepareDownload(final List<CidsBean> flurstuecke) {
        boolean checkProtokollPane = false;
        try {
            checkProtokollPane = SessionManager.getConnection()
                        .hasConfigAttr(SessionManager.getSession().getUser(),
                                "baulast.bescheinigung.protokollpane_enabled",
                                getConnectionContext());
        } catch (ConnectionException ex) {
        }
        jPanel8.setVisible(checkProtokollPane);

        try {
            if ((worker != null) && !worker.isDone()) {
                worker.cancel(true);
            }

            try {
                protokollPane.getDocument().remove(0, protokollPane.getDocument().getLength());
            } catch (BadLocationException ex) {
                LOG.error("Could not clear Protokoll Pane", ex);
            }
            jButton1.setEnabled(false);
            protokollPane.setBusy(true);
            busyStatusPanel1.setBusy(true);

            pack();

            worker = new SwingWorker<BerechtigungspruefungBescheinigungDownloadInfo, Void>() {

                    @Override
                    protected BerechtigungspruefungBescheinigungDownloadInfo doInBackground() throws Exception {
                        final boolean hasBilling = BillingPopup.hasUserBillingMode(getConnectionContext());
                        return
                            new ClientBaulastBescheinigungHelper(getConnectionContext()).calculateDownloadInfo(
                                hasBilling ? null : jTextField2.getText(),
                                hasBilling ? null : jTextField1.getText(),
                                AlkisUtils.createBaulastenFertigungsVermerk(
                                    SessionManager.getSession().getUser(),
                                    getConnectionContext()),
                                flurstuecke,
                                new BaulastBescheinigungHelper.ProtocolBuffer() {

                                    @Override
                                    public BaulastBescheinigungHelper.ProtocolBuffer appendLine(
                                            final String string) {
                                        addMessage(string);
                                        return super.appendLine(string);
                                    }
                                },
                                new BaulastBescheinigungHelper.StatusHolder() {

                                    @Override
                                    public void setMessage(final String message) {
                                        super.setMessage(message);
                                        setStatusMessage(message);
                                    }
                                });
                    }

                    @Override
                    protected void done() {
                        boolean errorOccurred = false;
                        try {
                            downloadInfo = get();
                        } catch (final Exception ex) {
                            downloadInfo = null;
                            errorOccurred = true;
                            final String errMessage;
                            final Throwable exception;
                            if (ex.getCause() instanceof ClientBaulastBescheinigungHelper.BaBeException) {
                                exception = ex.getCause();
                                errMessage = exception.getMessage();
                                addError(errMessage);
                            } else {
                                exception = ex;
                                LOG.error(ex, ex);
                                errMessage = exception.getMessage();
                                addError("Es ist ein Fehler aufgetreten: " + errMessage);
                            }
                            if (!(ex instanceof CancellationException)) {
                                JOptionPane.showMessageDialog(
                                    BaulastBescheinigungDialog.this,
                                    errMessage,
                                    "Es ist ein Fehler aufgetreten.",
                                    JOptionPane.ERROR_MESSAGE);
                            }
                        } finally {
                            if (errorOccurred) {
                                setStatusMessage("Es ist ein Fehler aufgetreten.");
                            } else {
                                setStatusMessage("Die Bescheinigung kann jetzt erzeugt werden.");
                            }
                            busyStatusPanel1.setBusy(false);
                            protokollPane.setBusy(false);
                            jButton1.setEnabled(!errorOccurred);
                        }
                    }
                };
            worker.execute();
        } catch (final Exception ex) {
            LOG.fatal(ex, ex);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  downloadInfo produktbezeichnung DOCUMENT ME!
     */
    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        setVisible(false);
        if ((worker != null) && !worker.isDone()) {
            worker.cancel(true);
        }
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (final javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(BaulastBescheinigungDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(BaulastBescheinigungDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(BaulastBescheinigungDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(BaulastBescheinigungDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        try {
            DevelopmentTools.initSessionManagerFromRMIConnectionOnLocalhost("WUNDA_BLAU", null, "admin", "");
        } catch (final Exception ex) {
            LOG.fatal(ex, ex);
            System.exit(1);
        }

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final BaulastBescheinigungDialog dialog = BaulastBescheinigungDialog.getInstance();
                    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                            @Override
                            public void windowClosing(final java.awt.event.WindowEvent e) {
                                System.exit(0);
                            }
                        });
//                    dialog.show(BaulastBescheinigungDialog.createTestFlurstuecke(), new javax.swing.JFrame());
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param  message  DOCUMENT ME!
     */
    private void setStatusMessage(final String message) {
        busyStatusPanel1.setStatusMessage(message);
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
