/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * AlLuftbildFeatureRenderer.java
 *
 *
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;

import java.io.IOException;

import java.util.Properties;

import javax.swing.JComponent;

import de.cismet.cids.featurerenderer.*;

import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;

/**
 * DOCUMENT ME!
 *
 * @author   sandra
 * @version  $Revision$, $Date$
 */
public class AlLuftbildFeatureRenderer extends CustomCidsFeatureRenderer {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            AlLuftbildFeatureRenderer.class);
    public static final String FIELD__KAT__KEY = "fk_kategorie.schluessel";

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel lblImagePreview;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlLuftbildFeatureRenderer object.
     */
    public AlLuftbildFeatureRenderer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("AlLuftbildFeatureRenderer init()");
        }
        initComponents();
        setOpaque(false);
        setPreferredSize(new Dimension(150, 150));
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void assign() {
        this.cidsBean = metaObject.getBean();
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    @Override
    public Paint getFillingStyle() {
        return new Color(255, 255, 255, 0);
    }

    @Override
    public Stroke getLineStyle() {
        final String kategorie = (String)cidsBean.getProperty(FIELD__KAT__KEY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AlLuftbildFeatureRenderer GetLineStyle " + kategorie);
        }
        if ("ohne".equals(kategorie)) {
            return new CustomFixedWidthStroke(5.0f);
        } else {
            return new CustomFixedWidthStroke(10.0f);
        }
    }

    @Override
    public Paint getLinePaint() {
        final String kategorie = (String)cidsBean.getProperty(FIELD__KAT__KEY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AlLuftbildFeatureRenderer GetLinePaint " + kategorie);
        }
        if (kategorie == null) {
            return new Color(0, 0, 0, 255);
        } else {
            switch (kategorie) {
                case "gut": {
                    return new Color(0, 255, 0, 50);
                }
                case "mittel": {
                    return new Color(255, 136, 0, 50);
                }
                case "schlecht": {
                    return new Color(255, 0, 0, 50);
                }
                case "ohne": {
                    return new Color(0, 0, 255, 50);
                }
                default: {
                    return new Color(255, 255, 255, 50);
                }
            }
        }
    }

    @Override
    public JComponent getInfoComponent(final Refreshable arg0) {
        super.getInfoComponent(arg0);
        return null;
    }

    @Override
    public String getAlternativeName() {
        return (String)cidsBean.getProperty("dateiname");
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        lblImagePreview = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        setPreferredSize(new java.awt.Dimension(100, 100));
        setLayout(new java.awt.BorderLayout());

        lblImagePreview.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblImagePreview.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png"))); // NOI18N
        lblImagePreview.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseExited(final java.awt.event.MouseEvent evt) {
                    lblImagePreviewMouseExited(evt);
                }
                @Override
                public void mouseEntered(final java.awt.event.MouseEvent evt) {
                    lblImagePreviewMouseEntered(evt);
                }
            });
        add(lblImagePreview, java.awt.BorderLayout.CENTER);

        jLabel12.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel12.setText("Höhere Auflösung durch Mausklick.");
        add(jLabel12, java.awt.BorderLayout.PAGE_END);
    } // </editor-fold>//GEN-END:initComponents
    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblImagePreviewMouseExited(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblImagePreviewMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }                                                                              //GEN-LAST:event_lblImagePreviewMouseExited

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblImagePreviewMouseEntered(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblImagePreviewMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }                                                                               //GEN-LAST:event_lblImagePreviewMouseEntered
}
