/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.MetaClass;

import com.vividsolutions.jts.geom.Point;

import org.apache.log4j.Logger;

import org.openide.util.Exceptions;

import de.cismet.cids.custom.objecteditors.utils.BaumConfProperties;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   sandra
 * @version  $Revision$, $Date$ Vorschau der Geometrie wird an einem Ort gesteuert
 */
public class BaumLagePanel extends javax.swing.JPanel implements Disposable {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(BaumLagePanel.class);
    public static final String FIELD__ID = "id";
    public static final String FIELD__GEOM = "fk_geom";
    public static final String FIELD__GEO_FIELD = "geo_field"; // geom
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_GEOM = "geom";

    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JLabel lblKarte;
    javax.swing.JPanel panContent;
    javax.swing.JPanel panGeometrie;
    javax.swing.JPanel panLage;
    de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel panPreviewMap;
    de.cismet.tools.gui.RoundedPanel rpKarte;
    de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanel7;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new BaumLagePanel object.
     */
    public BaumLagePanel() {
        panPreviewMap = new DefaultPreviewMapPanel();
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        panContent = new javax.swing.JPanel();
        panGeometrie = new javax.swing.JPanel();
        panLage = new javax.swing.JPanel();
        rpKarte = new de.cismet.tools.gui.RoundedPanel();
        panPreviewMap = new de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel();
        semiRoundedPanel7 = new de.cismet.tools.gui.SemiRoundedPanel();
        lblKarte = new javax.swing.JLabel();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        panContent.setName(""); // NOI18N
        panContent.setOpaque(false);
        panContent.setPreferredSize(new java.awt.Dimension(205, 400));
        panContent.setLayout(new java.awt.GridBagLayout());

        panGeometrie.setMinimumSize(new java.awt.Dimension(50, 200));
        panGeometrie.setName("panGeometrie"); // NOI18N
        panGeometrie.setOpaque(false);
        panGeometrie.setLayout(new java.awt.GridBagLayout());

        panLage.setName("panLage"); // NOI18N
        panLage.setOpaque(false);
        panLage.setLayout(new java.awt.GridBagLayout());

        rpKarte.setName(""); // NOI18N
        rpKarte.setLayout(new java.awt.GridBagLayout());

        panPreviewMap.setName("panPreviewMap"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        rpKarte.add(panPreviewMap, gridBagConstraints);

        semiRoundedPanel7.setBackground(java.awt.Color.darkGray);
        semiRoundedPanel7.setName("semiRoundedPanel7"); // NOI18N
        semiRoundedPanel7.setLayout(new java.awt.GridBagLayout());

        lblKarte.setForeground(new java.awt.Color(255, 255, 255));
        org.openide.awt.Mnemonics.setLocalizedText(
            lblKarte,
            org.openide.util.NbBundle.getMessage(BaumLagePanel.class, "BaumLagePanel.lblKarte.text")); // NOI18N
        lblKarte.setName("lblKarte");                                                                  // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        semiRoundedPanel7.add(lblKarte, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        rpKarte.add(semiRoundedPanel7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panLage.add(rpKarte, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panGeometrie.add(panLage, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 2);
        panContent.add(panGeometrie, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(panContent, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void dispose() {
        if (panPreviewMap != null) {
            panPreviewMap.dispose();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean           DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     * @param  mapCallString      DOCUMENT ME!
     */
    public void setMapWindow(final CidsBean cidsBean,
            final ConnectionContext connectionContext,
            final String mapCallString) {
        Double bufferMeter = 0.0;
        try {
            bufferMeter = BaumConfProperties.getInstance().getBufferMeter();
        } catch (final Exception ex) {
            LOG.warn("Get no conf properties.", ex);
        }
        if (cidsBean != null) {
            try {
                if (cidsBean.getProperty(FIELD__GEOM) != null) {
                    panPreviewMap.initMap(cidsBean, FIELD__GEOREFERENZ__GEO_FIELD, bufferMeter, mapCallString);
                } else {
                    if (cidsBean.getProperty(FIELD__GEO_FIELD) != null) {
                        panPreviewMap.initMap(cidsBean, FIELD__GEO_FIELD, bufferMeter, mapCallString);
                    } else {
                        final CidsBean newGeom = createDefaultGeom(connectionContext);
                        panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, bufferMeter, mapCallString);
                    }
                }
            } catch (final Exception ex) {
                LOG.warn("Map window not set.", ex);
            }
        } else {
            final CidsBean newGeom = createDefaultGeom(connectionContext);
            panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, bufferMeter);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   connectionContext  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public CidsBean createDefaultGeom(final ConnectionContext connectionContext) {
        final int srid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
        final BoundingBox initialBoundingBox;
        initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
        final Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();

        final MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass(
                CidsBeanSupport.DOMAIN_NAME,
                TABLE_GEOM,
                connectionContext);
        final CidsBean newGeom = geomMetaClass.getEmptyInstance(connectionContext).getBean();
        try {
            newGeom.setProperty(FIELD__GEO_FIELD, centerPoint);
        } catch (Exception ex) {
            Exceptions.printStackTrace(ex);
        }
        return newGeom;
    }
}
