/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import lombok.Getter;

import org.apache.log4j.Logger;

import java.awt.BorderLayout;

import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.abfrage.AbstractAbfragePanel;
import de.cismet.cids.custom.wunda_blau.search.server.StorableSearch;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class CsSearchconfEditor extends javax.swing.JPanel implements CidsBeanRenderer,
    ConnectionContextStore,
    EditorSaveListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(CsSearchconfEditor.class);

    //~ Instance fields --------------------------------------------------------

    AbstractAbfragePanel searchPanel = null;

    @Getter private final boolean editable;
    private CidsBean cidsBean;

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JPanel searchPanelHolder;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new CsSearchconfEditor object.
     */
    public CsSearchconfEditor() {
        this(true);
    }

    /**
     * Creates a new CsSearchconfEditor object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public CsSearchconfEditor(final boolean editable) {
        this.editable = editable;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        searchPanelHolder = new javax.swing.JPanel();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel3.setText("Name:");   // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel3, gridBagConstraints);

        jTextField1.setName("jTextField1"); // NOI18N

        final org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                jTextField1,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jTextField1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel1, gridBagConstraints);

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jScrollPane1.setName("jScrollPane1"); // NOI18N

        searchPanelHolder.setName("searchPanelHolder"); // NOI18N
        searchPanelHolder.setOpaque(false);
        searchPanelHolder.setLayout(new java.awt.BorderLayout());
        jScrollPane1.setViewportView(searchPanelHolder);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jScrollPane1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }
    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            cidsBean.setArtificialChangeFlag(true);
        }
        if (!editable) {
            RendererTools.makeReadOnly(bindingGroup, "cidsBean");
        }
        bindingGroup.bind();
        searchPanelHolder.removeAll();
        if (searchPanelHolder != null) {
            final String seachInfoJson = (cidsBean != null) ? (String)cidsBean.getProperty("conf_json") : null;
            final String searchName = (cidsBean != null) ? (String)cidsBean.getProperty("search_name") : null;

            searchPanel = CsSearchconfPanelHandler.getInstance().getStorableSearchPanel(searchName, isEditable());
            if (searchPanel != null) {
                searchPanel.initWithConnectionContext(getConnectionContext());
                searchPanel.setOpaque(false);
                searchPanelHolder.add(searchPanel, BorderLayout.CENTER);
                StorableSearch.Configuration searchInfo;
                try {
                    searchInfo = searchPanel.readConfiguration(seachInfoJson);
                } catch (final Exception ex) {
                    searchInfo = null;
                }
                searchPanel.initFromConfiguration(searchInfo);
            }
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getTitle() {
        return String.format(
                "Abfrage: %s",
                ((cidsBean != null) && (cidsBean.getProperty("name") != null)) ? (String)cidsBean.getProperty("name")
                                                                               : "");
    }

    @Override
    public void setTitle(final String string) {
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        initComponents();

        jPanel1.setVisible(isEditable());
        if (searchPanel != null) {
            searchPanel.initWithConnectionContext(connectionContext);
        }
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    @Override
    public void editorClosed(final EditorClosedEvent ece) {
    }

    @Override
    public boolean prepareForSave() {
        try {
            cidsBean.setProperty("conf_json", searchPanel.createConfiguration());
            return true;
        } catch (final Exception ex) {
            LOG.error(ex, ex);
            return false;
        }
    }
}
