/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import org.openide.util.NbBundle;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.cismet.cids.custom.wunda_blau.search.server.Sb_maxBildnummerFetcherServerSearch;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class Sb_stadtbildserieEditorAddBildnummerDialog extends javax.swing.JDialog
        implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Pattern noAlphaSuffixPattern = Pattern.compile(".*[a-zA-Z]$");
    private static final Pattern sixNumbersPattern = Pattern.compile("\\d{6}$");
    public static final String DOMAIN = "WUNDA_BLAU";
    public static final String STADTBILDER_TABLE = "SB_STADTBILD";

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            Sb_stadtbildserieEditorAddBildnummerDialog.class);

    //~ Instance fields --------------------------------------------------------

    private final ArrayList<String> bildnummernToAdd = new ArrayList<String>();
    private final HashMap<String, CidsBean> stadtBilderBeans = new HashMap<String, CidsBean>();
    private final BildnummerEvaluationDocumentListener bildnummerEvaluationDocumentListener =
        new BildnummerEvaluationDocumentListener();
    private ShowWarning showWarning;

    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnOk;
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private org.jdesktop.swingx.JXBusyLabel lblBusy;
    private javax.swing.JLabel lblWarning;
    private javax.swing.JTextField txtFromBildnummer;
    private javax.swing.JTextField txtTillBildnummer;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form Sb_stadtbildserieEditorAddBildnummerDialog.
     *
     * @param  parent             DOCUMENT ME!
     * @param  modal              DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public Sb_stadtbildserieEditorAddBildnummerDialog(final java.awt.Frame parent,
            final boolean modal,
            final ConnectionContext connectionContext) {
        super(parent, modal);
        this.connectionContext = connectionContext;

        initComponents();
        new NextBildNummerFetcherWorker().execute();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        txtFromBildnummer = new javax.swing.JTextField();
        btnOk = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        txtTillBildnummer = new javax.swing.JTextField();
        lblWarning = new javax.swing.JLabel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        lblBusy = new org.jdesktop.swingx.JXBusyLabel(new java.awt.Dimension(20, 20));

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.title")); // NOI18N
        setPreferredSize(new java.awt.Dimension(500, 170));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        txtFromBildnummer.setText(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.txtFromBildnummer.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtFromBildnummer, gridBagConstraints);
        txtFromBildnummer.getDocument().addDocumentListener(bildnummerEvaluationDocumentListener);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnOk,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.btnOk.text")); // NOI18N
        btnOk.setEnabled(false);
        btnOk.setPreferredSize(new java.awt.Dimension(75, 26));
        btnOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnOk, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnCancel,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.btnCancel.text")); // NOI18N
        btnCancel.setPreferredSize(new java.awt.Dimension(110, 26));
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnCancel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel2,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel2, gridBagConstraints);

        txtTillBildnummer.setText(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.txtTillBildnummer.text")); // NOI18N
        txtTillBildnummer.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtTillBildnummerActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtTillBildnummer, gridBagConstraints);
        txtTillBildnummer.getDocument().addDocumentListener(bildnummerEvaluationDocumentListener);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblWarning,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.text")); // NOI18N
        lblWarning.setPreferredSize(new java.awt.Dimension(120, 15));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(lblWarning, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(filler1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(filler2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblBusy,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieEditorAddBildnummerDialog.class,
                "Sb_stadtbildserieEditorAddBildnummerDialog.lblBusy.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        getContentPane().add(lblBusy, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtTillBildnummerActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtTillBildnummerActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_txtTillBildnummerActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOkActionPerformed
        stadtBilderBeans.clear();
        final StringBuilder bildnummern = new StringBuilder("'" + bildnummernToAdd.get(0) + "'");
        for (int i = 1; i < bildnummernToAdd.size(); i++) {
            bildnummern.append(",");
            bildnummern.append("'").append(bildnummernToAdd.get(i)).append("'");
        }
        final MetaClass mc = ClassCacheMultiple.getMetaClass(DOMAIN, STADTBILDER_TABLE, getConnectionContext());
        final String query = "SELECT "
                    + mc.getID()
                    + ", "
                    + mc.getPrimaryKey()
                    + " FROM "
                    + mc.getTableName()
                    + " WHERE "
                    + " bildnummer IN (" + bildnummern + ")"
                    + " order by bildnummer";
        try {
            final MetaObject[] metaObjects = SessionManager.getProxy()
                        .getMetaObjectByQuery(SessionManager.getSession().getUser(),
                            query,
                            DOMAIN,
                            getConnectionContext());
            for (final MetaObject mo : metaObjects) {
                final CidsBean cb = mo.getBean();
                stadtBilderBeans.put((String)cb.getProperty("bildnummer"), cb);
            }
            for (final String bildnummer : bildnummernToAdd) {
                if (!stadtBilderBeans.containsKey(bildnummer)) {
                    final MetaObject metaObject = mc.getEmptyInstance(getConnectionContext());
                    metaObject.setStatus(MetaObject.NEW);
                    final CidsBean cidsBean = metaObject.getBean();
                    try {
                        cidsBean.setProperty("bildnummer", bildnummer);
                        stadtBilderBeans.put(bildnummer, cidsBean);
                    } catch (Exception ex) {
                        LOG.warn(ex, ex);
                    }
                }
            }
        } catch (ConnectionException ex) {
            LOG.warn(ex, ex);
            stadtBilderBeans.clear();
        } finally {
            setVisible(false);
            dispose();
        }
    }                                                                         //GEN-LAST:event_btnOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        stadtBilderBeans.clear();
        setVisible(false);
        dispose();
    }                                                                             //GEN-LAST:event_btnCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Collection<CidsBean> showDialog() {
        StaticSwingTools.showDialog(this);
        return stadtBilderBeans.values();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (final javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final Sb_stadtbildserieEditorAddBildnummerDialog dialog =
                        new Sb_stadtbildserieEditorAddBildnummerDialog(new javax.swing.JFrame(), true, null);
                    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                            @Override
                            public void windowClosing(final java.awt.event.WindowEvent e) {
                                System.exit(0);
                            }
                        });
                    dialog.setVisible(true);
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param   a  DOCUMENT ME!
     * @param   b  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private static String greatestCommonPrefix(final String a, final String b) {
        final int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; i++) {
            if (a.charAt(i) != b.charAt(i)) {
                return a.substring(0, i);
            }
        }
        return a.substring(0, minLength);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  error  DOCUMENT ME!
     */
    private void showError(final String error) {
        if (showWarning != null) {
            showWarning.stop();
        }
        lblWarning.setText(error);
        lblWarning.setForeground(Color.red);
        btnOk.setEnabled(false);
    }

    /**
     * DOCUMENT ME!
     */
    private void clearWarningOrError() {
        if (showWarning != null) {
            showWarning.stop();
        }
        lblWarning.setText("");
        btnOk.setEnabled(true);
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class BildnummerEvaluationDocumentListener implements DocumentListener {

        //~ Instance fields ----------------------------------------------------

        private final Timer timer;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new BildnummerEvaluationDocumentListener object.
         */
        public BildnummerEvaluationDocumentListener() {
            timer = new Timer(300, new ActionListener() {

                        @Override
                        public void actionPerformed(final ActionEvent e) {
                            evaluateBildnummern();
                        }
                    });
            timer.setRepeats(false);
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public void insertUpdate(final DocumentEvent e) {
            timer.restart();
        }

        @Override
        public void removeUpdate(final DocumentEvent e) {
            timer.restart();
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            timer.restart();
        }

        /**
         * DOCUMENT ME!
         */
        private void evaluateBildnummern() {
            final String fromBildnummer = txtFromBildnummer.getText().trim();
            final String tillBildnummer = txtTillBildnummer.getText().trim();

            if (fromBildnummer.isEmpty()) {
                clearWarningOrError();
                btnOk.setEnabled(false);
                return;
            }

            // No intent to enter an interval. The FromBildnummer can be everything.
            if (tillBildnummer.isEmpty()) {
                bildnummernToAdd.clear();
                bildnummernToAdd.add(txtFromBildnummer.getText());
                if (!sixNumbersPattern.matcher(fromBildnummer).matches()) {
                    showWarning = new ShowWarning(NbBundle.getMessage(
                                BildnummerEvaluationDocumentListener.class,
                                "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.sixNumbers"));
                    showWarning.start();
                } else {
                    clearWarningOrError();
                }
                return;
            }

            if (noAlphaSuffixPattern.matcher(fromBildnummer).matches()
                        || noAlphaSuffixPattern.matcher(tillBildnummer).matches()) {
                // there are letters as suffix in the numbers
                showError(NbBundle.getMessage(
                        Sb_stadtbildserieEditorAddBildnummerDialog.class,
                        "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.suffixLetter"));
            } else if (fromBildnummer.equalsIgnoreCase(tillBildnummer)) {
                showError(NbBundle.getMessage(
                        BildnummerEvaluationDocumentListener.class,
                        "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.equals"));
            } else if (fromBildnummer.length() != tillBildnummer.length()) {
                showError(NbBundle.getMessage(
                        BildnummerEvaluationDocumentListener.class,
                        "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.length"));
            } else { // normal interval

                final String prefix = greatestCommonPrefix(fromBildnummer, tillBildnummer);
                final int prefix_length = prefix.length();
                final String begin_str = fromBildnummer.substring(prefix_length);
                final String end_str = tillBildnummer.substring(prefix_length);
                final int begin = Integer.parseInt(begin_str);
                final int end = Integer.parseInt(end_str);
                if (begin >= end) {
                    showError(NbBundle.getMessage(
                            BildnummerEvaluationDocumentListener.class,
                            "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.endBiggerThanBegining"));
                } else {
                    final String intToStringFormat = "%0" + end_str.length() + "d";
                    bildnummernToAdd.clear();
                    for (int i = begin; i <= end; i++) {
                        bildnummernToAdd.add(prefix + String.format(intToStringFormat, i));
                    }
                    if (!sixNumbersPattern.matcher(fromBildnummer).matches()
                                || !sixNumbersPattern.matcher(tillBildnummer).matches()) {
                        showWarning = new ShowWarning(NbBundle.getMessage(
                                    BildnummerEvaluationDocumentListener.class,
                                    "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.sixNumbers"));
                        showWarning.start();
                    } else if ((end - begin) > 300) {
                        showWarning = new ShowWarning(NbBundle.getMessage(
                                    BildnummerEvaluationDocumentListener.class,
                                    "Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.tooBig"));
                        showWarning.start();
                    } else {
                        clearWarningOrError();
                    }
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class ShowWarning {

        //~ Static fields/initializers -----------------------------------------

        private static final int TIMER_PERIOD = 1000;
        protected static final int MAX_COUNT = 2;

        //~ Instance fields ----------------------------------------------------

        private int count;
        private Timer timer;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new ShowWarning object.
         *
         * @param  warning  DOCUMENT ME!
         */
        public ShowWarning(final String warning) {
            if (showWarning != null) {
//stop the old showWarning
                showWarning.stop();
            }
            lblWarning.setText(warning);
            lblWarning.setForeground(Color.black);
            btnOk.setEnabled(false);
            final String text = "Ok (" + (MAX_COUNT - count + 1) + ")";
            btnOk.setText(text);
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         */
        public void start() {
            timer = new Timer(TIMER_PERIOD, new ActionListener() {

                        @Override
                        public void actionPerformed(final ActionEvent e) {
                            if (count < MAX_COUNT) {
                                count++;
                                final String text = "Ok (" + (MAX_COUNT - count + 1) + ")";
                                btnOk.setText(text);
                                btnOk.setEnabled(false);
                            } else {
                                ((Timer)e.getSource()).stop();
                                btnOk.setEnabled(true);
                                btnOk.setText("Ok");
                            }
                        }
                    });
            timer.start();
        }

        /**
         * DOCUMENT ME!
         */
        public void stop() {
            btnOk.setText("Ok");
            btnOk.setEnabled(true);
            timer.stop();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class NextBildNummerFetcherWorker extends SwingWorker<Integer, Void> {

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new NextBildNummerFetcherWorker object.
         */
        public NextBildNummerFetcherWorker() {
            txtFromBildnummer.setEnabled(false);
            lblBusy.setVisible(true);
            lblBusy.setBusy(true);
        }

        //~ Methods ------------------------------------------------------------

        @Override
        protected Integer doInBackground() throws Exception {
            final Sb_maxBildnummerFetcherServerSearch maxBildnummerFetcher = new Sb_maxBildnummerFetcherServerSearch();
            final Collection maxBildnummerCollection = SessionManager.getConnection()
                        .customServerSearch(SessionManager.getSession().getUser(),
                            maxBildnummerFetcher,
                            getConnectionContext());
            if ((maxBildnummerCollection != null) && !maxBildnummerCollection.isEmpty()) {
                final ArrayList firstColumnObject = (ArrayList)maxBildnummerCollection.toArray(new Object[1])[0];
                final Object firstRowObject = firstColumnObject.get(0);
                return (Integer)firstRowObject;
            }
            return null;
        }

        @Override
        protected void done() {
            Integer maxBildnummer = null;
            try {
                maxBildnummer = get();
            } catch (InterruptedException ex) {
                LOG.warn(ex, ex);
            } catch (ExecutionException ex) {
                LOG.warn(ex, ex);
            }
            if (maxBildnummer != null) {
                final String nextBildnummer = Integer.toString(maxBildnummer + 1);
                txtFromBildnummer.setText(nextBildnummer);
            } else {
                txtFromBildnummer.requestFocusInWindow();
            }
            txtFromBildnummer.setEnabled(true);
            lblBusy.setVisible(false);
            lblBusy.setBusy(false);
        }
    }
}
