/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.cismet.cids.client.tools.WebDavTunnelHelper;

import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;

import de.cismet.cids.server.actions.WebDavTunnelAction;

import de.cismet.cismap.commons.gui.MappingComponent;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.CismetThreadPool;

import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class SimpleWebDavPanel extends javax.swing.JPanel implements CidsBeanStore,
    EditorSaveListener,
    Disposable,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(SimpleWebDavPanel.class);

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        bindingGroup = new BindingGroup();

        final RoundedPanel pnlFotos = new RoundedPanel();
        final SemiRoundedPanel pnlHeaderFotos = new SemiRoundedPanel();
        final JLabel lblHeaderFotos = new JLabel();
        final JPanel jPanel2 = new JPanel();
        final JPanel jPanel1 = new JPanel();
        final JScrollPane jspFotoList = new JScrollPane();
        lstFotos = new JList();
        final JPanel pnlCtrlButtons = new JPanel();
        btnAddImg = new JButton();
        btnRemoveImg = new JButton();

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new GridBagLayout());

        pnlFotos.setMinimumSize(new Dimension(400, 200));
        pnlFotos.setName("pnlFotos"); // NOI18N
        pnlFotos.setPreferredSize(new Dimension(400, 200));
        pnlFotos.setLayout(new GridBagLayout());

        pnlHeaderFotos.setBackground(new Color(51, 51, 51));
        pnlHeaderFotos.setForeground(new Color(51, 51, 51));
        pnlHeaderFotos.setName("pnlHeaderFotos"); // NOI18N
        pnlHeaderFotos.setLayout(new FlowLayout());

        lblHeaderFotos.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText(
            lblHeaderFotos,
            NbBundle.getMessage(SimpleWebDavPanel.class, "SimpleWebDavPanel.lblHeaderFotos.text")); // NOI18N
        lblHeaderFotos.setName("lblHeaderFotos");                                                   // NOI18N
        pnlHeaderFotos.add(lblHeaderFotos);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        pnlFotos.add(pnlHeaderFotos, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());

        jspFotoList.setMinimumSize(new Dimension(250, 130));
        jspFotoList.setName("jspFotoList"); // NOI18N

        lstFotos.setName("lstFotos"); // NOI18N

        final ELProperty eLProperty = ELProperty.create("${cidsBean." + beanCollProp + "}");
        final JListBinding jListBinding = SwingBindings.createJListBinding(
                AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                eLProperty,
                lstFotos);
        bindingGroup.addBinding(jListBinding);

        lstFotos.addMouseListener(formListener);
        lstFotos.addListSelectionListener(formListener);
        jspFotoList.setViewportView(lstFotos);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jspFotoList, gridBagConstraints);

        pnlCtrlButtons.setName("pnlCtrlButtons"); // NOI18N
        pnlCtrlButtons.setOpaque(false);
        pnlCtrlButtons.setLayout(new GridBagLayout());

        btnAddImg.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png"))); // NOI18N
        Mnemonics.setLocalizedText(
            btnAddImg,
            NbBundle.getMessage(SimpleWebDavPanel.class, "SimpleWebDavPanel.btnAddImg.text"));                 // NOI18N
        btnAddImg.setBorderPainted(false);
        btnAddImg.setContentAreaFilled(false);
        btnAddImg.setName("btnAddImg");                                                                        // NOI18N
        btnAddImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        pnlCtrlButtons.add(btnAddImg, gridBagConstraints);

        btnRemoveImg.setIcon(new ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png"))); // NOI18N
        Mnemonics.setLocalizedText(
            btnRemoveImg,
            NbBundle.getMessage(SimpleWebDavPanel.class, "SimpleWebDavPanel.btnRemoveImg.text"));                 // NOI18N
        btnRemoveImg.setBorderPainted(false);
        btnRemoveImg.setContentAreaFilled(false);
        btnRemoveImg.setName("btnRemoveImg");                                                                     // NOI18N
        btnRemoveImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pnlCtrlButtons.add(btnRemoveImg, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel1.add(pnlCtrlButtons, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        jPanel2.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlFotos.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(pnlFotos, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements ActionListener, MouseListener, ListSelectionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent evt) {
            if (evt.getSource() == btnAddImg) {
                SimpleWebDavPanel.this.btnAddImgActionPerformed(evt);
            } else if (evt.getSource() == btnRemoveImg) {
                SimpleWebDavPanel.this.btnRemoveImgActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(final MouseEvent evt) {
            if (evt.getSource() == lstFotos) {
                SimpleWebDavPanel.this.lstFotosMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(final MouseEvent evt) {
        }

        @Override
        public void mouseExited(final MouseEvent evt) {
        }

        @Override
        public void mousePressed(final MouseEvent evt) {
        }

        @Override
        public void mouseReleased(final MouseEvent evt) {
        }

        @Override
        public void valueChanged(final ListSelectionEvent evt) {
            if (evt.getSource() == lstFotos) {
                SimpleWebDavPanel.this.lstFotosValueChanged(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    protected final WebDavTunnelHelper webdavHelper;
    protected final String beanCollProp;
    protected final String nameProp;
    protected final String bildClassName;

    protected final JFileChooser fileChooser = new JFileChooser();
    protected final List<CidsBean> removeNewAddedFotoBean = new ArrayList<>();
    protected final List<CidsBean> removedFotoBeans = new ArrayList<>();
    protected final MappingComponent map = new MappingComponent();
    protected boolean listListenerEnabled = true;
    protected CidsBean cidsBean;

    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    JButton btnAddImg;
    JButton btnRemoveImg;
    JList lstFotos;
    private BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new WebDavPicturePanel object.
     */
    public SimpleWebDavPanel() {
        this(true, "dokumente", "dokumentClass", "name", "webDavTunnelAction", ConnectionContext.createDummy());
    }

    /**
     * Creates new form WebDavPicturePanel.
     *
     * @param  editable           DOCUMENT ME!
     * @param  beanCollProp       DOCUMENT ME!
     * @param  bildClassName      DOCUMENT ME!
     * @param  nameProp           DOCUMENT ME!
     * @param  tunnelAction       webdavDirectory urlProp DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public SimpleWebDavPanel(final boolean editable,
            final String beanCollProp,
            final String bildClassName,
            final String nameProp,
            final String tunnelAction,
            final ConnectionContext connectionContext) {
        this.beanCollProp = beanCollProp;
        this.bildClassName = bildClassName;
        this.nameProp = nameProp;
        this.connectionContext = connectionContext;

        WebDavTunnelHelper webdavHelper = null;
        try {
            webdavHelper = new WebDavTunnelHelper("WUNDA_BLAU", tunnelAction);
        } catch (final Exception ex) {
            final String message = "Fehler beim Initialisieren der Bilderablage.";
            LOG.error(message, ex);
            ObjectRendererUtils.showExceptionWindowToUser(message, ex, null);
        }
        this.webdavHelper = webdavHelper;

        initComponents();
        lstFotos.setCellRenderer(new DefaultListCellRenderer() {

                @Override
                public Component getListCellRendererComponent(final JList list,
                        final Object value,
                        final int index,
                        final boolean isSelected,
                        final boolean cellHasFocus) {
                    final Component component = super.getListCellRendererComponent(
                            list,
                            value,
                            index,
                            isSelected,
                            cellHasFocus);
                    if ((component instanceof JLabel) && (value instanceof CidsBean)) {
                        final CidsBean dokumentBean = (CidsBean)value;
                        final String name = (String)dokumentBean.getProperty(nameProp);
                        ((JLabel)component).setText(name);
                    }
                    return component;
                }
            });

        fileChooser.setMultiSelectionEnabled(true);

        lstFotos.getModel().addListDataListener(new ListDataListener() {

                @Override
                public void intervalAdded(final ListDataEvent e) {
//                    defineButtonStatus();
                }

                @Override
                public void intervalRemoved(final ListDataEvent e) {
//                    defineButtonStatus();
                }

                @Override
                public void contentsChanged(final ListDataEvent e) {
//                    defineButtonStatus();
                }
            });

        btnAddImg.setVisible(editable);
        btnRemoveImg.setVisible(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lstFotosValueChanged(final ListSelectionEvent evt) { //GEN-FIRST:event_lstFotosValueChanged
        if (!evt.getValueIsAdjusting() && listListenerEnabled) {
        }
    }                                                                 //GEN-LAST:event_lstFotosValueChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddImgActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnAddImgActionPerformed
        if (JFileChooser.APPROVE_OPTION == fileChooser.showOpenDialog(this)) {
            final File[] selFiles = fileChooser.getSelectedFiles();
            if ((selFiles != null) && (selFiles.length > 0)) {
                CismetThreadPool.execute(new ImageUploadWorker(Arrays.asList(selFiles)));
            }
        }
    }                                                              //GEN-LAST:event_btnAddImgActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveImgActionPerformed(final ActionEvent evt) { //GEN-FIRST:event_btnRemoveImgActionPerformed
        final Object[] selection = lstFotos.getSelectedValues();
        if ((selection != null) && (selection.length > 0)) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Sollen die Fotos wirklich gelöscht werden?",
                    "Fotos entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    listListenerEnabled = false;
                    final List<Object> removeList = Arrays.asList(selection);
                    final List<CidsBean> fotos = cidsBean.getBeanCollectionProperty(beanCollProp);
                    if (fotos != null) {
                        fotos.removeAll(removeList);
                    }
                    // TODO set the laufende_nr
                    for (int i = 0; i < lstFotos.getModel().getSize(); i++) {
                        final CidsBean foto = (CidsBean)lstFotos.getModel().getElementAt(i);
                        foto.setProperty("laufende_nummer", i + 1);
                    }

                    for (final Object toDeleteObj : removeList) {
                        if (toDeleteObj instanceof CidsBean) {
                            final CidsBean fotoToDelete = (CidsBean)toDeleteObj;
                            removedFotoBeans.add(fotoToDelete);
                        }
                    }
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                } finally {
                    // TODO check the laufende_nummer attribute
                    listListenerEnabled = true;
                    final int modelSize = lstFotos.getModel().getSize();
                    if (modelSize > 0) {
                        lstFotos.setSelectedIndex(0);
                    }
                }
            }
        }
    } //GEN-LAST:event_btnRemoveImgActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lstFotosMouseClicked(final MouseEvent evt) { //GEN-FIRST:event_lstFotosMouseClicked
        if (evt.getClickCount() == 2) {
            final CidsBean dokumentBean = (CidsBean)lstFotos.getSelectedValue();
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(getParent())) {
                final String jobname = DownloadManagerDialog.getInstance().getJobName();

                final Download download = new AbstractDownload() {

                        {
                            status = State.WAITING;
                            this.directory = jobname;
                            final String dateiname = (String)dokumentBean.getProperty("dateiname");
                            final int extIndex = dateiname.lastIndexOf(".");
                            final String extension = (extIndex >= 0) ? dateiname.substring(extIndex) : "";
                            final String filename = (extIndex >= 0) ? dateiname.substring(0, extIndex) : dateiname;
                            determineDestinationFile(filename, extension);
                        }

                        @Override
                        public void run() {
                            try {
                                status = State.RUNNING;
                                stateChanged();

                                final InputStream is = webdavHelper.getFileFromWebDAV((String)dokumentBean.getProperty(
                                            nameProp),
                                        getConnectionContext());
                                try(final OutputStream os = new FileOutputStream(fileToSaveTo)) {
                                    IOUtils.copy(is, os);
                                }

                                if (status == State.RUNNING) {
                                    status = State.COMPLETED;
                                    stateChanged();
                                }
                            } catch (final Exception ex) {
                                LOG.error(ex, ex);
                                status = State.ABORTED;
                                stateChanged();
                            }
                        }
                    };
                DownloadManager.instance().add(download);
            }
        }
    } //GEN-LAST:event_lstFotosMouseClicked

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        this.cidsBean = cidsBean;
        bindingGroup.bind();

        if (cidsBean != null) {
            if (lstFotos.getModel().getSize() > 0) {
                lstFotos.setSelectedIndex(0);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   bi         DOCUMENT ME!
     * @param   component  DOCUMENT ME!
     * @param   insetX     DOCUMENT ME!
     * @param   insetY     DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static Image adjustScale(final BufferedImage bi,
            final JComponent component,
            final int insetX,
            final int insetY) {
        final double scalex = (double)component.getWidth() / bi.getWidth();
        final double scaley = (double)component.getHeight() / bi.getHeight();
        final double scale = Math.min(scalex, scaley);
        if (scale <= 1d) {
            return bi.getScaledInstance((int)(bi.getWidth() * scale) - insetX,
                    (int)(bi.getHeight() * scale)
                            - insetY,
                    Image.SCALE_SMOOTH);
        } else {
            return bi;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  ex      DOCUMENT ME!
     * @param  parent  DOCUMENT ME!
     */
    private static void showExceptionToUser(final Exception ex, final JComponent parent) {
        final ErrorInfo ei = new ErrorInfo(
                "Fehler",
                "Beim Vorgang ist ein Fehler aufgetreten",
                null,
                null,
                ex,
                Level.SEVERE,
                null);
        JXErrorPane.showDialog(parent, ei);
    }
    @Override
    public void editorClosed(final EditorClosedEvent event) {
        if (EditorSaveStatus.SAVE_SUCCESS == event.getStatus()) {
            for (final CidsBean deleteBean : removedFotoBeans) {
                final String fileName = (String)deleteBean.getProperty(nameProp);

                try {
                    webdavHelper.deleteFileFromWebDAV(fileName, getConnectionContext());
                    deleteBean.delete();
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                }
            }
        } else {
            for (final CidsBean deleteBean : removeNewAddedFotoBean) {
                final String fileName = (String)deleteBean.getProperty(nameProp);
                try {
                    webdavHelper.deleteFileFromWebDAV(fileName, getConnectionContext());
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                    showExceptionToUser(ex, this);
                }
            }
        }
    }

    @Override
    public boolean prepareForSave() {
        return true;
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
        map.getFeatureCollection().removeAllFeatures();
        map.dispose();
        cidsBean = null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    protected class ImageUploadWorker extends SwingWorker<Collection<CidsBean>, Void> {

        //~ Instance fields ----------------------------------------------------

        private final Collection<File> dokumente;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new ImageUploadWorker object.
         *
         * @param  dokumente  DOCUMENT ME!
         */
        public ImageUploadWorker(final Collection<File> dokumente) {
            this.dokumente = dokumente;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            final Collection<CidsBean> newBeans = new ArrayList<>();
            for (final File dokument : dokumente) {
                webdavHelper.uploadFileToWebDAV(dokument.getName(),
                    dokument,
                    SimpleWebDavPanel.this,
                    getConnectionContext());

                final CidsBean newDokument = CidsBean.createNewCidsBeanFromTableName(
                        "WUNDA_BLAU",
                        bildClassName,
                        getConnectionContext());
                newDokument.setProperty(nameProp, dokument.getName());
                newDokument.setProperty("messstelle", cidsBean.getProperty("id"));
                newBeans.add(newDokument);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                final Collection<CidsBean> newBeans = get();
                if (!newBeans.isEmpty()) {
                    final List<CidsBean> oldBeans = cidsBean.getBeanCollectionProperty(beanCollProp);
                    oldBeans.addAll(newBeans);
                    removeNewAddedFotoBean.addAll(newBeans);
                    lstFotos.setSelectedValue(newBeans.iterator().next(), true);
                }
            } catch (final InterruptedException ex) {
                LOG.warn(ex, ex);
            } catch (final ExecutionException ex) {
                LOG.error(ex, ex);
            }
        }
    }
}
