/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wunda_blau;

import org.apache.log4j.Logger;

import javax.swing.JPanel;

import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;

import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   jweintraut
 * @version  $Revision$, $Date$
 */
public class VermessungGebaeudebeschreibungEditor extends AbstractVermessungEditor {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(VermessungGebaeudebeschreibungEditor.class);

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox chkL;
    private javax.swing.JCheckBox chkM;
    private javax.swing.JCheckBox chkX;
    private javax.swing.JComboBox cmbGeometrie;
    private javax.swing.JComboBox cmbGeometrieStatus;
    private javax.swing.Box.Filler gluGeneralInformationGap;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel lblBlatt;
    private javax.swing.JLabel lblGeometrie;
    private javax.swing.JLabel lblGeometrieStatus;
    private javax.swing.JLabel lblHausnummer;
    private javax.swing.JLabel lblRolle;
    private javax.swing.JLabel lblStrasse;
    private javax.swing.JPanel panInformation;
    private javax.swing.JSpinner spnBlatt;
    private javax.swing.JSpinner spnRolle;
    private javax.swing.JTextField txtHausnummer;
    private javax.swing.JTextField txtStrasse;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new VermessungGebaeudebeschreibungEditor object.
     */
    public VermessungGebaeudebeschreibungEditor() {
        this(false);
    }

    /**
     * Creates new form VermessungGebaeudebeschreibungEditor.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public VermessungGebaeudebeschreibungEditor(final boolean readOnly) {
        super(readOnly);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        initComponents();
        super.initWithConnectionContext(connectionContext);
        if (isReadOnly()) {
            getGeneralInformationPanel().setVisible(false);

            cmbGeometrieStatus.setEditable(false);
            cmbGeometrieStatus.setEnabled(false);
            spnBlatt.setEnabled(false);
            spnRolle.setEnabled(false);
            chkM.setEnabled(false);
            chkX.setEnabled(false);
            chkL.setEnabled(false);
            txtStrasse.setEditable(false);
            txtHausnummer.setEditable(false);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        panInformation = new javax.swing.JPanel();
        lblGeometrieStatus = new javax.swing.JLabel();
        cmbGeometrieStatus = new DefaultBindableReferenceCombo();
        lblGeometrie = new javax.swing.JLabel();
        if (!isReadOnly()) {
            cmbGeometrie = new DefaultCismapGeometryComboBoxEditor();
        }
        gluGeneralInformationGap = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        chkM = new javax.swing.JCheckBox();
        chkX = new javax.swing.JCheckBox();
        chkL = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        lblRolle = new javax.swing.JLabel();
        spnRolle = new javax.swing.JSpinner();
        lblBlatt = new javax.swing.JLabel();
        spnBlatt = new javax.swing.JSpinner();
        lblStrasse = new javax.swing.JLabel();
        txtStrasse = new javax.swing.JTextField();
        lblHausnummer = new javax.swing.JLabel();
        txtHausnummer = new javax.swing.JTextField();

        panInformation.setOpaque(false);
        panInformation.setLayout(new java.awt.GridBagLayout());

        lblGeometrieStatus.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblGeometrieStatus.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        panInformation.add(lblGeometrieStatus, gridBagConstraints);

        cmbGeometrieStatus.setRenderer(new GeometrieStatusRenderer(cmbGeometrieStatus.getRenderer()));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geometrie_status}"),
                cmbGeometrieStatus,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        cmbGeometrieStatus.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmbGeometrieStatusActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        panInformation.add(cmbGeometrieStatus, gridBagConstraints);

        lblGeometrie.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblGeometrie.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformation.add(lblGeometrie, gridBagConstraints);

        if (!isReadOnly()) {
            binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                    org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                    this,
                    org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geometrie}"),
                    cmbGeometrie,
                    org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)cmbGeometrie).getConverter());
            bindingGroup.addBinding(binding);
        }
        if (!isReadOnly()) {
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
            panInformation.add(cmbGeometrie, gridBagConstraints);
        }
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        panInformation.add(gluGeneralInformationGap, gridBagConstraints);

        chkM.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.chkM.text")); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.m}"),
                chkM,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformation.add(chkM, gridBagConstraints);

        chkX.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.chkX.text")); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.x}"),
                chkX,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformation.add(chkX, gridBagConstraints);

        chkL.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.chkL.text")); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.l}"),
                chkL,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformation.add(chkL, gridBagConstraints);

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        lblRolle.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblRolle.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        jPanel1.add(lblRolle, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.rolle}"),
                spnRolle,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(spnRolle, gridBagConstraints);

        lblBlatt.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblBlatt.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(lblBlatt, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.blatt}"),
                spnBlatt,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(spnBlatt, gridBagConstraints);

        lblStrasse.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblStrasse.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        jPanel1.add(lblStrasse, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.strasse}"),
                txtStrasse,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        jPanel1.add(txtStrasse, gridBagConstraints);

        lblHausnummer.setText(org.openide.util.NbBundle.getMessage(
                VermessungGebaeudebeschreibungEditor.class,
                "VermessungGebaeudebeschreibungEditor.lblHausnummer.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(lblHausnummer, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.hausnummer}"),
                txtHausnummer,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        jPanel1.add(txtHausnummer, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        panInformation.add(jPanel1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmbGeometrieStatusActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmbGeometrieStatusActionPerformed
        if (cmbGeometrieStatus.getSelectedItem() instanceof CidsBean) {
            final CidsBean geometrieStatus = (CidsBean)cmbGeometrieStatus.getSelectedItem();

            if (geometrieStatus.getProperty("id") instanceof Integer) {
                cmbGeometrieStatus.setBackground(COLORS_GEOMETRIE_STATUS.get(
                        (Integer)geometrieStatus.getProperty("id")));
            }
        }
    } //GEN-LAST:event_cmbGeometrieStatusActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected String getDocumentFilename() {
        final CidsBean cidsBean = getCidsBean();
        final String ordner = (String)cidsBean.getProperty("ordner");
        final Integer nummer = (Integer)cidsBean.getProperty("nummer");
        return VermessungPictureFinderClientUtils.getGebauedebschreibungPictureFilename(ordner, nummer);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean  DOCUMENT ME!
     */
    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        super.setCidsBean(cidsBean);

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean,
                getConnectionContext());
            bindingGroup.bind();

            if ((cidsBean.getProperty("geometrie_status") instanceof CidsBean)
                        && (cidsBean.getProperty("geometrie_status.id") instanceof Integer)) {
                cmbGeometrieStatus.setBackground(COLORS_GEOMETRIE_STATUS.get(
                        (Integer)cidsBean.getProperty("geometrie_status.id")));
            }
        }
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void dispose() {
        super.dispose();
        bindingGroup.unbind();
        if (!isReadOnly()) {
            ((DefaultCismapGeometryComboBoxEditor)cmbGeometrie).dispose();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected String generateTitle() {
        final CidsBean cidsBean = getCidsBean();
        final String ordner = (String)cidsBean.getProperty("ordner");
        final Integer nummer = (Integer)cidsBean.getProperty("nummer");

        return String.format("%s/%s", (ordner != null) ? ordner : "", (nummer != null) ? Integer.toString(nummer) : "");
    }

    @Override
    protected JPanel getInformationPanel() {
        return panInformation;
    }

    @Override
    protected String getVermessungName() {
        return "Gebaeudebeschreibung";
    }

    @Override
    protected String findPicture() {
        final CidsBean cidsBean = getCidsBean();
        final String ordner = (String)cidsBean.getProperty("ordner");
        final Integer nummer = (Integer)cidsBean.getProperty("nummer");

        return VermessungPictureFinderClientUtils.findGebaeudebeschreibungPicture(ordner, nummer);
    }
}
