/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import Sirius.navigator.connection.SessionManager;

import Sirius.server.middleware.types.MetaObject;

import com.vividsolutions.jts.geom.Geometry;

import org.jdesktop.beansbinding.BindingGroup;

import java.awt.CardLayout;

import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import de.cismet.cids.custom.objecteditors.utils.LongNumberConverter;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.server.StrAdrStrasseLightweightSearch;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.FastBindableReferenceCombo;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AlboFlaecheMainBeschreibungPanel extends AbstractAlboFlaechePanel {

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jLabel13 = new javax.swing.JLabel();
        cbFlaechenart = new DefaultBindableReferenceCombo(new DefaultBindableReferenceCombo.CategorisedOption(" : "),
                new DefaultBindableReferenceCombo.SortingColumnOption("order_by"));
        jLabel14 = new javax.swing.JLabel();
        cbFlaechenstatus = new DefaultBindableScrollableComboBox();
        jLabel15 = new javax.swing.JLabel();
        cbFlaechenzuordnung = new DefaultBindableScrollableComboBox();
        jLabel12 = new javax.swing.JLabel();
        jPanel54 = new javax.swing.JPanel();
        jLabel75 = new javax.swing.JLabel();
        txtJahrVon = new javax.swing.JFormattedTextField();
        jButton5 = new javax.swing.JButton();
        jLabel74 = new javax.swing.JLabel();
        txtJahrBis = new javax.swing.JFormattedTextField();
        jButton6 = new javax.swing.JButton();
        filler68 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jLabel37 = new javax.swing.JLabel();
        jTextField7 = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jComboBox4 = new de.cismet.cids.editors.FastBindableScrollableComboBox(
                strassennameSearch,
                strassennameSearch.getRepresentationPattern(),
                strassennameSearch.getRepresentationFields());
        jLabel17 = new javax.swing.JLabel();
        jTextField5 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        txtAlteNummer = new javax.swing.JTextField();
        jCheckBox1 = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        ckProp1 = new javax.swing.JCheckBox();
        jComboBox5 = new DefaultBindableReferenceCombo(new DefaultBindableReferenceCombo.NullableOption(),
                new DefaultBindableReferenceCombo.WhereOption("flaeche = true"));
        jPanel5 = new javax.swing.JPanel();
        labBearbeiter = new javax.swing.JLabel();

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel13, "Art der Fläche:");
        jLabel13.setName("jLabel13"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel13, gridBagConstraints);

        cbFlaechenart.setName("cbFlaechenart"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_art}"),
                cbFlaechenart,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        cbFlaechenart.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(cbFlaechenart, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel14, "Status der Fläche:");
        jLabel14.setName("jLabel14"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel14, gridBagConstraints);

        cbFlaechenstatus.setName("cbFlaechenstatus"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_status}"),
                cbFlaechenstatus,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(cbFlaechenstatus, gridBagConstraints);
        ((DefaultBindableScrollableComboBox)cbFlaechenstatus).setNullable(true);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel15, "Flächenzuordnung zu:");
        jLabel15.setName("jLabel15"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel15, gridBagConstraints);

        cbFlaechenzuordnung.setName("cbFlaechenzuordnung"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_zuordnung}"),
                cbFlaechenzuordnung,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(cbFlaechenzuordnung, gridBagConstraints);
        ((DefaultBindableScrollableComboBox)cbFlaechenzuordnung).setNullable(true);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel12, "Jahr");
        jLabel12.setName("jLabel12"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 2, 2, 2);
        add(jLabel12, gridBagConstraints);

        jPanel54.setName("jPanel54"); // NOI18N
        jPanel54.setOpaque(false);
        jPanel54.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel75, "von:");
        jLabel75.setName("jLabel75"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel54.add(jLabel75, gridBagConstraints);

        txtJahrVon.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(
                new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("###0"))));
        txtJahrVon.setName("txtJahrVon"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.jahr_von}"),
                txtJahrVon,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        binding.setConverter(new LongNumberConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel54.add(txtJahrVon, gridBagConstraints);

        jButton5.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/emptytrash.png"))); // NOI18N
        jButton5.setBorderPainted(false);
        jButton5.setContentAreaFilled(false);
        jButton5.setFocusPainted(false);
        jButton5.setMaximumSize(new java.awt.Dimension(16, 16));
        jButton5.setMinimumSize(new java.awt.Dimension(16, 16));
        jButton5.setName("jButton5");                                                                       // NOI18N
        jButton5.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton5.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel54.add(jButton5, gridBagConstraints);
        jButton6.setVisible(isEditable());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel74, "bis:");
        jLabel74.setName("jLabel74"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 2, 2);
        jPanel54.add(jLabel74, gridBagConstraints);

        txtJahrBis.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(
                new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("###0"))));
        txtJahrBis.setName("txtJahrBis"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.jahr_bis}"),
                txtJahrBis,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        binding.setConverter(new LongNumberConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel54.add(txtJahrBis, gridBagConstraints);

        jButton6.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/emptytrash.png"))); // NOI18N
        jButton6.setBorderPainted(false);
        jButton6.setContentAreaFilled(false);
        jButton6.setFocusPainted(false);
        jButton6.setMaximumSize(new java.awt.Dimension(16, 16));
        jButton6.setMinimumSize(new java.awt.Dimension(16, 16));
        jButton6.setName("jButton6");                                                                       // NOI18N
        jButton6.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton6.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel54.add(jButton6, gridBagConstraints);
        jButton5.setVisible(isEditable());

        filler68.setName("filler68"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        jPanel54.add(filler68, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jPanel54, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel37, "Ortsübliche Bezeichnung:");
        jLabel37.setName("jLabel37"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel37, gridBagConstraints);

        jTextField7.setName("jTextField7"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.ortsuebliche_bezeichnung}"),
                jTextField7,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jTextField7, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel16, "Straße:");
        jLabel16.setName("jLabel16"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel16, gridBagConstraints);

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jComboBox4.setName("jComboBox4"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_strasse}"),
                jComboBox4,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jComboBox4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel17, "Haus-Nr:");
        jLabel17.setName("jLabel17"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 2);
        jPanel1.add(jLabel17, gridBagConstraints);

        jTextField5.setMaximumSize(new java.awt.Dimension(172, 25));
        jTextField5.setMinimumSize(new java.awt.Dimension(172, 25));
        jTextField5.setName("jTextField5"); // NOI18N
        jTextField5.setPreferredSize(new java.awt.Dimension(172, 25));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.hausnummer}"),
                jTextField5,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jTextField5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, "Alte Nummer:");
        jLabel4.setName("jLabel4"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jLabel4, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.GridBagLayout());

        txtAlteNummer.setName("txtAlteNummer"); // NOI18N
        txtAlteNummer.setPreferredSize(new java.awt.Dimension(59, 34));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.alte_nummer}"),
                txtAlteNummer,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(txtAlteNummer, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBox1, "Fläche unterdrücken");
        jCheckBox1.setContentAreaFilled(false);
        jCheckBox1.setMaximumSize(new java.awt.Dimension(172, 25));
        jCheckBox1.setMinimumSize(new java.awt.Dimension(172, 25));
        jCheckBox1.setName("jCheckBox1"); // NOI18N
        jCheckBox1.setPreferredSize(new java.awt.Dimension(172, 25));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.loeschen}"),
                jCheckBox1,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(jCheckBox1, gridBagConstraints);

        jPanel4.setMaximumSize(new java.awt.Dimension(62, 17));
        jPanel4.setMinimumSize(new java.awt.Dimension(62, 17));
        jPanel4.setName("jPanel4"); // NOI18N
        jPanel4.setOpaque(false);
        jPanel4.setPreferredSize(new java.awt.Dimension(62, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 2);
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel2, gridBagConstraints);

        jPanel3.setName("jPanel3"); // NOI18N
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(ckProp1, "Entwurf");
        ckProp1.setContentAreaFilled(false);
        ckProp1.setMaximumSize(new java.awt.Dimension(172, 25));
        ckProp1.setMinimumSize(new java.awt.Dimension(172, 25));
        ckProp1.setName("ckProp1"); // NOI18N
        ckProp1.setPreferredSize(new java.awt.Dimension(172, 25));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.entwurf}"),
                ckProp1,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        ckProp1.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel3.add(ckProp1, gridBagConstraints);

        jComboBox5.setName("jComboBox5"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.fk_bearbeiter}"),
                jComboBox5,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel3.add(jComboBox5, gridBagConstraints);

        jPanel5.setMaximumSize(new java.awt.Dimension(62, 17));
        jPanel5.setMinimumSize(new java.awt.Dimension(62, 17));
        jPanel5.setName("jPanel5"); // NOI18N
        jPanel5.setOpaque(false);
        jPanel5.setPreferredSize(new java.awt.Dimension(62, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 2);
        jPanel3.add(jPanel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel3, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(labBearbeiter, "Bearbeiter:");
        labBearbeiter.setName("labBearbeiter"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(labBearbeiter, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements java.awt.event.ActionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final java.awt.event.ActionEvent evt) {
            if (evt.getSource() == cbFlaechenart) {
                AlboFlaecheMainBeschreibungPanel.this.cbFlaechenartActionPerformed(evt);
            } else if (evt.getSource() == jButton5) {
                AlboFlaecheMainBeschreibungPanel.this.jButton5ActionPerformed(evt);
            } else if (evt.getSource() == jButton6) {
                AlboFlaecheMainBeschreibungPanel.this.jButton6ActionPerformed(evt);
            } else if (evt.getSource() == ckProp1) {
                AlboFlaecheMainBeschreibungPanel.this.ckProp1ActionPerformed(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    public static final String STRASSENNAME_TOSTRING_TEMPLATE = "%s";
    public static final String[] STRASSENNAME_TOSTRING_FIELDS = {
            StrAdrStrasseLightweightSearch.Subject.NAME.toString()
        };
    public static final String STRASSENSCHLUESSEL_TOSTRING_TEMPLATE = "%s";
    public static final String[] STRASSENSCHLUESSEL_TOSTRING_FIELDS = {
            StrAdrStrasseLightweightSearch.Subject.SCHLUESSEL.toString()
        };

    //~ Instance fields --------------------------------------------------------

    private JPanel panSpezifisch;

    private final StrAdrStrasseLightweightSearch strassennameSearch = new StrAdrStrasseLightweightSearch(
            StrAdrStrasseLightweightSearch.Subject.NAME,
            STRASSENNAME_TOSTRING_TEMPLATE,
            STRASSENNAME_TOSTRING_FIELDS);

    private boolean unlocked = false;

    private AlboFlaecheMainPanel mainPanel;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> cbFlaechenart;
    private javax.swing.JComboBox<String> cbFlaechenstatus;
    private javax.swing.JComboBox<String> cbFlaechenzuordnung;
    private javax.swing.JCheckBox ckProp1;
    private javax.swing.Box.Filler filler68;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox<String> jComboBox4;
    private javax.swing.JComboBox<String> jComboBox5;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel74;
    private javax.swing.JLabel jLabel75;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel54;
    private javax.swing.JTextField jTextField5;
    private javax.swing.JTextField jTextField7;
    private javax.swing.JLabel labBearbeiter;
    private javax.swing.JTextField txtAlteNummer;
    private javax.swing.JFormattedTextField txtJahrBis;
    private javax.swing.JFormattedTextField txtJahrVon;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainDescriptionPanel object.
     */
    public AlboFlaecheMainBeschreibungPanel() {
        initComponents();
    }

    /**
     * Creates a new AlboFlaecheDescriptionPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboFlaecheMainBeschreibungPanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbFlaechenartActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbFlaechenartActionPerformed
        updateArtFk();
        updateDetailsPanel();
    }                                                                                 //GEN-LAST:event_cbFlaechenartActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton5ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton5ActionPerformed
        txtJahrVon.setValue(null);
    }                                                                            //GEN-LAST:event_jButton5ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton6ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton6ActionPerformed
        txtJahrBis.setValue(null);
    }                                                                            //GEN-LAST:event_jButton6ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void ckProp1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_ckProp1ActionPerformed
        if (ckProp1.isSelected() && (jComboBox5.getSelectedIndex() == -1)) {
            final ComboBoxModel<String> model = jComboBox5.getModel();
            final String currentUser = SessionManager.getSession().getUser().getName();

            for (int i = 0; i < model.getSize(); ++i) {
                final Object element = model.getElementAt(i);

                if (element instanceof CidsBean) {
                    final String name = (String)((CidsBean)element).getProperty("name");

                    if (currentUser.toLowerCase().contains(name.toLowerCase())
                                || name.toLowerCase().contains(currentUser.toLowerCase())) {
                        jComboBox5.setSelectedItem(element);
                        break;
                    }
                }
            }
        }
    } //GEN-LAST:event_ckProp1ActionPerformed

    @Override
    protected void initGui() {
        initComponents();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  panSpezifisch  DOCUMENT ME!
     */
    public void setPanSpezifisch(final JPanel panSpezifisch) {
        this.panSpezifisch = panSpezifisch;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  mainPanel  DOCUMENT ME!
     */
    public void setMainPanel(final AlboFlaecheMainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        setUnlocked((cidsBean != null) && (MetaObject.NEW == cidsBean.getMetaObject().getStatus()));
        super.setCidsBean(cidsBean);

        updateArtFk();
        updateDetailsPanel();
        refreshStrCbo();
    }

    /**
     * DOCUMENT ME!
     */
    private void updateArtFk() {
        if (isEditable()) {
            final CidsBean cidsBean = getCidsBean();
            if ((cidsBean != null) && (cidsBean.getProperty("fk_art.schluessel") != null)) {
                try {
                    switch ((String)cidsBean.getProperty("fk_art.schluessel")) {
                        case "altablagerung": {
                            if (cidsBean.getProperty("fk_altablagerung") == null) {
                                cidsBean.setProperty(
                                    "fk_altablagerung",
                                    CidsBean.createNewCidsBeanFromTableName(
                                        "WUNDA_BLAU",
                                        "ALBO_ALTABLAGERUNG",
                                        getConnectionContext()));
                            }
                        }
                        break;
                        case "rcl": {
                            if (cidsBean.getProperty("fk_rcl") == null) {
                                cidsBean.setProperty(
                                    "fk_rcl",
                                    CidsBean.createNewCidsBeanFromTableName(
                                        "WUNDA_BLAU",
                                        "ALBO_RCL",
                                        getConnectionContext()));
                            }
                        }
                        case "stoffliche": {
                            if (cidsBean.getProperty("fk_stoffliche") == null) {
                                cidsBean.setProperty(
                                    "fk_stoffliche",
                                    CidsBean.createNewCidsBeanFromTableName(
                                        "WUNDA_BLAU",
                                        "ALBO_STOFFLICHE",
                                        getConnectionContext()));
                            }
                        }
                        break;
                    }
                } catch (final Exception ex) {
                    LOG.error(ex, ex);
                }
                mainPanel.updateCidsBeanOfFkPanels();
            }
        }
    }

    @Override
    public boolean prepareForSave() {
        final CidsBean cidsBean = getCidsBean();
        try {
            if (!"altablagerung".equals(cidsBean.getProperty("fk_art.schluessel"))) {
                cidsBean.setProperty("fk_altablagerung", null);
            }
            if (!"rcl".equals(cidsBean.getProperty("fk_art.schluessel"))) {
                cidsBean.setProperty("fk_rcl", null);
            }
            if (!"stoffliche".equals(cidsBean.getProperty("fk_art.schluessel"))) {
                cidsBean.setProperty("fk_stoffliche", null);
            }
            return true;
        } catch (final Exception ex) {
            LOG.error(ex, ex);
        }
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  unlocked  DOCUMENT ME!
     */
    public void setUnlocked(final boolean unlocked) {
        this.unlocked = isEditable() ? unlocked : false;
        updateLockedFields();
    }

    /**
     * DOCUMENT ME!
     */
    private void updateLockedFields() {
        if (isEditable()) {
            RendererTools.makeUneditable(cbFlaechenart, !unlocked);
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void updateDetailsPanel() {
        final CidsBean selected = (CidsBean)cbFlaechenart.getSelectedItem();

        if (null != selected) {
            switch ((String)selected.getProperty("schluessel")) {
                case "altstandort": {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "standort");
                    break;
                }
                case "altablagerung": {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "altablagerung");
                    break;
                }
                case "betriebsstandort": {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "standort");
                    break;
                }
                case "rcl": {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "rcl");
                    break;
                }
                case "stoffliche": {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "stoffliche");
                    break;
                }
                default: {
                    ((CardLayout)panSpezifisch.getLayout()).show(panSpezifisch, "sonstige");
                    break;
                }
            }
            ((TitledBorder)panSpezifisch.getBorder()).setTitle((String)selected.getProperty("name"));
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void refreshStrCbo() {
        if (getCidsBean() != null) {
            final Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
            if (getCidsBean() != null) {
                strassennameSearch.setSortDistanceLimit(10);
                strassennameSearch.setGeom(geom);
            }
            ((FastBindableReferenceCombo)jComboBox4).refreshModel();
        }
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }
}
