/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objectrenderer.utils;

import com.vividsolutions.jts.geom.Geometry;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;

import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$ Sandra Simmert 12.2.2018: Parameter GEO_BUFFER und MAP_CALL_STRING von außen steuerbar.
 * @version  $Revision$, $Date$ Sandra Simmert 15.9.2021: dispose-Methode ergaenzt
 */
public class DefaultPreviewMapPanel extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(DefaultPreviewMapPanel.class);

    //~ Instance fields --------------------------------------------------------

    final StyledFeature previewGeometry = new DefaultStyledFeature();
    private final MappingComponent previewMap;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefaultPreviewMapPanel.
     */
    public DefaultPreviewMapPanel() {
        initComponents();
        previewMap = new MappingComponent();
        this.add(previewMap, BorderLayout.CENTER);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        setOpaque(false);
        setLayout(new java.awt.BorderLayout());
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean               DOCUMENT ME!
     * @param  geometryAttributeName  DOCUMENT ME!
     * @param  geoBuffer              DOCUMENT ME!
     * @param  mapURL                 DOCUMENT ME!
     */
    public void initMap(final CidsBean cidsBean,
            final String geometryAttributeName,
            final double geoBuffer,
            final String mapURL) {
        boolean showMap = false;
        if (cidsBean != null) {
            final Object geoObj = cidsBean.getProperty(geometryAttributeName);
            if (geoObj instanceof Geometry) {
                showMap = true;
                final Geometry pureGeom = CrsTransformer.transformToGivenCrs((Geometry)geoObj,
                        ClientAlkisConf.getInstance().getSrsService());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ClientAlkisConf.getInstance().GeoBUffer: "
                                + ClientAlkisConf.getInstance().getGeoBuffer());
                }
                final XBoundingBox box = new XBoundingBox(pureGeom.getEnvelope().buffer(
                            geoBuffer));
                final double diagonalLength = Math.sqrt((box.getWidth() * box.getWidth())
                                + (box.getHeight() * box.getHeight()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Buffer for map: " + diagonalLength);
                }
                final XBoundingBox bufferedBox = new XBoundingBox(box.getGeometry().buffer(diagonalLength));
                final Runnable mapRunnable = new Runnable() {

                        @Override
                        public void run() {
                            final ActiveLayerModel mappingModel = new ActiveLayerModel();
                            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                            mappingModel.addHome(new XBoundingBox(
                                    bufferedBox.getX1(),
                                    bufferedBox.getY1(),
                                    bufferedBox.getX2(),
                                    bufferedBox.getY2(),
                                    ClientAlkisConf.getInstance().getSrsService(),
                                    true));
                            final SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(
                                        mapURL));
                            swms.setName(cidsBean.getClass().getSimpleName());

                            previewGeometry.setGeometry(pureGeom);
                            previewGeometry.setFillingPaint(new Color(1, 0, 0, 0.5f));
                            previewGeometry.setLineWidth(3);
                            previewGeometry.setLinePaint(new Color(1, 0, 0, 1f));
                            // add the raster layer to the model
                            mappingModel.addLayer(swms);
                            // set the model
                            previewMap.setMappingModel(mappingModel);
                            // initial positioning of the map
                            final int duration = previewMap.getAnimationDuration();
                            previewMap.setAnimationDuration(0);
                            previewMap.gotoInitialBoundingBox();
                            // interaction mode
                            previewMap.setInteractionMode(MappingComponent.ZOOM);
                            // finally when all configurations are done ...
                            previewMap.unlock();
                            previewMap.addCustomInputListener("MUTE", new PBasicInputEventHandler() {

                                    @Override
                                    public void mouseClicked(final PInputEvent evt) {
                                        if (evt.getClickCount() > 1) {
                                            final CidsBean bean = cidsBean;
                                            ObjectRendererUtils.switchToCismapMap();
                                            ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(bean, false);
                                        }
                                    }
                                });
                            previewMap.setInteractionMode("MUTE");
                            if (previewMap.getFeatureCollection().contains(previewGeometry)) {
                                previewMap.getFeatureCollection().removeFeature(previewGeometry);
                            }
                            previewMap.getFeatureCollection().addFeature(previewGeometry);
                            previewMap.setAnimationDuration(duration);
                        }
                    };
                if (EventQueue.isDispatchThread()) {
                    mapRunnable.run();
                } else {
                    EventQueue.invokeLater(mapRunnable);
                }
            }
        }
        showMap(showMap);
    }

    /**
     * DOCUMENT ME!
     */
    public void dispose() {
        previewMap.dispose();
    }
    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean               DOCUMENT ME!
     * @param  geometryAttributeName  DOCUMENT ME!
     * @param  geoBuffer              DOCUMENT ME!
     */
    public void initMap(final CidsBean cidsBean, final String geometryAttributeName, final double geoBuffer) {
        initMap(cidsBean, geometryAttributeName, geoBuffer, ClientAlkisConf.getInstance().getMapCallString());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean               DOCUMENT ME!
     * @param  geometryAttributeName  DOCUMENT ME!
     */
    public void initMap(final CidsBean cidsBean, final String geometryAttributeName) {
        initMap(
            cidsBean,
            geometryAttributeName,
            ClientAlkisConf.getInstance().getGeoBuffer(),
            ClientAlkisConf.getInstance().getMapCallString());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  showMap  DOCUMENT ME!
     */
    private void showMap(final boolean showMap) {
        previewMap.setVisible(showMap);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
