/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.wunda.oab.objectrenderer;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import org.openide.util.NbBundle;

import java.awt.EventQueue;

import javax.swing.event.EventListenerList;

import de.cismet.cids.custom.wunda.oab.AbstractCidsBeanRenderer;
import de.cismet.cids.custom.wunda.oab.OabUtilities;
import de.cismet.cids.custom.wunda.oab.mapvis.Oab_BerechnungMapVisualisationProvider;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @author   martin.scholl@cismet.de
 * @version  1.0
 */
public class Oab_berechnungRenderer extends AbstractCidsBeanRenderer implements RequestsFullSizeComponent,
    ConnectionContextStore {

    //~ Instance fields --------------------------------------------------------

    // only to hold strong reference to listeners
    private EventListenerList refHolderList;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnGotoCondMeas;
    private javax.swing.JLabel lblAnnuality;
    private javax.swing.JLabel lblAnnualityValue;
    private javax.swing.JLabel lblBelongsToCondMeas;
    private javax.swing.JLabel lblData;
    private javax.swing.JLabel lblMapTitle;
    private de.cismet.cismap.commons.gui.MappingComponent map;
    private javax.swing.JPanel pnlData;
    private javax.swing.JPanel pnlMap;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanelData;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanelMap;
    private javax.swing.Box.Filler vFillCalc;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form OABProjectEditor.
     */
    public Oab_berechnungRenderer() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
    }

    @Override
    protected void init() {
        cidsBean = OabUtilities.getBean(cidsBean, "zustand_massnahme", getConnectionContext()); // NOI18N

        final Runnable r = new Runnable() {

                @Override
                public void run() {
                    bindingGroup.unbind();

                    if (cidsBean != null) {
                        refHolderList = new EventListenerList();

                        final CidsBean condMeasBean = (CidsBean)cidsBean.getProperty("zustand_massnahme"); // NOI18N

                        OabUtilities.initPreviewMap(
                            cidsBean,
                            "zustand_massnahme.umschreibende_geometrie.geo_field",          // NOI18N
                            map,
                            lblMapTitle,
                            new Oab_BerechnungMapVisualisationProvider().buildAction(cidsBean),
                            OabUtilities.createWMSLayer(
                                (String)cidsBean.getProperty("max_wasser_cap"),             // NOI18N
                                (String)cidsBean.getProperty("max_wasser_layer_name")));    // NOI18N

                        btnGotoCondMeas.setText((String)condMeasBean.getProperty("name")); // NOI18N
                        OabUtilities.toGotoBeanHyperlinkButton(btnGotoCondMeas, condMeasBean, refHolderList);

                        bindingGroup.bind();
                    }
                }
            };

        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        pnlMap = new javax.swing.JPanel();
        semiRoundedPanelMap = new de.cismet.tools.gui.SemiRoundedPanel();
        lblMapTitle = new javax.swing.JLabel();
        map = new de.cismet.cismap.commons.gui.MappingComponent();
        pnlData = new javax.swing.JPanel();
        semiRoundedPanelData = new de.cismet.tools.gui.SemiRoundedPanel();
        lblData = new javax.swing.JLabel();
        lblAnnuality = new javax.swing.JLabel();
        lblAnnualityValue = new javax.swing.JLabel();
        vFillCalc = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        lblBelongsToCondMeas = new javax.swing.JLabel();
        btnGotoCondMeas = new javax.swing.JButton();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        pnlMap.setOpaque(false);
        pnlMap.setLayout(new java.awt.GridBagLayout());

        semiRoundedPanelMap.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanelMap.setLayout(new java.awt.GridBagLayout());

        lblMapTitle.setFont(new java.awt.Font("Lucida Grande", 0, 14));                                    // NOI18N
        lblMapTitle.setForeground(new java.awt.Color(255, 255, 255));
        lblMapTitle.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(
            lblMapTitle,
            NbBundle.getMessage(Oab_berechnungRenderer.class, "Oab_berechnungRenderer.lblMapTitle.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        semiRoundedPanelMap.add(lblMapTitle, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlMap.add(semiRoundedPanelMap, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlMap.add(map, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(pnlMap, gridBagConstraints);

        pnlData.setOpaque(false);
        pnlData.setLayout(new java.awt.GridBagLayout());

        semiRoundedPanelData.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanelData.setLayout(new java.awt.GridBagLayout());

        lblData.setFont(new java.awt.Font("Lucida Grande", 0, 14));                                    // NOI18N
        lblData.setForeground(new java.awt.Color(255, 255, 255));
        lblData.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(
            lblData,
            NbBundle.getMessage(Oab_berechnungRenderer.class, "Oab_berechnungRenderer.lblData.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        semiRoundedPanelData.add(lblData, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlData.add(semiRoundedPanelData, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblAnnuality,
            NbBundle.getMessage(Oab_berechnungRenderer.class, "Oab_berechnungRenderer.lblAnnuality.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblAnnuality, gridBagConstraints);

        final org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.jaehrlichkeit}"),
                lblAnnualityValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblAnnualityValue, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        pnlData.add(vFillCalc, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblBelongsToCondMeas,
            NbBundle.getMessage(Oab_berechnungRenderer.class, "Oab_berechnungRenderer.lblBelongsToCondMeas.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblBelongsToCondMeas, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnGotoCondMeas,
            NbBundle.getMessage(Oab_berechnungRenderer.class, "Oab_berechnungRenderer.btnGotoCondMeas.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(btnGotoCondMeas, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(pnlData, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
