/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wunda_blau.toolbaritem;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import java.awt.Component;

import java.util.logging.Level;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifier;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifierListener;
import de.cismet.cids.custom.wunda_blau.search.actions.BerechtigungspruefungFreigabeServerAction;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.navigator.utils.CidsClientToolbarItem;

import de.cismet.cids.server.actions.ServerActionParameter;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
@org.openide.util.lookup.ServiceProvider(service = CidsClientToolbarItem.class)
public class BerechtigungspruefungToolbarWidget extends javax.swing.JPanel implements CidsClientToolbarItem,
    ConnectionContextStore,
    CidsUiComponent {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(BerechtigungspruefungToolbarWidget.class);

    private static final String TEXT_TEMPLATE = "%s offene Berechtigungsprüfungs-Anfragen";
    private static final String TEXT_TEMPLATE_NONE = "keine offene Berechtigungsprüfungs-Anfragen";
    private static final String TEXT_TEMPLATE_ONE = "Eine offene Berechtigungsprüfungs-Anfrage";

    private static final ImageIcon ICON_PENDING = new javax.swing.ImageIcon(BerechtigungspruefungToolbarWidget.class
                    .getResource("/de/cismet/cids/custom/wunda_blau/toolbaritem/exclamation-red-icon.png"));
    private static final ImageIcon ICON_DONE = new javax.swing.ImageIcon(BerechtigungspruefungToolbarWidget.class
                    .getResource("/de/cismet/cids/custom/wunda_blau/toolbaritem/tick-circle-icon.png"));

    //~ Instance fields --------------------------------------------------------

    private final BerechtigungspruefungMessageNotifierListener notifierListener =
        new BerechtigungspruefungToolbarWidget.MessageListener();

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form BerechtigungspruefungToolbarWidget.
     */
    public BerechtigungspruefungToolbarWidget() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        if (isVisible()) {
            initComponents();
            updateAnfragen();

            BerechtigungspruefungMessageNotifier.getInstance().addListener(notifierListener);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        setMaximumSize(new java.awt.Dimension(333, 31));
        setOpaque(false);
        setPreferredSize(new java.awt.Dimension(333, 31));
        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, TEXT_TEMPLATE_NONE);
        jButton1.setBorderPainted(false);
        jButton1.setContentAreaFilled(false);
        jButton1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jButton1, gridBagConstraints);

        jLabel1.setIcon(ICON_DONE);
        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                BerechtigungspruefungToolbarWidget.class,
                "BerechtigungspruefungToolbarWidget.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        add(jLabel1, gridBagConstraints);
    }                                                                // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        new SwingWorker<BerechtigungspruefungFreigabeServerAction.ReturnType, Void>() {

                @Override
                protected BerechtigungspruefungFreigabeServerAction.ReturnType doInBackground() throws Exception {
                    try {
                        return (BerechtigungspruefungFreigabeServerAction.ReturnType)SessionManager
                                    .getSession().getConnection()
                                    .executeTask(
                                            SessionManager.getSession().getUser(),
                                            BerechtigungspruefungFreigabeServerAction.TASK_NAME,
                                            SessionManager.getSession().getUser().getDomain(),
                                            BerechtigungspruefungMessageNotifier.getInstance().getAeltesteOffeneAnfrage(
                                                getConnectionContext()),
                                            getConnectionContext(),
                                            new ServerActionParameter<>(
                                                BerechtigungspruefungFreigabeServerAction.ParameterType.MODUS
                                                    .toString(),
                                                BerechtigungspruefungFreigabeServerAction.MODUS_PRUEFUNG));
                    } catch (final Exception ex) {
                        LOG.error(ex, ex);
                        return null;
                    }
                }

                @Override
                protected void done() {
                    final BerechtigungspruefungFreigabeServerAction.ReturnType ret;
                    try {
                        ret = get();
                        if (ret.equals(
                                        BerechtigungspruefungFreigabeServerAction.ReturnType.OK)) {
                            gotoPruefung(BerechtigungspruefungMessageNotifier.getInstance().getAeltesteOffeneAnfrage(
                                    getConnectionContext()));
                        } else {
                            final String title = "Fehler beim Sperren.";
                            final String message =
                                "<html>Die Berechtigungs-Anfrage wird bereits von einem anderen Prüfer bearbeitet.";
                            JOptionPane.showMessageDialog(
                                StaticSwingTools.getParentFrame(
                                    ComponentRegistry.getRegistry().getMainWindow()),
                                message,
                                title,
                                JOptionPane.ERROR_MESSAGE);
                        }
                    } catch (final Exception ex) {
                        final String title = "Fehler beim Sperren.";
                        final String message = "Beim Sperren ist es zu unerwartetem einem Fehler gekommen.";
                        final ErrorInfo info = new ErrorInfo(
                                title,
                                message,
                                null,
                                null,
                                ex,
                                Level.SEVERE,
                                null);
                        JXErrorPane.showDialog(
                            ComponentRegistry.getRegistry().getMainWindow(),
                            info);

                        LOG.error("Fehler beim Freigeben", ex);
                    }
                }
            }.execute();
    } //GEN-LAST:event_jButton1ActionPerformed

    @Override
    public String getSorterString() {
        return "XXX";
    }

    @Override
    public final boolean isVisible() {
        return (!BerechtigungspruefungMessageNotifier.getInstance().getProdukttypeList().isEmpty());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  schluessel  DOCUMENT ME!
     */
    private void gotoPruefung(final String schluessel) {
        ComponentRegistry.getRegistry().showComponent(ComponentRegistry.DESCRIPTION_PANE);
        ComponentRegistry.getRegistry().getDescriptionPane().showWaitScreen();
        new SwingWorker<MetaObjectNode, Object>() {

                @Override
                protected MetaObjectNode doInBackground() throws Exception {
                    final MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName(
                            "WUNDA_BLAU",
                            "berechtigungspruefung",
                            getConnectionContext());

                    final String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", "
                                + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey()
                                + " "
                                + "FROM " + mcBerechtigungspruefung.getTableName() + " "
                                + "WHERE " + mcBerechtigungspruefung.getTableName() + ".schluessel LIKE '" + schluessel
                                + "' "
                                + "LIMIT 1;";

                    final MetaObject[] mos = SessionManager.getProxy()
                                .getMetaObjectByQuery(pruefungQuery, 0, getConnectionContext());
                    final CidsBean cidsBean = mos[0].getBean();
                    return new MetaObjectNode(cidsBean);
                }

                @Override
                protected void done() {
                    try {
                        final MetaObjectNode mon = get();
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(mon);
                    } catch (final Exception ex) {
                        LOG.error(ex, ex);
                    }
                }
            }.execute();
    }

    /**
     * DOCUMENT ME!
     */
    private void updateAnfragen() {
        int anzahlAnfragen;

        try {
            anzahlAnfragen = BerechtigungspruefungMessageNotifier.getInstance()
                        .getOffeneAnfragen(getConnectionContext())
                        .size();
        } catch (final Exception ex) {
            LOG.error("Fehler bei der Abfrage der offenen Anfragen", ex);
            anzahlAnfragen = -1;
        }

        final String name;
        final ImageIcon icon;
        final boolean pending;
        switch (anzahlAnfragen) {
            case 0: {
                name = TEXT_TEMPLATE_NONE;
                icon = ICON_DONE;
                pending = false;
            }
            break;
            case 1: {
                name = TEXT_TEMPLATE_ONE;
                icon = ICON_PENDING;
                pending = true;
            }
            break;
            default: {
                name = String.format(TEXT_TEMPLATE, String.valueOf(anzahlAnfragen));
                icon = ICON_PENDING;
                pending = true;
            }
        }

        jButton1.setEnabled(pending);
        jButton1.setText(name);
        jLabel1.setToolTipText(name);
        jLabel1.setIcon(icon);
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    @Override
    public String getValue(final String key) {
        if (key.equals(CidsUiComponent.CIDS_ACTION_KEY)) {
            return "BerechtigungspruefungToolbarWidget";
        } else {
            return null;
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class MessageListener implements BerechtigungspruefungMessageNotifierListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void anfrageAdded(final String key) {
            updateAnfragen();
        }

        @Override
        public void anfrageRemoved(final String key) {
            updateAnfragen();
        }
    }
}
