/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wupp.client.alkis;

import de.cismet.cids.custom.wupp.client.alkis.ParcelInputField;
import de.cismet.cids.custom.wupp.client.alkis.ParcelInputFieldConfig;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParcelInputFieldTest {
    private ParcelInputField field;
    private ParcelInputFieldConfig config;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.config = new ParcelInputFieldConfig();
        this.config.setDelimiter1('-');
        this.config.setDelimiter2('/');
        this.config.setMaxLenDistrictNumberField(4);
        this.config.setMaxLenParcelNumberField(3);
        this.config.setMaxLenParcelNumeratorField(5);
        this.config.setMaxLenParcelDenominatorField(4);
        HashMap<Integer, String> gemarkung = new HashMap<Integer, String>();
        gemarkung.put(3001, "Barmen");
        gemarkung.put(3135, "Elberfeld");
        gemarkung.put(3267, "Ronsdorf");
        gemarkung.put(3276, "Sch\u00f6ller");
        gemarkung.put(3277, "Vohwinkel");
        gemarkung.put(3278, "D\u00f6nberg");
        gemarkung.put(3279, "Cronenberg");
        gemarkung.put(3485, "Beyenburg");
        gemarkung.put(3486, "Langerfeld");
        gemarkung.put(3487, "N\u00e4chstebreck");
        this.config.setDistrictNamesMap(gemarkung);
        HashMap<String, Integer> umsetzung = new HashMap<String, Integer>();
        umsetzung.put("b", 3001);
        umsetzung.put("ba", 3001);
        umsetzung.put("e", 3135);
        umsetzung.put("el", 3135);
        umsetzung.put("r", 3267);
        umsetzung.put("ro", 3267);
        umsetzung.put("s", 3276);
        umsetzung.put("sc", 3276);
        umsetzung.put("v", 3277);
        umsetzung.put("vo", 3277);
        umsetzung.put("d", 3278);
        umsetzung.put("do", 3278);
        umsetzung.put("d\u00f6", 3278);
        umsetzung.put("c", 3279);
        umsetzung.put("cr", 3279);
        umsetzung.put("be", 3485);
        umsetzung.put("l", 3486);
        umsetzung.put("la", 3486);
        umsetzung.put("n", 3487);
        umsetzung.put("na", 3487);
        umsetzung.put("n\u00e4", 3487);
        this.config.setConversionMap(umsetzung);
        this.config.setAlternativeAbbreviationLength(new HashMap());
        this.config.setDefaultAbbreviationLength(2);
        this.field = new ParcelInputField(this.config);
    }

    @After
    public void tearDown() {
        this.config = null;
        this.field = null;
    }

    @Test
    public void testSetDistrictNumber() {
        System.out.println("setDistrictNumber");
        String districtNumber = "3001";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberSpecialCharacter() {
        System.out.println("setDistrictNumberSpecialCharacter");
        String districtNumber = "n\u00e4";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053487", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort() {
        System.out.println("setDistrictNumberShort");
        String districtNumber = "30";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals(null, (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort2() {
        System.out.println("setDistrictNumberShort2");
        String districtNumber = "ba";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberLong() {
        System.out.println("setDistrictNumberLong");
        String districtNumber = "30017435";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberWrong() {
        System.out.println("setDistrictNumberWrong");
        String districtNumber = "sadfh";
        ParcelInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals(null, (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetCurrentParcel() {
        System.out.println("setCurrentParcel");
        String currentParcel = "053135-002-00004/0003";
        ParcelInputField instance = this.field;
        instance.setCurrentParcel(currentParcel);
        Assert.assertEquals((Object)currentParcel, (Object)instance.getCurrentParcel());
    }

    @Test
    public void testSetCurrentParcelOverflow() {
        System.out.println("setCurrentParcelOverflow");
        String currentParcel = "3135-002-00004/00030";
        ParcelInputField instance = this.field;
        instance.setCurrentParcel(currentParcel);
        Assert.assertEquals((Object)"053135-002-00004/0003", (Object)instance.getCurrentParcel());
    }

    @Test
    public void testSetCurrentParcelDelimiterAtEnd() {
        System.out.println("setCurrentParcelDelimiterAtEnd");
        String currentParcel = "3135-002-00004/00030-";
        ParcelInputField instance = this.field;
        instance.setCurrentParcel(currentParcel);
        Assert.assertEquals((Object)"053135-002-00004/0003", (Object)instance.getCurrentParcel());
    }

    @Test
    public void testSetCurrentParcelShort() {
        System.out.println("setCurrentParcelShort");
        String currentParcel = "3135-002-04";
        ParcelInputField instance = this.field;
        instance.setCurrentParcel(currentParcel);
        Assert.assertEquals((Object)"053135-002-00004", (Object)instance.getCurrentParcel());
    }

    @Test
    public void testSetCurrentParcelShort2() {
        System.out.println("setCurrentParcelShort2");
        String currentParcel = "ba-1-3";
        ParcelInputField instance = this.field;
        instance.setCurrentParcel(currentParcel);
        Assert.assertEquals((Object)"053001-001-00003", (Object)instance.getCurrentParcel());
    }

    @Test
    public void testSetParcelDenominator() {
        System.out.println("setParcelDenominator");
        String parcelDenominator = "0002";
        ParcelInputField instance = this.field;
        instance.setParcelDenominator(parcelDenominator);
        Assert.assertEquals((Object)"0002", (Object)instance.getParcelDenominator());
    }

    @Test
    public void testSetParcelDenominatorShort() {
        System.out.println("setParcelDenominatorShort");
        String parcelDenominator = "2";
        ParcelInputField instance = this.field;
        instance.setParcelDenominator(parcelDenominator);
        Assert.assertEquals((Object)"0002", (Object)instance.getParcelDenominator());
    }

    @Test
    public void testSetParcelDenominatorLong() {
        System.out.println("setParcelDenominatorLong");
        String parcelDenominator = "00020005";
        ParcelInputField instance = this.field;
        instance.setParcelDenominator(parcelDenominator);
        Assert.assertEquals((Object)"0002", (Object)instance.getParcelDenominator());
    }

    @Test
    public void testSetParcelDenominatorWrong() {
        System.out.println("setParcelDenominatorWrong");
        String parcelDenominator = "abced";
        ParcelInputField instance = this.field;
        instance.setParcelDenominator(parcelDenominator);
        Assert.assertEquals((Object)"", (Object)instance.getParcelDenominator());
    }

    @Test
    public void testSetParcelNumber() {
        System.out.println("setParcelNumber");
        String parcelNumber = "001";
        ParcelInputField instance = this.field;
        instance.setParcelNumber(parcelNumber);
        Assert.assertEquals((Object)parcelNumber, (Object)instance.getParcelNumber());
    }

    @Test
    public void testSetParcelNumberShort() {
        System.out.println("setParcelNumberShort");
        String parcelNumber = "1";
        ParcelInputField instance = this.field;
        instance.setParcelNumber(parcelNumber);
        Assert.assertEquals((Object)"001", (Object)instance.getParcelNumber());
    }

    @Test
    public void testSetParcelNumberShortLong() {
        System.out.println("setParcelNumberLong");
        String parcelNumber = "10002";
        ParcelInputField instance = this.field;
        instance.setParcelNumber(parcelNumber);
        Assert.assertEquals((Object)"100", (Object)instance.getParcelNumber());
    }

    @Test
    public void testSetParcelNumberShortWrong() {
        System.out.println("setParcelNumberWrong");
        String parcelNumber = "abc";
        ParcelInputField instance = this.field;
        instance.setParcelNumber(parcelNumber);
        Assert.assertEquals((Object)"000", (Object)instance.getParcelNumber());
    }

    @Test
    public void testSetParcelNumerator() {
        System.out.println("setParcelNumerator");
        String parcelNumerator = "00003";
        ParcelInputField instance = this.field;
        instance.setParcelNumerator(parcelNumerator);
        Assert.assertEquals((Object)parcelNumerator, (Object)instance.getParcelNumerator());
    }

    @Test
    public void testSetParcelNumeratorShort() {
        System.out.println("setParcelNumeratorShort");
        String parcelNumerator = "3";
        ParcelInputField instance = this.field;
        instance.setParcelNumerator(parcelNumerator);
        Assert.assertEquals((Object)"00003", (Object)instance.getParcelNumerator());
    }

    @Test
    public void testSetParcelNumeratorLong() {
        System.out.println("setParcelNumeratorLong");
        String parcelNumerator = "00003674";
        ParcelInputField instance = this.field;
        instance.setParcelNumerator(parcelNumerator);
        Assert.assertEquals((Object)"00003", (Object)instance.getParcelNumerator());
    }

    @Test
    public void testSetParcelNumeratorWrong() {
        System.out.println("setParcelNumeratorWrong");
        String parcelNumerator = "abdvr";
        ParcelInputField instance = this.field;
        instance.setParcelNumerator(parcelNumerator);
        Assert.assertEquals((Object)"00000", (Object)instance.getParcelNumerator());
    }
}

