/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SetTIMNoteAction
extends AbstractAction
implements CommonFeatureAction,
ConnectionContextStore {
    private static Logger LOG = Logger.getLogger(SetTIMNoteAction.class);
    private Feature feature;
    private boolean isCurrentUserAllowedToSetHint;
    private MetaClass timLiegMetaClass;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public SetTIMNoteAction() {
        super(NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.name"), new ImageIcon(SetTIMNoteAction.class.getResource("/de/cismet/cids/custom/actions/wunda_blau/tag_blue_add.png")));
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            MetaClassCacheService classcache = (MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class);
            this.timLiegMetaClass = classcache.getMetaClass("WUNDA_BLAU", "tim_lieg", this.getConnectionContext());
            this.isCurrentUserAllowedToSetHint = this.timLiegMetaClass.getPermissions().hasWritePermission(SessionManager.getSession().getUser());
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while trying to set up SetTIMNoteAction. There was a problem with the lookup mechanism or session handling.", (Throwable)e);
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String hinweis = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).JOptionPane.message"), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).JOptionPane.title"), 3);
        if (hinweis == null || hinweis.trim().length() <= 0) {
            return;
        }
        User usr = SessionManager.getSession().getUser();
        String name = hinweis + " (" + usr.getName() + ")";
        int srid = this.feature.getGeometry().getSRID();
        int defaultSrid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs());
        if (srid == CismapBroker.getInstance().getDefaultCrsAlias()) {
            srid = defaultSrid;
        }
        if (srid != defaultSrid) {
            this.feature.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)this.feature.getGeometry()));
        }
        this.feature.getGeometry().setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        CidsBean hint = null;
        CidsBean persistedHint = null;
        CidsBean geometry = null;
        try {
            hint = CidsBeanSupport.createNewCidsBeanFromTableName("tim_lieg", this.getConnectionContext());
            geometry = CidsBeanSupport.createNewCidsBeanFromTableName("geom", this.getConnectionContext());
            hint.setProperty("ein_beab", (Object)usr.getName());
            hint.setProperty("ein_dat", (Object)new Timestamp(System.currentTimeMillis()));
            hint.setProperty("name", (Object)name);
            hint.setProperty("hinweis", (Object)hinweis);
            geometry.setProperty("geo_field", (Object)this.feature.getGeometry());
            hint.setProperty("georeferenz", (Object)geometry);
            persistedHint = hint.persist(this.getConnectionContext());
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not persist new entity for table 'tim_lieg'.", (Throwable)ex);
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).errorMessage"), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).errorTitle"), 0);
            return;
        }
        if (persistedHint == null) {
            LOG.error((Object)"Could not persist new entity for table 'tim_lieg'.");
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).errorMessage"), NbBundle.getMessage(SetTIMNoteAction.class, (String)"SetTIMNoteAction.actionPerformed(ActionEvent).errorTitle"), 0);
            return;
        }
        this.updateMappingComponent(persistedHint);
        this.updateCatalogueTree();
    }

    private void updateCatalogueTree() {
        MetaCatalogueTree catalogueTree = ComponentRegistry.getRegistry().getCatalogueTree();
        DefaultTreeModel catalogueTreeModel = (DefaultTreeModel)catalogueTree.getModel();
        Enumeration expandedPaths = catalogueTree.getExpandedDescendants(new TreePath(catalogueTreeModel.getRoot()));
        TreePath selectionPath = catalogueTree.getSelectionPath();
        RootTreeNode rootTreeNode = null;
        try {
            rootTreeNode = new RootTreeNode(SessionManager.getProxy().getRoots(this.getConnectionContext()), this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Updating catalogue tree after successful insertion of 'tim_lieg' entity failed.", (Throwable)ex);
            return;
        }
        catalogueTreeModel.setRoot((TreeNode)rootTreeNode);
        catalogueTreeModel.reload();
        if (selectionPath == null) {
            while (expandedPaths.hasMoreElements()) {
                TreePath expandedPath = (TreePath)expandedPaths.nextElement();
                if (selectionPath != null && selectionPath.getPathCount() >= selectionPath.getPathCount()) continue;
                selectionPath = expandedPath;
            }
        }
        catalogueTree.exploreSubtree(selectionPath);
    }

    private void updateMappingComponent(CidsBean persistedHint) throws IllegalArgumentException {
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        mappingComponent.getFeatureCollection().removeFeature(this.feature);
        mappingComponent.getFeatureCollection().addFeature((Feature)new CidsFeature(persistedHint.getMetaObject()));
    }

    public void setSourceFeature(Feature source) {
        this.feature = source;
    }

    public Feature getSourceFeature() {
        return this.feature;
    }

    public boolean isActive() {
        return this.isCurrentUserAllowedToSetHint && this.feature instanceof PureNewFeature;
    }

    public int getSorter() {
        return 10;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

