/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.wunda_blau.search.actions.WohnlagenKategorisierungServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WohnlagenKategorisierungDialog
extends JDialog
implements ConnectionContextProvider {
    public static final Logger LOG = Logger.getLogger(WohnlagenKategorisierungDialog.class);
    private static final MetaClass MC_WOHNLAGE;
    private static final MetaClass MC_WOHNLAGE_KATEGORIE;
    private final Map<ButtonModel, CidsBean> buttonToBeanMap = new HashMap<ButtonModel, CidsBean>();
    private final Collection<CidsLayerFeature> cidsLayerFeatures;
    private final ConnectionContext connectionContext;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public WohnlagenKategorisierungDialog(Frame parent, Collection<CidsLayerFeature> cidsLayerFeatures, CidsBean kategorieToSelect, ConnectionContext connectionContext) {
        super(parent, true);
        MetaObject[] metaObjects;
        this.cidsLayerFeatures = cidsLayerFeatures;
        this.connectionContext = connectionContext;
        this.initComponents();
        try {
            String query = "SELECT " + MC_WOHNLAGE_KATEGORIE.getID() + "," + MC_WOHNLAGE_KATEGORIE.getPrimaryKey() + " FROM " + MC_WOHNLAGE_KATEGORIE.getTableName() + " WHERE schluessel != 'keine' ORDER BY reihenfolge";
            metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, MC_WOHNLAGE_KATEGORIE.getDomain(), this.getConnectionContext());
        }
        catch (CacheException ex) {
            metaObjects = new MetaObject[]{};
        }
        this.jPanel3.removeAll();
        int count = 0;
        for (MetaObject metaObject : metaObjects) {
            CidsBean kategorie = metaObject.getBean();
            JRadioButton btnKategorie = new JRadioButton();
            JLabel lblKategorieColor = new JLabel();
            JLabel lblKategorieName = new JLabel();
            btnKategorie.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WohnlagenKategorisierungDialog.this.inputChanged();
                }
            });
            lblKategorieColor.setText(" ");
            lblKategorieColor.setBackground(new Color((Integer)kategorie.getProperty("farbcode")));
            lblKategorieColor.setOpaque(true);
            lblKategorieName.setText((String)kategorie.getProperty("name"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = count;
            gridBagConstraints.fill = 2;
            this.jPanel3.add((Component)btnKategorie, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = count;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.jPanel3.add((Component)lblKategorieColor, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = count++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.jPanel3.add((Component)lblKategorieName, gridBagConstraints);
            this.buttonGroup1.add(btnKategorie);
            if (kategorieToSelect != null && kategorieToSelect.getProperty("schluessel").equals(kategorie.getProperty("schluessel"))) {
                btnKategorie.setSelected(true);
            }
            this.buttonToBeanMap.put(btnKategorie.getModel(), kategorie);
        }
        this.getRootPane().setDefaultButton(this.btnOk);
        int size = cidsLayerFeatures.size();
        if (size == 1) {
            this.jLabel1.setText("<html>Es wurde eine Wohnlage markiert.<br/>W\u00e4hlen Sie eine der Kategorien:");
        } else {
            this.jLabel1.setText("<html>Es wurden #ANZAHL# Wohnlagen markiert.<br/>W\u00e4hlen Sie eine der Kategorien:".replaceAll("#ANZAHL#", Integer.toString(size)));
        }
        this.jTextArea1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                WohnlagenKategorisierungDialog.this.inputChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WohnlagenKategorisierungDialog.this.inputChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                WohnlagenKategorisierungDialog.this.inputChanged();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel6 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jRadioButton2 = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel12 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel13 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton2 = new JButton();
        this.btnOk = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel6.text"));
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButton1);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jRadioButton1.text"));
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.jRadioButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jLabel10.setBackground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel10.text"));
        this.jLabel10.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jLabel10, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jRadioButton2.text"));
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.jRadioButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jLabel11.setBackground(new Color(255, 153, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel11.text"));
        this.jLabel11.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jLabel11, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton3);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton3, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jRadioButton3.text"));
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.jRadioButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jRadioButton3, gridBagConstraints);
        this.jLabel12.setBackground(new Color(0, 255, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel12.text"));
        this.jLabel12.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jLabel12, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton4);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton4, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jRadioButton4.text"));
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.jRadioButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jRadioButton4, gridBagConstraints);
        this.jLabel13.setBackground(new Color(51, 153, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel13.text"));
        this.jLabel13.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.btnOk.text"));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WohnlagenKategorisierungDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WohnlagenKategorisierungDialog.class, (String)"WohnlagenKategorisierungDialog.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        final CidsBean kategorie = this.buttonToBeanMap.get(this.buttonGroup1.getSelection());
        Enumeration<AbstractButton> buttonEnumeration = this.buttonGroup1.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton button = buttonEnumeration.nextElement();
            button.setEnabled(false);
        }
        this.btnOk.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jLabel2.setText("Kategorie wird gesetzt...");
        AbstractFeatureService tmpService = null;
        for (CidsLayerFeature cidsLayerFeature : this.cidsLayerFeatures) {
            if (tmpService != null) continue;
            tmpService = cidsLayerFeature.getLayerProperties().getFeatureService();
            break;
        }
        final AbstractFeatureService service = tmpService;
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    String trimmedTextAreaText;
                    ArrayList<MetaObjectNode> wohnlageNodes = new ArrayList<MetaObjectNode>();
                    for (CidsLayerFeature cidsLayerFeature : WohnlagenKategorisierungDialog.this.cidsLayerFeatures) {
                        int wohnlageId = (Integer)cidsLayerFeature.getProperty("id");
                        wohnlageNodes.add(new MetaObjectNode(MC_WOHNLAGE.getDomain(), wohnlageId, MC_WOHNLAGE.getId()));
                        if (kategorie == null) continue;
                        cidsLayerFeature.setProperty("farbcode", kategorie.getProperty("farbcode"));
                        cidsLayerFeature.setProperty("kategorie_id", kategorie.getProperty("id"));
                    }
                    if (service != null) {
                        service.refreshFeatures();
                    }
                    String bemerkung = (trimmedTextAreaText = WohnlagenKategorisierungDialog.this.jTextArea1.getText().trim()).isEmpty() ? null : trimmedTextAreaText;
                    MetaObjectNode kategorieNode = kategorie == null ? null : new MetaObjectNode(kategorie);
                    SessionManager.getProxy().executeTask("wohnlagenKategorisierung", "WUNDA_BLAU", null, WohnlagenKategorisierungDialog.this.getConnectionContext(), new ServerActionParameter[]{new ServerActionParameter(WohnlagenKategorisierungServerAction.ParameterType.KATEGORIE.toString(), (Object)kategorieNode), new ServerActionParameter(WohnlagenKategorisierungServerAction.ParameterType.WOHNLAGEN.toString(), wohnlageNodes), new ServerActionParameter(WohnlagenKategorisierungServerAction.ParameterType.BEMERKUNG.toString(), (Object)bemerkung)});
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    String title = "Unerwarteter Fehler";
                    String message = "Beim Setzen der Kategorie ist es zu unerwartetem einem Fehler gekommen.";
                    LOG.error((Object)"Beim Setzen der Kategorie ist es zu unerwartetem einem Fehler gekommen.", (Throwable)ex);
                    ErrorInfo info = new ErrorInfo("Unerwarteter Fehler", "Beim Setzen der Kategorie ist es zu unerwartetem einem Fehler gekommen.", null, null, (Throwable)ex, Level.SEVERE, null);
                    JXErrorPane.showDialog((Component)ComponentRegistry.getRegistry().getMainWindow(), (ErrorInfo)info);
                    if (service != null) {
                        service.refresh();
                    }
                }
                finally {
                    WohnlagenKategorisierungDialog.this.dispose();
                }
            }
        }.execute();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.inputChanged();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.inputChanged();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.inputChanged();
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.inputChanged();
    }

    private void inputChanged() {
        this.btnOk.setEnabled(this.buttonGroup1.getSelection() != null || !this.jTextArea1.getText().trim().isEmpty());
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)WohnlagenKategorisierungDialog.class.getSimpleName());
        MetaClass mcWohnlage = null;
        try {
            mcWohnlage = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"WOHNLAGE", (ConnectionContext)connectionContext);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could get MetaClass (WOHNLAGE)!", (Throwable)ex);
        }
        MC_WOHNLAGE = mcWohnlage;
        MetaClass mcWohnlageKategorie = null;
        try {
            mcWohnlageKategorie = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"WOHNLAGE_KATEGORIE", (ConnectionContext)connectionContext);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could get MetaClass (WOHNLAGE_KATEGORIE)!", (Throwable)ex);
        }
        MC_WOHNLAGE_KATEGORIE = mcWohnlageKategorie;
    }
}

