/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.alkisfortfuehrung;

import de.cismet.cids.custom.alkisfortfuehrung.FortfuehrungItem;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class FortfuehrungenTableModel
extends AbstractTableModel {
    private static final transient Logger LOG = Logger.getLogger(FortfuehrungenTableModel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Datum", "FFN", "Art", ""};
    private static final Class[] COLUMN_CLASSES = new Class[]{Date.class, String.class, String.class, String.class};
    private FortfuehrungItem[] items = new FortfuehrungItem[0];

    public void setItems(FortfuehrungItem[] items) {
        this.items = items != null ? items : new FortfuehrungItem[0];
        this.fireTableDataChanged();
    }

    public FortfuehrungItem getItem(int rowIndex) {
        return this.items[rowIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FortfuehrungItem item = this.getItem(rowIndex);
        if (item == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                try {
                    Date date = item.getBeginn();
                    if (date != null) {
                        return date;
                    }
                    return "";
                }
                catch (Exception e) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)e);
                    return "";
                }
            }
            case 1: {
                try {
                    return item.getFfn();
                }
                catch (Exception e) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)e);
                    return "";
                }
            }
            case 2: {
                try {
                    return item.getAnlass();
                }
                catch (Exception e) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)e);
                    return "";
                }
            }
            case 3: {
                try {
                    String flurstueck_alt = item.getFlurstueckAlt();
                    String flurstueck_neu = item.getFlurstueckNeu();
                    if (flurstueck_alt.equals(flurstueck_neu)) {
                        return flurstueck_alt;
                    }
                    return flurstueck_alt + " => " + flurstueck_neu;
                }
                catch (Exception e) {
                    LOG.warn((Object)"exception in tablemodel", (Throwable)e);
                    return "";
                }
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }
}

