/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.berechtigungspruefung;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifierListener;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungProperties;
import de.cismet.cids.custom.clientutils.BerechtigungspruefungKonfiguration;
import de.cismet.cids.custom.wunda_blau.search.server.BerechtigungspruefungOffeneAnfragenStatement;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BerechtigungspruefungMessageNotifier
implements CidsServerMessageNotifierListener {
    private static final Logger LOG = Logger.getLogger(BerechtigungspruefungMessageNotifier.class);
    public static final String CONFATTR_PRODUKTTYPES = "custom.berechtigungspruefung.benachrichtigung_produkttypen";
    private final Collection<BerechtigungspruefungMessageNotifierListener> listeners = new ArrayList<BerechtigungspruefungMessageNotifierListener>();
    private final Set<String> produkttypeList = new HashSet<String>();

    private BerechtigungspruefungMessageNotifier(ConnectionContext connectionContext) {
        try {
            String confAttr = SessionManager.getConnection().getConfigAttr(SessionManager.getSession().getUser(), CONFATTR_PRODUKTTYPES, connectionContext);
            if (confAttr != null) {
                BerechtigungspruefungKonfiguration conf = BerechtigungspruefungKonfiguration.INSTANCE;
                ArrayList<String> existingTypes = new ArrayList<String>(conf.getProdukte().size());
                for (BerechtigungspruefungKonfiguration.ProduktTyp type : conf.getProdukte()) {
                    existingTypes.add(type.getProduktbezeichnung());
                }
                for (String line : Arrays.asList(confAttr.trim().split("\n"))) {
                    String type;
                    if (line == null || !existingTypes.contains(type = line.trim())) continue;
                    this.produkttypeList.add(type);
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"error while getConfAttr: custom.berechtigungspruefung.benachrichtigung_produkttypen", (Throwable)ex);
        }
    }

    public Collection<String> getProdukttypeList() {
        return this.produkttypeList;
    }

    public void messageRetrieved(CidsServerMessageNotifierListenerEvent event) {
        String category = event.getMessage().getCategory();
        if (BerechtigungspruefungProperties.getInstance().getCsmAnfrage().equals(category)) {
            List schluesselList = (List)event.getMessage().getContent();
            String schluessel = (String)schluesselList.iterator().next();
            this.fireAnfrageAdded(schluessel);
        } else if (BerechtigungspruefungProperties.getInstance().getCsmBearbeitung().equals(category)) {
            List schluesselList = (List)event.getMessage().getContent();
            String schluessel = schluesselList.isEmpty() ? null : (String)schluesselList.iterator().next();
            this.fireAnfrageRemoved(schluessel);
        }
    }

    public String getAeltesteOffeneAnfrage(ConnectionContext connectionContext) throws ConnectionException {
        if (this.getOffeneAnfragen(connectionContext).isEmpty()) {
            return null;
        }
        return this.getOffeneAnfragen(connectionContext).iterator().next();
    }

    public List<String> getOffeneAnfragen(ConnectionContext connectionContext) throws ConnectionException {
        List offeneAnfragen = (List)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new BerechtigungspruefungOffeneAnfragenStatement(this.produkttypeList), connectionContext);
        return offeneAnfragen;
    }

    public static BerechtigungspruefungMessageNotifier getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public boolean addListener(BerechtigungspruefungMessageNotifierListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(BerechtigungspruefungMessageNotifierListener listener) {
        return this.listeners.remove(listener);
    }

    public void fireAnfrageAdded(String key) {
        for (BerechtigungspruefungMessageNotifierListener listener : this.listeners) {
            listener.anfrageAdded(key);
        }
    }

    public void fireAnfrageRemoved(String key) {
        for (BerechtigungspruefungMessageNotifierListener listener : this.listeners) {
            listener.anfrageRemoved(key);
        }
    }

    private static final class LazyInitialiser {
        private static final BerechtigungspruefungMessageNotifier INSTANCE = new BerechtigungspruefungMessageNotifier(ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.INSTANCE, (String)BerechtigungspruefungMessageNotifier.class.getSimpleName()));

        private LazyInitialiser() {
        }
    }
}

