/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.custom.butler.Butler1ProductPanel;
import de.cismet.cids.custom.butler.ButlerProductGroup;
import de.cismet.cids.custom.butler.ButlerProductInfo;
import de.cismet.cids.custom.nas.NasFeePreviewPanel;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerResolution;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Butler2ProductPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Butler1ProductPanel.class);
    private static final double RASTER_DISCOUNT = 0.25;
    ArrayList<ButlerProduct> products;
    ArrayList<ButlerResolution> resolutions;
    private Geometry geom;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup btGroupFormat;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblFiller;
    private JLabel lblFormat;
    private JLabel lblProdukt;
    private JList lstProdukt;
    private JPanel pnlFee;
    private NasFeePreviewPanel pnlFeePreview;
    private JPanel pnlFormat;
    private JRadioButton rbShp;
    private JRadioButton rbTif;
    private BindingGroup bindingGroup;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.loadPrductDescriptions();
        this.initComponents();
        this.pnlFeePreview = new NasFeePreviewPanel(this.getConnectionContext());
        this.lstProdukt.setSelectionMode(0);
        this.rbShp.addActionListener(this);
        this.rbTif.addActionListener(this);
        this.rbShp.setSelected(true);
        GeometryFactory gf = new GeometryFactory();
        this.geom = gf.createMultiPolygon(null);
        this.calculateFee();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.btGroupFormat = new ButtonGroup();
        this.lblProdukt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProdukt = new JList();
        this.lblFormat = new JLabel();
        this.pnlFormat = new JPanel();
        this.rbShp = new JRadioButton();
        this.rbTif = new JRadioButton();
        this.lblFiller = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.pnlFee = new JPanel();
        this.pnlFeePreview = new NasFeePreviewPanel(this.getConnectionContext());
        this.setPreferredSize(new Dimension(400, 425));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblProdukt, (String)NbBundle.getMessage(Butler2ProductPanel.class, (String)"Butler2ProductPanel.lblProdukt.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 40);
        this.add((Component)this.lblProdukt, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(258, 150));
        ELProperty eLProperty = ELProperty.create((String)"${products}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstProdukt, (String)"productBinding");
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.jScrollPane1.setViewportView(this.lstProdukt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblFormat, (String)NbBundle.getMessage(Butler2ProductPanel.class, (String)"Butler2ProductPanel.lblFormat.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 40);
        this.add((Component)this.lblFormat, gridBagConstraints);
        this.pnlFormat.setLayout(new GridBagLayout());
        this.btGroupFormat.add(this.rbShp);
        Mnemonics.setLocalizedText((AbstractButton)this.rbShp, (String)NbBundle.getMessage(Butler2ProductPanel.class, (String)"Butler2ProductPanel.rbShp.text"));
        this.rbShp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2ProductPanel.this.rbShpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbShp, gridBagConstraints);
        this.btGroupFormat.add(this.rbTif);
        Mnemonics.setLocalizedText((AbstractButton)this.rbTif, (String)NbBundle.getMessage(Butler2ProductPanel.class, (String)"Butler2ProductPanel.rbTif.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbTif, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblFiller, (String)NbBundle.getMessage(Butler2ProductPanel.class, (String)"Butler2ProductPanel.lblFiller.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlFormat.add((Component)this.lblFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.pnlFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.pnlFee.setBackground(new Color(255, 255, 255));
        this.pnlFee.setLayout(new BorderLayout());
        this.pnlFee.add((Component)this.pnlFeePreview, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.pnlFee, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void rbShpActionPerformed(ActionEvent evt) {
    }

    private void loadPrductDescriptions() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ButlerProductInfo tester = (ButlerProductInfo)mapper.readValue(ButlerProductInfo.class.getResourceAsStream("/de/cismet/cids/custom/butler/productDescription.json"), ButlerProductInfo.class);
            ArrayList<ButlerProductGroup> productGroups = tester.getButler2ProductGroups();
            this.products = productGroups.get(0).getButlerProducts();
            this.resolutions = productGroups.get(0).getButlerResolutions();
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public ArrayList<ButlerResolution> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(ArrayList<ButlerResolution> resolutions) {
        this.resolutions = resolutions;
    }

    public ArrayList<ButlerProduct> getProducts() {
        return this.products;
    }

    public void setProducts(ArrayList<ButlerProduct> products) {
        this.products = products;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void setGeometry(Geometry geom) {
        this.geom = geom;
        this.calculateFee();
    }

    public ButlerProduct getSelectedProduct() {
        ButlerProduct bp = (ButlerProduct)this.lstProdukt.getSelectedValue();
        if (bp != null) {
            if (this.rbShp.isSelected()) {
                ButlerResolution res = new ButlerResolution();
                res.setKey("600");
                bp.setResolution(res);
                bp.setFormat(new ButlerFormat("pdf"));
            } else if (this.rbTif.isSelected()) {
                ButlerResolution res = new ButlerResolution();
                res.setKey("600");
                bp.setResolution(res);
                bp.setFormat(new ButlerFormat("tif"));
            }
        }
        return bp;
    }

    public void addProductListSelectionListener(ListSelectionListener listener) {
        this.lstProdukt.addListSelectionListener(listener);
    }

    private void calculateFee() {
        this.pnlFee.removeAll();
        this.pnlFeePreview = new NasFeePreviewPanel(this.getConnectionContext());
        this.pnlFeePreview.setDiscount(0.25);
        this.pnlFeePreview.setGeom(this.geom);
        this.pnlFeePreview.refresh();
        this.pnlFee.add(this.pnlFeePreview);
        this.pnlFee.revalidate();
        this.pnlFee.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.calculateFee();
    }

    public ArrayList<BillingProductGroupAmount> getProductGroupAmounts() {
        return this.pnlFeePreview.getProductGroupAmounts();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.calculateFee();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

